      subroutine chrgdp(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,g,coord,cdfitc,alphaaux,coeffs,coeffp,
     &                  coeffd,fock,zeta,axbx,ayby,azbz,px,py,pz,base,
     &                  pxax,pyay,pzaz,u,zetarec,wxcx,wycy,wzcz,wxpx,
     &                  wypy,wzpz,sss0,sss1,sss2,sss3,sss4,sss5,pss0,
     &                  pss1,pss2,pss3,pss4,dss,dss0,dss1,dss2,dss3,fss,
     &                  fss0,fss1,fss2,psp1,dsp,dsp0,dsp1,fsp,fsp0,fsp1,
     &                  dsd,dsd0,fsd,fsd0,dps,dpp,dpd,zetac1,zetac2,c,
     &                  c1,c2,c3,c4,c5,zzeta,ppx,ppy,ppz,ppxax,ppyay,
     &                  ppzaz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(m,*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),pxax(*),pyay(*),
     &          pzaz(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),wxpx(*),
     &          wypy(*),wzpz(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          sss5(*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          pss4(n,*),dss(m,*),dss0(n,*),dss1(n,*),dss2(n,*),
     &          dss3(n,*),fss(m,*),fss0(n,*),fss1(n,*),fss2(n,*),
     &          psp1(n,*),dsp(m,*),dsp0(n,*),dsp1(n,*),fsp(m,*),
     &          fsp0(n,*),fsp1(n,*),dsd(m,*),dsd0(n,*),fsd(m,*),
     &          fsd0(n,*),dps(m,*),dpp(m,*),dpd(m,*),zetac1(*),
     &          zetac2(*),c(*),c1(n,*),c2(n,*),c3(n,*),c4(n,*),c5(n,*),
     &          zzeta(*),ppx(*),ppy(*),ppz(*),ppxax(*),ppyay(*),ppzaz(*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(4,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
 1004 sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                 endif

 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

 1008 continue

      do 1009 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 1011 i=1,nn
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1011 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1012 j=1,6
      do 1012 i=1,m
 1012 dss(i,j)=zero

      do 1013 j=1,10
      do 1013 i=1,m
 1013 fss(i,j)=zero

      do 1014 j=1,6
      do 1014 i=1,nn
 1014 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 1015 j=1,10
      do 1015 i=1,nn
 1015 fss(iicontr(i),j)=fss(iicontr(i),j)+fss0(i,j)

      do 1016 i=1,m
      dps(i,01)=axbx(i)*dss(i,1)+fss(i,01)
      dps(i,02)=ayby(i)*dss(i,1)+fss(i,02)
      dps(i,03)=azbz(i)*dss(i,1)+fss(i,03)
      dps(i,04)=axbx(i)*dss(i,2)+fss(i,02)
      dps(i,05)=ayby(i)*dss(i,2)+fss(i,04)
      dps(i,06)=azbz(i)*dss(i,2)+fss(i,05)
      dps(i,07)=axbx(i)*dss(i,3)+fss(i,03)
      dps(i,08)=ayby(i)*dss(i,3)+fss(i,05)
      dps(i,09)=azbz(i)*dss(i,3)+fss(i,06)
      dps(i,10)=axbx(i)*dss(i,4)+fss(i,04)
      dps(i,11)=ayby(i)*dss(i,4)+fss(i,07)
      dps(i,12)=azbz(i)*dss(i,4)+fss(i,08)
      dps(i,13)=axbx(i)*dss(i,5)+fss(i,05)
      dps(i,14)=ayby(i)*dss(i,5)+fss(i,08)
      dps(i,15)=azbz(i)*dss(i,5)+fss(i,09)
      dps(i,16)=axbx(i)*dss(i,6)+fss(i,06)
      dps(i,17)=ayby(i)*dss(i,6)+fss(i,09)
 1016 dps(i,18)=azbz(i)*dss(i,6)+fss(i,10)

      do 1017 j=1,18
      do 1017 i=1,m
 1017 fock(inddyy(i,j))=fock(inddyy(i,j))+dps(i,j)*cdfits

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      call augg(6,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
      sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux
 2004 sss5(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(6)/zeta(i)/zetaux

      nn=0

      do 2005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                       sss5(nn)=sss5(i)
                                 endif

 2005 continue

      do 2006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 2006 zetac2(i)=zzeta(i)*zetarec(i)

      do 2007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 2008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 2009 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      pss4(i,1)=ppxax(i)*sss4(i)+wxpx(i)*sss5(i)
      pss4(i,2)=ppyay(i)*sss4(i)+wypy(i)*sss5(i)
      pss4(i,3)=ppzaz(i)*sss4(i)+wzpz(i)*sss5(i)

 2009 continue

      do 2010 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      c(i)=(sss3(i)-zetac1(i)*sss4(i))/(two*zzeta(i))

      dss3(i,1)=ppxax(i)*pss3(i,1)+wxpx(i)*pss4(i,1)+c(i)
      dss3(i,2)=ppyay(i)*pss3(i,1)+wypy(i)*pss4(i,1)
      dss3(i,3)=ppzaz(i)*pss3(i,1)+wzpz(i)*pss4(i,1)
      dss3(i,4)=ppyay(i)*pss3(i,2)+wypy(i)*pss4(i,2)+c(i)
      dss3(i,5)=ppzaz(i)*pss3(i,2)+wzpz(i)*pss4(i,2)
      dss3(i,6)=ppzaz(i)*pss3(i,3)+wzpz(i)*pss4(i,3)+c(i)

 2010 continue

      do 2011 j=1,3
      do 2011 i=1,nn
 2011 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 2012 i=1,n
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 2012 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 2013 j=1,3
      do 2013 i=1,nn
 2013 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 2014 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 2014 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 2015 j=1,3
      do 2015 i=1,nn
 2015 c1(i,j)=(pss2(i,j)-zetac1(i)*pss3(i,j))/(two*zzeta(i))

      do 2016 i=1,nn
      fss2(i,01)=ppxax(i)*dss2(i,1)+wxpx(i)*dss3(i,1)+c1(i,1)+c1(i,1)
      fss2(i,02)=ppyay(i)*dss2(i,1)+wypy(i)*dss3(i,1)
      fss2(i,03)=ppzaz(i)*dss2(i,1)+wzpz(i)*dss3(i,1)
      fss2(i,04)=ppyay(i)*dss2(i,2)+wypy(i)*dss3(i,2)+c1(i,1)
      fss2(i,05)=ppzaz(i)*dss2(i,2)+wzpz(i)*dss3(i,2)
      fss2(i,06)=ppzaz(i)*dss2(i,3)+wzpz(i)*dss3(i,3)+c1(i,1)
      fss2(i,07)=ppyay(i)*dss2(i,4)+wypy(i)*dss3(i,4)+c1(i,2)+c1(i,2)
      fss2(i,08)=ppzaz(i)*dss2(i,4)+wzpz(i)*dss3(i,4)
      fss2(i,09)=ppzaz(i)*dss2(i,5)+wzpz(i)*dss3(i,5)+c1(i,2)
 2016 fss2(i,10)=ppzaz(i)*dss2(i,6)+wzpz(i)*dss3(i,6)+c1(i,3)+c1(i,3)

      do 2017 i=1,nn

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2017 continue

      do 2018 j=1,3
      do 2018 i=1,nn
 2018 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 2019 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 2019 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 2020 j=1,3
      do 2020 i=1,nn
 2020 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 2021 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 2021 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 2022 j=1,6
      do 2022 i=1,nn
 2022 c2(i,j)=half*dss1(i,j)*zetarec(i)

      do 2023 i=1,nn
      fsp0(i,01)=wxcx(i)*fss1(i,01)+c2(i,1)*three
      fsp0(i,02)=wycy(i)*fss1(i,01)
      fsp0(i,03)=wzcz(i)*fss1(i,01)
      fsp0(i,04)=wxcx(i)*fss1(i,02)+c2(i,2)*two
      fsp0(i,05)=wycy(i)*fss1(i,02)+c2(i,1)
      fsp0(i,06)=wzcz(i)*fss1(i,02)
      fsp0(i,07)=wxcx(i)*fss1(i,03)+c2(i,3)*two
      fsp0(i,08)=wycy(i)*fss1(i,03)
      fsp0(i,09)=wzcz(i)*fss1(i,03)+c2(i,1)
      fsp0(i,10)=wxcx(i)*fss1(i,04)+c2(i,4)
      fsp0(i,11)=wycy(i)*fss1(i,04)+c2(i,2)*two
      fsp0(i,12)=wzcz(i)*fss1(i,04)
      fsp0(i,13)=wxcx(i)*fss1(i,05)+c2(i,5)
      fsp0(i,14)=wycy(i)*fss1(i,05)+c2(i,3)
      fsp0(i,15)=wzcz(i)*fss1(i,05)+c2(i,2)
      fsp0(i,16)=wxcx(i)*fss1(i,06)+c2(i,6)
      fsp0(i,17)=wycy(i)*fss1(i,06)
      fsp0(i,18)=wzcz(i)*fss1(i,06)+c2(i,3)*two
      fsp0(i,19)=wxcx(i)*fss1(i,07)
      fsp0(i,20)=wycy(i)*fss1(i,07)+c2(i,4)*three
      fsp0(i,21)=wzcz(i)*fss1(i,07)
      fsp0(i,22)=wxcx(i)*fss1(i,08)
      fsp0(i,23)=wycy(i)*fss1(i,08)+c2(i,5)*two
      fsp0(i,24)=wzcz(i)*fss1(i,08)+c2(i,4)
      fsp0(i,25)=wxcx(i)*fss1(i,09)
      fsp0(i,26)=wycy(i)*fss1(i,09)+c2(i,6)
      fsp0(i,27)=wzcz(i)*fss1(i,09)+c2(i,5)*two
      fsp0(i,28)=wxcx(i)*fss1(i,10)
      fsp0(i,29)=wycy(i)*fss1(i,10)
 2023 fsp0(i,30)=wzcz(i)*fss1(i,10)+c2(i,6)*three

      do 2024 j=1,6
      do 2024 i=1,nn
 2024 c2(i,j)=half*dss2(i,j)*zetarec(i)

      do 2025 i=1,nn
      fsp1(i,01)=wxcx(i)*fss2(i,01)+c2(i,1)*three
      fsp1(i,02)=wycy(i)*fss2(i,01)
      fsp1(i,03)=wzcz(i)*fss2(i,01)
      fsp1(i,04)=wxcx(i)*fss2(i,02)+c2(i,2)*two
      fsp1(i,05)=wycy(i)*fss2(i,02)+c2(i,1)
      fsp1(i,06)=wzcz(i)*fss2(i,02)
      fsp1(i,07)=wxcx(i)*fss2(i,03)+c2(i,3)*two
      fsp1(i,08)=wycy(i)*fss2(i,03)
      fsp1(i,09)=wzcz(i)*fss2(i,03)+c2(i,1)
      fsp1(i,10)=wxcx(i)*fss2(i,04)+c2(i,4)
      fsp1(i,11)=wycy(i)*fss2(i,04)+c2(i,2)*two
      fsp1(i,12)=wzcz(i)*fss2(i,04)
      fsp1(i,13)=wxcx(i)*fss2(i,05)+c2(i,5)
      fsp1(i,14)=wycy(i)*fss2(i,05)+c2(i,3)
      fsp1(i,15)=wzcz(i)*fss2(i,05)+c2(i,2)
      fsp1(i,16)=wxcx(i)*fss2(i,06)+c2(i,6)
      fsp1(i,17)=wycy(i)*fss2(i,06)
      fsp1(i,18)=wzcz(i)*fss2(i,06)+c2(i,3)*two
      fsp1(i,19)=wxcx(i)*fss2(i,07)
      fsp1(i,20)=wycy(i)*fss2(i,07)+c2(i,4)*three
      fsp1(i,21)=wzcz(i)*fss2(i,07)
      fsp1(i,22)=wxcx(i)*fss2(i,08)
      fsp1(i,23)=wycy(i)*fss2(i,08)+c2(i,5)*two
      fsp1(i,24)=wzcz(i)*fss2(i,08)+c2(i,4)
      fsp1(i,25)=wxcx(i)*fss2(i,09)
      fsp1(i,26)=wycy(i)*fss2(i,09)+c2(i,6)
      fsp1(i,27)=wzcz(i)*fss2(i,09)+c2(i,5)*two
      fsp1(i,28)=wxcx(i)*fss2(i,10)
      fsp1(i,29)=wycy(i)*fss2(i,10)
 2025 fsp1(i,30)=wzcz(i)*fss2(i,10)+c2(i,6)*three

      do 2026 j=1,6
      do 2026 i=1,nn
 2026 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 2027 j=1,9
      do 2027 i=1,nn
 2027 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 2028 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 2028 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 2029 j=1,10
      do 2029 i=1,nn
 2029 c4(i,j)=(fss0(i,j)-zetac2(i)*fss1(i,j))/(two*zetaux)

      do 2030 j=1,18
      do 2030 i=1,nn
 2030 c5(i,j)=half*dsp1(i,j)*zetarec(i)

      do 2031 i=1,nn
      fsd0(i,01)=wxcx(i)*fsp1(i,01)+c4(i,01)+c5(i,01)*three
      fsd0(i,02)=wycy(i)*fsp1(i,01)
      fsd0(i,03)=wzcz(i)*fsp1(i,01)
      fsd0(i,04)=wycy(i)*fsp1(i,02)+c4(i,01)
      fsd0(i,05)=wzcz(i)*fsp1(i,02)
      fsd0(i,06)=wzcz(i)*fsp1(i,03)+c4(i,01)
      fsd0(i,07)=wxcx(i)*fsp1(i,04)+c4(i,02)+c5(i,04)*two
      fsd0(i,08)=wycy(i)*fsp1(i,04)         +c5(i,01)
      fsd0(i,09)=wzcz(i)*fsp1(i,04)
      fsd0(i,10)=wycy(i)*fsp1(i,05)+c4(i,02)+c5(i,02)
      fsd0(i,11)=wzcz(i)*fsp1(i,05)
      fsd0(i,12)=wzcz(i)*fsp1(i,06)+c4(i,02)
      fsd0(i,13)=wxcx(i)*fsp1(i,07)+c4(i,03)+c5(i,07)*two
      fsd0(i,14)=wycy(i)*fsp1(i,07)
      fsd0(i,15)=wzcz(i)*fsp1(i,07)         +c5(i,01)
      fsd0(i,16)=wycy(i)*fsp1(i,08)+c4(i,03)
      fsd0(i,17)=wzcz(i)*fsp1(i,08)         +c5(i,02)
      fsd0(i,18)=wzcz(i)*fsp1(i,09)+c4(i,03)+c5(i,03)
      fsd0(i,19)=wxcx(i)*fsp1(i,10)+c4(i,04)+c5(i,10)
      fsd0(i,20)=wycy(i)*fsp1(i,10)         +c5(i,04)*two
      fsd0(i,21)=wzcz(i)*fsp1(i,10)
      fsd0(i,22)=wycy(i)*fsp1(i,11)+c4(i,04)+c5(i,05)*two
      fsd0(i,23)=wzcz(i)*fsp1(i,11)
      fsd0(i,24)=wzcz(i)*fsp1(i,12)+c4(i,04)
      fsd0(i,25)=wxcx(i)*fsp1(i,13)+c4(i,05)+c5(i,13)
      fsd0(i,26)=wycy(i)*fsp1(i,13)         +c5(i,07)
      fsd0(i,27)=wzcz(i)*fsp1(i,13)         +c5(i,04)
      fsd0(i,28)=wycy(i)*fsp1(i,14)+c4(i,05)+c5(i,08)
      fsd0(i,29)=wzcz(i)*fsp1(i,14)         +c5(i,05)
      fsd0(i,30)=wzcz(i)*fsp1(i,15)+c4(i,05)+c5(i,06)
      fsd0(i,31)=wxcx(i)*fsp1(i,16)+c4(i,06)+c5(i,16)
      fsd0(i,32)=wycy(i)*fsp1(i,16)
      fsd0(i,33)=wzcz(i)*fsp1(i,16)         +c5(i,07)*two
      fsd0(i,34)=wycy(i)*fsp1(i,17)+c4(i,06)
      fsd0(i,35)=wzcz(i)*fsp1(i,17)         +c5(i,08)*two
      fsd0(i,36)=wzcz(i)*fsp1(i,18)+c4(i,06)+c5(i,09)*two
      fsd0(i,37)=wxcx(i)*fsp1(i,19)+c4(i,07)
      fsd0(i,38)=wycy(i)*fsp1(i,19)         +c5(i,10)*three
      fsd0(i,39)=wzcz(i)*fsp1(i,19)
      fsd0(i,40)=wycy(i)*fsp1(i,20)+c4(i,07)+c5(i,11)*three
      fsd0(i,41)=wzcz(i)*fsp1(i,20)
      fsd0(i,42)=wzcz(i)*fsp1(i,21)+c4(i,07)
      fsd0(i,43)=wxcx(i)*fsp1(i,22)+c4(i,08)
      fsd0(i,44)=wycy(i)*fsp1(i,22)         +c5(i,13)*two
      fsd0(i,45)=wzcz(i)*fsp1(i,22)         +c5(i,10)
      fsd0(i,46)=wycy(i)*fsp1(i,23)+c4(i,08)+c5(i,14)*two
      fsd0(i,47)=wzcz(i)*fsp1(i,23)         +c5(i,11)
      fsd0(i,48)=wzcz(i)*fsp1(i,24)+c4(i,08)+c5(i,12)
      fsd0(i,49)=wxcx(i)*fsp1(i,25)+c4(i,09)
      fsd0(i,50)=wycy(i)*fsp1(i,25)         +c5(i,16)
      fsd0(i,51)=wzcz(i)*fsp1(i,25)         +c5(i,13)*two
      fsd0(i,52)=wycy(i)*fsp1(i,26)+c4(i,09)+c5(i,17)
      fsd0(i,53)=wzcz(i)*fsp1(i,26)         +c5(i,14)*two
      fsd0(i,54)=wzcz(i)*fsp1(i,27)+c4(i,09)+c5(i,15)*two
      fsd0(i,55)=wxcx(i)*fsp1(i,28)+c4(i,10)
      fsd0(i,56)=wycy(i)*fsp1(i,28)
      fsd0(i,57)=wzcz(i)*fsp1(i,28)         +c5(i,16)*three
      fsd0(i,58)=wycy(i)*fsp1(i,29)+c4(i,10)
      fsd0(i,59)=wzcz(i)*fsp1(i,29)         +c5(i,17)*three
 2031 fsd0(i,60)=wzcz(i)*fsp1(i,30)+c4(i,10)+c5(i,18)*three

      do 2032 j=1,6
      do 2032 i=1,m
 2032 dss(i,j)=zero

      do 2033 j=1,18
      do 2033 i=1,m
 2033 dsp(i,j)=zero

      do 2034 j=1,36
      do 2034 i=1,m
 2034 dsd(i,j)=zero

      do 2035 j=1,10
      do 2035 i=1,m
 2035 fss(i,j)=zero

      do 2036 j=1,30
      do 2036 i=1,m
 2036 fsp(i,j)=zero

      do 2037 j=1,60
      do 2037 i=1,m
 2037 fsd(i,j)=zero

      do 2038 j=1,6
      do 2038 i=1,nn
 2038 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 2039 j=1,18
      do 2039 i=1,nn
 2039 dsp(iicontr(i),j)=dsp(iicontr(i),j)+dsp0(i,j)

      do 2040 j=1,36
      do 2040 i=1,nn
 2040 dsd(iicontr(i),j)=dsd(iicontr(i),j)+dsd0(i,j)

      do 2041 j=1,10
      do 2041 i=1,nn
 2041 fss(iicontr(i),j)=fss(iicontr(i),j)+fss0(i,j)

      do 2042 j=1,30
      do 2042 i=1,nn
 2042 fsp(iicontr(i),j)=fsp(iicontr(i),j)+fsp0(i,j)

      do 2043 j=1,60
      do 2043 i=1,nn
 2043 fsd(iicontr(i),j)=fsd(iicontr(i),j)+fsd0(i,j)

      do 2044 i=1,m
      dps(i,01)=axbx(i)*dss(i,1)+fss(i,01)
      dps(i,02)=ayby(i)*dss(i,1)+fss(i,02)
      dps(i,03)=azbz(i)*dss(i,1)+fss(i,03)
      dps(i,04)=axbx(i)*dss(i,2)+fss(i,02)
      dps(i,05)=ayby(i)*dss(i,2)+fss(i,04)
      dps(i,06)=azbz(i)*dss(i,2)+fss(i,05)
      dps(i,07)=axbx(i)*dss(i,3)+fss(i,03)
      dps(i,08)=ayby(i)*dss(i,3)+fss(i,05)
      dps(i,09)=azbz(i)*dss(i,3)+fss(i,06)
      dps(i,10)=axbx(i)*dss(i,4)+fss(i,04)
      dps(i,11)=ayby(i)*dss(i,4)+fss(i,07)
      dps(i,12)=azbz(i)*dss(i,4)+fss(i,08)
      dps(i,13)=axbx(i)*dss(i,5)+fss(i,05)
      dps(i,14)=ayby(i)*dss(i,5)+fss(i,08)
      dps(i,15)=azbz(i)*dss(i,5)+fss(i,09)
      dps(i,16)=axbx(i)*dss(i,6)+fss(i,06)
      dps(i,17)=ayby(i)*dss(i,6)+fss(i,09)
 2044 dps(i,18)=azbz(i)*dss(i,6)+fss(i,10)

      do 2045 i=1,m
      dpp(i,01)=axbx(i)*dsp(i,01)+fsp(i,01)
      dpp(i,02)=axbx(i)*dsp(i,02)+fsp(i,02)
      dpp(i,03)=axbx(i)*dsp(i,03)+fsp(i,03)
      dpp(i,04)=ayby(i)*dsp(i,01)+fsp(i,04)
      dpp(i,05)=ayby(i)*dsp(i,02)+fsp(i,05)
      dpp(i,06)=ayby(i)*dsp(i,03)+fsp(i,06)
      dpp(i,07)=azbz(i)*dsp(i,01)+fsp(i,07)
      dpp(i,08)=azbz(i)*dsp(i,02)+fsp(i,08)
      dpp(i,09)=azbz(i)*dsp(i,03)+fsp(i,09)
      dpp(i,10)=axbx(i)*dsp(i,04)+fsp(i,04)
      dpp(i,11)=axbx(i)*dsp(i,05)+fsp(i,05)
      dpp(i,12)=axbx(i)*dsp(i,06)+fsp(i,06)
      dpp(i,13)=ayby(i)*dsp(i,04)+fsp(i,10)
      dpp(i,14)=ayby(i)*dsp(i,05)+fsp(i,11)
      dpp(i,15)=ayby(i)*dsp(i,06)+fsp(i,12)
      dpp(i,16)=azbz(i)*dsp(i,04)+fsp(i,13)
      dpp(i,17)=azbz(i)*dsp(i,05)+fsp(i,14)
      dpp(i,18)=azbz(i)*dsp(i,06)+fsp(i,15)
      dpp(i,19)=axbx(i)*dsp(i,07)+fsp(i,07)
      dpp(i,20)=axbx(i)*dsp(i,08)+fsp(i,08)
      dpp(i,21)=axbx(i)*dsp(i,09)+fsp(i,09)
      dpp(i,22)=ayby(i)*dsp(i,07)+fsp(i,13)
      dpp(i,23)=ayby(i)*dsp(i,08)+fsp(i,14)
      dpp(i,24)=ayby(i)*dsp(i,09)+fsp(i,15)
      dpp(i,25)=azbz(i)*dsp(i,07)+fsp(i,16)
      dpp(i,26)=azbz(i)*dsp(i,08)+fsp(i,17)
      dpp(i,27)=azbz(i)*dsp(i,09)+fsp(i,18)
      dpp(i,28)=axbx(i)*dsp(i,10)+fsp(i,10)
      dpp(i,29)=axbx(i)*dsp(i,11)+fsp(i,11)
      dpp(i,30)=axbx(i)*dsp(i,12)+fsp(i,12)
      dpp(i,31)=ayby(i)*dsp(i,10)+fsp(i,19)
      dpp(i,32)=ayby(i)*dsp(i,11)+fsp(i,20)
      dpp(i,33)=ayby(i)*dsp(i,12)+fsp(i,21)
      dpp(i,34)=azbz(i)*dsp(i,10)+fsp(i,22)
      dpp(i,35)=azbz(i)*dsp(i,11)+fsp(i,23)
      dpp(i,36)=azbz(i)*dsp(i,12)+fsp(i,24)
      dpp(i,37)=axbx(i)*dsp(i,13)+fsp(i,13)
      dpp(i,38)=axbx(i)*dsp(i,14)+fsp(i,14)
      dpp(i,39)=axbx(i)*dsp(i,15)+fsp(i,15)
      dpp(i,40)=ayby(i)*dsp(i,13)+fsp(i,22)
      dpp(i,41)=ayby(i)*dsp(i,14)+fsp(i,23)
      dpp(i,42)=ayby(i)*dsp(i,15)+fsp(i,24)
      dpp(i,43)=azbz(i)*dsp(i,13)+fsp(i,25)
      dpp(i,44)=azbz(i)*dsp(i,14)+fsp(i,26)
      dpp(i,45)=azbz(i)*dsp(i,15)+fsp(i,27)
      dpp(i,46)=axbx(i)*dsp(i,16)+fsp(i,16)
      dpp(i,47)=axbx(i)*dsp(i,17)+fsp(i,17)
      dpp(i,48)=axbx(i)*dsp(i,18)+fsp(i,18)
      dpp(i,49)=ayby(i)*dsp(i,16)+fsp(i,25)
      dpp(i,50)=ayby(i)*dsp(i,17)+fsp(i,26)
      dpp(i,51)=ayby(i)*dsp(i,18)+fsp(i,27)
      dpp(i,52)=azbz(i)*dsp(i,16)+fsp(i,28)
      dpp(i,53)=azbz(i)*dsp(i,17)+fsp(i,29)
 2045 dpp(i,54)=azbz(i)*dsp(i,18)+fsp(i,30)

      do 2046 i=1,m
      dpd(i,001)=axbx(i)*dsd(i,01)+fsd(i,01)
      dpd(i,002)=axbx(i)*dsd(i,02)+fsd(i,02)
      dpd(i,003)=axbx(i)*dsd(i,03)+fsd(i,03)
      dpd(i,004)=axbx(i)*dsd(i,04)+fsd(i,04)
      dpd(i,005)=axbx(i)*dsd(i,05)+fsd(i,05)
      dpd(i,006)=axbx(i)*dsd(i,06)+fsd(i,06)
      dpd(i,007)=ayby(i)*dsd(i,01)+fsd(i,07)
      dpd(i,008)=ayby(i)*dsd(i,02)+fsd(i,08)
      dpd(i,009)=ayby(i)*dsd(i,03)+fsd(i,09)
      dpd(i,010)=ayby(i)*dsd(i,04)+fsd(i,10)
      dpd(i,011)=ayby(i)*dsd(i,05)+fsd(i,11)
      dpd(i,012)=ayby(i)*dsd(i,06)+fsd(i,12)
      dpd(i,013)=azbz(i)*dsd(i,01)+fsd(i,13)
      dpd(i,014)=azbz(i)*dsd(i,02)+fsd(i,14)
      dpd(i,015)=azbz(i)*dsd(i,03)+fsd(i,15)
      dpd(i,016)=azbz(i)*dsd(i,04)+fsd(i,16)
      dpd(i,017)=azbz(i)*dsd(i,05)+fsd(i,17)
      dpd(i,018)=azbz(i)*dsd(i,06)+fsd(i,18)
      dpd(i,019)=axbx(i)*dsd(i,07)+fsd(i,07)
      dpd(i,020)=axbx(i)*dsd(i,08)+fsd(i,08)
      dpd(i,021)=axbx(i)*dsd(i,09)+fsd(i,09)
      dpd(i,022)=axbx(i)*dsd(i,10)+fsd(i,10)
      dpd(i,023)=axbx(i)*dsd(i,11)+fsd(i,11)
      dpd(i,024)=axbx(i)*dsd(i,12)+fsd(i,12)
      dpd(i,025)=ayby(i)*dsd(i,07)+fsd(i,19)
      dpd(i,026)=ayby(i)*dsd(i,08)+fsd(i,20)
      dpd(i,027)=ayby(i)*dsd(i,09)+fsd(i,21)
      dpd(i,028)=ayby(i)*dsd(i,10)+fsd(i,22)
      dpd(i,029)=ayby(i)*dsd(i,11)+fsd(i,23)
      dpd(i,030)=ayby(i)*dsd(i,12)+fsd(i,24)
      dpd(i,031)=azbz(i)*dsd(i,07)+fsd(i,25)
      dpd(i,032)=azbz(i)*dsd(i,08)+fsd(i,26)
      dpd(i,033)=azbz(i)*dsd(i,09)+fsd(i,27)
      dpd(i,034)=azbz(i)*dsd(i,10)+fsd(i,28)
      dpd(i,035)=azbz(i)*dsd(i,11)+fsd(i,29)
      dpd(i,036)=azbz(i)*dsd(i,12)+fsd(i,30)
      dpd(i,037)=axbx(i)*dsd(i,13)+fsd(i,13)
      dpd(i,038)=axbx(i)*dsd(i,14)+fsd(i,14)
      dpd(i,039)=axbx(i)*dsd(i,15)+fsd(i,15)
      dpd(i,040)=axbx(i)*dsd(i,16)+fsd(i,16)
      dpd(i,041)=axbx(i)*dsd(i,17)+fsd(i,17)
      dpd(i,042)=axbx(i)*dsd(i,18)+fsd(i,18)
      dpd(i,043)=ayby(i)*dsd(i,13)+fsd(i,25)
      dpd(i,044)=ayby(i)*dsd(i,14)+fsd(i,26)
      dpd(i,045)=ayby(i)*dsd(i,15)+fsd(i,27)
      dpd(i,046)=ayby(i)*dsd(i,16)+fsd(i,28)
      dpd(i,047)=ayby(i)*dsd(i,17)+fsd(i,29)
      dpd(i,048)=ayby(i)*dsd(i,18)+fsd(i,30)
      dpd(i,049)=azbz(i)*dsd(i,13)+fsd(i,31)
      dpd(i,050)=azbz(i)*dsd(i,14)+fsd(i,32)
      dpd(i,051)=azbz(i)*dsd(i,15)+fsd(i,33)
      dpd(i,052)=azbz(i)*dsd(i,16)+fsd(i,34)
      dpd(i,053)=azbz(i)*dsd(i,17)+fsd(i,35)
      dpd(i,054)=azbz(i)*dsd(i,18)+fsd(i,36)
      dpd(i,055)=axbx(i)*dsd(i,19)+fsd(i,19)
      dpd(i,056)=axbx(i)*dsd(i,20)+fsd(i,20)
      dpd(i,057)=axbx(i)*dsd(i,21)+fsd(i,21)
      dpd(i,058)=axbx(i)*dsd(i,22)+fsd(i,22)
      dpd(i,059)=axbx(i)*dsd(i,23)+fsd(i,23)
      dpd(i,060)=axbx(i)*dsd(i,24)+fsd(i,24)
      dpd(i,061)=ayby(i)*dsd(i,19)+fsd(i,37)
      dpd(i,062)=ayby(i)*dsd(i,20)+fsd(i,38)
      dpd(i,063)=ayby(i)*dsd(i,21)+fsd(i,39)
      dpd(i,064)=ayby(i)*dsd(i,22)+fsd(i,40)
      dpd(i,065)=ayby(i)*dsd(i,23)+fsd(i,41)
      dpd(i,066)=ayby(i)*dsd(i,24)+fsd(i,42)
      dpd(i,067)=azbz(i)*dsd(i,19)+fsd(i,43)
      dpd(i,068)=azbz(i)*dsd(i,20)+fsd(i,44)
      dpd(i,069)=azbz(i)*dsd(i,21)+fsd(i,45)
      dpd(i,070)=azbz(i)*dsd(i,22)+fsd(i,46)
      dpd(i,071)=azbz(i)*dsd(i,23)+fsd(i,47)
      dpd(i,072)=azbz(i)*dsd(i,24)+fsd(i,48)
      dpd(i,073)=axbx(i)*dsd(i,25)+fsd(i,25)
      dpd(i,074)=axbx(i)*dsd(i,26)+fsd(i,26)
      dpd(i,075)=axbx(i)*dsd(i,27)+fsd(i,27)
      dpd(i,076)=axbx(i)*dsd(i,28)+fsd(i,28)
      dpd(i,077)=axbx(i)*dsd(i,29)+fsd(i,29)
      dpd(i,078)=axbx(i)*dsd(i,30)+fsd(i,30)
      dpd(i,079)=ayby(i)*dsd(i,25)+fsd(i,43)
      dpd(i,080)=ayby(i)*dsd(i,26)+fsd(i,44)
      dpd(i,081)=ayby(i)*dsd(i,27)+fsd(i,45)
      dpd(i,082)=ayby(i)*dsd(i,28)+fsd(i,46)
      dpd(i,083)=ayby(i)*dsd(i,29)+fsd(i,47)
      dpd(i,084)=ayby(i)*dsd(i,30)+fsd(i,48)
      dpd(i,085)=azbz(i)*dsd(i,25)+fsd(i,49)
      dpd(i,086)=azbz(i)*dsd(i,26)+fsd(i,50)
      dpd(i,087)=azbz(i)*dsd(i,27)+fsd(i,51)
      dpd(i,088)=azbz(i)*dsd(i,28)+fsd(i,52)
      dpd(i,089)=azbz(i)*dsd(i,29)+fsd(i,53)
      dpd(i,090)=azbz(i)*dsd(i,30)+fsd(i,54)
      dpd(i,091)=axbx(i)*dsd(i,31)+fsd(i,31)
      dpd(i,092)=axbx(i)*dsd(i,32)+fsd(i,32)
      dpd(i,093)=axbx(i)*dsd(i,33)+fsd(i,33)
      dpd(i,094)=axbx(i)*dsd(i,34)+fsd(i,34)
      dpd(i,095)=axbx(i)*dsd(i,35)+fsd(i,35)
      dpd(i,096)=axbx(i)*dsd(i,36)+fsd(i,36)
      dpd(i,097)=ayby(i)*dsd(i,31)+fsd(i,49)
      dpd(i,098)=ayby(i)*dsd(i,32)+fsd(i,50)
      dpd(i,099)=ayby(i)*dsd(i,33)+fsd(i,51)
      dpd(i,100)=ayby(i)*dsd(i,34)+fsd(i,52)
      dpd(i,101)=ayby(i)*dsd(i,35)+fsd(i,53)
      dpd(i,102)=ayby(i)*dsd(i,36)+fsd(i,54)
      dpd(i,103)=azbz(i)*dsd(i,31)+fsd(i,55)
      dpd(i,104)=azbz(i)*dsd(i,32)+fsd(i,56)
      dpd(i,105)=azbz(i)*dsd(i,33)+fsd(i,57)
      dpd(i,106)=azbz(i)*dsd(i,34)+fsd(i,58)
      dpd(i,107)=azbz(i)*dsd(i,35)+fsd(i,59)
 2046 dpd(i,108)=azbz(i)*dsd(i,36)+fsd(i,60)

      do 2047 j=1,18
      do 2047 i=1,m
 2047 fock(inddyy(i,j))=fock(inddyy(i,j))+dps(i,j)*cdfits

      do 2048 k=1,3
      do 2048 j=1,18
      do 2048 i=1,m
 2048 fock(inddyy(i,j))=fock(inddyy(i,j))+dpp(i,3*(j-1)+k)*cdfitp(k)

      do 2049 k=1,6
      do 2049 j=1,18
      do 2049 i=1,m
 2049 fock(inddyy(i,j))=fock(inddyy(i,j))+dpd(i,6*(j-1)+k)*cdfitd(k)

 2001 continue

      do 3001 i=1,n
 3001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      do 3002 i=1,m
      fock(inddyy(i,01))=fock(inddyy(i,01))/sqrt3
      fock(inddyy(i,02))=fock(inddyy(i,02))/sqrt3
      fock(inddyy(i,03))=fock(inddyy(i,03))/sqrt3
      fock(inddyy(i,10))=fock(inddyy(i,10))/sqrt3
      fock(inddyy(i,11))=fock(inddyy(i,11))/sqrt3
      fock(inddyy(i,12))=fock(inddyy(i,12))/sqrt3
      fock(inddyy(i,16))=fock(inddyy(i,16))/sqrt3
      fock(inddyy(i,17))=fock(inddyy(i,17))/sqrt3
 3002 fock(inddyy(i,18))=fock(inddyy(i,18))/sqrt3

      return
      end
