      subroutine compg1(ncntrt,npts,ndm,nconts,ncontp,ncontd,ilfunc,
     &                  icfunc,ngauss,nptrs,nptrp,nptrd,cent,alpha,
     &                  coeff,x,y,z,qf,qx,qy,qz,xx,yy,zz,rr,rralpha,s,
     &                  px,py,pz,dxx,dxy,dxz,dyy,dyz,dzz,fxxx,fxxy,fxxz,
     &                  fxyy,fxyz,fxzz,fyyy,fyyz,fyzz,fzzz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension cent(3,*),alpha(*),coeff(*)

      dimension x(*),y(*),z(*),qf(ndm,*),qx(ndm,*),qy(ndm,*),qz(ndm,*)

      dimension xx(*),yy(*),zz(*),rr(*),rralpha(*)
      dimension s(*),px(*),py(*),pz(*)
      dimension dxx(*),dxy(*),dxz(*),dyy(*),dyz(*),dzz(*)
      dimension fxxx(*),fxxy(*),fxxz(*),fxyy(*),fxyz(*),
     &          fxzz(*),fyyy(*),fyyz(*),fyzz(*),fzzz(*)

      data zero,one,two,three,expcut/0.0,1.0,2.0,3.0,80.0/

      rsqrt3=one/sqrt(three)

      do 1001 i=1,ncntrt
      do 1001 j=1,ndm
      qf(j,i)=zero
      qx(j,i)=zero
      qy(j,i)=zero
 1001 qz(j,i)=zero

      k=0

c  loop over s functions

      if(nconts.eq.0) return

      do 1002 i=1,nconts

      ilabel=nptrs(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1003 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1003 zz(j)=z(j)-cent(3,nc)

      do 1004 j=1,npts
 1004 rr(j)=xx(j)*xx(j)+yy(j)*yy(j)+zz(j)*zz(j)

      do 1005 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      do 1006 j=1,npts
 1006 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1007 j=1,npts
      if(rralpha(j).lt.expcut) then

                     s(j)=coeff(nprimitive)*exp(-rralpha(j))

                     qf(j,k+1)=qf(j,k+1)+s(j)

                     qx(j,k+1)=qx(j,k+1)-twozeta*xx(j)*s(j)
                     qy(j,k+1)=qy(j,k+1)-twozeta*yy(j)*s(j)
                     qz(j,k+1)=qz(j,k+1)-twozeta*zz(j)*s(j)

                               endif
 1007 continue

 1005 continue

 1002 k=k+1

c  loop over p functions

      if(ncontp.eq.0) return

      do 1011 i=1,ncontp

      ilabel=nptrp(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1012 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1012 zz(j)=z(j)-cent(3,nc)

      do 1013 j=1,npts
      dxx(j)=xx(j)*xx(j)
      dxy(j)=xx(j)*yy(j)
      dxz(j)=xx(j)*zz(j)
      dyy(j)=yy(j)*yy(j)
      dyz(j)=yy(j)*zz(j)
 1013 dzz(j)=zz(j)*zz(j)

      do 1014 j=1,npts
 1014 rr(j)=dxx(j)+dyy(j)+dzz(j)

      do 1015 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      do 1016 j=1,npts
 1016 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1017 j=1,npts
      if(rralpha(j).lt.expcut) then

                     s(j)=coeff(nprimitive)*exp(-rralpha(j))

                     qf(j,k+1)=qf(j,k+1)+xx(j)*s(j)
                     qf(j,k+2)=qf(j,k+2)+yy(j)*s(j)
                     qf(j,k+3)=qf(j,k+3)+zz(j)*s(j)

                     qx(j,k+1)=qx(j,k+1)-twozeta*dxx(j)*s(j)+s(j)
                     qy(j,k+1)=qy(j,k+1)-twozeta*dxy(j)*s(j)
                     qz(j,k+1)=qz(j,k+1)-twozeta*dxz(j)*s(j)

                     qx(j,k+2)=qx(j,k+2)-twozeta*dxy(j)*s(j)
                     qy(j,k+2)=qy(j,k+2)-twozeta*dyy(j)*s(j)+s(j)
                     qz(j,k+2)=qz(j,k+2)-twozeta*dyz(j)*s(j)

                     qx(j,k+3)=qx(j,k+3)-twozeta*dxz(j)*s(j)
                     qy(j,k+3)=qy(j,k+3)-twozeta*dyz(j)*s(j)
                     qz(j,k+3)=qz(j,k+3)-twozeta*dzz(j)*s(j)+s(j)

                               endif
 1017 continue

 1015 continue

 1011 k=k+3

c  loop over d functions

      if(ncontd.eq.0) return

      do 1021 i=1,ncontd

      ilabel=nptrd(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1022 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1022 zz(j)=z(j)-cent(3,nc)

      do 1023 j=1,npts
      dxx(j)=xx(j)*xx(j)
      dxy(j)=xx(j)*yy(j)
      dxz(j)=xx(j)*zz(j)
      dyy(j)=yy(j)*yy(j)
      dyz(j)=yy(j)*zz(j)
 1023 dzz(j)=zz(j)*zz(j)

      do 1024 j=1,npts
      fxxx(j)=xx(j)*dxx(j)
      fxxy(j)=yy(j)*dxx(j)
      fxxz(j)=zz(j)*dxx(j)
      fxyy(j)=yy(j)*dxy(j)
      fxyz(j)=zz(j)*dxy(j)
      fxzz(j)=zz(j)*dxz(j)
      fyyy(j)=yy(j)*dyy(j)
      fyyz(j)=zz(j)*dyy(j)
      fyzz(j)=zz(j)*dyz(j)
 1024 fzzz(j)=zz(j)*dzz(j)

      do 1025 j=1,npts
 1025 rr(j)=dxx(j)+dyy(j)+dzz(j)

      do 1026 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      do 1027 j=1,npts
 1027 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1028 j=1,npts
      if(rralpha(j).lt.expcut) then

                     s(j)=coeff(nprimitive)*exp(-rralpha(j))

                     px(j)=xx(j)*s(j)
                     py(j)=yy(j)*s(j)
                     pz(j)=zz(j)*s(j)

                     qf(j,k+1)=qf(j,k+1)+dxx(j)*s(j)
                     qf(j,k+2)=qf(j,k+2)+dxy(j)*s(j)
                     qf(j,k+3)=qf(j,k+3)+dxz(j)*s(j)
                     qf(j,k+4)=qf(j,k+4)+dyy(j)*s(j)
                     qf(j,k+5)=qf(j,k+5)+dyz(j)*s(j)
                     qf(j,k+6)=qf(j,k+6)+dzz(j)*s(j)

                     qx(j,k+1)=qx(j,k+1)-twozeta*fxxx(j)*s(j)+two*px(j)
                     qy(j,k+1)=qy(j,k+1)-twozeta*fxxy(j)*s(j)
                     qz(j,k+1)=qz(j,k+1)-twozeta*fxxz(j)*s(j)

                     qx(j,k+2)=qx(j,k+2)-twozeta*fxxy(j)*s(j)+py(j)
                     qy(j,k+2)=qy(j,k+2)-twozeta*fxyy(j)*s(j)+px(j)
                     qz(j,k+2)=qz(j,k+2)-twozeta*fxyz(j)*s(j)

                     qx(j,k+3)=qx(j,k+3)-twozeta*fxxz(j)*s(j)+pz(j)
                     qy(j,k+3)=qy(j,k+3)-twozeta*fxyz(j)*s(j)
                     qz(j,k+3)=qz(j,k+3)-twozeta*fxzz(j)*s(j)+px(j)

                     qx(j,k+4)=qx(j,k+4)-twozeta*fxyy(j)*s(j)
                     qy(j,k+4)=qy(j,k+4)-twozeta*fyyy(j)*s(j)+two*py(j)
                     qz(j,k+4)=qz(j,k+4)-twozeta*fyyz(j)*s(j)

                     qx(j,k+5)=qx(j,k+5)-twozeta*fxyz(j)*s(j)
                     qy(j,k+5)=qy(j,k+5)-twozeta*fyyz(j)*s(j)+pz(j)
                     qz(j,k+5)=qz(j,k+5)-twozeta*fyzz(j)*s(j)+py(j)

                     qx(j,k+6)=qx(j,k+6)-twozeta*fxzz(j)*s(j)
                     qy(j,k+6)=qy(j,k+6)-twozeta*fyzz(j)*s(j)
                     qz(j,k+6)=qz(j,k+6)-twozeta*fzzz(j)*s(j)+two*pz(j)

                             endif
 1028 continue

 1026 continue

      do 1029 j=1,npts

      qf(j,k+1)=qf(j,k+1)*rsqrt3
      qf(j,k+4)=qf(j,k+4)*rsqrt3
      qf(j,k+6)=qf(j,k+6)*rsqrt3

      qx(j,k+1)=qx(j,k+1)*rsqrt3
      qy(j,k+1)=qy(j,k+1)*rsqrt3
      qz(j,k+1)=qz(j,k+1)*rsqrt3

      qx(j,k+4)=qx(j,k+4)*rsqrt3
      qy(j,k+4)=qy(j,k+4)*rsqrt3
      qz(j,k+4)=qz(j,k+4)*rsqrt3

      qx(j,k+6)=qx(j,k+6)*rsqrt3
      qy(j,k+6)=qy(j,k+6)*rsqrt3
      qz(j,k+6)=qz(j,k+6)*rsqrt3

 1029 continue

 1021 k=k+6

      return
      end
