      subroutine coreds(m,n,ncentr,icontr,inddyy,g,coord,charge,overlap,
     &                  core,zeta,zetaa,px,py,pz,pxax,pyay,pzaz,eta,
     &                  base,etarr,ss,ss0,ss1,ss2,ps,ps0,ps1,ds,dscond,
     &                  c,pxcx,pycy,pzcz,u,twozeta,eta2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*)

      dimension g(*),coord(3,*),charge(*),overlap(*),core(*),zeta(*),
     &          zetaa(*),px(*),py(*),pz(*),pxax(*),pyay(*),pzaz(*),
     &          eta(*),base(*),etarr(*),ss(*),ss0(*),ss1(*),ss2(*),
     &          ps(n,*),ps0(n,*),ps1(n,*),ds(n,*),dscond(m,*),c(*),
     &          pxcx(*),pycy(*),pzcz(*),u(*),twozeta(*),eta2(*)

      data zero,thrhlf,two,three,pi/0.0,1.5,2.0,3.0,3.1415926535898/

      sqrt3=sqrt(three)

      do 1001 i=1,n
      eta2(i)=two*eta(i)
 1001 twozeta(i)=two*zeta(i)

      do 1002 i=1,n
 1002 ss0(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1003 i=1,n
      ps0(i,1)=pxax(i)*ss0(i)
      ps0(i,2)=pyay(i)*ss0(i)
 1003 ps0(i,3)=pzaz(i)*ss0(i)

      do 1004 i=1,n
 1004 c(i)=ss0(i)/twozeta(i)

      do 1005 i=1,n
      ds(i,1)=pxax(i)*ps0(i,1)+c(i)
      ds(i,2)=pyay(i)*ps0(i,1)
      ds(i,3)=pzaz(i)*ps0(i,1)
      ds(i,4)=pyay(i)*ps0(i,2)+c(i)
      ds(i,5)=pzaz(i)*ps0(i,2)
 1005 ds(i,6)=pzaz(i)*ps0(i,3)+c(i)

      do 1006 j=1,6
      do 1006 i=1,m
 1006 dscond(i,j)=zero

      do 1007 j=1,6
      do 1007 i=1,n
 1007 dscond(icontr(i),j)=dscond(icontr(i),j)+ds(i,j)

      do 1008 j=1,6
      do 1008 i=1,m
 1008 overlap(inddyy(i,j))=overlap(inddyy(i,j))+dscond(i,j)

      do 1009 i=1,n
 1009 ss(i)=eta(i)*(three-two*etarr(i))*ss0(i)

      do 1010 i=1,n
      ps(i,1)=pxax(i)*ss(i)+eta2(i)*ps0(i,1)
      ps(i,2)=pyay(i)*ss(i)+eta2(i)*ps0(i,2)
 1010 ps(i,3)=pzaz(i)*ss(i)+eta2(i)*ps0(i,3)

      do 1011 i=1,n
 1011 c(i)=ss(i)/twozeta(i)-eta2(i)*ss0(i)/(two*zetaa(i))

      do 1012 i=1,n
      ds(i,1)=pxax(i)*ps(i,1)+eta2(i)*ds(i,1)+c(i)
      ds(i,2)=pyay(i)*ps(i,1)+eta2(i)*ds(i,2)
      ds(i,3)=pzaz(i)*ps(i,1)+eta2(i)*ds(i,3)
      ds(i,4)=pyay(i)*ps(i,2)+eta2(i)*ds(i,4)+c(i)
      ds(i,5)=pzaz(i)*ps(i,2)+eta2(i)*ds(i,5)
 1012 ds(i,6)=pzaz(i)*ps(i,3)+eta2(i)*ds(i,6)+c(i)

      do 1013 j=1,6
      do 1013 i=1,m
 1013 dscond(i,j)=zero

      do 1014 j=1,6
      do 1014 i=1,n
 1014 dscond(icontr(i),j)=dscond(icontr(i),j)+ds(i,j)

      do 1015 j=1,6
      do 1015 i=1,m
 1015 core(inddyy(i,j))=core(inddyy(i,j))+dscond(i,j)

      do 2001 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 2002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 2002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 2003 i=1,n
      call augg(3,u(i),g)
      ss0(i)=base(i)*g(1)*twopichrg/zeta(i)
      ss1(i)=base(i)*g(2)*twopichrg/zeta(i)
 2003 ss2(i)=base(i)*g(3)*twopichrg/zeta(i)

      do 2004 i=1,n

      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
      ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
      ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

 2004 continue

      do 2005 i=1,n
 2005 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 2006 i=1,n
      ds(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 2006 ds(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 2007 j=1,6
      do 2007 i=1,m
 2007 dscond(i,j)=zero

      do 2008 j=1,6
      do 2008 i=1,n
 2008 dscond(icontr(i),j)=dscond(icontr(i),j)+ds(i,j)

      do 2009 j=1,6
      do 2009 i=1,m
 2009 core(inddyy(i,j))=core(inddyy(i,j))-dscond(i,j)

 2001 continue

      do 3001 i=1,m

      overlap(inddyy(i,1))=overlap(inddyy(i,1))/sqrt3
      overlap(inddyy(i,4))=overlap(inddyy(i,4))/sqrt3
      overlap(inddyy(i,6))=overlap(inddyy(i,6))/sqrt3

      core(inddyy(i,1))=core(inddyy(i,1))/sqrt3
      core(inddyy(i,4))=core(inddyy(i,4))/sqrt3
      core(inddyy(i,6))=core(inddyy(i,6))/sqrt3

 3001 continue

      return
      end
