      subroutine drho(gx,gy,gz,hxx,hxy,hxz,hyy,hyz,hzz,gradmod,
     &                dlaplacian,xcpotterm)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      data zero,two,tolerance/0.0,2.0,1.0e-15/

      gradmod=sqrt(gx*gx+gy*gy+gz*gz)

      dlaplacian=hxx+hyy+hzz

      if(gradmod.gt.tolerance) then
                                     xcpotterm=(gx*gx*hxx
     &                                         +gx*gy*hxy*two
     &                                         +gx*gz*hxz*two
     &                                         +gy*gy*hyy
     &                                         +gy*gz*hyz*two
     &                                         +gz*gz*hzz)/gradmod
                               else
                                     xcpotterm=zero
                               endif

      return
      end
