      subroutine espgen(nlimit,mlimit,natoms,ncenters,maxpoints,nalpha,
     &                  nbeta,nconts,ncontp,ncontd,nunitpts,iprimvec,
     &                  nprimvec,icfunc,mtloca,nshels,nshelp,nsheld,
     &                  natomtype,iswitch,nequivnb,nequivvec,iwkvec,
     &                  coord,charge,dmata,dmatb,alpha,coeff,potpt,qqa,
     &                  qqb,radius,cneighbour,rneighbour,contacts,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension scale(4)

      dimension iprimvec(*),nprimvec(*),icfunc(*),mtloca(*),nshels(*),
     &          nshelp(*),nsheld(*),natomtype(*),iswitch(*),
     &          nequivvec(natoms,2),iwkvec(*)

      dimension coord(3,*),charge(*),dmata(*),dmatb(*),alpha(*),
     &          coeff(*),potpt(maxpoints,3),qqa(2*ncenters,*),qqb(*),
     &          radius(*),cneighbour(3,*),rneighbour(*),contacts(3,*),
     &          wkvec(*)

      data zero,one,debye,density/0.00,1.00,2.54176568,1.0/
      data scale/1.40,1.60,1.80,2.00/

      nespts=0

      dnetcharge=zero

      do 1001 i=1,ncenters
 1001 dnetcharge=dnetcharge+charge(i)

      dnetcharge=dnetcharge-real64(nalpha+nbeta)

      do 1002 i=1,ncenters
      qqa(i,ncenters+1)=one
 1002 qqa(ncenters+1,i)=one

      qqa(ncenters+1,ncenters+1)=zero

      if(nequivnb.gt.0) then
                              do 1003 i=1,nequivnb
                              qqa(nequivvec(i,1),ncenters+1+i)=+one
                              qqa(nequivvec(i,2),ncenters+1+i)=-one
                              qqa(ncenters+1+i,nequivvec(i,1))=+one
 1003                         qqa(ncenters+1+i,nequivvec(i,2))=-one
                        endif

      qqb(ncenters+1)=dnetcharge

      rewind 66

      call surfac(density,scale(1),coord,radius,cneighbour,rneighbour,
     &            contacts,potpt,natomtype,iswitch,nunitpts,ncenters,
     &            maxpoints,nesp1)

      nespts=nespts+nesp1

      call surfac(density,scale(2),coord,radius,cneighbour,rneighbour,
     &            contacts,potpt,natomtype,iswitch,nunitpts,ncenters,
     &            maxpoints,nesp2)

      nespts=nespts+nesp2

      call surfac(density,scale(3),coord,radius,cneighbour,rneighbour,
     &            contacts,potpt,natomtype,iswitch,nunitpts,ncenters,
     &            maxpoints,nesp3)

      nespts=nespts+nesp3

      call surfac(density,scale(4),coord,radius,cneighbour,rneighbour,
     &            contacts,potpt,natomtype,iswitch,nunitpts,ncenters,
     &            maxpoints,nesp4)

      nespts=nespts+nesp4

      rewind 66

      ndim=nconts+3*ncontp+6*ncontd
      ndim=ndim*(ndim+1)/2

      do 1004 i=1,ndim
 1004 wkvec(i)=dmata(i)+dmatb(i)

      iesp1=1
      iesp2=iesp1+ndim
      iesp3=iesp2+nespts*ncenters
      iesp4=iesp3+nespts*4

      if(iesp4.gt.nlimit) stop 'mesp evaluation'

      call mespmm(nlimit-iesp4,mlimit,nespts,ncenters,2*ncenters,nconts,
     &            ncontp,ncontd,nshels,nshelp,nsheld,mtloca,iprimvec,
     &            nprimvec,icfunc,iwkvec,coord,charge,alpha,coeff,
     &            wkvec(iesp1),qqa,qqb,wkvec(iesp2),wkvec(iesp3),
     &            wkvec(iesp4))

      call matinv(qqa,qqb,ncenters+1+nequivnb,1,2*ncenters)

      write(6,1005) nespts
 1005 format(' number of points used to fit esp = ',i6,/)

      do 1006 i=1,ncenters
 1006 write(6,1007) i,qqb(i)
 1007 format(' the esp fitted charge on atom # ',i3,' = ',f8.5)

      write(6,1008)
 1008 format(/)

      xcomp=zero
      ycomp=zero
      zcomp=zero

      do 1009 i=1,ncenters
      xcomp=xcomp+coord(1,i)*qqb(i)
      ycomp=ycomp+coord(2,i)*qqb(i)
 1009 zcomp=zcomp+coord(3,i)*qqb(i)

      dipole=sqrt(xcomp*xcomp+ycomp*ycomp+zcomp*zcomp)*debye

      write(6,1010) dipole
 1010 format(' dipole moment from point charges = ',f9.4,' debyes',//)

      write(99,1011)
 1011 format(1x)

      do 1012 i=1,ncenters
 1012 write(99,1013) natomtype(i),coord(1,i),coord(2,i),coord(3,i)
 1013 format(i5,5x,3f15.7)

      return
      end
