      subroutine gradmm(nreal,ninteger,ndim,natoms,nconts,ncontp,ncontd,
     &                  ncds,ncdspd,nshels,nshelp,nsheld,mtloca,iprimvc,
     &                  nprimvc,icentvc,icdlfunc,icdcfunc,iwkvec,coord,
     &                  charge,alpha,coeff,cdfitc,alphacd,coefscd,
     &                  coefpcd,coefdcd,gradient,overlap,dmata,dmatb,
     &                  density,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(8)

      dimension nshels(*),nshelp(*),nsheld(*),mtloca(*),iprimvc(*),
     &          nprimvc(*),icentvc(*),icdlfunc(*),icdcfunc(*),iwkvec(*)

      dimension coord(3,*),charge(*),alpha(*),coeff(*),cdfitc(*),
     &          alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),
     &          gradient(3,*),overlap(ndim,*),dmata(*),dmatb(*),
     &          density(*),wkvec(*)

      data zero,half,one,three/0.0,0.5,1.0,3.0/

      sqrt3=sqrt(three)

      ncontractions=nconts+3*ncontp+6*ncontd

      do 1001 i=1,ncontractions*(ncontractions+1)/2
 1001 density(i)=dmata(i)+dmatb(i)

      do 1002 i=1,ncontd
      do 1002 j=1,nconts

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshels(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3

 1002 continue

      do 1003 i=1,ncontd
      do 1003 j=1,ncontp

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshelp(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+1)=density(i4+1)/sqrt3
      density(i4+2)=density(i4+2)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3

 1003 continue

      do 1004 i=1,ncontd
      do 1004 j=1,i

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nsheld(j))
      i4=i2+i3

      density(i4)=density(i4)/three
      if(i.ne.j) density(i4+1)=density(i4+1)/sqrt3
      if(i.ne.j) density(i4+2)=density(i4+2)/sqrt3
      if(i.ne.j) density(i4+3)=density(i4+3)/three
      if(i.ne.j) density(i4+4)=density(i4+4)/sqrt3
      if(i.ne.j) density(i4+5)=density(i4+5)/three

      density(i4+i1)=density(i4+i1)/sqrt3
      if(i.ne.j) density(i4+i1+3)=density(i4+i1+3)/sqrt3
      if(i.ne.j) density(i4+i1+5)=density(i4+i1+5)/sqrt3

      density(i4+i1*2+1)=density(i4+i1*2+1)/sqrt3
      if(i.ne.j) density(i4+i1*2+4)=density(i4+i1*2+4)/sqrt3
      if(i.ne.j) density(i4+i1*2+6)=density(i4+i1*2+6)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/three
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3
      density(i4+i1*3+6)=density(i4+i1*3+6)/three
      if(i.ne.j) density(i4+i1*3+7)=density(i4+i1*3+7)/sqrt3
      if(i.ne.j) density(i4+i1*3+8)=density(i4+i1*3+8)/three

      density(i4+i1*4+6)=density(i4+i1*4+6)/sqrt3
      density(i4+i1*4+9)=density(i4+i1*4+9)/sqrt3
      if(i.ne.j) density(i4+i1*4+11)=density(i4+i1*4+11)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/three
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3
      density(i4+i1*5+13)=density(i4+i1*5+13)/three
      density(i4+i1*5+14)=density(i4+i1*5+14)/sqrt3
      density(i4+i1*5+15)=density(i4+i1*5+15)/three

 1004 continue

      do 1005 i=1,natoms
      do 1005 j=1,3
 1005 gradient(j,i)=zero

      do 1006 j=1,3
      do 1006 i=1,ndim
 1006 overlap(i,j)=zero

      do 1007 i=1,natoms
      do 1007 j=1,i

      if(i.eq.j) goto 1007

      factor=charge(i)*charge(j)/
     &       ((((coord(1,i)-coord(1,j))**2)+
     &         ((coord(2,i)-coord(2,j))**2)+
     &         ((coord(3,i)-coord(3,j))**2))**(one+half))

      gradient(1,i)=gradient(1,i)+factor*(coord(1,j)-coord(1,i))
      gradient(2,i)=gradient(2,i)+factor*(coord(2,j)-coord(2,i))
      gradient(3,i)=gradient(3,i)+factor*(coord(3,j)-coord(3,i))

      gradient(1,j)=gradient(1,j)+factor*(coord(1,i)-coord(1,j))
      gradient(2,j)=gradient(2,j)+factor*(coord(2,i)-coord(2,j))
      gradient(3,j)=gradient(3,j)+factor*(coord(3,i)-coord(3,j))

 1007 continue

      ncposs=nconts*(nconts+1)/2
      ncpopp=ncontp*(ncontp+1)/2
      ncpodd=ncontd*(ncontd+1)/2

      ncpops=ncontp*nconts
      ncpods=ncontd*nconts
      ncpodp=ncontd*ncontp

      npposs=0
      nppops=0
      nppopp=0
      nppods=0
      nppodp=0
      nppodd=0

      do 1008 i=1,nconts
      do 1008 j=1,i
 1008 npposs=npposs+nprimvc(nshels(i))*nprimvc(nshels(j))

      do 1009 i=1,ncontp
      do 1009 j=1,nconts
 1009 nppops=nppops+nprimvc(nshelp(i))*nprimvc(nshels(j))

      do 1010 i=1,ncontp
      do 1010 j=1,i
 1010 nppopp=nppopp+nprimvc(nshelp(i))*nprimvc(nshelp(j))

      do 1011 i=1,ncontd
      do 1011 j=1,nconts
 1011 nppods=nppods+nprimvc(nsheld(i))*nprimvc(nshels(j))

      do 1012 i=1,ncontd
      do 1012 j=1,ncontp
 1012 nppodp=nppodp+nprimvc(nsheld(i))*nprimvc(nshelp(j))

      do 1013 i=1,ncontd
      do 1013 j=1,i
 1013 nppodd=nppodd+nprimvc(nsheld(i))*nprimvc(nsheld(j))

      ja=1
      jb=ja+npposs
      jc=jb+ncposs

      ia=jc+ncposs*2
      ib=ia+npposs

      if(ib.gt.ninteger) stop 'gradmm ss integer overflow'

      je=1
      jf=je+npposs
      jg=jf+npposs
      jh=jg+npposs
      ji=jh+npposs
      jj=ji+npposs
      jk=jj+npposs
      jl=jk+npposs
      jm=jl+npposs
      jn=jm+npposs
      jo=jn+npposs
      jp=jo+npposs
      jq=jp+npposs
      jr=jq+npposs
      js=jr+npposs
      jt=js+npposs
      ju=jt+npposs
      jv=ju+npposs
      jw=jv+npposs
      jx=jw+ncposs
      jy=jx+ncposs
      jz=jy+ncposs

      if(jz.gt.nreal) stop 'gradmm ss real overflow'

      call setupgss(ncposs,n,nconts,nshels,mtloca,iprimvc,nprimvc,
     &              icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,
     &              alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &              wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &              wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &              wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n*3
      kd=kc+ncposs*3
      ke=kd+ncposs*3

      if(ke.gt.nreal) stop 'gradmm ss real overflow'

      call gradovss(ndim,ncposs,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              density,overlap,gradient,wkvec(je),wkvec(jh),
     &              wkvec(jm),wkvec(jn),wkvec(jp),wkvec(jo),wkvec(jt),
     &              wkvec(ju),wkvec(jv),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n*3
      ki=kh+ncposs
      kj=ki+ncposs*3
      kk=kj+ncposs*3
      kl=kk+ncposs*3

      if(kl.gt.nreal) stop 'gradmm ss real overflow'

      call gradnass(ncposs,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              g,coord,charge,density,gradient,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n*3
      ks=kr+ncposs
      kt=ks+ncposs*3
      ku=kt+ncposs*3
      kv=ku+ncposs*3

      if(kv.gt.nreal) stop 'gradmm ss real overflow'

      call gradcdss(ncposs,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n*3
      kz=ky+n*3
      la=kz+n*3
      lb=la+n*3
      lc=lb+n*3
      ld=lc+n*6
      le=ld+n*9
      lf=le+n*9
      lg=lf+n*18
      lh=lg+n
      li=lh+n*3
      lj=li+n*3
      lk=lj+ncposs
      ll=lk+ncposs*3
      lm=ll+ncposs*6
      ln=lm+ncposs*3
      lo=ln+ncposs*9
      lp=lo+ncposs*18
      lq=lp+ncposs*3
      lr=lq+ncposs*9
      ls=lr+ncposs*18
      lt=ls+ncposs*3

      if(lt.gt.nreal) stop 'gradmm ss real overflow'

      call gradxxss(ncposs,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,coefpcd,coefdcd,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &              wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &              wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &              wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &              wkvec(lq),wkvec(lr),wkvec(ls))

      if(ncontp.eq.0) goto 1014

      ja=1
      jb=ja+nppops
      jc=jb+ncpops*3

      ia=jc+ncpops*2
      ib=ia+nppops

      if(ib.gt.ninteger) stop 'gradmm ps integer overflow'

      je=1
      jf=je+nppops
      jg=jf+nppops
      jh=jg+nppops
      ji=jh+nppops
      jj=ji+nppops
      jk=jj+nppops
      jl=jk+nppops
      jm=jl+nppops
      jn=jm+nppops
      jo=jn+nppops
      jp=jo+nppops
      jq=jp+nppops
      jr=jq+nppops
      js=jr+nppops
      jt=js+nppops
      ju=jt+nppops
      jv=ju+nppops
      jw=jv+nppops
      jx=jw+ncpops
      jy=jx+ncpops
      jz=jy+ncpops

      if(jz.gt.nreal) stop 'gradmm ps real overflow'

      call setupgps(ncpops,n,ncontp,nconts,nshelp,nshels,mtloca,iprimvc,
     &              nprimvc,icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              coord,alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),
     &              wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),
     &              wkvec(jm),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*6
      kg=kf+n
      kh=kg+ncpops
      ki=kh+ncpops*6
      kj=ki+ncpops*9

      if(kj.gt.nreal) stop 'gradmm ps real overflow'

      call gradovps(ndim,ncpops,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              density,overlap,gradient,wkvec(je),wkvec(jh),
     &              wkvec(jm),wkvec(jn),wkvec(jp),wkvec(jo),wkvec(jt),
     &              wkvec(ju),wkvec(jv),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              wkvec(ki))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n*3
      kk=kj+n*3
      kl=kk+n*6
      km=kl+n
      kn=km+ncpops
      ko=kn+ncpops*3
      kp=ko+ncpops*6
      kq=kp+ncpops*9
      kr=kq+ncpops*9

      if(kr.gt.nreal) stop 'gradmm ps real overflow'

      call gradnaps(ncpops,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              g,coord,charge,density,gradient,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n*3
      ku=kt+n*3
      kv=ku+n*6
      kw=kv+n
      kx=kw+ncpops
      ky=kx+ncpops*3
      kz=ky+ncpops*6
      k0=kz+ncpops*9
      k1=k0+ncpops*9

      if(k1.gt.nreal) stop 'gradmm ps real overflow'

      call gradcdps(ncpops,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &              wkvec(ky),wkvec(kz),wkvec(k0))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n*3
      la=kz+n*3
      lb=la+n*3
      lc=lb+n*3
      ld=lc+n*6
      le=ld+n*6
      lf=le+n*6
      lg=lf+n*3
      lh=lg+n*3
      li=lh+n*6
      lj=li+n*9
      lk=lj+n*9
      ll=lk+n*18
      lm=ll+n*18
      ln=lm+n*18
      lo=ln+n*36
      lp=lo+n
      lq=lp+n*6
      lr=lq+n*9
      ls=lr+ncpops
      lt=ls+ncpops*3
      lu=lt+ncpops*6
      lv=lu+ncpops*3
      lw=lv+ncpops*9
      lx=lw+ncpops*18
      ly=lx+ncpops*6
      lz=ly+ncpops*18
      ma=lz+ncpops*36
      mb=ma+ncpops*9
      mc=mb+ncpops*27
      md=mc+ncpops*54
      me=md+ncpops*9

      if(me.gt.nreal) stop 'gradmm ps real overflow'

      call gradxxps(ncpops,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,coefpcd,coefdcd,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &              wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &              wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &              wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &              wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),
     &              wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz),
     &              wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md))

      ja=1
      jb=ja+ncpopp
      jc=jb+nppopp
      jd=jc+ncpopp*9

      ia=jd+ncpopp*2
      ib=ia+nppopp

      if(ib.gt.ninteger) stop 'gradmm pp integer overflow'

      je=1
      jf=je+nppopp
      jg=jf+nppopp
      jh=jg+nppopp
      ji=jh+nppopp
      jj=ji+nppopp
      jk=jj+nppopp
      jl=jk+nppopp
      jm=jl+nppopp
      jn=jm+nppopp
      jo=jn+nppopp
      jp=jo+nppopp
      jq=jp+nppopp
      jr=jq+nppopp
      js=jr+nppopp
      jt=js+nppopp
      ju=jt+nppopp
      jv=ju+nppopp
      jw=jv+nppopp
      jx=jw+nppopp
      jy=jx+nppopp
      jz=jy+nppopp
      j0=jz+ncpopp
      j1=j0+ncpopp
      j2=j1+ncpopp

      if(j2.gt.nreal) stop 'gradmm pp real overflow'

      call setupgpp(ncpopp,n,ncontp,nshelp,mtloca,iprimvc,nprimvc,
     &              icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),iwkvec(jd),
     &              coord,alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),
     &              wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),
     &              wkvec(jm),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jz),wkvec(j0),
     &              wkvec(j1))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+n*6
      kh=kg+n*18
      ki=kh+n
      kj=ki+n*3
      kk=kj+ncpopp*3
      kl=kk+ncpopp*18
      km=kl+ncpopp*27

      if(km.gt.nreal) stop 'gradmm pp real overflow'

      call gradovpp(ndim,ncpopp,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              iwkvec(jd),density,overlap,gradient,wkvec(je),
     &              wkvec(jh),wkvec(jm),wkvec(jn),wkvec(jp),wkvec(jo),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n*3
      kl=kk+n*3
      km=kl+n*3
      kn=km+n*6
      ko=kn+n*6
      kp=ko+n*10
      kq=kp+n
      kr=kq+n*3
      ks=kr+ncpopp
      kt=ks+ncpopp*3
      ku=kt+ncpopp*3
      kv=ku+ncpopp*6
      kw=kv+ncpopp*9
      kx=kw+ncpopp*10
      ky=kx+ncpopp*18
      kz=ky+ncpopp*18
      k0=kz+ncpopp*27

      if(k0.gt.nreal) stop 'gradmm pp real overflow'

      call gradnapp(ncpopp,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              iwkvec(jd),g,coord,charge,density,gradient,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jz),wkvec(j0),wkvec(j1),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n*3
      kv=ku+n*3
      kw=kv+n*3
      kx=kw+n*6
      ky=kx+n*6
      kz=ky+n*10
      la=kz+n
      lb=la+n*3
      lc=lb+ncpopp
      ld=lc+ncpopp*3
      le=ld+ncpopp*3
      lf=le+ncpopp*6
      lg=lf+ncpopp*9
      lh=lg+ncpopp*10
      li=lh+ncpopp*18
      lj=li+ncpopp*18
      lk=lj+ncpopp*27

      if(lk.gt.nreal) stop 'gradmm pp real overflow'

      call gradcdpp(ncpopp,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(jd),iwkvec(ia),g,coord,
     &              density,gradient,cdfitc,alphacd,coefscd,wkvec(je),
     &              wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),
     &              wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jz),
     &              wkvec(j0),wkvec(j1),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &              wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &              wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),
     &              wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),
     &              wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),
     &              wkvec(lh),wkvec(li),wkvec(lj))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n*3
      lb=la+n*3
      lc=lb+n*3
      ld=lc+n*3
      le=ld+n*3
      lf=le+n*6
      lg=lf+n*6
      lh=lg+n*6
      li=lh+n*6
      lj=li+n*10
      lk=lj+n*10
      ll=lk+n*10
      lm=ll+n*3
      ln=lm+n*3
      lo=ln+n*6
      lp=lo+n*9
      lq=lp+n*9
      lr=lq+n*18
      ls=lr+n*18
      lt=ls+n*18
      lu=lt+n*36
      lv=lu+n*30
      lw=lv+n*30
      lx=lw+n*60
      ly=lx+n
      lz=ly+n*10
      ma=lz+n*18
      mb=ma+ncpopp
      mc=mb+ncpopp*3
      md=mc+ncpopp*6
      me=md+ncpopp*3
      mf=me+ncpopp*9
      mg=mf+ncpopp*18
      mh=mg+ncpopp*3
      mi=mh+ncpopp*9
      mj=mi+ncpopp*18
      mk=mj+ncpopp*6
      ml=mk+ncpopp*18
      mm=ml+ncpopp*36
      mn=mm+ncpopp*9
      mo=mn+ncpopp*27
      mp=mo+ncpopp*54
      mq=mp+ncpopp*10
      mr=mq+ncpopp*30
      ms=mr+ncpopp*60
      mt=ms+ncpopp*18
      mu=mt+ncpopp*54
      mv=mu+ncpopp*108
      mw=mv+ncpopp*18
      mx=mw+ncpopp*54
      my=mx+ncpopp*108
      mz=my+ncpopp*27

      if(mz.gt.nreal) stop 'gradmm pp real overflow'

      call gradxxpp(ncpopp,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(jd),iwkvec(ia),g,coord,
     &              density,gradient,cdfitc,alphacd,coefscd,coefpcd,
     &              coefdcd,wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),
     &              wkvec(jv),wkvec(jz),wkvec(j0),wkvec(j1),wkvec(ka),
     &              wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &              wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &              wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &              wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),
     &              wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),
     &              wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),
     &              wkvec(lf),wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),
     &              wkvec(lk),wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),
     &              wkvec(lp),wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),
     &              wkvec(lu),wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),
     &              wkvec(lz),wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md),
     &              wkvec(me),wkvec(mf),wkvec(mg),wkvec(mh),wkvec(mi),
     &              wkvec(mj),wkvec(mk),wkvec(ml),wkvec(mm),wkvec(mn),
     &              wkvec(mo),wkvec(mp),wkvec(mq),wkvec(mr),wkvec(ms),
     &              wkvec(mt),wkvec(mu),wkvec(mv),wkvec(mw),wkvec(mx),
     &              wkvec(my))

      if(ncontd.eq.0) goto 1014

      ja=1
      jb=ja+nppods
      jc=jb+ncpods*6

      ia=jc+ncpods*2
      ib=ia+nppods

      if(ib.gt.ninteger) stop 'gradmm ds integer overflow'

      je=1
      jf=je+nppods
      jg=jf+nppods
      jh=jg+nppods
      ji=jh+nppods
      jj=ji+nppods
      jk=jj+nppods
      jl=jk+nppods
      jm=jl+nppods
      jn=jm+nppods
      jo=jn+nppods
      jp=jo+nppods
      jq=jp+nppods
      jr=jq+nppods
      js=jr+nppods
      jt=js+nppods
      ju=jt+nppods
      jv=ju+nppods
      jw=jv+nppods
      jx=jw+ncpods
      jy=jx+ncpods
      jz=jy+ncpods

      if(jz.gt.nreal) stop 'gradmm ds real overflow'

      call setupgds(ncpods,n,ncontd,nconts,nsheld,nshels,mtloca,iprimvc,
     &              nprimvc,icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              coord,alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),
     &              wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),
     &              wkvec(jm),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+n*6
      kh=kg+n*10
      ki=kh+n
      kj=ki+n*3
      kk=kj+ncpods*3
      kl=kk+ncpods*10
      km=kl+ncpods*18

      if(km.gt.nreal) stop 'gradmm ds real overflow'

      call gradovds(ndim,ncpods,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              density,overlap,gradient,wkvec(je),wkvec(jh),
     &              wkvec(jm),wkvec(jn),wkvec(jp),wkvec(jo),wkvec(jt),
     &              wkvec(ju),wkvec(jv),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n*3
      kl=kk+n*3
      km=kl+n*3
      kn=km+n*6
      ko=kn+n*6
      kp=ko+n*10
      kq=kp+n
      kr=kq+n*3
      ks=kr+ncpods*3
      kt=ks+ncpods*6
      ku=kt+ncpods*10
      kv=ku+ncpods*18
      kw=kv+ncpods*18

      if(kw.gt.nreal) stop 'gradmm ds real overflow'

      call gradnads(ncpods,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              g,coord,charge,density,gradient,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku),wkvec(kv))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n*3
      kv=ku+n*3
      kw=kv+n*3
      kx=kw+n*6
      ky=kx+n*6
      kz=ky+n*10
      k0=kz+n
      k1=k0+n*3
      k2=k1+ncpods*3
      k3=k2+ncpods*6
      k4=k3+ncpods*10
      k5=k4+ncpods*18
      k6=k5+ncpods*18

      if(k6.gt.nreal) stop 'gradmm ds real overflow'

      call gradcdds(ncpods,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),
     &              wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &              wkvec(ky),wkvec(kz),wkvec(k0),wkvec(k1),wkvec(k2),
     &              wkvec(k3),wkvec(k4),wkvec(k5))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n*3
      lb=la+n*3
      lc=lb+n*3
      ld=lc+n*3
      le=ld+n*3
      lf=le+n*6
      lg=lf+n*6
      lh=lg+n*6
      li=lh+n*6
      lj=li+n*10
      lk=lj+n*10
      ll=lk+n*10
      lm=ll+n*3
      ln=lm+n*9
      lo=ln+n*9
      lp=lo+n*18
      lq=lp+n*18
      lr=lq+n*18
      ls=lr+n*36
      lt=ls+n*30
      lu=lt+n*30
      lv=lu+n*60
      lw=lv+n
      lx=lw+n*10
      ly=lx+n*18
      lz=ly+ncpods*3
      ma=lz+ncpods*9
      mb=ma+ncpods*18
      mc=mb+ncpods*6
      md=mc+ncpods*18
      me=md+ncpods*36
      mf=me+ncpods*10
      mg=mf+ncpods*30
      mh=mg+ncpods*60
      mi=mh+ncpods*18
      mj=mi+ncpods*54
      mk=mj+ncpods*108
      ml=mk+ncpods*18

      if(ml.gt.nreal) stop 'gradmm ds real overflow'

      call gradxxds(ncpods,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,coefpcd,coefdcd,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &              wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &              wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &              wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &              wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),
     &              wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz),
     &              wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md),wkvec(me),
     &              wkvec(mf),wkvec(mg),wkvec(mh),wkvec(mi),wkvec(mj),
     &              wkvec(mk))

      ja=1
      jb=ja+nppodp
      jc=jb+ncpodp*18

      ia=jc+ncpodp*2
      ib=ia+nppodp

      if(ib.gt.ninteger) stop 'gradmm dp integer overflow'

      je=1
      jf=je+nppodp
      jg=jf+nppodp
      jh=jg+nppodp
      ji=jh+nppodp
      jj=ji+nppodp
      jk=jj+nppodp
      jl=jk+nppodp
      jm=jl+nppodp
      jn=jm+nppodp
      jo=jn+nppodp
      jp=jo+nppodp
      jq=jp+nppodp
      jr=jq+nppodp
      js=jr+nppodp
      jt=js+nppodp
      ju=jt+nppodp
      jv=ju+nppodp
      jw=jv+nppodp
      jx=jw+nppodp
      jy=jx+nppodp
      jz=jy+nppodp
      j0=jz+ncpodp
      j1=j0+ncpodp
      j2=j1+ncpodp

      if(j2.gt.nreal) stop 'gradmm dp real overflow'

      call setupgdp(ncpodp,n,ncontd,ncontp,nsheld,nshelp,mtloca,iprimvc,
     &              nprimvc,icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              coord,alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),
     &              wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),
     &              wkvec(jm),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jz),wkvec(j0),
     &              wkvec(j1))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+n*6
      kh=kg+n*9
      ki=kh+n*10
      kj=ki+n*30
      kk=kj+n
      kl=kk+n*3
      km=kl+n*6
      kn=km+ncpodp*9
      ko=kn+ncpodp*30
      kp=ko+ncpodp*54

      if(kp.gt.nreal) stop 'gradmm dp real overflow'

      call gradovdp(ndim,ncpodp,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              density,overlap,gradient,wkvec(je),wkvec(jh),
     &              wkvec(jm),wkvec(jn),wkvec(jp),wkvec(jo),wkvec(jt),
     &              wkvec(ju),wkvec(jv),wkvec(jw),wkvec(jx),wkvec(jy),
     &              wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &              wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &              wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n*3
      km=kl+n*3
      kn=km+n*3
      ko=kn+n*3
      kp=ko+n*6
      kq=kp+n*6
      kr=kq+n*6
      ks=kr+n*10
      kt=ks+n*10
      ku=kt+n*15
      kv=ku+n
      kw=kv+n*6
      kx=kw+ncpodp*3
      ky=kx+ncpodp*6
      kz=ky+ncpodp*9
      k0=kz+ncpodp*10
      k1=k0+ncpodp*18
      k2=k1+ncpodp*15
      k3=k2+ncpodp*30
      k4=k3+ncpodp*36
      k5=k4+ncpodp*54

      if(k5.gt.nreal) stop 'gradmm dp real overflow'

      call gradnadp(ncpodp,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              g,coord,charge,density,gradient,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jz),wkvec(j0),
     &              wkvec(j1),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &              wkvec(ky),wkvec(kz),wkvec(k0),wkvec(k1),wkvec(k2),
     &              wkvec(k3),wkvec(k4))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n*3
      kw=kv+n*3
      kx=kw+n*3
      ky=kx+n*3
      kz=ky+n*6
      la=kz+n*6
      lb=la+n*6
      lc=lb+n*10
      ld=lc+n*10
      le=ld+n*15
      lf=le+n
      lg=lf+n*6
      lh=lg+ncpodp*3
      li=lh+ncpodp*6
      lj=li+ncpodp*9
      lk=lj+ncpodp*10
      ll=lk+ncpodp*18
      lm=ll+ncpodp*15
      ln=lm+ncpodp*30
      lo=ln+ncpodp*36
      lp=lo+ncpodp*54

      if(lp.gt.nreal) stop 'gradmm dp real overflow'

      call gradcddp(ncpodp,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,wkvec(je),wkvec(jh),
     &              wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jp),
     &              wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jz),wkvec(j0),
     &              wkvec(j1),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &              wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &              wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),
     &              wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),
     &              wkvec(li),wkvec(lj),wkvec(lk),wkvec(ll),wkvec(lm),
     &              wkvec(ln),wkvec(lo))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n
      lb=la+n*3
      lc=lb+n*3
      ld=lc+n*3
      le=ld+n*3
      lf=le+n*3
      lg=lf+n*3
      lh=lg+n*6
      li=lh+n*6
      lj=li+n*6
      lk=lj+n*6
      ll=lk+n*6
      lm=ll+n*10
      ln=lm+n*10
      lo=ln+n*10
      lp=lo+n*10
      lq=lp+n*15
      lr=lq+n*15
      ls=lr+n*15
      lt=ls+n*3
      lu=lt+n*9
      lv=lu+n*9
      lw=lv+n*18
      lx=lw+n*18
      ly=lx+n*18
      lz=ly+n*36
      ma=lz+n*30
      mb=ma+n*30
      mc=mb+n*60
      md=mc+n*45
      me=md+n*45
      mf=me+n*90
      mg=mf+n
      mh=mg+n*15
      mi=mh+n*30
      mj=mi+ncpodp*3
      mk=mj+ncpodp*9
      ml=mk+ncpodp*18
      mm=ml+ncpodp*6
      mn=mm+ncpodp*18
      mo=mn+ncpodp*36
      mp=mo+ncpodp*9
      mq=mp+ncpodp*27
      mr=mq+ncpodp*54
      ms=mr+ncpodp*10
      mt=ms+ncpodp*30
      mu=mt+ncpodp*60
      mv=mu+ncpodp*18
      mw=mv+ncpodp*54
      mx=mw+ncpodp*108
      my=mx+ncpodp*15
      mz=my+ncpodp*45
      na=mz+ncpodp*90
      nb=na+ncpodp*30
      nc=nb+ncpodp*90
      nd=nc+ncpodp*180
      ne=nd+ncpodp*36
      nf=ne+ncpodp*108
      ng=nf+ncpodp*216
      nh=ng+ncpodp*54

      if(nh.gt.nreal) stop 'gradmm dp real overflow'

      call gradxxdp(ncpodp,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(ia),g,coord,density,
     &              gradient,cdfitc,alphacd,coefscd,coefpcd,coefdcd,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jz),wkvec(j0),wkvec(j1),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &              wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &              wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &              wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &              wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),
     &              wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz),
     &              wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md),wkvec(me),
     &              wkvec(mf),wkvec(mg),wkvec(mh),wkvec(mi),wkvec(mj),
     &              wkvec(mk),wkvec(ml),wkvec(mm),wkvec(mn),wkvec(mo),
     &              wkvec(mp),wkvec(mq),wkvec(mr),wkvec(ms),wkvec(mt),
     &              wkvec(mu),wkvec(mv),wkvec(mw),wkvec(mx),wkvec(my),
     &              wkvec(mz),wkvec(na),wkvec(nb),wkvec(nc),wkvec(nd),
     &              wkvec(ne),wkvec(nf),wkvec(ng))

      ja=1
      jb=ja+ncpodd
      jc=jb+nppodd
      jd=jc+ncpodd*36

      ia=jd+ncpodd*2
      ib=ia+nppodd

      if(ib.gt.ninteger) stop 'gradmm dd integer overflow'

      je=1
      jf=je+nppodd
      jg=jf+nppodd
      jh=jg+nppodd
      ji=jh+nppodd
      jj=ji+nppodd
      jk=jj+nppodd
      jl=jk+nppodd
      jm=jl+nppodd
      jn=jm+nppodd
      jo=jn+nppodd
      jp=jo+nppodd
      jq=jp+nppodd
      jr=jq+nppodd
      js=jr+nppodd
      jt=js+nppodd
      ju=jt+nppodd
      jv=ju+nppodd
      jw=jv+nppodd
      jx=jw+nppodd
      jy=jx+nppodd
      jz=jy+nppodd
      j0=jz+ncpodd
      j1=j0+ncpodd
      j2=j1+ncpodd

      if(j2.gt.nreal) stop 'gradmm dd real overflow'

      call setupgdd(ncpodd,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &              icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),iwkvec(jd),
     &              coord,alpha,coeff,wkvec(je),wkvec(jf),wkvec(jg),
     &              wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),
     &              wkvec(jm),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jz),wkvec(j0),
     &              wkvec(j1))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*6
      ki=kh+n*6
      kj=ki+n*6
      kk=kj+n*10
      kl=kk+n*10
      km=kl+n*18
      kn=km+n*18
      ko=kn+n*30
      kp=ko+n*60
      kq=kp+n
      kr=kq+n*10
      ks=kr+n*18
      kt=ks+ncpodd*18
      ku=kt+ncpodd*60
      kv=ku+ncpodd*108

      if(kv.gt.nreal) stop 'gradmm dd real overflow'

      call gradovdd(ndim,ncpodd,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              iwkvec(jd),density,overlap,gradient,wkvec(je),
     &              wkvec(jh),wkvec(ji),wkvec(jm),wkvec(jn),wkvec(jp),
     &              wkvec(jo),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &              wkvec(jx),wkvec(jy),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &              wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &              wkvec(ks),wkvec(kt),wkvec(ku))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n*3
      kn=km+n*3
      ko=kn+n*3
      kp=ko+n*3
      kq=kp+n*3
      kr=kq+n*6
      ks=kr+n*6
      kt=ks+n*6
      ku=kt+n*6
      kv=ku+n*10
      kw=kv+n*10
      kx=kw+n*10
      ky=kx+n*15
      kz=ky+n*15
      la=kz+n*21
      lb=la+n
      lc=lb+n*10
      ld=lc+ncpodd*3
      le=ld+ncpodd*6
      lf=le+ncpodd*9
      lg=lf+ncpodd*10
      lh=lg+ncpodd*18
      li=lh+ncpodd*18
      lj=li+ncpodd*15
      lk=lj+ncpodd*30
      ll=lk+ncpodd*36
      lm=ll+ncpodd*21
      ln=lm+ncpodd*45
      lo=ln+ncpodd*60
      lp=lo+ncpodd*60
      lq=lp+ncpodd*108

      if(lq.gt.nreal) stop 'gradmm dd real overflow'

      call gradnadd(ncpodd,n,natoms,iwkvec(ja),iwkvec(jb),iwkvec(jc),
     &              iwkvec(jd),g,coord,charge,density,gradient,
     &              wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jz),wkvec(j0),wkvec(j1),wkvec(ka),wkvec(kb),
     &              wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &              wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &              wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &              wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &              wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &              wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &              wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &              wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &              wkvec(lq))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n*3
      kx=kw+n*3
      ky=kx+n*3
      kz=ky+n*3
      la=kz+n*3
      lb=la+n*6
      lc=lb+n*6
      ld=lc+n*6
      le=ld+n*6
      lf=le+n*10
      lg=lf+n*10
      lh=lg+n*10
      li=lh+n*15
      lj=li+n*15
      lk=lj+n*21
      ll=lk+n
      lm=ll+n*10
      ln=lm+ncpodd*3
      lo=ln+ncpodd*6
      lp=lo+ncpodd*9
      lq=lp+ncpodd*10
      lr=lq+ncpodd*18
      ls=lr+ncpodd*18
      lt=ls+ncpodd*15
      lu=lt+ncpodd*30
      lv=lu+ncpodd*36
      lw=lv+ncpodd*21
      lx=lw+ncpodd*45
      ly=lx+ncpodd*60
      lz=ly+ncpodd*60
      l0=lz+ncpodd*108

      if(l0.gt.nreal) stop 'gradmm dd real overflow'

      call gradcddd(ncpodd,n,ncds,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(jd),iwkvec(ia),g,coord,
     &              density,gradient,cdfitc,alphacd,coefscd,wkvec(je),
     &              wkvec(jh),wkvec(ji),wkvec(jq),wkvec(jr),wkvec(js),
     &              wkvec(jp),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jz),
     &              wkvec(j0),wkvec(j1),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &              wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &              wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),
     &              wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),
     &              wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),
     &              wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),wkvec(ll),
     &              wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),wkvec(lq),
     &              wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),wkvec(lv),
     &              wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz))

      ka=j2+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n
      lb=la+n
      lc=lb+n*3
      ld=lc+n*3
      le=ld+n*3
      lf=le+n*3
      lg=lf+n*3
      lh=lg+n*3
      li=lh+n*3
      lj=li+n*6
      lk=lj+n*6
      ll=lk+n*6
      lm=ll+n*6
      ln=lm+n*6
      lo=ln+n*6
      lp=lo+n*10
      lq=lp+n*10
      lr=lq+n*10
      ls=lr+n*10
      lt=ls+n*10
      lu=lt+n*15
      lv=lu+n*15
      lw=lv+n*15
      lx=lw+n*15
      ly=lx+n*21
      lz=ly+n*21
      ma=lz+n*21
      mb=ma+n*3
      mc=mb+n*9
      md=mc+n*9
      me=md+n*18
      mf=me+n*18
      mg=mf+n*18
      mh=mg+n*36
      mi=mh+n*30
      mj=mi+n*30
      mk=mj+n*60
      ml=mk+n*45
      mm=ml+n*45
      mn=mm+n*90
      mo=mn+n*63
      mp=mo+n*63
      mq=mp+n*126
      mr=mq+n
      ms=mr+n*21
      mt=ms+n*45
      mu=mt+ncpodd*3
      mv=mu+ncpodd*9
      mw=mv+ncpodd*18
      mx=mw+ncpodd*6
      my=mx+ncpodd*18
      mz=my+ncpodd*36
      na=mz+ncpodd*9
      nb=na+ncpodd*27
      nc=nb+ncpodd*54
      nd=nc+ncpodd*10
      ne=nd+ncpodd*30
      nf=ne+ncpodd*60
      ng=nf+ncpodd*18
      nh=ng+ncpodd*54
      ni=nh+ncpodd*108
      nj=ni+ncpodd*18
      nk=nj+ncpodd*54
      nl=nk+ncpodd*108
      nm=nl+ncpodd*15
      nn=nm+ncpodd*45
      no=nn+ncpodd*90
      np=no+ncpodd*30
      nq=np+ncpodd*90
      nr=nq+ncpodd*180
      ns=nr+ncpodd*36
      nt=ns+ncpodd*108
      nu=nt+ncpodd*216
      nv=nu+ncpodd*21
      nw=nv+ncpodd*63
      nx=nw+ncpodd*126
      ny=nx+ncpodd*45
      nz=ny+ncpodd*135
      n0=nz+ncpodd*270
      n1=n0+ncpodd*60
      n2=n1+ncpodd*180
      n3=n2+ncpodd*360
      n4=n3+ncpodd*60
      n5=n4+ncpodd*180
      n6=n5+ncpodd*360
      n7=n6+ncpodd*108

      if(n7.gt.nreal) stop 'gradmm dd real overflow'

      call gradxxdd(ncpodd,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &              iwkvec(jb),iwkvec(jc),iwkvec(jd),iwkvec(ia),g,coord,
     &              density,gradient,cdfitc,alphacd,coefscd,coefpcd,
     &              coefdcd,wkvec(je),wkvec(jh),wkvec(ji),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jp),wkvec(jt),wkvec(ju),
     &              wkvec(jv),wkvec(jz),wkvec(j0),wkvec(j1),wkvec(ka),
     &              wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &              wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &              wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &              wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),
     &              wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),
     &              wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),
     &              wkvec(lf),wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),
     &              wkvec(lk),wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),
     &              wkvec(lp),wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),
     &              wkvec(lu),wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),
     &              wkvec(lz),wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md),
     &              wkvec(me),wkvec(mf),wkvec(mg),wkvec(mh),wkvec(mi),
     &              wkvec(mj),wkvec(mk),wkvec(ml),wkvec(mm),wkvec(mn),
     &              wkvec(mo),wkvec(mp),wkvec(mq),wkvec(mr),wkvec(ms),
     &              wkvec(mt),wkvec(mu),wkvec(mv),wkvec(mw),wkvec(mx),
     &              wkvec(my),wkvec(mz),wkvec(na),wkvec(nb),wkvec(nc),
     &              wkvec(nd),wkvec(ne),wkvec(nf),wkvec(ng),wkvec(nh),
     &              wkvec(ni),wkvec(nj),wkvec(nk),wkvec(nl),wkvec(nm),
     &              wkvec(nn),wkvec(no),wkvec(np),wkvec(nq),wkvec(nr),
     &              wkvec(ns),wkvec(nt),wkvec(nu),wkvec(nv),wkvec(nw),
     &              wkvec(nx),wkvec(ny),wkvec(nz),wkvec(n0),wkvec(n1),
     &              wkvec(n2),wkvec(n3),wkvec(n4),wkvec(n5),wkvec(n6))

 1014 continue

      do 1015 i=1,ncontd
      do 1015 j=1,nconts

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshels(j))
      i4=i2+i3

      overlap(i4,1)=overlap(i4,1)/sqrt3
      overlap(i4,2)=overlap(i4,2)/sqrt3
      overlap(i4,3)=overlap(i4,3)/sqrt3

      overlap(i4+i1*3+3,1)=overlap(i4+i1*3+3,1)/sqrt3
      overlap(i4+i1*3+3,2)=overlap(i4+i1*3+3,2)/sqrt3
      overlap(i4+i1*3+3,3)=overlap(i4+i1*3+3,3)/sqrt3

      overlap(i4+i1*5+10,1)=overlap(i4+i1*5+10,1)/sqrt3
      overlap(i4+i1*5+10,2)=overlap(i4+i1*5+10,2)/sqrt3
      overlap(i4+i1*5+10,3)=overlap(i4+i1*5+10,3)/sqrt3

 1015 continue

      do 1016 i=1,ncontd
      do 1016 j=1,ncontp

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshelp(j))
      i4=i2+i3

      overlap(i4,1)=overlap(i4,1)/sqrt3
      overlap(i4,2)=overlap(i4,2)/sqrt3
      overlap(i4,3)=overlap(i4,3)/sqrt3

      overlap(i4+1,1)=overlap(i4+1,1)/sqrt3
      overlap(i4+1,2)=overlap(i4+1,2)/sqrt3
      overlap(i4+1,3)=overlap(i4+1,3)/sqrt3

      overlap(i4+2,1)=overlap(i4+2,1)/sqrt3
      overlap(i4+2,2)=overlap(i4+2,2)/sqrt3
      overlap(i4+2,3)=overlap(i4+2,3)/sqrt3

      overlap(i4+i1*3+3,1)=overlap(i4+i1*3+3,1)/sqrt3
      overlap(i4+i1*3+3,2)=overlap(i4+i1*3+3,2)/sqrt3
      overlap(i4+i1*3+3,3)=overlap(i4+i1*3+3,3)/sqrt3

      overlap(i4+i1*3+4,1)=overlap(i4+i1*3+4,1)/sqrt3
      overlap(i4+i1*3+4,2)=overlap(i4+i1*3+4,2)/sqrt3
      overlap(i4+i1*3+4,3)=overlap(i4+i1*3+4,3)/sqrt3

      overlap(i4+i1*3+5,1)=overlap(i4+i1*3+5,1)/sqrt3
      overlap(i4+i1*3+5,2)=overlap(i4+i1*3+5,2)/sqrt3
      overlap(i4+i1*3+5,3)=overlap(i4+i1*3+5,3)/sqrt3

      overlap(i4+i1*5+10,1)=overlap(i4+i1*5+10,1)/sqrt3
      overlap(i4+i1*5+10,2)=overlap(i4+i1*5+10,2)/sqrt3
      overlap(i4+i1*5+10,3)=overlap(i4+i1*5+10,3)/sqrt3

      overlap(i4+i1*5+11,1)=overlap(i4+i1*5+11,1)/sqrt3
      overlap(i4+i1*5+11,2)=overlap(i4+i1*5+11,2)/sqrt3
      overlap(i4+i1*5+11,3)=overlap(i4+i1*5+11,3)/sqrt3

      overlap(i4+i1*5+12,1)=overlap(i4+i1*5+12,1)/sqrt3
      overlap(i4+i1*5+12,2)=overlap(i4+i1*5+12,2)/sqrt3
      overlap(i4+i1*5+12,3)=overlap(i4+i1*5+12,3)/sqrt3

 1016 continue

      do 1017 i=1,ncontd
      do 1017 j=1,i

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nsheld(j))
      i4=i2+i3

      overlap(i4,1)=overlap(i4,1)/three
      overlap(i4,2)=overlap(i4,2)/three
      overlap(i4,3)=overlap(i4,3)/three

      if(i.ne.j) overlap(i4+1,1)=overlap(i4+1,1)/sqrt3
      if(i.ne.j) overlap(i4+1,2)=overlap(i4+1,2)/sqrt3
      if(i.ne.j) overlap(i4+1,3)=overlap(i4+1,3)/sqrt3

      if(i.ne.j) overlap(i4+2,1)=overlap(i4+2,1)/sqrt3
      if(i.ne.j) overlap(i4+2,2)=overlap(i4+2,2)/sqrt3
      if(i.ne.j) overlap(i4+2,3)=overlap(i4+2,3)/sqrt3

      if(i.ne.j) overlap(i4+3,1)=overlap(i4+3,1)/three
      if(i.ne.j) overlap(i4+3,2)=overlap(i4+3,2)/three
      if(i.ne.j) overlap(i4+3,3)=overlap(i4+3,3)/three

      if(i.ne.j) overlap(i4+4,1)=overlap(i4+4,1)/sqrt3
      if(i.ne.j) overlap(i4+4,2)=overlap(i4+4,2)/sqrt3
      if(i.ne.j) overlap(i4+4,3)=overlap(i4+4,3)/sqrt3

      if(i.ne.j) overlap(i4+5,1)=overlap(i4+5,1)/three
      if(i.ne.j) overlap(i4+5,2)=overlap(i4+5,2)/three
      if(i.ne.j) overlap(i4+5,3)=overlap(i4+5,3)/three

      overlap(i4+i1,1)=overlap(i4+i1,1)/sqrt3
      overlap(i4+i1,2)=overlap(i4+i1,2)/sqrt3
      overlap(i4+i1,3)=overlap(i4+i1,3)/sqrt3

      if(i.ne.j) overlap(i4+i1+3,1)=overlap(i4+i1+3,1)/sqrt3
      if(i.ne.j) overlap(i4+i1+3,2)=overlap(i4+i1+3,2)/sqrt3
      if(i.ne.j) overlap(i4+i1+3,3)=overlap(i4+i1+3,3)/sqrt3

      if(i.ne.j) overlap(i4+i1+5,1)=overlap(i4+i1+5,1)/sqrt3
      if(i.ne.j) overlap(i4+i1+5,2)=overlap(i4+i1+5,2)/sqrt3
      if(i.ne.j) overlap(i4+i1+5,3)=overlap(i4+i1+5,3)/sqrt3

      overlap(i4+i1*2+1,1)=overlap(i4+i1*2+1,1)/sqrt3
      overlap(i4+i1*2+1,2)=overlap(i4+i1*2+1,2)/sqrt3
      overlap(i4+i1*2+1,3)=overlap(i4+i1*2+1,3)/sqrt3

      if(i.ne.j) overlap(i4+i1*2+4,1)=overlap(i4+i1*2+4,1)/sqrt3
      if(i.ne.j) overlap(i4+i1*2+4,2)=overlap(i4+i1*2+4,2)/sqrt3
      if(i.ne.j) overlap(i4+i1*2+4,3)=overlap(i4+i1*2+4,3)/sqrt3

      if(i.ne.j) overlap(i4+i1*2+6,1)=overlap(i4+i1*2+6,1)/sqrt3
      if(i.ne.j) overlap(i4+i1*2+6,2)=overlap(i4+i1*2+6,2)/sqrt3
      if(i.ne.j) overlap(i4+i1*2+6,3)=overlap(i4+i1*2+6,3)/sqrt3

      overlap(i4+i1*3+3,1)=overlap(i4+i1*3+3,1)/three
      overlap(i4+i1*3+3,2)=overlap(i4+i1*3+3,2)/three
      overlap(i4+i1*3+3,3)=overlap(i4+i1*3+3,3)/three

      overlap(i4+i1*3+4,1)=overlap(i4+i1*3+4,1)/sqrt3
      overlap(i4+i1*3+4,2)=overlap(i4+i1*3+4,2)/sqrt3
      overlap(i4+i1*3+4,3)=overlap(i4+i1*3+4,3)/sqrt3

      overlap(i4+i1*3+5,1)=overlap(i4+i1*3+5,1)/sqrt3
      overlap(i4+i1*3+5,2)=overlap(i4+i1*3+5,2)/sqrt3
      overlap(i4+i1*3+5,3)=overlap(i4+i1*3+5,3)/sqrt3

      overlap(i4+i1*3+6,1)=overlap(i4+i1*3+6,1)/three
      overlap(i4+i1*3+6,2)=overlap(i4+i1*3+6,2)/three
      overlap(i4+i1*3+6,3)=overlap(i4+i1*3+6,3)/three

      if(i.ne.j) overlap(i4+i1*3+7,1)=overlap(i4+i1*3+7,1)/sqrt3
      if(i.ne.j) overlap(i4+i1*3+7,2)=overlap(i4+i1*3+7,2)/sqrt3
      if(i.ne.j) overlap(i4+i1*3+7,3)=overlap(i4+i1*3+7,3)/sqrt3

      if(i.ne.j) overlap(i4+i1*3+8,1)=overlap(i4+i1*3+8,1)/three
      if(i.ne.j) overlap(i4+i1*3+8,2)=overlap(i4+i1*3+8,2)/three
      if(i.ne.j) overlap(i4+i1*3+8,3)=overlap(i4+i1*3+8,3)/three

      overlap(i4+i1*4+6,1)=overlap(i4+i1*4+6,1)/sqrt3
      overlap(i4+i1*4+6,2)=overlap(i4+i1*4+6,2)/sqrt3
      overlap(i4+i1*4+6,3)=overlap(i4+i1*4+6,3)/sqrt3

      overlap(i4+i1*4+9,1)=overlap(i4+i1*4+9,1)/sqrt3
      overlap(i4+i1*4+9,2)=overlap(i4+i1*4+9,2)/sqrt3
      overlap(i4+i1*4+9,3)=overlap(i4+i1*4+9,3)/sqrt3

      if(i.ne.j) overlap(i4+i1*4+11,1)=overlap(i4+i1*4+11,1)/sqrt3
      if(i.ne.j) overlap(i4+i1*4+11,2)=overlap(i4+i1*4+11,2)/sqrt3
      if(i.ne.j) overlap(i4+i1*4+11,3)=overlap(i4+i1*4+11,3)/sqrt3

      overlap(i4+i1*5+10,1)=overlap(i4+i1*5+10,1)/three
      overlap(i4+i1*5+10,2)=overlap(i4+i1*5+10,2)/three
      overlap(i4+i1*5+10,3)=overlap(i4+i1*5+10,3)/three

      overlap(i4+i1*5+11,1)=overlap(i4+i1*5+11,1)/sqrt3
      overlap(i4+i1*5+11,2)=overlap(i4+i1*5+11,2)/sqrt3
      overlap(i4+i1*5+11,3)=overlap(i4+i1*5+11,3)/sqrt3

      overlap(i4+i1*5+12,1)=overlap(i4+i1*5+12,1)/sqrt3
      overlap(i4+i1*5+12,2)=overlap(i4+i1*5+12,2)/sqrt3
      overlap(i4+i1*5+12,3)=overlap(i4+i1*5+12,3)/sqrt3

      overlap(i4+i1*5+13,1)=overlap(i4+i1*5+13,1)/three
      overlap(i4+i1*5+13,2)=overlap(i4+i1*5+13,2)/three
      overlap(i4+i1*5+13,3)=overlap(i4+i1*5+13,3)/three

      overlap(i4+i1*5+14,1)=overlap(i4+i1*5+14,1)/sqrt3
      overlap(i4+i1*5+14,2)=overlap(i4+i1*5+14,2)/sqrt3
      overlap(i4+i1*5+14,3)=overlap(i4+i1*5+14,3)/sqrt3

      overlap(i4+i1*5+15,1)=overlap(i4+i1*5+15,1)/three
      overlap(i4+i1*5+15,2)=overlap(i4+i1*5+15,2)/three
      overlap(i4+i1*5+15,3)=overlap(i4+i1*5+15,3)/three

 1017 continue

      return
      end
