      subroutine gridgen(ngridtype,nscf,nrandom,ncenters,nconts,ncontp,
     &                   ncontd,ilfunc,icfunc,ngauss,nptrs,nptrp,nptrd,
     &                   natomtype,nptsatom,cent,alpha,coeff,xcoord,
     &                   ycoord,zcoord,weight,dcp,dcc,wtbecke)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension slater(105),glroot(32),glwght(32)

      dimension coordshell(3,194),wghtshell(194)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)
      dimension natomtype(*),nptsatom(*)

      dimension cent(3,*),alpha(*),coeff(*)

      dimension xcoord(*),ycoord(*),zcoord(*),weight(*)
      dimension dcp(ncenters,*),dcc(ncenters,*),wtbecke(*)

      data slater/ 0.50, 2.00, 1.45, 1.05, 0.85, 0.70, 0.65, 0.60, 0.50,
     &             2.25, 1.80, 1.50, 1.25, 1.10, 1.00, 1.00, 1.00, 2.50,
     &             2.20, 1.80, 1.60, 1.40, 1.35, 1.40, 1.40, 1.40, 1.35,
     &             1.35, 1.35, 1.35, 1.30, 1.25, 1.15, 1.15, 1.15, 2.75,
     &             2.35, 2.00, 1.80, 1.55, 1.45, 1.45, 1.35, 1.30, 1.35,
     &             1.40, 1.60, 1.55, 1.55, 1.45, 1.45, 1.40, 1.40, 3.00,
     &             2.60, 2.15, 1.95, 1.85, 1.85, 1.85, 1.85, 1.85, 1.85,
     &             1.80, 1.75, 1.75, 1.75, 1.75, 1.75, 1.75, 1.75, 1.55,
     &             1.45, 1.35, 1.35, 1.30, 1.35, 1.35, 1.35, 1.50, 1.90,
     &             1.80, 1.60, 1.90, 1.65, 3.25, 2.80, 2.15, 1.95, 1.80,
     &             1.80, 1.75, 1.75, 1.75, 1.75, 1.75, 1.75, 1.75, 1.75,
     &             1.75, 1.75, 1.75, 1.75, 1.55, 1.55/

      data glroot/ -0.9972638618, -0.9856115115,
     &             -0.9647622555, -0.9349060759,
     &             -0.8963211557, -0.8493676137,
     &             -0.7944837959, -0.7321821187,
     &             -0.6630442669, -0.5877157572,
     &             -0.5068999089, -0.4213512761,
     &             -0.3318686022, -0.2392873622,
     &             -0.1444719615, -0.0483076656,
     &             +0.0483076656, +0.1444719615,
     &             +0.2392873622, +0.3318686022,
     &             +0.4213512761, +0.5068999089,
     &             +0.5877157572, +0.6630442669,
     &             +0.7321821187, +0.7944837959,
     &             +0.8493676137, +0.8963211557,
     &             +0.9349060759, +0.9647622555,
     &             +0.9856115115, +0.9972638618/

      data glwght/  0.0070186100,  0.0162743947,
     &              0.0253920653,  0.0342738629,
     &              0.0428358980,  0.0509980592,
     &              0.0586840934,  0.0658222227,
     &              0.0723457941,  0.0781938957,
     &              0.0833119242,  0.0876520930,
     &              0.0911738786,  0.0938443990,
     &              0.0956387200,  0.0965400885,
     &              0.0965400885,  0.0956387200,
     &              0.0938443990,  0.0911738786,
     &              0.0876520930,  0.0833119242,
     &              0.0781938957,  0.0723457941,
     &              0.0658222227,  0.0586840934,
     &              0.0509980592,  0.0428358980,
     &              0.0342738629,  0.0253920653,
     &              0.0162743947,  0.0070186100/

      data zero,half,one,two,four/0.0,0.5,1.0,2.0,4.0/
      data tolerance,hradius,bohr/0.0000000001,0.35,0.529177/
      data pi/3.1415926535898/

      rewind 11

      do 1001 jatom=1,ncenters
      do 1001 iatom=1,ncenters
 1001 dcc(iatom,jatom)=dist(cent(1,iatom),cent(1,jatom))

      do 1002 iatom=1,ncenters

      if(natomtype(iatom).eq.0) goto 1002

      call aranset(1)

      npoints=0

      do 1003 nshell=1,32

      if(ngridtype.eq.1) then
                               nangpts=50

                               if(nshell.gt.13) nangpts=110
                               if(nshell.gt.16) nangpts=194
                               if(nshell.gt.23) nangpts=110
                               if(nshell.gt.26) nangpts=50

                               if(nscf.eq.1) nangpts=26
                         endif

      if(ngridtype.eq.2) then
                               nangpts=26

                               if(nshell.gt.13) nangpts=50
                               if(nshell.gt.16) nangpts=110
                               if(nshell.gt.23) nangpts=50
                               if(nshell.gt.26) nangpts=26

                               if(nscf.eq.1) nangpts=12
                         endif

      halfslater=half*slater(natomtype(iatom))/bohr

      radius=halfslater*(one+glroot(nshell))/(one-glroot(nshell))

      thickness=two*halfslater/((one-glroot(nshell))**2)

      volume=four*pi*radius*radius*thickness*glwght(nshell)

      call points(nangpts,nrandom,radius,volume,cent(1,iatom),
     &            coordshell,wghtshell)

      do 1004 ipoint=1,nangpts
      do 1004 icenter=1,ncenters
 1004 dcp(icenter,ipoint)=dist(cent(1,icenter),coordshell(1,ipoint))

      do 1003 ipoint=1,nangpts

      do 1005 icenter=1,ncenters
 1005 wtbecke(icenter)=zero

      do 1006 icenter=1,ncenters

      if(natomtype(icenter).eq.0) goto 1006 

      partition=one

      do 1007 jcenter=1,ncenters

      if((jcenter.eq.icenter).or.(natomtype(jcenter).eq.0)) goto 1007

      rad1=slater(natomtype(icenter))
      rad2=slater(natomtype(jcenter))

      if(natomtype(icenter).eq.1) rad1=hradius
      if(natomtype(jcenter).eq.1) rad2=hradius

      u=((rad1/rad2)-one)/((rad1/rad2)+one)

      a=u/(u*u-one)

      if(abs(a).gt.half) a=half*abs(a)/a

      u=(dcp(icenter,ipoint)-dcp(jcenter,ipoint))/dcc(icenter,jcenter)

      u=u+a*(one-u*u)

      u=(one+half)*u-half*u*u*u
      u=(one+half)*u-half*u*u*u
      u=(one+half)*u-half*u*u*u

      partition=partition*half*(one-u)

 1007 continue

      wtbecke(icenter)=partition

 1006 continue

      totalwtbecke=zero

      do 1008 kcenter=1,ncenters
 1008 totalwtbecke=totalwtbecke+wtbecke(kcenter)

      wghtshell(ipoint)=wghtshell(ipoint)*wtbecke(iatom)/totalwtbecke

      call checkpt(alpha,coeff,cent,coordshell(1,ipoint),dlarge,ilfunc,
     &             icfunc,ngauss,nptrs,nptrp,nptrd,nconts,ncontp,ncontd)

      if((dlarge*wghtshell(ipoint)).ge.tolerance) then

                                   npoints=npoints+1

                                   xcoord(npoints)=coordshell(1,ipoint)
                                   ycoord(npoints)=coordshell(2,ipoint)
                                   zcoord(npoints)=coordshell(3,ipoint)

                                   weight(npoints)=wghtshell(ipoint)

                                                  endif

 1003 continue

      nptsatom(iatom)=npoints

      call fastwr(11,xcoord,nptsatom(iatom))
      call fastwr(11,ycoord,nptsatom(iatom))
      call fastwr(11,zcoord,nptsatom(iatom))
      call fastwr(11,weight,nptsatom(iatom))

 1002 continue

      return
      end
