      subroutine mespdd(m,n,iminj,icontr,inddyy,esp,ccx,ccy,ccz,g,
     &                  density,zeta,axbx,ayby,azbz,px,py,pz,pxax,pyay,
     &                  pzaz,base,ss0,ss1,ss2,ss3,ss4,ps0,ps1,ps2,ps3,
     &                  dscond,ds0,ds1,ds2,fscond,fs0,fs1,gscond,gs0,
     &                  dpcond,fpcond,ddcond,c,c1,c2,pxcx,pycy,pzcz,u,
     &                  twozeta)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iminj(*),icontr(*),inddyy(m,*)

      dimension g(*),density(*),zeta(*),axbx(*),ayby(*),azbz(*),px(*),
     &          py(*),pz(*),pxax(*),pyay(*),pzaz(*),base(*),ss0(*),
     &          ss1(*),ss2(*),ss3(*),ss4(*),ps0(n,*),ps1(n,*),ps2(n,*),
     &          ps3(n,*),dscond(m,*),ds0(n,*),ds1(n,*),ds2(n,*),
     &          fscond(m,*),fs0(n,*),fs1(n,*),gscond(m,*),gs0(n,*),
     &          dpcond(m,*),fpcond(m,*),ddcond(m,*),c(*),c1(n,*),
     &          c2(n,*),pxcx(*),pycy(*),pzcz(*),u(*),twozeta(*)

      data zero,two,three,pi/0.0,2.0,3.0,3.1415926535898/

      do 1001 i=1,n
 1001 twozeta(i)=two*zeta(i)

      twopi=two*pi

      do 1002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 1002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 1003 i=1,n
      call augg(5,u(i),g)
      ss0(i)=base(i)*g(1)*twopi/zeta(i)
      ss1(i)=base(i)*g(2)*twopi/zeta(i)
      ss2(i)=base(i)*g(3)*twopi/zeta(i)
      ss3(i)=base(i)*g(4)*twopi/zeta(i)
 1003 ss4(i)=base(i)*g(5)*twopi/zeta(i)

      do 1004 i=1,n

      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
      ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
      ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

      ps2(i,1)=pxax(i)*ss2(i)-pxcx(i)*ss3(i)
      ps2(i,2)=pyay(i)*ss2(i)-pycy(i)*ss3(i)
      ps2(i,3)=pzaz(i)*ss2(i)-pzcz(i)*ss3(i)

      ps3(i,1)=pxax(i)*ss3(i)-pxcx(i)*ss4(i)
      ps3(i,2)=pyay(i)*ss3(i)-pycy(i)*ss4(i)
      ps3(i,3)=pzaz(i)*ss3(i)-pzcz(i)*ss4(i)

 1004 continue

      do 1005 i=1,n
 1005 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 1006 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 1006 ds0(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 1007 i=1,n
 1007 c(i)=(ss1(i)-ss2(i))/twozeta(i)

      do 1008 i=1,n
      ds1(i,1)=pxax(i)*ps1(i,1)-pxcx(i)*ps2(i,1)+c(i)
      ds1(i,2)=pyay(i)*ps1(i,1)-pycy(i)*ps2(i,1)
      ds1(i,3)=pzaz(i)*ps1(i,1)-pzcz(i)*ps2(i,1)
      ds1(i,4)=pyay(i)*ps1(i,2)-pycy(i)*ps2(i,2)+c(i)
      ds1(i,5)=pzaz(i)*ps1(i,2)-pzcz(i)*ps2(i,2)
 1008 ds1(i,6)=pzaz(i)*ps1(i,3)-pzcz(i)*ps2(i,3)+c(i)

      do 1009 i=1,n
 1009 c(i)=(ss2(i)-ss3(i))/twozeta(i)

      do 1010 i=1,n
      ds2(i,1)=pxax(i)*ps2(i,1)-pxcx(i)*ps3(i,1)+c(i)
      ds2(i,2)=pyay(i)*ps2(i,1)-pycy(i)*ps3(i,1)
      ds2(i,3)=pzaz(i)*ps2(i,1)-pzcz(i)*ps3(i,1)
      ds2(i,4)=pyay(i)*ps2(i,2)-pycy(i)*ps3(i,2)+c(i)
      ds2(i,5)=pzaz(i)*ps2(i,2)-pzcz(i)*ps3(i,2)
 1010 ds2(i,6)=pzaz(i)*ps2(i,3)-pzcz(i)*ps3(i,3)+c(i)

      do 1011 j=1,3
      do 1011 i=1,n
 1011 c1(i,j)=(ps0(i,j)-ps1(i,j))/twozeta(i)

      do 1012 i=1,n
      fs0(i,01)=pxax(i)*ds0(i,1)-pxcx(i)*ds1(i,1)+c1(i,1)*two
      fs0(i,02)=pyay(i)*ds0(i,1)-pycy(i)*ds1(i,1)
      fs0(i,03)=pzaz(i)*ds0(i,1)-pzcz(i)*ds1(i,1)
      fs0(i,04)=pyay(i)*ds0(i,2)-pycy(i)*ds1(i,2)+c1(i,1)
      fs0(i,05)=pzaz(i)*ds0(i,2)-pzcz(i)*ds1(i,2)
      fs0(i,06)=pzaz(i)*ds0(i,3)-pzcz(i)*ds1(i,3)+c1(i,1)
      fs0(i,07)=pyay(i)*ds0(i,4)-pycy(i)*ds1(i,4)+c1(i,2)*two
      fs0(i,08)=pzaz(i)*ds0(i,4)-pzcz(i)*ds1(i,4)
      fs0(i,09)=pzaz(i)*ds0(i,5)-pzcz(i)*ds1(i,5)+c1(i,2)
 1012 fs0(i,10)=pzaz(i)*ds0(i,6)-pzcz(i)*ds1(i,6)+c1(i,3)*two

      do 1013 j=1,3
      do 1013 i=1,n
 1013 c1(i,j)=(ps1(i,j)-ps2(i,j))/twozeta(i)

      do 1014 i=1,n
      fs1(i,01)=pxax(i)*ds1(i,1)-pxcx(i)*ds2(i,1)+c1(i,1)*two
      fs1(i,02)=pyay(i)*ds1(i,1)-pycy(i)*ds2(i,1)
      fs1(i,03)=pzaz(i)*ds1(i,1)-pzcz(i)*ds2(i,1)
      fs1(i,04)=pyay(i)*ds1(i,2)-pycy(i)*ds2(i,2)+c1(i,1)
      fs1(i,05)=pzaz(i)*ds1(i,2)-pzcz(i)*ds2(i,2)
      fs1(i,06)=pzaz(i)*ds1(i,3)-pzcz(i)*ds2(i,3)+c1(i,1)
      fs1(i,07)=pyay(i)*ds1(i,4)-pycy(i)*ds2(i,4)+c1(i,2)*two
      fs1(i,08)=pzaz(i)*ds1(i,4)-pzcz(i)*ds2(i,4)
      fs1(i,09)=pzaz(i)*ds1(i,5)-pzcz(i)*ds2(i,5)+c1(i,2)
 1014 fs1(i,10)=pzaz(i)*ds1(i,6)-pzcz(i)*ds2(i,6)+c1(i,3)*two

      do 1015 j=1,6
      do 1015 i=1,n
 1015 c2(i,j)=(ds0(i,j)-ds1(i,j))/twozeta(i)

      do 1016 i=1,n
      gs0(i,01)=pxax(i)*fs0(i,01)-pxcx(i)*fs1(i,01)+c2(i,1)*three
      gs0(i,02)=pyay(i)*fs0(i,01)-pycy(i)*fs1(i,01)
      gs0(i,03)=pzaz(i)*fs0(i,01)-pzcz(i)*fs1(i,01)
      gs0(i,04)=pyay(i)*fs0(i,02)-pycy(i)*fs1(i,02)+c2(i,1)
      gs0(i,05)=pzaz(i)*fs0(i,02)-pzcz(i)*fs1(i,02)
      gs0(i,06)=pzaz(i)*fs0(i,03)-pzcz(i)*fs1(i,03)+c2(i,1)
      gs0(i,07)=pyay(i)*fs0(i,04)-pycy(i)*fs1(i,04)+c2(i,2)*two
      gs0(i,08)=pzaz(i)*fs0(i,04)-pzcz(i)*fs1(i,04)
      gs0(i,09)=pzaz(i)*fs0(i,05)-pzcz(i)*fs1(i,05)+c2(i,2)
      gs0(i,10)=pzaz(i)*fs0(i,06)-pzcz(i)*fs1(i,06)+c2(i,3)*two
      gs0(i,11)=pyay(i)*fs0(i,07)-pycy(i)*fs1(i,07)+c2(i,4)*three
      gs0(i,12)=pzaz(i)*fs0(i,07)-pzcz(i)*fs1(i,07)
      gs0(i,13)=pzaz(i)*fs0(i,08)-pzcz(i)*fs1(i,08)+c2(i,4)
      gs0(i,14)=pzaz(i)*fs0(i,09)-pzcz(i)*fs1(i,09)+c2(i,5)*two
 1016 gs0(i,15)=pzaz(i)*fs0(i,10)-pzcz(i)*fs1(i,10)+c2(i,6)*three

      do 1017 j=1,6
      do 1017 i=1,m
 1017 dscond(i,j)=zero

      do 1018 j=1,10
      do 1018 i=1,m
 1018 fscond(i,j)=zero

      do 1019 j=1,15
      do 1019 i=1,m
 1019 gscond(i,j)=zero

      do 1020 j=1,6
      do 1020 i=1,n
 1020 dscond(icontr(i),j)=dscond(icontr(i),j)+ds0(i,j)

      do 1021 j=1,10
      do 1021 i=1,n
 1021 fscond(icontr(i),j)=fscond(icontr(i),j)+fs0(i,j)

      do 1022 j=1,15
      do 1022 i=1,n
 1022 gscond(icontr(i),j)=gscond(icontr(i),j)+gs0(i,j)

      do 1023 i=1,m
      dpcond(i,01)=axbx(i)*dscond(i,1)+fscond(i,01)
      dpcond(i,02)=ayby(i)*dscond(i,1)+fscond(i,02)
      dpcond(i,03)=azbz(i)*dscond(i,1)+fscond(i,03)
      dpcond(i,04)=axbx(i)*dscond(i,2)+fscond(i,02)
      dpcond(i,05)=ayby(i)*dscond(i,2)+fscond(i,04)
      dpcond(i,06)=azbz(i)*dscond(i,2)+fscond(i,05)
      dpcond(i,07)=axbx(i)*dscond(i,3)+fscond(i,03)
      dpcond(i,08)=ayby(i)*dscond(i,3)+fscond(i,05)
      dpcond(i,09)=azbz(i)*dscond(i,3)+fscond(i,06)
      dpcond(i,10)=axbx(i)*dscond(i,4)+fscond(i,04)
      dpcond(i,11)=ayby(i)*dscond(i,4)+fscond(i,07)
      dpcond(i,12)=azbz(i)*dscond(i,4)+fscond(i,08)
      dpcond(i,13)=axbx(i)*dscond(i,5)+fscond(i,05)
      dpcond(i,14)=ayby(i)*dscond(i,5)+fscond(i,08)
      dpcond(i,15)=azbz(i)*dscond(i,5)+fscond(i,09)
      dpcond(i,16)=axbx(i)*dscond(i,6)+fscond(i,06)
      dpcond(i,17)=ayby(i)*dscond(i,6)+fscond(i,09)
 1023 dpcond(i,18)=azbz(i)*dscond(i,6)+fscond(i,10)

      do 1024 i=1,m
      fpcond(i,01)=axbx(i)*fscond(i,01)+gscond(i,01)
      fpcond(i,02)=ayby(i)*fscond(i,01)+gscond(i,02)
      fpcond(i,03)=azbz(i)*fscond(i,01)+gscond(i,03)
      fpcond(i,04)=axbx(i)*fscond(i,02)+gscond(i,02)
      fpcond(i,05)=ayby(i)*fscond(i,02)+gscond(i,04)
      fpcond(i,06)=azbz(i)*fscond(i,02)+gscond(i,05)
      fpcond(i,07)=axbx(i)*fscond(i,03)+gscond(i,03)
      fpcond(i,08)=ayby(i)*fscond(i,03)+gscond(i,05)
      fpcond(i,09)=azbz(i)*fscond(i,03)+gscond(i,06)
      fpcond(i,10)=axbx(i)*fscond(i,04)+gscond(i,04)
      fpcond(i,11)=ayby(i)*fscond(i,04)+gscond(i,07)
      fpcond(i,12)=azbz(i)*fscond(i,04)+gscond(i,08)
      fpcond(i,13)=axbx(i)*fscond(i,05)+gscond(i,05)
      fpcond(i,14)=ayby(i)*fscond(i,05)+gscond(i,08)
      fpcond(i,15)=azbz(i)*fscond(i,05)+gscond(i,09)
      fpcond(i,16)=axbx(i)*fscond(i,06)+gscond(i,06)
      fpcond(i,17)=ayby(i)*fscond(i,06)+gscond(i,09)
      fpcond(i,18)=azbz(i)*fscond(i,06)+gscond(i,10)
      fpcond(i,19)=axbx(i)*fscond(i,07)+gscond(i,07)
      fpcond(i,20)=ayby(i)*fscond(i,07)+gscond(i,11)
      fpcond(i,21)=azbz(i)*fscond(i,07)+gscond(i,12)
      fpcond(i,22)=axbx(i)*fscond(i,08)+gscond(i,08)
      fpcond(i,23)=ayby(i)*fscond(i,08)+gscond(i,12)
      fpcond(i,24)=azbz(i)*fscond(i,08)+gscond(i,13)
      fpcond(i,25)=axbx(i)*fscond(i,09)+gscond(i,09)
      fpcond(i,26)=ayby(i)*fscond(i,09)+gscond(i,13)
      fpcond(i,27)=azbz(i)*fscond(i,09)+gscond(i,14)
      fpcond(i,28)=axbx(i)*fscond(i,10)+gscond(i,10)
      fpcond(i,29)=ayby(i)*fscond(i,10)+gscond(i,14)
 1024 fpcond(i,30)=azbz(i)*fscond(i,10)+gscond(i,15)

      do 1025 i=1,m
      ddcond(i,01)=axbx(i)*dpcond(i,01)+fpcond(i,01)
      ddcond(i,02)=ayby(i)*dpcond(i,01)+fpcond(i,04)
      ddcond(i,03)=azbz(i)*dpcond(i,01)+fpcond(i,07)
      ddcond(i,04)=ayby(i)*dpcond(i,02)+fpcond(i,05)
      ddcond(i,05)=azbz(i)*dpcond(i,02)+fpcond(i,08)
      ddcond(i,06)=azbz(i)*dpcond(i,03)+fpcond(i,09)
      ddcond(i,07)=axbx(i)*dpcond(i,04)+fpcond(i,04)
      ddcond(i,08)=ayby(i)*dpcond(i,04)+fpcond(i,10)
      ddcond(i,09)=azbz(i)*dpcond(i,04)+fpcond(i,13)
      ddcond(i,10)=ayby(i)*dpcond(i,05)+fpcond(i,11)
      ddcond(i,11)=azbz(i)*dpcond(i,05)+fpcond(i,14)
      ddcond(i,12)=azbz(i)*dpcond(i,06)+fpcond(i,15)
      ddcond(i,13)=axbx(i)*dpcond(i,07)+fpcond(i,07)
      ddcond(i,14)=ayby(i)*dpcond(i,07)+fpcond(i,13)
      ddcond(i,15)=azbz(i)*dpcond(i,07)+fpcond(i,16)
      ddcond(i,16)=ayby(i)*dpcond(i,08)+fpcond(i,14)
      ddcond(i,17)=azbz(i)*dpcond(i,08)+fpcond(i,17)
      ddcond(i,18)=azbz(i)*dpcond(i,09)+fpcond(i,18)
      ddcond(i,19)=axbx(i)*dpcond(i,10)+fpcond(i,10)
      ddcond(i,20)=ayby(i)*dpcond(i,10)+fpcond(i,19)
      ddcond(i,21)=azbz(i)*dpcond(i,10)+fpcond(i,22)
      ddcond(i,22)=ayby(i)*dpcond(i,11)+fpcond(i,20)
      ddcond(i,23)=azbz(i)*dpcond(i,11)+fpcond(i,23)
      ddcond(i,24)=azbz(i)*dpcond(i,12)+fpcond(i,24)
      ddcond(i,25)=axbx(i)*dpcond(i,13)+fpcond(i,13)
      ddcond(i,26)=ayby(i)*dpcond(i,13)+fpcond(i,22)
      ddcond(i,27)=azbz(i)*dpcond(i,13)+fpcond(i,25)
      ddcond(i,28)=ayby(i)*dpcond(i,14)+fpcond(i,23)
      ddcond(i,29)=azbz(i)*dpcond(i,14)+fpcond(i,26)
      ddcond(i,30)=azbz(i)*dpcond(i,15)+fpcond(i,27)
      ddcond(i,31)=axbx(i)*dpcond(i,16)+fpcond(i,16)
      ddcond(i,32)=ayby(i)*dpcond(i,16)+fpcond(i,25)
      ddcond(i,33)=azbz(i)*dpcond(i,16)+fpcond(i,28)
      ddcond(i,34)=ayby(i)*dpcond(i,17)+fpcond(i,26)
      ddcond(i,35)=azbz(i)*dpcond(i,17)+fpcond(i,29)
 1025 ddcond(i,36)=azbz(i)*dpcond(i,18)+fpcond(i,30)

      do 1026 i=1,m
      esp=esp-density(inddyy(i,01))*ddcond(i,01)
      esp=esp-density(inddyy(i,07))*ddcond(i,07)
      esp=esp-density(inddyy(i,08))*ddcond(i,08)
      esp=esp-density(inddyy(i,13))*ddcond(i,13)
      esp=esp-density(inddyy(i,14))*ddcond(i,14)
      esp=esp-density(inddyy(i,15))*ddcond(i,15)
      esp=esp-density(inddyy(i,19))*ddcond(i,19)
      esp=esp-density(inddyy(i,20))*ddcond(i,20)
      esp=esp-density(inddyy(i,21))*ddcond(i,21)
      esp=esp-density(inddyy(i,22))*ddcond(i,22)
      esp=esp-density(inddyy(i,25))*ddcond(i,25)
      esp=esp-density(inddyy(i,26))*ddcond(i,26)
      esp=esp-density(inddyy(i,27))*ddcond(i,27)
      esp=esp-density(inddyy(i,28))*ddcond(i,28)
      esp=esp-density(inddyy(i,29))*ddcond(i,29)
      esp=esp-density(inddyy(i,31))*ddcond(i,31)
      esp=esp-density(inddyy(i,32))*ddcond(i,32)
      esp=esp-density(inddyy(i,33))*ddcond(i,33)
      esp=esp-density(inddyy(i,34))*ddcond(i,34)
      esp=esp-density(inddyy(i,35))*ddcond(i,35)
 1026 esp=esp-density(inddyy(i,36))*ddcond(i,36)

      do 1027 i=1,m
      if(iminj(i).ne.0) then

                           esp=esp-density(inddyy(i,02))*ddcond(i,02)
                           esp=esp-density(inddyy(i,03))*ddcond(i,03)
                           esp=esp-density(inddyy(i,04))*ddcond(i,04)
                           esp=esp-density(inddyy(i,05))*ddcond(i,05)
                           esp=esp-density(inddyy(i,06))*ddcond(i,06)
                           esp=esp-density(inddyy(i,09))*ddcond(i,09)
                           esp=esp-density(inddyy(i,10))*ddcond(i,10)
                           esp=esp-density(inddyy(i,11))*ddcond(i,11)
                           esp=esp-density(inddyy(i,12))*ddcond(i,12)
                           esp=esp-density(inddyy(i,16))*ddcond(i,16)
                           esp=esp-density(inddyy(i,17))*ddcond(i,17)
                           esp=esp-density(inddyy(i,18))*ddcond(i,18)
                           esp=esp-density(inddyy(i,23))*ddcond(i,23)
                           esp=esp-density(inddyy(i,24))*ddcond(i,24)
                           esp=esp-density(inddyy(i,30))*ddcond(i,30)

                        endif
 1027 continue

      return
      end
