      subroutine xcorss(m,n,nxcs,nxcspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,coord,xcfit1,xcfit2,xcfit3,alphaaux,
     &                  coeffs,coeffp,coeffd,fock1,fock2,fock3,zeta,ax,
     &                  ay,az,px,py,pz,base,zetarec,zetafac,efac,gxax,
     &                  gyay,gzaz,sss,ssscond,pss,psscond,dss,dsscond,
     &                  ssp,psp,ssd,c,zzeta,aax,aay,aaz,ppx,ppy,ppz,
     &                  axcx,aycy,azcz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcft1p(3),xcft2p(3),xcft3p(3),
     &          xcft1d(6),xcft2d(6),xcft3d(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(*)

      dimension coord(3,*),xcfit1(*),xcfit2(*),xcfit3(*),alphaaux(*),
     &          coeffs(*),coeffp(*),coeffd(*),fock1(*),fock2(*),
     &          fock3(*),zeta(*),ax(*),ay(*),az(*),px(*),py(*),pz(*),
     &          base(*),zetarec(*),zetafac(*),efac(*),gxax(*),gyay(*),
     &          gzaz(*),sss(*),ssscond(*),pss(n,*),psscond(m,*),
     &          dss(n,*),dsscond(m,*),ssp(m,*),psp(m,*),ssd(m,*),c(*),
     &          zzeta(*),aax(*),aay(*),aaz(*),ppx(*),ppy(*),ppz(*),
     &          axcx(*),aycy(*),azcz(*)

      data zero,one,two,three/0.0,1.0,2.0,3.0/
      data expcut,calcut/80.0,1.0e-16/

      sqrt3=sqrt(three)

      do 1001 naux=1,nxcs

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(naux)*coeffs(ilaux)
      xcft2s=xcfit2(naux)*coeffs(ilaux)
      xcft3s=xcfit3(naux)*coeffs(ilaux)

      do 1002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      sss(i)=zero
 1004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      do 1005 i=1,m
 1005 ssscond(i)=zero

      do 1006 i=1,n
 1006 ssscond(icontr(i))=ssscond(icontr(i))+sss(i)

      do 1007 i=1,m
      fock1(inddyy(i))=fock1(inddyy(i))+ssscond(i)*xcft1s
      fock2(inddyy(i))=fock2(inddyy(i))+ssscond(i)*xcft2s
 1007 fock3(inddyy(i))=fock3(inddyy(i))+ssscond(i)*xcft3s

 1001 continue

      do 2001 naux=1,nxcspd

      ilaux=ilfunc(nxcs+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft2s=xcfit2(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft3s=xcfit3(nxcs+(naux-1)*10+1)*coeffs(ilaux)

      xcft1p(1)=xcfit1(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft1p(2)=xcfit1(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft1p(3)=xcfit1(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft2p(1)=xcfit2(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft2p(2)=xcfit2(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft2p(3)=xcfit2(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft3p(1)=xcfit3(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft3p(2)=xcfit3(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft3p(3)=xcfit3(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft1d(1)=xcfit1(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft1d(2)=xcfit1(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft1d(3)=xcfit1(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft1d(4)=xcfit1(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft1d(5)=xcfit1(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft1d(6)=xcfit1(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft2d(1)=xcfit2(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft2d(2)=xcfit2(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft2d(3)=xcfit2(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft2d(4)=xcfit2(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft2d(5)=xcfit2(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft2d(6)=xcfit2(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft3d(1)=xcfit3(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft3d(2)=xcfit3(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft3d(3)=xcfit3(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft3d(4)=xcfit3(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft3d(5)=xcfit3(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft3d(6)=xcfit3(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      do 2002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n

      axcx(icontr(i))=ax(i)-ccx
      aycy(icontr(i))=ay(i)-ccy
      azcz(icontr(i))=az(i)-ccz

      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz

 2003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      sss(i)=zero
 2004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 2005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 2005 continue

      do 2006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 2006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 2007 i=1,nn
 2007 zetarec(i)=zetarec(i)/two

      do 2008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 2008 pss(i,3)=gzaz(i)*sss(i)

      do 2009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 2009 continue

      do 2010 i=1,m
 2010 ssscond(i)=zero

      do 2011 j=1,3
      do 2011 i=1,m
 2011 psscond(i,j)=zero

      do 2012 j=1,6
      do 2012 i=1,m
 2012 dsscond(i,j)=zero

      do 2013 i=1,nn
 2013 ssscond(iicontr(i))=ssscond(iicontr(i))+sss(i)

      do 2014 j=1,3
      do 2014 i=1,nn
 2014 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss(i,j)

      do 2015 j=1,6
      do 2015 i=1,nn
 2015 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 2016 i=1,m
      ssp(i,1)=axcx(i)*ssscond(i)+psscond(i,1)
      ssp(i,2)=aycy(i)*ssscond(i)+psscond(i,2)
 2016 ssp(i,3)=azcz(i)*ssscond(i)+psscond(i,3)

      do 2017 i=1,m
      psp(i,1)=axcx(i)*psscond(i,1)+dsscond(i,1)
      psp(i,2)=aycy(i)*psscond(i,1)+dsscond(i,2)
      psp(i,3)=azcz(i)*psscond(i,1)+dsscond(i,3)
      psp(i,4)=axcx(i)*psscond(i,2)+dsscond(i,2)
      psp(i,5)=aycy(i)*psscond(i,2)+dsscond(i,4)
      psp(i,6)=azcz(i)*psscond(i,2)+dsscond(i,5)
      psp(i,7)=axcx(i)*psscond(i,3)+dsscond(i,3)
      psp(i,8)=aycy(i)*psscond(i,3)+dsscond(i,5)
 2017 psp(i,9)=azcz(i)*psscond(i,3)+dsscond(i,6)

      do 2018 i=1,m
      ssd(i,1)=axcx(i)*ssp(i,1)+psp(i,1)
      ssd(i,2)=aycy(i)*ssp(i,1)+psp(i,4)
      ssd(i,3)=azcz(i)*ssp(i,1)+psp(i,7)
      ssd(i,4)=aycy(i)*ssp(i,2)+psp(i,5)
      ssd(i,5)=azcz(i)*ssp(i,2)+psp(i,8)
 2018 ssd(i,6)=azcz(i)*ssp(i,3)+psp(i,9)

      do 2019 i=1,m
      fock1(inddyy(i))=fock1(inddyy(i))+ssscond(i)*xcft1s
      fock2(inddyy(i))=fock2(inddyy(i))+ssscond(i)*xcft2s
 2019 fock3(inddyy(i))=fock3(inddyy(i))+ssscond(i)*xcft3s

      do 2022 k=1,3
      do 2022 i=1,m
      fock1(inddyy(i))=fock1(inddyy(i))+ssp(i,k)*xcft1p(k)
      fock2(inddyy(i))=fock2(inddyy(i))+ssp(i,k)*xcft2p(k)
 2022 fock3(inddyy(i))=fock3(inddyy(i))+ssp(i,k)*xcft3p(k)

      do 2023 k=1,6
      do 2023 i=1,m
      fock1(inddyy(i))=fock1(inddyy(i))+ssd(i,k)*xcft1d(k)
      fock2(inddyy(i))=fock2(inddyy(i))+ssd(i,k)*xcft2d(k)
 2023 fock3(inddyy(i))=fock3(inddyy(i))+ssd(i,k)*xcft3d(k)

 2001 continue

      return
      end
