      subroutine cdgrss(ncds,ilfunc,icfunc,cdfitc,alpha,coeffs,coord,
     &                  gradient)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(2)
 
      dimension ilfunc(*),icfunc(*)

      dimension cdfitc(*),alpha(*),coeffs(*),coord(3,*),gradient(3,*) 

      data one,two,pi,four,five/1.0,2.0,3.1415926535898,4.0,5.0/

      factor=(pi**(five/four)*sqrt(two))**2

      do 1001 i=1,ncds

      ilabel=ilfunc(i)

      nc1=icfunc(ilabel)

      zetaa=alpha(ilabel)

      do 1001 j=1,i

      jlabel=ilfunc(j)

      nc2=icfunc(jlabel)

      zetab=alpha(jlabel)

      axbx=coord(1,nc1)-coord(1,nc2)
      ayby=coord(2,nc1)-coord(2,nc2)
      azbz=coord(3,nc1)-coord(3,nc2)

      const=factor/(zetaa*zetab)

      zetaab=one/(zetaa+zetab)

      wxpx=(zetaa*coord(1,nc1)+zetab*coord(1,nc2))*zetaab-coord(1,nc1)
      wypy=(zetaa*coord(2,nc1)+zetab*coord(2,nc2))*zetaab-coord(2,nc1)
      wzpz=(zetaa*coord(3,nc1)+zetab*coord(3,nc2))*zetaab-coord(3,nc1)

      u=zetaa*zetab*zetaab*(axbx*axbx+ayby*ayby+azbz*azbz)

      call augg(2,u,g)

      s1=g(2)*const*sqrt(zetaab)

      px0=wxpx*s1
      py0=wypy*s1
      pz0=wzpz*s1

      cfact=zetaa*cdfitc(i)*cdfitc(j)*coeffs(ilabel)*coeffs(jlabel)

      if(i.ne.j) cfact=cfact+cfact

      gradient(1,nc1)=gradient(1,nc1)-cfact*px0
      gradient(2,nc1)=gradient(2,nc1)-cfact*py0
      gradient(3,nc1)=gradient(3,nc1)-cfact*pz0

      gradient(1,nc2)=gradient(1,nc2)+cfact*px0
      gradient(2,nc2)=gradient(2,nc2)+cfact*py0
      gradient(3,nc2)=gradient(3,nc2)+cfact*pz0

 1001 continue

      return
      end
