      subroutine gridxc(npts,ndim,n,n1,n2,ilaux,icaux,cent,alpha,
     &                  coeffs,coeffp,coeffd,x,y,z,q,xx,yy,zz,rr,sfac)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilaux(*),icaux(*)

      dimension cent(3,*),alpha(*),coeffs(*),coeffp(*),coeffd(*)
      dimension x(*),y(*),z(*),q(ndim,*),xx(*),yy(*),zz(*),rr(*),sfac(*)

      data zero,three,expcut/0.0,3.0,80.0/

      sqrt3=sqrt(three)

      do 1001 i=1,n
      do 1001 j=1,npts
 1001 q(j,i)=zero

c  now for lone-s exponent xc fitting functions

      k=1

      do 1002 i=1,n1

      ilabel=ilaux(i)

      nc=icaux(ilabel)

      do 1003 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1003 zz(j)=z(j)-cent(3,nc)

      do 1004 j=1,npts
 1004 rr(j)=(xx(j)*xx(j)+yy(j)*yy(j)+zz(j)*zz(j))*alpha(ilabel)

      do 1005 j=1,npts
 1005 if(rr(j).lt.expcut) q(j,k)=exp(-rr(j))*coeffs(ilabel)

 1002 k=k+1

      if(n2.eq.n1) return

c  now for shared exponent xc fitting functions

      do 1006 i=n1+1,n2

      ilabel=ilaux(i)

      nc=icaux(ilabel)

      do 1007 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1007 zz(j)=z(j)-cent(3,nc)

      do 1008 j=1,npts
 1008 rr(j)=(xx(j)*xx(j)+yy(j)*yy(j)+zz(j)*zz(j))*alpha(ilabel)

      do 1009 j=1,npts

      if(rr(j).lt.expcut) then

                   sfac(j)=exp(-rr(j))

                   q(j,k)=sfac(j)*coeffs(ilabel)

                   q(j,k+1)=xx(j)*sfac(j)*coeffp(ilabel)
                   q(j,k+2)=yy(j)*sfac(j)*coeffp(ilabel)
                   q(j,k+3)=zz(j)*sfac(j)*coeffp(ilabel)

                   q(j,k+4)=xx(j)*xx(j)*sfac(j)*coeffd(ilabel)/sqrt3
                   q(j,k+5)=xx(j)*yy(j)*sfac(j)*coeffd(ilabel)
                   q(j,k+6)=xx(j)*zz(j)*sfac(j)*coeffd(ilabel)
                   q(j,k+7)=yy(j)*yy(j)*sfac(j)*coeffd(ilabel)/sqrt3
                   q(j,k+8)=yy(j)*zz(j)*sfac(j)*coeffd(ilabel)
                   q(j,k+9)=zz(j)*zz(j)*sfac(j)*coeffd(ilabel)/sqrt3

                          endif

 1009 continue

 1006 k=k+10

      return
      end
