      subroutine augg(n,tvalue,gv)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.
c
c  based on brett dunlap's incomplete gamma function subroutines

      implicit real*8(a-h,o-z)

      dimension gv(13)

      common/igfdata/table(17,161),smallu(17),bigu(13)

      data small,eterm/0.00000001,0.018315638888734/

      data a1,a2,a3/0.2507213,0.0292732,0.0038278/

      data b1,b2,b3,b4,b5/1.333333333333,0.53333333333333,
     &                    0.152380952000,3.28125000000000,
     &                    0.937500000000/

      data c1,c2,c3,c4/1.772453850905500,0.88622692545276,
     &                 0.041666666666667,0.16666666666667/

      data zero,tenth,quarter,three8ths,half,
     &     one,two,ten,sixteen,plus16,thirty6/  0.000,  0.100,  0.250,
     &                                          0.375,  0.500,  1.000,
     &                                          2.000, 10.000, 16.000,
     &                                         16.050, 36.000/

      twotvalue=two*tvalue

      if(n.eq.1) then
                       if(tvalue.le.small) then
                                                 gv(1)=one
                                                 return
                                           endif

                        if(tvalue.ge.plus16) then
                                                   gv(1)=c2/sqrt(tvalue)
                                                   return
                                             endif

                        i=ten*tvalue

                        x=tvalue-tenth*real64(i)

                        gv(1)=(((c3*table(5,i+1)*x-c4*table(4,i+1))*x
     &                          +half*table(3,i+1))*x-table(2,i+1))*x
     &                          +table(1,i+1)

                        return
                  endif

      if(tvalue.le.small) then
                                do 1001 i=1,n
 1001                           gv(i)=smallu(i)

                                return
                          endif

      if(tvalue.lt.plus16) goto 1002

      if(n.gt.5) goto 1003

      x=tvalue-sixteen

      factor1=(eterm/(((a3*x+a2)*x+a1)*x+one))**4
      factor2=one/tvalue
      factor3=factor2+two
      factor4=sqrt(tvalue)
      factor5=c1/factor4

      goto(1004,1005,1006,1007,1008) n

 1008 gv(5)=b4*factor2*(factor5/(tvalue**3)
     &     -factor1*(((factor3*factor2+b1)*factor2+b2)*factor2+b3))

 1007 gv(4)=b5*factor2*(factor5/(tvalue**2)
     &     -factor1*((factor3*factor2+b1)*factor2+b2))

 1006 gv(3)=three8ths*factor2*(factor5/tvalue
     &     -factor1*(factor3*factor2+b1))

 1005 gv(2)=quarter*factor2*(factor5-factor1*factor3)

 1004 gv(1)=half*factor2*(c1*factor4-factor1)

      return

 1003 gv(n)=c2*bigu(n)/sqrt(tvalue)

      do 1009 i=1,n-1
 1009 gv(n)=gv(n)*half/tvalue

      x1=2*n-1
      x2=2*n-1

      term=one
      sum=one

      do 1010 i=1,n
      x1=x1-two
      term=term*x1/twotvalue
 1010 sum=sum+term

      expfac=zero
      if(tvalue.lt.thirty6) expfac=exp(-tvalue)

      gv(n)=gv(n)-sum*expfac/twotvalue

      do 1011 i=1,n-1
      x2=x2-two
 1011 gv(n-i)=(gv(n-i+1)*twotvalue+expfac)/x2

      return

 1002 i=ten*tvalue

      x1=tvalue-tenth*real64(i)
      x2=2*n-1

      gv(n)=(((c3*table(n+4,i+1)*x1-c4*table(n+3,i+1))*x1
     &        +half*table(n+2,i+1))*x1-table(n+1,i+1))*x1+table(n,i+1)

      expfac=exp(-tvalue)

      do 1012 i=1,n-1
      x2=x2-two
 1012 gv(n-i)=(gv(n-i+1)*twotvalue+expfac)/x2

      return
      end
