      subroutine coremm(nreal,ninteger,natoms,nptcharges,nconts,ncontp,
     &                  ncontd,nshels,nshelp,nsheld,mtloca,iprimvc,
     &                  nprimvc,icentvc,iwkvec,coord,coordatom,
     &                  coordptcharge,charge,chargatom,chargptcharge,
     &                  alpha,coeff,overlap,core,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(5)

      dimension nshels(*),nshelp(*),nsheld(*),mtloca(*),iprimvc(*),
     &          nprimvc(*),icentvc(*),iwkvec(*)

      dimension coord(3,*),coordatom(3,*),coordptcharge(3,*),charge(*),
     &          chargatom(*),chargptcharge(*),alpha(*),coeff(*),
     &          overlap(*),core(*),wkvec(*)

      data zero/0.0/

      n=nconts+3*ncontp+6*ncontd
      n=n*(n+1)/2

      do 1001 i=1,n
 1001 overlap(i)=zero

      do 1002 i=1,n
 1002 core(i)=zero

      ncentr=natoms+nptcharges

      do 1003 i=1,natoms
      do 1004 j=1,3
 1004 coord(j,i)=coordatom(j,i)
 1003 charge(i)=chargatom(i)

      if(nptcharges.eq.0) goto 1005

      do 1006 i=1,nptcharges
      do 1007 j=1,3
 1007 coord(j,natoms+i)=coordptcharge(j,i)
 1006 charge(natoms+i)=chargptcharge(i)

 1005 continue

      ncposs=nconts*(nconts+1)/2
      ncpopp=ncontp*(ncontp+1)/2
      ncpodd=ncontd*(ncontd+1)/2

      ncpops=ncontp*nconts
      ncpods=ncontd*nconts
      ncpodp=ncontd*ncontp

      npposs=0
      nppops=0
      nppopp=0
      nppods=0
      nppodp=0
      nppodd=0

      do 1008 i=1,nconts
      do 1008 j=1,i
 1008 npposs=npposs+nprimvc(nshels(i))*nprimvc(nshels(j))

      do 1009 i=1,ncontp
      do 1009 j=1,nconts
 1009 nppops=nppops+nprimvc(nshelp(i))*nprimvc(nshels(j))

      do 1010 i=1,ncontp
      do 1010 j=1,i
 1010 nppopp=nppopp+nprimvc(nshelp(i))*nprimvc(nshelp(j))

      do 1011 i=1,ncontd
      do 1011 j=1,nconts
 1011 nppods=nppods+nprimvc(nsheld(i))*nprimvc(nshels(j))

      do 1012 i=1,ncontd
      do 1012 j=1,ncontp
 1012 nppodp=nppodp+nprimvc(nsheld(i))*nprimvc(nshelp(j))

      do 1013 i=1,ncontd
      do 1013 j=1,i
 1013 nppodd=nppodd+nprimvc(nsheld(i))*nprimvc(nsheld(j))

      ja=1
      jb=ja+npposs
      jc=jb+ncposs

      if(jc.gt.ninteger) stop 'coremm ss integer overflow'

      je=1
      jf=je+npposs
      jg=jf+npposs
      jh=jg+npposs
      ji=jh+npposs
      jj=ji+npposs
      jk=jj+npposs
      jl=jk+npposs
      jm=jl+npposs
      jn=jm+npposs
      jo=jn+npposs
      jp=jo+npposs
      jq=jp+npposs

      if(jq.gt.nreal) stop 'coremm ss real overflow'

      call setupss(ncposs,n,nconts,nshels,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,coeff,
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),wkvec(ji),
     &             wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),wkvec(jn),
     &             wkvec(jo),wkvec(jp))

      ka=jq+1
      kb=ka+n
      kc=kb+ncposs
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n

      if(kg.gt.nreal) stop 'coremm ss real overflow'

      call coress(ncposs,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf))

      if(ncontp.eq.0) return

      ja=1
      jb=ja+nppops
      jc=jb+ncpops*3

      if(jc.gt.ninteger) stop 'coremm ps integer overflow'

      je=1
      jf=je+nppops
      jg=jf+nppops
      jh=jg+nppops
      ji=jh+nppops
      jj=ji+nppops
      jk=jj+nppops
      jl=jk+nppops
      jm=jl+nppops
      jn=jm+nppops
      jo=jn+nppops
      jp=jo+nppops
      jq=jp+nppops
      jr=jq+nppops
      js=jr+nppops
      jt=js+nppops

      if(jt.gt.nreal) stop 'coremm ps real overflow'

      call setupps(ncpops,n,ncontp,nconts,nshelp,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+ncpops*3
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n

      if(kk.gt.nreal) stop 'coremm ps real overflow'

      call coreps(ncpops,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(jk),wkvec(jm),
     &            wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj))

      ja=1
      jb=ja+ncpopp
      jc=jb+nppopp
      jd=jc+ncpopp*9

      if(jd.gt.ninteger) stop 'coremm pp integer overflow'

      je=1
      jf=je+nppopp
      jg=jf+nppopp
      jh=jg+nppopp
      ji=jh+nppopp
      jj=ji+nppopp
      jk=jj+nppopp
      jl=jk+nppopp
      jm=jl+nppopp
      jn=jm+nppopp
      jo=jn+nppopp
      jp=jo+nppopp
      jq=jp+nppopp
      jr=jq+nppopp
      js=jr+nppopp
      jt=js+nppopp
      ju=jt+nppopp
      jv=ju+nppopp
      jw=jv+nppopp
      jx=jw+ncpopp
      jy=jx+ncpopp
      jz=jy+ncpopp

      if(jz.gt.nreal) stop 'coremm pp real overflow'

      call setuppp(ncpopp,n,ncontp,nshelp,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+ncpopp*3
      kj=ki+n*6
      kk=kj+ncpopp*6
      kl=kk+n*9
      km=kl+ncpopp*9
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n

      if(kt.gt.nreal) stop 'coremm pp real overflow'

      call corepp(ncpopp,n,ncentr,iwkvec(ja),iwkvec(jb),iwkvec(jc),g,
     &            coord,charge,overlap,core,wkvec(je),wkvec(jw),
     &            wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),
     &            wkvec(jv),wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),
     &            wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &            wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &            wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &            wkvec(kq),wkvec(kr),wkvec(ks))

      if(ncontd.eq.0) return

      ja=1
      jb=ja+nppods
      jc=jb+ncpods*6

      if(jc.gt.ninteger) stop 'coremm ds integer overflow'

      je=1
      jf=je+nppods
      jg=jf+nppods
      jh=jg+nppods
      ji=jh+nppods
      jj=ji+nppods
      jk=jj+nppods
      jl=jk+nppods
      jm=jl+nppods
      jn=jm+nppods
      jo=jn+nppods
      jp=jo+nppods
      jq=jp+nppods
      jr=jq+nppods
      js=jr+nppods
      jt=js+nppods

      if(jt.gt.nreal) stop 'coremm ds real overflow'

      call setupds(ncpods,n,ncontd,nconts,nsheld,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+n*6
      kj=ki+ncpods*6
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n

      if(kq.gt.nreal) stop 'coremm ds real overflow'

      call coreds(ncpods,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jf),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jk),
     &            wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),
     &            wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &            wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &            wkvec(kn),wkvec(ko),wkvec(kp))

      ja=1
      jb=ja+nppodp
      jc=jb+ncpodp*18

      if(jc.gt.ninteger) stop 'coremm dp integer overflow'

      je=1
      jf=je+nppodp
      jg=jf+nppodp
      jh=jg+nppodp
      ji=jh+nppodp
      jj=ji+nppodp
      jk=jj+nppodp
      jl=jk+nppodp
      jm=jl+nppodp
      jn=jm+nppodp
      jo=jn+nppodp
      jp=jo+nppodp
      jq=jp+nppodp
      jr=jq+nppodp
      js=jr+nppodp
      jt=js+nppodp
      ju=jt+nppodp
      jv=ju+nppodp
      jw=jv+nppodp
      jx=jw+ncpodp
      jy=jx+ncpodp
      jz=jy+ncpodp

      if(jz.gt.nreal) stop 'coremm dp real overflow'

      call setupdp(ncpodp,n,ncontd,ncontp,nsheld,nshelp,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+n*3
      kj=ki+n*3
      kk=kj+ncpodp*6
      kl=kk+n*6
      km=kl+n*6
      kn=km+ncpodp*10
      ko=kn+n*10
      kp=ko+n*18
      kq=kp+ncpodp*18
      kr=kq+n
      ks=kr+n*3
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n

      if(ky.gt.nreal) stop 'coremm dp real overflow'

      call coredp(ncpodp,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jf),wkvec(jw),wkvec(jx),
     &            wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &            wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &            wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx))

      ja=1
      jb=ja+ncpodd
      jc=jb+nppodd
      jd=jc+ncpodd*36

      if(jd.gt.ninteger) stop 'coremm dd integer overflow'

      je=1
      jf=je+nppodd
      jg=jf+nppodd
      jh=jg+nppodd
      ji=jh+nppodd
      jj=ji+nppodd
      jk=jj+nppodd
      jl=jk+nppodd
      jm=jl+nppodd
      jn=jm+nppodd
      jo=jn+nppodd
      jp=jo+nppodd
      jq=jp+nppodd
      jr=jq+nppodd
      js=jr+nppodd
      jt=js+nppodd
      ju=jt+nppodd
      jv=ju+nppodd
      jw=jv+nppodd
      jx=jw+ncpodd
      jy=jx+ncpodd
      jz=jy+ncpodd

      if(jz.gt.nreal) stop 'coremm dd real overflow'

      call setupdd(ncpodd,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n*3
      ki=kh+n*3
      kj=ki+n*3
      kk=kj+n*3
      kl=kk+n*3
      km=kl+ncpodd*6
      kn=km+n*6
      ko=kn+n*6
      kp=ko+n*6
      kq=kp+ncpodd*10
      kr=kq+n*10
      ks=kr+n*10
      kt=ks+ncpodd*15
      ku=kt+n*15
      kv=ku+n*9
      kw=kv+ncpodd*18
      kx=kw+n*18
      ky=kx+ncpodd*30
      kz=ky+ncpodd*36
      la=kz+n*36
      lb=la+n
      lc=lb+n*3
      ld=lc+n*6
      le=ld+n*9
      lf=le+n
      lg=lf+n
      lh=lg+n
      li=lh+n
      lj=li+n
      lk=lj+n

      if(lk.gt.nreal) stop 'coremm dd real overflow'

      call coredd(ncpodd,n,ncentr,iwkvec(ja),iwkvec(jb),iwkvec(jc),g,
     &            coord,charge,overlap,core,wkvec(je),wkvec(jf),
     &            wkvec(jg),wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jk),wkvec(jm),
     &            wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &            wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &            wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &            wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),
     &            wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),
     &            wkvec(li),wkvec(lj))

      return
      end
