      subroutine gradxc(ndim,ngridmax,ncntrt,ncentr,nconts,ncontp,
     &                  ncontd,natnumber,nptsatom,nfuncatom,ilfunc,
     &                  icfunc,ngauss,nptrs,nptrp,nptrd,wv,dmta,dmtb,
     &                  cent,grad,alpha,coeff)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      parameter (ngridbatch=512)

      dimension natnumber(*),nptsatom(*),nfuncatom(*)
      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension wv(*),dmta(*),dmtb(*),cent(3,*),grad(3,*)
      dimension alpha(*),coeff(*)

      ii=0

      do 1001 i=1,nconts
      nc=icfunc(nptrs(i))
      nfuncatom(ii+1)=nc
 1001 ii=ii+1

      do 1002 i=1,ncontp
      nc=icfunc(nptrp(i))
      do 1003 k=1,3
 1003 nfuncatom(ii+k)=nc
 1002 ii=ii+3

      do 1004 i=1,ncontd
      nc=icfunc(nptrd(i))
      do 1005 k=1,6
 1005 nfuncatom(ii+k)=nc
 1004 ii=ii+6

      ia=1
      ib=ia+ngridmax
      ic=ib+ngridmax
      id=ic+ngridmax
      ie=id+ngridmax
      ig=ie+ngridmax
      ih=ig+ngridmax
      ii=ih+ngridbatch*ncntrt
      ij=ii+ngridbatch*ncntrt
      ik=ij+ngridbatch*ncntrt
      il=ik+ngridbatch*ncntrt
      im=il+ngridbatch*ncntrt
      in=im+ngridbatch*ncntrt
      io=in+ngridbatch*ncntrt
      ip=io+ncntrt*ncntrt
      iq=ip+ncntrt*ncntrt

      if((iq+ngridmax*27).gt.ndim) stop 'gradxc going into xcgrad'

      call xcgrad(ngridmax,ngridbatch,ncntrt,nconts,ncontp,ncontd,
     &            ncentr,ilfunc,icfunc,ngauss,nptrs,nptrp,nptrd,
     &            nptsatom,natnumber,nfuncatom,alpha,coeff,dmta,dmtb,
     &            cent,grad,wv(ia),wv(ib),wv(ic),wv(id),wv(ie),wv(ig),
     &            wv(ih),wv(ii),wv(ij),wv(ik),wv(il),wv(im),wv(in),
     &            wv(io),wv(ip),wv(iq))

      return
      end
