      subroutine gridcall(iswitch,iteration,nfunctional,ninteger,nreal,
     &                    nmaxpoints,ndim1,ndim2,natoms,nalpha,nbeta,
     &                    nconts,ncontp,ncontd,nshays,nshay,nxcfit,
     &                    natomtype,nptsatom,nshels,nshelp,nsheld,
     &                    ilfunc,icfunc,ngaussians,ixclfunc,ixccfunc,
     &                    iwkvec,dmixing,coord,coeffa,coeffb,alpha,
     &                    coeffs,alphaxc,coefsxc,coefpxc,coefdxc,xcfita,
     &                    xcfitb,xcfite,tveca,tvecb,tvece,overlap,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),ngaussians(*),ixclfunc(*),
     &          ixccfunc(*),iwkvec(*)

      dimension coord(3,*),coeffa(ndim1,*),coeffb(ndim1,*),alpha(*),
     &          coeffs(*),alphaxc(*),coefsxc(*),coefpxc(*),coefdxc(*),
     &          xcfita(*),xcfitb(*),xcfite(*),tveca(*),tvecb(*),
     &          tvece(*),overlap(ndim2,*),wkvec(*)

      ncontractions=nconts+3*ncontp+6*ncontd

      ij=0

      do 1001 i=1,ncontractions
      do 1001 j=1,ncontractions
      ij=ij+1
 1001 wkvec(ij)=coeffa(i,j)

      do 1002 i=1,ncontractions
      do 1002 j=1,ncontractions
      ij=ij+1
 1002 wkvec(ij)=coeffb(i,j)

      ja=1
      jb=ja+ncontractions*ncontractions

      npoints=128
      nfunctions=max(ncontractions,nxcfit)
      norbitals=max(nalpha,nbeta)
      nwork=max((nxcfit*30*2+nxcfit*3),(npoints*121))

      ka=ij+1
      kb=ka+npoints*nfunctions
      kc=kb+npoints*norbitals
      kd=kc+npoints*norbitals
      ke=kd+npoints*3
      kf=ke+npoints*2
      kg=kf+npoints
      kh=kg+npoints
      ki=kh+npoints*3
      kj=ki+npoints*3
      kk=kj+npoints*3
      kl=kk+npoints*3
      km=kl+npoints*3
      kn=km+npoints*3
      ko=kn+npoints*3
      kp=ko+npoints*3
      kq=kp+npoints*3
      kr=kq+nmaxpoints
      ks=kr+nmaxpoints
      kt=ks+nmaxpoints
      ku=kt+nmaxpoints
      kv=ku+nwork
      kw=kv+npoints*nfunctions
      kx=kw+npoints*nfunctions
      ky=kx+npoints*ncontractions
      kz=ky+npoints*ncontractions
      la=kz+npoints*ncontractions
      lb=la+npoints*ncontractions
      lc=lb+npoints*ncontractions
      ld=lc+npoints*ncontractions
      le=ld+npoints*ncontractions
      lf=le+npoints*norbitals
      lg=lf+npoints*norbitals
      lh=lg+npoints*norbitals
      li=lh+npoints*norbitals

      if(li.gt.nreal) stop 'real overflow for scf grid work'

      call gridwork(iswitch,iteration,nfunctional,ndim2,npoints,
     &              nfunctions,norbitals,ncontractions,natoms,nalpha,
     &              nbeta,nconts,ncontp,ncontd,nxcfit,nshays,nshay,
     &              natomtype,nptsatom,nshels,nshelp,nsheld,ilfunc,
     &              icfunc,ngaussians,ixclfunc,ixccfunc,iwkvec,coord,
     &              alpha,coeffs,alphaxc,coefsxc,coefpxc,coefdxc,tveca,
     &              tvecb,tvece,overlap,wkvec(ja),wkvec(jb),wkvec(ka),
     &              wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &              wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &              wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &              wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),
     &              wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),
     &              wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),
     &              wkvec(lf),wkvec(lg),wkvec(lh))

      if(iswitch.eq.0) return

      ja=1
      jb=ja+nxcfit*nxcfit
      jc=jb+nxcfit
      jd=jc+nxcfit
      je=jd+nxcfit
      jf=je+nxcfit

      if(jf.gt.nreal) stop 'matrix inversion required for grid work'

      if(iteration.eq.1) then
                               do 1003 i=1,nxcfit
                               do 1003 j=1,i
 1003                          overlap(i,j)=overlap(j,i)

                               ij=0

                               do 1004 j=1,nxcfit
                               do 1004 i=1,nxcfit
                               ij=ij+1
 1004                          wkvec(ij)=overlap(i,j)

                               call xctran(overlap,wkvec(ja),wkvec(jb),
     &                                     wkvec(jc),wkvec(jd),
     &                                     wkvec(je),nxcfit)
                         endif

      call gtxccf(wkvec,xcfita,xcfitb,xcfite,tveca,tvecb,tvece,overlap,
     &            dmixing,nxcfit,ndim2)

      return
      end
