      subroutine input(natoms,ncenters,nptcharges,ndegfreedom,
     &                 nfunctional,irandomgrid,ngridtype,maxiterations,
     &                 maxgeometries,icharge,imultiplicity,mopac,idiis,
     &                 nfdpbt,irestart,ioptimization,ivibrations,
     &                 ihessian,intcoordflag,nequivalences,izmat1,
     &                 izmat2,izmat3,natomtype,intfreeze,nequivvec,
     &                 econvergence,gconvergence,dmixing,dmaxstep,
     &                 elevelshift,epsilon,coord,charge,coordptcharge,
     &                 ptcharge,atomsymbol)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.
c
c  based on steve chin and fiona sim's decode subroutine

      implicit real*8(a-h,o-z)

      parameter(noptions=22,maxitems=40)

      character title*79,parsed(maxitems)*32,options(noptions)*4

      dimension nchars(maxitems)

      dimension value(3)

      dimension izmat1(*),izmat2(*),izmat3(*),
     &          natomtype(*),intfreeze(*),nequivvec(natoms,*)

      dimension coord(3,*),charge(*),coordptcharge(3,*),ptcharge(*)

      character atomsymbol(*)*4

      data zero,bohr,one,evolt/0.0,0.52917715,1.0,27.2116/

      data options/ 'TITL', 'CART', 'ZMAT', 'RUNT', 'POTE',
     &              'GRID', 'MULT', 'CHAR', 'MAXI', 'ECON',
     &              'GCON', 'MAXS', 'HESS', 'MIXI', 'DIIS',
     &              'LEVE', 'MAXG', 'EQUI', 'INIT', 'POIN',
     &              'FREE', 'FDPB'/

 2010 read(5,2011) title
 2011 format(79a)

      write(6,2012) title
 2012 format(//,1x,79a)

      write(6,2013)
 2013 format(//)

 1001 call parser(numwords,nchars,parsed)

      do 1002 i=1,noptions

      if(parsed(1)(1:4).eq.options(i)) goto 1003
      if(parsed(1)(1:3).eq.'END')  goto 1004

 1002 continue

      stop 'keyword error:  please check your input file'

 1003 continue

      goto( 2010, 2020, 2030, 2040, 2050, 2060, 2070, 2080, 2090, 2100,
     &      2110, 2120, 2130, 2140, 2150, 2160, 2170, 2180, 2190, 2200,
     &      2210, 2220) i




 2020 if(parsed(2)(1:3).eq.'ANG') then

           iangstroms=1

           write(6,2021)
 2021      format(' input in cartesian coordinates and angstroms',/)

                                  else

           iangstroms=0

           write(6,2022)
 2022      format(' input in cartesian coordinates and bohr radii',/)

                                  endif

      intcoordflag=0

 2023 call parser(numwords,nchars,parsed)

      if(parsed(1)(1:3).eq.'END') goto 1001

      ncenters=ncenters+1

      atomsymbol(ncenters)=parsed(1)(1:4)

      call element(ncenters,atomsymbol(ncenters),natomtype)

      if(iangstroms.eq.1) then

           coord(1,ncenters)=getvalue(parsed(2),nchars(2))/bohr
           coord(2,ncenters)=getvalue(parsed(3),nchars(3))/bohr
           coord(3,ncenters)=getvalue(parsed(4),nchars(4))/bohr

                          else

           coord(1,ncenters)=getvalue(parsed(2),nchars(2))
           coord(2,ncenters)=getvalue(parsed(3),nchars(3))
           coord(3,ncenters)=getvalue(parsed(4),nchars(4))

                          endif

      goto 2023





 2030 if(parsed(2)(1:3).eq.'ANG') then

           iangstroms=1

           write(6,2031)
 2031      format(' input in zmatrix form and angstroms',/)

                                  else

           iangstroms=0

           write(6,2032)
 2032      format(' input in zmatrix form and bohr radii',/)

                                  endif

      intcoordflag=1

 2033 call parser(numwords,nchars,parsed)

      if(parsed(1)(1:3).eq.'END') goto 1001

      ncenters=ncenters+1

      atomsymbol(ncenters)=parsed(1)(1:4)

      call element(ncenters,atomsymbol(ncenters),natomtype)

      if(ncenters.eq.1) call genxyz(1,0,0,0,zero,zero,zero,coord)

      if(ncenters.eq.2) then

           izmat1(ncenters)=int(getvalue(parsed(2),nchars(2)))

           if(iangstroms.eq.1) then

                           value(1)=getvalue(parsed(3),nchars(3))/bohr

                               else

                           value(1)=getvalue(parsed(3),nchars(3))

                               endif

           call genxyz(2,izmat1(2),0,0,value(1),zero,zero,coord)

                        endif

      if(ncenters.eq.3) then

           izmat1(ncenters)=int(getvalue(parsed(2),nchars(2)))
           izmat2(ncenters)=int(getvalue(parsed(4),nchars(4)))

           if(iangstroms.eq.1) then

                           value(1)=getvalue(parsed(3),nchars(3))/bohr

                               else

                           value(1)=getvalue(parsed(3),nchars(3))

                               endif

           value(2)=getvalue(parsed(5),nchars(5))

           call genxyz(3,izmat1(3),izmat2(3),0,value(1),value(2),
     &                 zero,coord)

                        endif

      if(ncenters.gt.3) then

           izmat1(ncenters)=int(getvalue(parsed(2),nchars(2)))
           izmat2(ncenters)=int(getvalue(parsed(4),nchars(4)))
           izmat3(ncenters)=int(getvalue(parsed(6),nchars(6)))

           if(iangstroms.eq.1) then

                           value(1)=getvalue(parsed(3),nchars(3))/bohr

                               else

                           value(1)=getvalue(parsed(3),nchars(3))

                               endif

           value(2)=getvalue(parsed(5),nchars(5))
           value(3)=getvalue(parsed(7),nchars(7))

           call genxyz(ncenters,izmat1(ncenters),izmat2(ncenters),
     &                 izmat3(ncenters),value(1),value(2),value(3),
     &                 coord)

                      endif

      goto 2033





 2040 do 2041 iword=2,3

      if(parsed(iword)(1:4).eq.'STAR') then

                    irestart=0

                    write(6,2042)
 2042               format(' starting up an scf calculation ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'REST') then

                    irestart=1

                    write(6,2043)
 2043               format(' restarting an scf calculation ',/)

                                       endif

      if(parsed(iword)(1:3).eq.'OPT')  then

                    ioptimization=1

                    write(6,2044)
 2044               format(' starting a geometry optimization ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'CONT') then

                    ioptimization=1

                    irestart=2

                    write(6,2045)
 2045               format(' restarting a geometry optimization ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'VIBR') then

                    ivibrations=1

                    irestart=2

                    write(6,2046)
 2046               format(' performing a vibrational analysis ',/)

                                       endif

 2041 continue

      goto 1001





 2050 if(parsed(2)(1:4).eq.'BECK') then

        nfunctional=1

        write(6,2051)
 2051   format(' using becke exchange/perdew correlation functional ',/)

        goto 1001

                                   endif

      if(parsed(2)(1:4).eq.'MIXB') then

        nfunctional=2

        write(6,2052)
 2052   format(' using becke exchange/perdew correlation energy',
     &         ' with the vwn potential ',/)

        goto 1001

                                   endif

      nfunctional=0

      write(6,2053)
 2053 format(' using the vwn (lsda) functional ',/)

      goto 1001





 2060 do 2061 iword=2,3

      if(parsed(iword)(1:4).eq.'RAND') then

                        irandomgrid=1

                        write(6,2062)
 2062                   format(' using a random grid ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'NONR') then

                        irandomgrid=0

                        write(6,2063)
 2063                   format(' using a nonrandom grid ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'FINE') then

                        ngridtype=1

                        write(6,2064)
 2064                   format(' using the fine grid ',/)

                                       endif

      if(parsed(iword)(1:4).eq.'COAR') then

                        ngridtype=2

                        write(6,2065)
 2065                   format(' using the coarse grid ',/)

                                       endif

 2061 continue

      goto 1001





 2070 imultiplicity=getvalue(parsed(2),nchars(2))

      write(6,2071) imultiplicity
 2071 format(' the multiplicity of the system is ',i3,/)

      goto 1001





 2080 icharge=int(getvalue(parsed(2),nchars(2)))

      write(6,2081) icharge
 2081 format(' the charge on the system is ',i4,/)

      goto 1001





 2090 maxiterations=int(getvalue(parsed(2),nchars(2)))

      write(6,2091) maxiterations
 2091 format(' the maximum number of iterations per geometry is ',i4,/)

      goto 1001





 2100 econvergence=getvalue(parsed(2),nchars(2))

      write(6,2101) econvergence
 2101 format(' the scf convergence criterion is set at ',e14.7,/)

      goto 1001





 2110 gconvergence=getvalue(parsed(2),nchars(2))

      write(6,2111) gconvergence
 2111 format(' the geometry optimization criterion is set at ',e14.7,/)

      goto 1001





 2120 dmaxstep=getvalue(parsed(2),nchars(2))

      write(6,2121) dmaxstep
 2121 format(' maximum stepsize in geometry optimization set at ',
     &       f10.6,' bohr ',/)

      goto 1001





 2130 ihessian=getvalue(parsed(2),nchars(2))

      if(ihessian.eq.0) then

            write(6,2131)
 2131       format(' using the steepest descent method for the',
     &             ' geometry optimization ',/)

                        endif

      if(ihessian.eq.1) then

            write(6,2132)
 2132       format(' using the conjuage gradient method for the',
     &             ' geometry optimization ',/)

                        endif

      if(ihessian.eq.2) then

            write(6,2133)
 2133       format(' using the cartesian bfgs method for the',
     &             ' geometry optimization ',/)

                        endif

      if(ihessian.eq.3) then

            write(6,2134)
 2134       format(' using the internals bfgs method for the',
     &             ' geometry optimization ',/)

                        endif

      if(ihessian.eq.4) then

            write(6,2135)
 2135       format(' using the baker method for the',
     &             ' location of a transition state ',/)

                        endif

      goto 1001





 2140 dmixing=getvalue(parsed(2),nchars(2))

      write(6,2141) dmixing
 2141 format(' using an scf mixing parameter of ',f6.3,/)

      goto 1001





 2150 if(parsed(2)(1:3).eq.'OFF') then

               idiis=0

               write(6,2151)
 2151          format(' the diis scheme has been turned off ',/)

                                  else

               idiis=1

               write(6,2152)
 2152          format(' the diis scheme has been turned on ',/)

                                  endif

      goto 1001





 2160 elevelshift=getvalue(parsed(2),nchars(2))

      write(6,2161) elevelshift
 2161 format(' the levelshift parameter is set to ',f10.3,
     &       ' electron volts ',/)

      elevelshift=elevelshift/evolt

      goto 1001





 2170 maxgeometries=int(getvalue(parsed(2),nchars(2)))

      write(6,2171) maxgeometries
 2171 format(' the maximum number of geometries permitted is ',i4,/)

      goto 1001





 2180 continue

      do 2181 i=3,numwords

      nequivalences=nequivalences+1

      nequivvec(nequivalences,1)=int(getvalue(parsed(2),nchars(2)))
      nequivvec(nequivalences,2)=int(getvalue(parsed(i),nchars(i)))

      write(6,2182) nequivvec(nequivalences,1),
     &              nequivvec(nequivalences,2)

 2182 format(' atoms # ',i4,' and ',i4,' are constrained to have',
     &       ' the same esp fitted charge ',/)

 2181 continue

      goto 1001





 2190 if(parsed(2)(1:2).eq.'YE') then

                mopac=1

                write(6,2191)
 2191           format(' using an initial guess at the hessian ',/)

                                 else

                mopac=0

                write(6,2192)
 2192           format(' not using an initial guess at the hessian ',/)

                                 endif

      goto 1001





 2200 if(parsed(2)(1:3).eq.'ANG') then

            iangstroms=1

            write(6,2201)
 2201       format(' the positions of the point charges are given',
     &             ' in angstroms ',/)

                                  else

            iangstroms=0

            write(6,2202)
 2202       format(' the positions of the point charges are given',
     &             ' in bohr ',/)

                                  endif

 2203 call parser(numwords,nchars,parsed)

      if(parsed(1)(1:3).eq.'END') goto 1001

      nptcharges=nptcharges+1

      if(iangstroms.eq.1) then

          coordptcharge(1,nptcharges)=getvalue(parsed(1),nchars(1))/bohr
          coordptcharge(2,nptcharges)=getvalue(parsed(2),nchars(2))/bohr
          coordptcharge(3,nptcharges)=getvalue(parsed(3),nchars(3))/bohr

                          else

          coordptcharge(1,nptcharges)=getvalue(parsed(1),nchars(1))
          coordptcharge(2,nptcharges)=getvalue(parsed(2),nchars(2))
          coordptcharge(3,nptcharges)=getvalue(parsed(3),nchars(3))

                          endif

      ptcharge(nptcharges)=getvalue(parsed(4),nchars(4))

      goto 2203





 2210 continue

      do 2211 i=1,ndegfreedom
 2211 intfreeze(i)=0

      do 2212 i=2,numwords

      index=int(getvalue(parsed(i),nchars(i)))

      if(index.eq.0) goto 2212

      intfreeze(index)=1

      write(6,2213) index
 2213 format(' internal coordinate # ',i4,' has been frozen ',/)

 2212 continue

      goto 1001





 2220 if(parsed(2)(1:3).eq.'ON') then

           nfdpbt=1

           epsilon=getvalue(parsed(3),nchars(3))

           write(6,2221) epsilon
 2221      format(' a dft-fdpb calculation will be performed,',
     &            ' with a dielectric of ',f8.3,/)

                                 else

           nfdpbt=0

           epsilon=one

           write(6,2222)
 2222      format(' a dft-fdpb calculation will not be performed ',/)

                                 endif

      goto 1001





 1004 continue

      do 1006 i=1,ncenters
 1006 call makelowercase(atomsymbol(i),4)

      do 1007 i=1,ncenters
 1007 charge(i)=real64(natomtype(i))

      return
      end
