      subroutine inputbases(natoms,ncenters,nconts,ncontp,ncontd,
     &                      ncontractions,ncds,ncdspd,ncdfuncs,nxcs,
     &                      nxcspd,nxcfuncs,iwkvec1,iwkvec2,iwkvec3,
     &                      iwkvec4,icfunc,ilfunc,ngaussians,mtloca,
     &                      nshels,nshelp,nsheld,icdcfunc,icdlfunc,
     &                      ixccfunc,ixclfunc,natomtype,alpha,coeff,
     &                      alphacd,coefscd,coefpcd,coefdcd,alphaxc,
     &                      coefsxc,coefpxc,coefdxc,bases_string)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      character input_string*30,bases_string(natoms,2)*30

      dimension iwkvec1(*),iwkvec2(*),iwkvec3(*),iwkvec4(*),icfunc(*),
     &          ilfunc(*),ngaussians(*),mtloca(*),nshels(*),nshelp(*),
     &          nsheld(*),icdcfunc(*),icdlfunc(*),ixccfunc(*),
     &          ixclfunc(*),natomtype(*)

      dimension alpha(*),coeff(*),alphacd(*),coefscd(*),coefpcd(*),
     &          coefdcd(*),alphaxc(*),coefsxc(*),coefpxc(*),coefdxc(*)

      data pi/3.1415926535898/
      data zero,quarter,thrhlf,fivhlf/0.0,0.25,1.5,2.5/
      data one,two,three,eight,twelve,twenty/1.0,2.0,3.0,8.0,12.0,20.0/
      data onehund28,twothou48/128.0,2048.0/

      ncds=0
      nxcs=0

      ncdspd=0
      nxcspd=0

      n1=0
      n2=0

      do 1001 i=1,ncenters

      if(natomtype(i).eq.0) goto 1001

      read(5,2001) bases_string(i,1)

      rewind(3)

 1002 read(3,2001) input_string
      if(input_string.ne.bases_string(i,1)) goto 1002

      read(3,2002) n

      if(n.ne.0) then
                       do 1003 j=1,n
                       read(3,2004) alphacd(n1+j)
                       icdcfunc(n1+j)=i
                       iwkvec1(ncds+j)=n1+j
 1003                  coefscd(n1+j)=one/sqrt(sqrt(two)*
     &                                  ((pi/alphacd(n1+j))**fivhlf))
                 endif

      ncds=ncds+n
      n1=n1+n

      read(3,2002) n

      if(n.ne.0) then
                       do 1004 j=1,n
                       read(3,2004) alphacd(n1+j)
                       icdcfunc(n1+j)=i
                       iwkvec2(ncdspd+j)=n1+j
                       factor=sqrt(two)*((pi/alphacd(n1+j))**fivhlf)
                       coefscd(n1+j)=one/sqrt(factor)
                       factor=factor/(twelve*alphacd(n1+j))
                       coefpcd(n1+j)=one/sqrt(factor)
                       factor=factor*three/(twenty*alphacd(n1+j))
 1004                  coefdcd(n1+j)=one/sqrt(factor)
                 endif

      ncdspd=ncdspd+n
      n1=n1+n

      read(3,2002) n

      if(n.ne.0) then
                       do 1005 j=1,n
                       read(3,2004) alphaxc(n2+j)
                       ixccfunc(n2+j)=i
                       iwkvec3(nxcs+j)=n2+j
 1005                  coefsxc(n2+j)=(eight*alphaxc(n2+j)**3/pi**3)**
     &                                                          quarter
                 endif

      nxcs=nxcs+n
      n2=n2+n

      read(3,2002) n

      if(n.ne.0) then
                       do 1006 j=1,n
                       read(3,2004) alphaxc(n2+j)
                       ixccfunc(n2+j)=i
                       iwkvec4(nxcspd+j)=n2+j
                       coefsxc(n2+j)=(eight*alphaxc(n2+j)**3/pi**3)
     &                                                       **quarter
                       coefpxc(n2+j)=(onehund28*alphaxc(n2+j)**5/pi**3)
     &                                                       **quarter
 1006                  coefdxc(n2+j)=(twothou48*alphaxc(n2+j)**7/pi**3)
     &                                                       **quarter
                 endif

      nxcspd=nxcspd+n
      n2=n2+n

 1001 continue

      if(ncds.ne.0) then
                          do 1007 i=1,ncds
 1007                     icdlfunc(i)=iwkvec1(i)
                    endif

      if(nxcs.ne.0) then
                          do 1008 i=1,nxcs
 1008                     ixclfunc(i)=iwkvec3(i)
                    endif

      if(ncdspd.ne.0) then
                            do 1009 i=1,ncdspd
 1009                       icdlfunc(ncds+i)=iwkvec2(i)
                      endif

      if(nxcspd.ne.0) then
                            do 1010 i=1,nxcspd
 1010                       ixclfunc(nxcs+i)=iwkvec4(i)
                      endif

      ncdfuncs=ncds+10*ncdspd
      nxcfuncs=nxcs+10*nxcspd

      ncdspd=ncds+ncdspd
      nxcspd=nxcs+nxcspd

      nconts=0
      ncontp=0
      ncontd=0

      m=0
      n=0

      do 1011 i=1,ncenters

      if(natomtype(i).eq.0) goto 1011

      read(5,2001) bases_string(i,2)

      rewind(3)

 1012 read(3,2001) input_string
      if(input_string.ne.bases_string(i,2)) goto 1012

      read(3,2003) nfuncs,nfuncp,nfuncd

      do 1013 j=1,nfuncs

      read(3,2002) nprimitives
      nshels(nconts+j)=m+j
      ngaussians(m+j)=nprimitives
      icfunc(m+j)=i
      ilfunc(m+j)=n+1

      do 1014 k=1,nprimitives
      read(3,2005) alpha(n+k),coeff(n+k)
 1014 coeff(n+k)=coeff(n+k)*(eight*alpha(n+k)**3/pi**3)**quarter

      dn=zero

      do 1015 k=1,nprimitives
      do 1015 l=1,nprimitives
 1015 dn=dn+coeff(n+k)*coeff(n+l)*(pi/(alpha(n+k)+alpha(n+l)))**thrhlf

      do 1016 k=1,nprimitives
 1016 coeff(n+k)=coeff(n+k)/sqrt(dn)

 1013 n=n+nprimitives

      m=m+nfuncs

      if(nfuncp.eq.0) goto 1017

      do 1018 j=1,nfuncp

      read(3,2002) nprimitives
      nshelp(ncontp+j)=m+j
      ngaussians(m+j)=nprimitives
      icfunc(m+j)=i
      ilfunc(m+j)=n+1

      do 1019 k=1,nprimitives
      read(3,2005) alpha(n+k),coeff(n+k)
 1019 coeff(n+k)=coeff(n+k)*(onehund28*alpha(n+k)**5/pi**3)**quarter

      dn=zero

      do 1020 k=1,nprimitives
      do 1020 l=1,nprimitives
      factor=coeff(n+k)*coeff(n+l)*(pi/(alpha(n+k)+alpha(n+l)))**thrhlf
 1020 dn=dn+factor/(two*(alpha(n+k)+alpha(n+l)))

      do 1021 k=1,nprimitives
 1021 coeff(n+k)=coeff(n+k)/sqrt(dn)

 1018 n=n+nprimitives

      m=m+nfuncp

      if(nfuncd.eq.0) goto 1017

      do 1022 j=1,nfuncd

      read(3,2002) nprimitives
      nsheld(ncontd+j)=m+j
      ngaussians(m+j)=nprimitives
      icfunc(m+j)=i
      ilfunc(m+j)=n+1

      do 1023 k=1,nprimitives
      read(3,2005) alpha(n+k),coeff(n+k)
 1023 coeff(n+k)=coeff(n+k)*(twothou48*alpha(n+k)**7/pi**3)**quarter

      dn=zero

      do 1024 k=1,nprimitives
      do 1024 l=1,nprimitives
      factor=coeff(n+k)*coeff(n+l)*(pi/(alpha(n+k)+alpha(n+l)))**thrhlf
 1024 dn=dn+factor/((two*(alpha(n+k)+alpha(n+l)))**2)

      do 1025 k=1,nprimitives
 1025 coeff(n+k)=coeff(n+k)/sqrt(dn)

 1022 n=n+nprimitives

 1017 continue

      m=m+nfuncd

      nconts=nconts+nfuncs
      ncontp=ncontp+nfuncp
      ncontd=ncontd+nfuncd

 1011 continue

      ncontractions=nconts+3*ncontp+6*ncontd

      write(6,2006) ncontractions,ncdfuncs,nxcfuncs

      do 1026 i=1,nconts
 1026 mtloca(nshels(i))=i

      if(ncontp.ne.0) then
                            do 1027 i=1,ncontp
 1027                       mtloca(nshelp(i))=nconts+3*(i-1)+1
                      endif

      if(ncontd.ne.0) then
                            do 1028 i=1,ncontd
 1028                       mtloca(nsheld(i))=nconts+3*ncontp+6*(i-1)+1
                      endif

 2001 format(a30)
 2002 format(1i5)
 2003 format(3i5)
 2004 format(1f20.10)
 2005 format(2f20.10)
 2006 format(' number of orbital basis functions                =',i5,/,
     &       ' number of charge density fitting functions       =',i5,/,
     &       ' number of exchange/correlation fitting functions =',i5,/)

      return
      end
