      subroutine ksorbs(maxorbitals,nalpha,nbeta,eigalpha,eigbeta)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension eigalpha(*),eigbeta(*)

      data zero,one,ev/0.0,1.0,27.212/

      write(6,1001)
 1001 format(' kohn-sham orbitals : ',/)

      do 1002 i=1,min(nalpha+5,maxorbitals)
      if(i.le.nalpha) write(6,1003) i,eigalpha(i)*ev,one
 1002 if(i.gt.nalpha) write(6,1003) i,eigalpha(i)*ev,zero

 1003 format(' spin alpha orbital # ',i4,',  eigenvalue = ',f12.5,
     &       ' eV,  occupancy = ',f6.4)

      write(6,1004)
 1004 format()

      do 1005 i=1,min(nbeta+5,maxorbitals)
      if(i.le.nbeta) write(6,1006) i,eigbeta(i)*ev,one
 1005 if(i.gt.nbeta) write(6,1006) i,eigbeta(i)*ev,zero

 1006 format(' spin beta orbital #  ',i4,',  eigenvalue = ',f12.5,
     &       ' eV,  occupancy = ',f6.4)

      write(6,1007)
 1007 format(//)

      return
      end
