      subroutine vibrations(nreal,ninteger,nmaxorbs,nmaxaux,nmaxpoints,
     &                      nmaxfock,nmaxdim,ncenters,nptcharges,nalpha,
     &                      nbeta,nconts,ncontp,ncontd,ncds,ncdspd,nxcs,
     &                      nxcspd,idiis,nmaxiterations,nfunctional,
     &                      irandgrid,ngridtype,iwkvec,izmat1,izmat2,
     &                      izmat3,natomtype,nfuncatom,nptsatom,icfunc,
     &                      ilfunc,ngaussians,mtloca,nshels,nshelp,
     &                      nsheld,icdcfunc,icdlfunc,ixccfunc,ixclfunc,
     &                      nintfreeze,econvergence,dmixing,elevelshift,
     &                      wkvec,coord,coordfix,charge,grad,gradsave,
     &                      coordpc,ptcharge,overlap,core,focka,fockb,
     &                      focke,dmta,dmtb,coeffa,coeffb,orbnrga,
     &                      orbnrgb,alpha,coeff,alphacd,coefscd,coefpcd,
     &                      coefdcd,alphaxc,coefsxc,coefpxc,coefdxc,
     &                      cdfitc,xcfita,xcfitb,xcfite,xcfitsave,tvec,
     &                      tveca,tvecb,tvece,sauxoverlap,grad1,grad2,
     &                      coord1,coord2,hessian,djacobian,labelatoms)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      character labelatoms(*)*4

      dimension iwkvec(*),izmat1(*),izmat2(*),izmat3(*),natomtype(*),
     &          nfuncatom(*),nptsatom(*),icfunc(*),ilfunc(*),
     &          ngaussians(*),mtloca(*),nshels(*),nshelp(*),nsheld(*),
     &          icdcfunc(*),icdlfunc(*),ixccfunc(*),ixclfunc(*),
     &          nintfreeze(*)

      dimension wkvec(*),coord(3,*),coordfix(3,*),charge(*),grad(3,*),
     &          gradsave(3,*),coordpc(3,*),ptcharge(*),
     &          overlap(nmaxorbs,*),core(*),focka(*),fockb(*),focke(*),
     &          dmta(*),dmtb(*),coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),
     &          orbnrga(*),orbnrgb(*),alpha(*),coeff(*),alphacd(*),
     &          coefscd(*),coefpcd(*),coefdcd(*),alphaxc(*),coefsxc(*),
     &          coefpxc(*),coefdxc(*),cdfitc(*),xcfita(*),xcfitb(*),
     &          xcfite(*),xcfitsave(*),tvec(*),tveca(*),tvecb(*),
     &          tvece(*),sauxoverlap(nmaxaux,*),grad1(*),grad2(*),
     &          coord1(*),coord2(*),hessian(nmaxdim,*),
     &          djacobian(nmaxdim,*)

      data small,step,bohr/0.00001,0.0025,0.529177/

      rewind 73
      rewind 74

      ncontractions=nconts+3*ncontp+6*ncontd

      ihessian=0

      nonlinear=0

      do 1001 i=1,ncenters
      do 1001 j=2,3
 1001 if(abs(coord(j,i)).ge.small) nonlinear=1

      if(nonlinear.eq.0) nmodes=3*ncenters-5
      if(nonlinear.eq.1) nmodes=3*ncenters-6

      displacement=step/bohr

      nstep=0

      do 1002 i=1,ncenters
      do 1002 j=1,3
 1002 coordfix(j,i)=coord(j,i)

      do 1003 i=1,2
      do 1003 j=1,ncenters
      do 1003 k=1,3

      if(i.eq.1) coord(k,j)=coord(k,j)+displacement
      if(i.eq.2) coord(k,j)=coord(k,j)-displacement

      nstep=nstep+1

      write(6,1004) nstep
 1004 format(///,' geometry number',i4,' of the vibrational analysis',/)

      do 1005 l=1,ncenters
 1005 write(6,1006) l,coord(1,l)*bohr,coord(2,l)*bohr,coord(3,l)*bohr
 1006 format(' atom # ',i3,5x,3f12.7)

      write(6,1007)
 1007 format(/)

      call scfrun(nreal,ninteger,nmaxorbs,nmaxaux,nmaxpoints,
     &            nfucntional,nmaxiterations,idiis,ngridtype,irandgrid,
     &            ncenters,nptcharges,nalpha,nbeta,nconts,ncontp,ncontd,
     &            ncds,ncdspd,nxcs,nxcspd,natomtype,nptsatom,nshels,
     &            nshelp,nsheld,ilfunc,icfunc,mtloca,ngaussians,
     &            icdlfunc,icdcfunc,ixclfunc,ixccfunc,iwkvec,
     &            econvergence,dmixing,elevelshift,diiserror,coord,
     &            charge,coordpc,ptcharge,core,focka,fockb,focke,dmta,
     &            dmtb,coeffa,coeffb,orbnrga,orbnrgb,alpha,coeff,
     &            alphacd,coefscd,coefpcd,coefdcd,alphaxc,coefsxc,
     &            coefpxc,coefdxc,cdfitc,xcfita,xcfitb,xcfite,xcfitsave,
     &            sauxoverlap,tvec,tveca,tvecb,tvece,overlap,wkvec)

      n=ncontractions*(ncontractions+1)/2

      call dipolemm(nreal-n-5,ninteger,ncenters,nconts,ncontp,ncontd,
     &              nshels,nshelp,nsheld,mtloca,ilfunc,ngaussians,
     &              icfunc,iwkvec,wkvec(1),coord,charge,alpha,coeff,
     &              dmta,dmtb,wkvec(5),wkvec(n+5))

      call fastwr(73,wkvec,3)

      call move(1,nstep,ihessian,nreal,ninteger,nmaxpoints,nmaxorbs,
     &          nmaxfock,nmaxdim,nmodes,ncenters,nalpha,nbeta,
     &          ncontractions,nconts,ncontp,ncontd,ncds,ncdspd,
     &          nintfreeze,natomtype,nptsatom,nfuncatom,izmat1,izmat2,
     &          izmat3,nshels,nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &          mtloca,icdlfunc,icdcfunc,iwkvec,dmaxfactor,step,
     &          coordfix,coord,charge,dmta,dmtb,coeffa,coeffb,orbnrga,
     &          orbnrgb,alpha,coeff,cdfitc,alphacd,coefscd,coefpcd,
     &          coefdcd,gradsave,grad,coord1,coord2,grad1,grad2,hessian,
     &          sauxoverlap,djacobian,wkvec,labelatoms)

      do 1008 l=1,ncenters
 1008 write(74) grad(1,l),grad(2,l),grad(3,l)

      do 1009 l=1,ncenters
      do 1009 m=1,3
 1009 coord(m,l)=coordfix(m,l)

 1003 continue

      ja=1
      jb=ja+ncenters*ncenters*9
      jc=jb+ncenters*ncenters*9
      jd=jc+ncenters*9
      je=jd+ncenters*9
      jf=je+ncenters*3
      jg=jf+ncenters*9
      jh=jg+ncenters*3
      ji=jh+ncenters*3

      call irspectrum(nonlinear,ncenters,natomtype,displacement,coord,
     &                wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),
     &                wkvec(jf),wkvec(jg),wkvec(jh),wkvec(ji))

      return
      end
