      subroutine xcordp(m,n,nxcs,nxcspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,coord,xcfit1,xcfit2,xcfit3,alphaaux,
     &                  coeffs,coeffp,coeffd,fock1,fock2,fock3,zeta,ax,
     &                  ay,az,axbx,ayby,azbz,px,py,pz,base,zetarec,
     &                  zetafac,efac,gxax,gyay,gzaz,sss,pss,dss,dsscond,
     &                  fss,fsscond,gss,gsscond,hss,hsscond,dps,fps,gps,
     &                  dpp,fpp,dpd,c,c1,c2,c3,zzeta,aax,aay,aaz,ppx,
     &                  ppy,ppz,axcx,aycy,azcz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcft1p(3),xcft2p(3),xcft3p(3),
     &          xcft1d(6),xcft2d(6),xcft3d(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(m,*)

      dimension coord(3,*),xcfit1(*),xcfit2(*),xcfit3(*),alphaaux(*),
     &          coeffs(*),coeffp(*),coeffd(*),fock1(*),fock2(*),
     &          fock3(*),zeta(*),ax(*),ay(*),az(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),zetarec(*),zetafac(*),
     &          efac(*),gxax(*),gyay(*),gzaz(*),sss(*),pss(n,*),
     &          dss(n,*),dsscond(m,*),fss(n,*),fsscond(m,*),gss(n,*),
     &          gsscond(m,*),hss(n,*),hsscond(m,*),dps(m,*),fps(m,*),
     &          gps(m,*),dpp(m,*),fpp(m,*),dpd(m,*),c(*),c1(n,*),
     &          c2(n,*),c3(n,*),zzeta(*),aax(*),aay(*),aaz(*),ppx(*),
     &          ppy(*),ppz(*),axcx(*),aycy(*),azcz(*)

      data zero,one,two,three,four/0.0,1.0,2.0,3.0,4.0/
      data expcut,calcut/80.0,1.0e-16/

      sqrt3=sqrt(three)

      do 1001 naux=1,nxcs

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(naux)*coeffs(ilaux)
      xcft2s=xcfit2(naux)*coeffs(ilaux)
      xcft3s=xcfit3(naux)*coeffs(ilaux)

      do 1002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      sss(i)=zero
 1004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 1005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 1005 continue

      do 1006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 1006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 1007 i=1,nn
 1007 zetarec(i)=zetarec(i)/two

      do 1008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 1008 pss(i,3)=gzaz(i)*sss(i)

      do 1009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 c1(i,j)=zetarec(i)*pss(i,j)

      do 1011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)+c1(i,1)
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)+c1(i,2)
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 1011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)+c1(i,3)

      do 1012 j=1,6
      do 1012 i=1,m
 1012 dsscond(i,j)=zero

      do 1013 j=1,10
      do 1013 i=1,m
 1013 fsscond(i,j)=zero

      do 1014 j=1,6
      do 1014 i=1,nn
 1014 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 1015 j=1,10
      do 1015 i=1,nn
 1015 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss(i,j)

      do 1016 i=1,m
      dps(i,01)=axbx(i)*dsscond(i,1)+fsscond(i,01)
      dps(i,02)=ayby(i)*dsscond(i,1)+fsscond(i,02)
      dps(i,03)=azbz(i)*dsscond(i,1)+fsscond(i,03)
      dps(i,04)=axbx(i)*dsscond(i,2)+fsscond(i,02)
      dps(i,05)=ayby(i)*dsscond(i,2)+fsscond(i,04)
      dps(i,06)=azbz(i)*dsscond(i,2)+fsscond(i,05)
      dps(i,07)=axbx(i)*dsscond(i,3)+fsscond(i,03)
      dps(i,08)=ayby(i)*dsscond(i,3)+fsscond(i,05)
      dps(i,09)=azbz(i)*dsscond(i,3)+fsscond(i,06)
      dps(i,10)=axbx(i)*dsscond(i,4)+fsscond(i,04)
      dps(i,11)=ayby(i)*dsscond(i,4)+fsscond(i,07)
      dps(i,12)=azbz(i)*dsscond(i,4)+fsscond(i,08)
      dps(i,13)=axbx(i)*dsscond(i,5)+fsscond(i,05)
      dps(i,14)=ayby(i)*dsscond(i,5)+fsscond(i,08)
      dps(i,15)=azbz(i)*dsscond(i,5)+fsscond(i,09)
      dps(i,16)=axbx(i)*dsscond(i,6)+fsscond(i,06)
      dps(i,17)=ayby(i)*dsscond(i,6)+fsscond(i,09)
 1016 dps(i,18)=azbz(i)*dsscond(i,6)+fsscond(i,10)

      do 1017 j=1,18
      do 1017 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dps(i,j)*xcft1s
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dps(i,j)*xcft2s
 1017 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dps(i,j)*xcft3s

 1001 continue

      do 2001 naux=1,nxcspd

      ilaux=ilfunc(nxcs+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft2s=xcfit2(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft3s=xcfit3(nxcs+(naux-1)*10+1)*coeffs(ilaux)

      xcft1p(1)=xcfit1(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft1p(2)=xcfit1(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft1p(3)=xcfit1(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft2p(1)=xcfit2(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft2p(2)=xcfit2(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft2p(3)=xcfit2(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft3p(1)=xcfit3(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft3p(2)=xcfit3(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft3p(3)=xcfit3(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft1d(1)=xcfit1(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft1d(2)=xcfit1(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft1d(3)=xcfit1(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft1d(4)=xcfit1(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft1d(5)=xcfit1(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft1d(6)=xcfit1(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft2d(1)=xcfit2(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft2d(2)=xcfit2(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft2d(3)=xcfit2(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft2d(4)=xcfit2(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft2d(5)=xcfit2(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft2d(6)=xcfit2(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft3d(1)=xcfit3(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft3d(2)=xcfit3(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft3d(3)=xcfit3(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft3d(4)=xcfit3(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft3d(5)=xcfit3(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft3d(6)=xcfit3(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      do 2002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n

      axcx(icontr(i))=ax(i)-ccx
      aycy(icontr(i))=ay(i)-ccy
      azcz(icontr(i))=az(i)-ccz

      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz

 2003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      sss(i)=zero
 2004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 2005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 2005 continue

      do 2006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 2006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 2007 i=1,nn
 2007 zetarec(i)=zetarec(i)/two

      do 2008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 2008 pss(i,3)=gzaz(i)*sss(i)

      do 2009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 2009 continue

      do 2010 j=1,3
      do 2010 i=1,nn
 2010 c1(i,j)=zetarec(i)*pss(i,j)

      do 2011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)+c1(i,1)
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)+c1(i,2)
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 2011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)+c1(i,3)

      do 2012 j=1,6
      do 2012 i=1,nn
 2012 c2(i,j)=zetarec(i)*dss(i,j)

      do 2013 i=1,nn
      gss(i,01)=gxax(i)*fss(i,01)+c2(i,1)*three
      gss(i,02)=gyay(i)*fss(i,01)
      gss(i,03)=gzaz(i)*fss(i,01)
      gss(i,04)=gyay(i)*fss(i,02)+c2(i,1)
      gss(i,05)=gzaz(i)*fss(i,02)
      gss(i,06)=gzaz(i)*fss(i,03)+c2(i,1)
      gss(i,07)=gyay(i)*fss(i,04)+c2(i,2)*two
      gss(i,08)=gzaz(i)*fss(i,04)
      gss(i,09)=gzaz(i)*fss(i,05)+c2(i,2)
      gss(i,10)=gzaz(i)*fss(i,06)+c2(i,3)*two
      gss(i,11)=gyay(i)*fss(i,07)+c2(i,4)*three
      gss(i,12)=gzaz(i)*fss(i,07)
      gss(i,13)=gzaz(i)*fss(i,08)+c2(i,4)
      gss(i,14)=gzaz(i)*fss(i,09)+c2(i,5)*two
 2013 gss(i,15)=gzaz(i)*fss(i,10)+c2(i,6)*three

      do 2014 j=1,10
      do 2014 i=1,nn
 2014 c3(i,j)=zetarec(i)*fss(i,j)

      do 2015 i=1,nn
      hss(i,01)=gxax(i)*gss(i,01)+c3(i,01)*four
      hss(i,02)=gyay(i)*gss(i,01)
      hss(i,03)=gzaz(i)*gss(i,01)
      hss(i,04)=gyay(i)*gss(i,02)+c3(i,01)
      hss(i,05)=gzaz(i)*gss(i,02)
      hss(i,06)=gzaz(i)*gss(i,03)+c3(i,01)
      hss(i,07)=gyay(i)*gss(i,04)+c3(i,02)*two
      hss(i,08)=gzaz(i)*gss(i,04)
      hss(i,09)=gzaz(i)*gss(i,05)+c3(i,02)
      hss(i,10)=gzaz(i)*gss(i,06)+c3(i,03)*two
      hss(i,11)=gyay(i)*gss(i,07)+c3(i,04)*three
      hss(i,12)=gzaz(i)*gss(i,07)
      hss(i,13)=gzaz(i)*gss(i,08)+c3(i,04)
      hss(i,14)=gzaz(i)*gss(i,09)+c3(i,05)*two
      hss(i,15)=gzaz(i)*gss(i,10)+c3(i,06)*three
      hss(i,16)=gyay(i)*gss(i,11)+c3(i,07)*four
      hss(i,17)=gzaz(i)*gss(i,11)
      hss(i,18)=gzaz(i)*gss(i,12)+c3(i,07)
      hss(i,19)=gzaz(i)*gss(i,13)+c3(i,08)*two
      hss(i,20)=gzaz(i)*gss(i,14)+c3(i,09)*three
 2015 hss(i,21)=gzaz(i)*gss(i,15)+c3(i,10)*four

      do 2016 j=1,6
      do 2016 i=1,m
 2016 dsscond(i,j)=zero

      do 2017 j=1,10
      do 2017 i=1,m
 2017 fsscond(i,j)=zero

      do 2018 j=1,15
      do 2018 i=1,m
 2018 gsscond(i,j)=zero

      do 2019 j=1,21
      do 2019 i=1,m
 2019 hsscond(i,j)=zero

      do 2020 j=1,6
      do 2020 i=1,nn
 2020 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 2021 j=1,10
      do 2021 i=1,nn
 2021 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss(i,j)

      do 2022 j=1,15
      do 2022 i=1,nn
 2022 gsscond(iicontr(i),j)=gsscond(iicontr(i),j)+gss(i,j)

      do 2023 j=1,21
      do 2023 i=1,nn
 2023 hsscond(iicontr(i),j)=hsscond(iicontr(i),j)+hss(i,j)

      do 2024 i=1,m
      dps(i,01)=axbx(i)*dsscond(i,1)+fsscond(i,01)
      dps(i,02)=ayby(i)*dsscond(i,1)+fsscond(i,02)
      dps(i,03)=azbz(i)*dsscond(i,1)+fsscond(i,03)
      dps(i,04)=axbx(i)*dsscond(i,2)+fsscond(i,02)
      dps(i,05)=ayby(i)*dsscond(i,2)+fsscond(i,04)
      dps(i,06)=azbz(i)*dsscond(i,2)+fsscond(i,05)
      dps(i,07)=axbx(i)*dsscond(i,3)+fsscond(i,03)
      dps(i,08)=ayby(i)*dsscond(i,3)+fsscond(i,05)
      dps(i,09)=azbz(i)*dsscond(i,3)+fsscond(i,06)
      dps(i,10)=axbx(i)*dsscond(i,4)+fsscond(i,04)
      dps(i,11)=ayby(i)*dsscond(i,4)+fsscond(i,07)
      dps(i,12)=azbz(i)*dsscond(i,4)+fsscond(i,08)
      dps(i,13)=axbx(i)*dsscond(i,5)+fsscond(i,05)
      dps(i,14)=ayby(i)*dsscond(i,5)+fsscond(i,08)
      dps(i,15)=azbz(i)*dsscond(i,5)+fsscond(i,09)
      dps(i,16)=axbx(i)*dsscond(i,6)+fsscond(i,06)
      dps(i,17)=ayby(i)*dsscond(i,6)+fsscond(i,09)
 2024 dps(i,18)=azbz(i)*dsscond(i,6)+fsscond(i,10)

      do 2025 i=1,m
      fps(i,01)=axbx(i)*fsscond(i,01)+gsscond(i,01)
      fps(i,02)=ayby(i)*fsscond(i,01)+gsscond(i,02)
      fps(i,03)=azbz(i)*fsscond(i,01)+gsscond(i,03)
      fps(i,04)=axbx(i)*fsscond(i,02)+gsscond(i,02)
      fps(i,05)=ayby(i)*fsscond(i,02)+gsscond(i,04)
      fps(i,06)=azbz(i)*fsscond(i,02)+gsscond(i,05)
      fps(i,07)=axbx(i)*fsscond(i,03)+gsscond(i,03)
      fps(i,08)=ayby(i)*fsscond(i,03)+gsscond(i,05)
      fps(i,09)=azbz(i)*fsscond(i,03)+gsscond(i,06)
      fps(i,10)=axbx(i)*fsscond(i,04)+gsscond(i,04)
      fps(i,11)=ayby(i)*fsscond(i,04)+gsscond(i,07)
      fps(i,12)=azbz(i)*fsscond(i,04)+gsscond(i,08)
      fps(i,13)=axbx(i)*fsscond(i,05)+gsscond(i,05)
      fps(i,14)=ayby(i)*fsscond(i,05)+gsscond(i,08)
      fps(i,15)=azbz(i)*fsscond(i,05)+gsscond(i,09)
      fps(i,16)=axbx(i)*fsscond(i,06)+gsscond(i,06)
      fps(i,17)=ayby(i)*fsscond(i,06)+gsscond(i,09)
      fps(i,18)=azbz(i)*fsscond(i,06)+gsscond(i,10)
      fps(i,19)=axbx(i)*fsscond(i,07)+gsscond(i,07)
      fps(i,20)=ayby(i)*fsscond(i,07)+gsscond(i,11)
      fps(i,21)=azbz(i)*fsscond(i,07)+gsscond(i,12)
      fps(i,22)=axbx(i)*fsscond(i,08)+gsscond(i,08)
      fps(i,23)=ayby(i)*fsscond(i,08)+gsscond(i,12)
      fps(i,24)=azbz(i)*fsscond(i,08)+gsscond(i,13)
      fps(i,25)=axbx(i)*fsscond(i,09)+gsscond(i,09)
      fps(i,26)=ayby(i)*fsscond(i,09)+gsscond(i,13)
      fps(i,27)=azbz(i)*fsscond(i,09)+gsscond(i,14)
      fps(i,28)=axbx(i)*fsscond(i,10)+gsscond(i,10)
      fps(i,29)=ayby(i)*fsscond(i,10)+gsscond(i,14)
 2025 fps(i,30)=azbz(i)*fsscond(i,10)+gsscond(i,15)

      do 2026 i=1,m
      dpp(i,01)=axcx(i)*dps(i,01)+fps(i,01)
      dpp(i,02)=aycy(i)*dps(i,01)+fps(i,04)
      dpp(i,03)=azcz(i)*dps(i,01)+fps(i,07)
      dpp(i,04)=axcx(i)*dps(i,02)+fps(i,02)
      dpp(i,05)=aycy(i)*dps(i,02)+fps(i,05)
      dpp(i,06)=azcz(i)*dps(i,02)+fps(i,08)
      dpp(i,07)=axcx(i)*dps(i,03)+fps(i,03)
      dpp(i,08)=aycy(i)*dps(i,03)+fps(i,06)
      dpp(i,09)=azcz(i)*dps(i,03)+fps(i,09)
      dpp(i,10)=axcx(i)*dps(i,04)+fps(i,04)
      dpp(i,11)=aycy(i)*dps(i,04)+fps(i,10)
      dpp(i,12)=azcz(i)*dps(i,04)+fps(i,13)
      dpp(i,13)=axcx(i)*dps(i,05)+fps(i,05)
      dpp(i,14)=aycy(i)*dps(i,05)+fps(i,11)
      dpp(i,15)=azcz(i)*dps(i,05)+fps(i,14)
      dpp(i,16)=axcx(i)*dps(i,06)+fps(i,06)
      dpp(i,17)=aycy(i)*dps(i,06)+fps(i,12)
      dpp(i,18)=azcz(i)*dps(i,06)+fps(i,15)
      dpp(i,19)=axcx(i)*dps(i,07)+fps(i,07)
      dpp(i,20)=aycy(i)*dps(i,07)+fps(i,13)
      dpp(i,21)=azcz(i)*dps(i,07)+fps(i,16)
      dpp(i,22)=axcx(i)*dps(i,08)+fps(i,08)
      dpp(i,23)=aycy(i)*dps(i,08)+fps(i,14)
      dpp(i,24)=azcz(i)*dps(i,08)+fps(i,17)
      dpp(i,25)=axcx(i)*dps(i,09)+fps(i,09)
      dpp(i,26)=aycy(i)*dps(i,09)+fps(i,15)
      dpp(i,27)=azcz(i)*dps(i,09)+fps(i,18)
      dpp(i,28)=axcx(i)*dps(i,10)+fps(i,10)
      dpp(i,29)=aycy(i)*dps(i,10)+fps(i,19)
      dpp(i,30)=azcz(i)*dps(i,10)+fps(i,22)
      dpp(i,31)=axcx(i)*dps(i,11)+fps(i,11)
      dpp(i,32)=aycy(i)*dps(i,11)+fps(i,20)
      dpp(i,33)=azcz(i)*dps(i,11)+fps(i,23)
      dpp(i,34)=axcx(i)*dps(i,12)+fps(i,12)
      dpp(i,35)=aycy(i)*dps(i,12)+fps(i,21)
      dpp(i,36)=azcz(i)*dps(i,12)+fps(i,24)
      dpp(i,37)=axcx(i)*dps(i,13)+fps(i,13)
      dpp(i,38)=aycy(i)*dps(i,13)+fps(i,22)
      dpp(i,39)=azcz(i)*dps(i,13)+fps(i,25)
      dpp(i,40)=axcx(i)*dps(i,14)+fps(i,14)
      dpp(i,41)=aycy(i)*dps(i,14)+fps(i,23)
      dpp(i,42)=azcz(i)*dps(i,14)+fps(i,26)
      dpp(i,43)=axcx(i)*dps(i,15)+fps(i,15)
      dpp(i,44)=aycy(i)*dps(i,15)+fps(i,24)
      dpp(i,45)=azcz(i)*dps(i,15)+fps(i,27)
      dpp(i,46)=axcx(i)*dps(i,16)+fps(i,16)
      dpp(i,47)=aycy(i)*dps(i,16)+fps(i,25)
      dpp(i,48)=azcz(i)*dps(i,16)+fps(i,28)
      dpp(i,49)=axcx(i)*dps(i,17)+fps(i,17)
      dpp(i,50)=aycy(i)*dps(i,17)+fps(i,26)
      dpp(i,51)=azcz(i)*dps(i,17)+fps(i,29)
      dpp(i,52)=axcx(i)*dps(i,18)+fps(i,18)
      dpp(i,53)=aycy(i)*dps(i,18)+fps(i,27)
 2026 dpp(i,54)=azcz(i)*dps(i,18)+fps(i,30)

      do 2027 i=1,m
      gps(i,01)=axbx(i)*gsscond(i,01)+hsscond(i,01)
      gps(i,02)=ayby(i)*gsscond(i,01)+hsscond(i,02)
      gps(i,03)=azbz(i)*gsscond(i,01)+hsscond(i,03)
      gps(i,04)=axbx(i)*gsscond(i,02)+hsscond(i,02)
      gps(i,05)=ayby(i)*gsscond(i,02)+hsscond(i,04)
      gps(i,06)=azbz(i)*gsscond(i,02)+hsscond(i,05)
      gps(i,07)=axbx(i)*gsscond(i,03)+hsscond(i,03)
      gps(i,08)=ayby(i)*gsscond(i,03)+hsscond(i,05)
      gps(i,09)=azbz(i)*gsscond(i,03)+hsscond(i,06)
      gps(i,10)=axbx(i)*gsscond(i,04)+hsscond(i,04)
      gps(i,11)=ayby(i)*gsscond(i,04)+hsscond(i,07)
      gps(i,12)=azbz(i)*gsscond(i,04)+hsscond(i,08)
      gps(i,13)=axbx(i)*gsscond(i,05)+hsscond(i,05)
      gps(i,14)=ayby(i)*gsscond(i,05)+hsscond(i,08)
      gps(i,15)=azbz(i)*gsscond(i,05)+hsscond(i,09)
      gps(i,16)=axbx(i)*gsscond(i,06)+hsscond(i,06)
      gps(i,17)=ayby(i)*gsscond(i,06)+hsscond(i,09)
      gps(i,18)=azbz(i)*gsscond(i,06)+hsscond(i,10)
      gps(i,19)=axbx(i)*gsscond(i,07)+hsscond(i,07)
      gps(i,20)=ayby(i)*gsscond(i,07)+hsscond(i,11)
      gps(i,21)=azbz(i)*gsscond(i,07)+hsscond(i,12)
      gps(i,22)=axbx(i)*gsscond(i,08)+hsscond(i,08)
      gps(i,23)=ayby(i)*gsscond(i,08)+hsscond(i,12)
      gps(i,24)=azbz(i)*gsscond(i,08)+hsscond(i,13)
      gps(i,25)=axbx(i)*gsscond(i,09)+hsscond(i,09)
      gps(i,26)=ayby(i)*gsscond(i,09)+hsscond(i,13)
      gps(i,27)=azbz(i)*gsscond(i,09)+hsscond(i,14)
      gps(i,28)=axbx(i)*gsscond(i,10)+hsscond(i,10)
      gps(i,29)=ayby(i)*gsscond(i,10)+hsscond(i,14)
      gps(i,30)=azbz(i)*gsscond(i,10)+hsscond(i,15)
      gps(i,31)=axbx(i)*gsscond(i,11)+hsscond(i,11)
      gps(i,32)=ayby(i)*gsscond(i,11)+hsscond(i,16)
      gps(i,33)=azbz(i)*gsscond(i,11)+hsscond(i,17)
      gps(i,34)=axbx(i)*gsscond(i,12)+hsscond(i,12)
      gps(i,35)=ayby(i)*gsscond(i,12)+hsscond(i,17)
      gps(i,36)=azbz(i)*gsscond(i,12)+hsscond(i,18)
      gps(i,37)=axbx(i)*gsscond(i,13)+hsscond(i,13)
      gps(i,38)=ayby(i)*gsscond(i,13)+hsscond(i,18)
      gps(i,39)=azbz(i)*gsscond(i,13)+hsscond(i,19)
      gps(i,40)=axbx(i)*gsscond(i,14)+hsscond(i,14)
      gps(i,41)=ayby(i)*gsscond(i,14)+hsscond(i,19)
      gps(i,42)=azbz(i)*gsscond(i,14)+hsscond(i,20)
      gps(i,43)=axbx(i)*gsscond(i,15)+hsscond(i,15)
      gps(i,44)=ayby(i)*gsscond(i,15)+hsscond(i,20)
 2027 gps(i,45)=azbz(i)*gsscond(i,15)+hsscond(i,21)

      do 2028 i=1,m
      fpp(i,01)=axcx(i)*fps(i,01)+gps(i,01)
      fpp(i,02)=aycy(i)*fps(i,01)+gps(i,04)
      fpp(i,03)=azcz(i)*fps(i,01)+gps(i,07)
      fpp(i,04)=axcx(i)*fps(i,02)+gps(i,02)
      fpp(i,05)=aycy(i)*fps(i,02)+gps(i,05)
      fpp(i,06)=azcz(i)*fps(i,02)+gps(i,08)
      fpp(i,07)=axcx(i)*fps(i,03)+gps(i,03)
      fpp(i,08)=aycy(i)*fps(i,03)+gps(i,06)
      fpp(i,09)=azcz(i)*fps(i,03)+gps(i,09)
      fpp(i,10)=axcx(i)*fps(i,04)+gps(i,04)
      fpp(i,11)=aycy(i)*fps(i,04)+gps(i,10)
      fpp(i,12)=azcz(i)*fps(i,04)+gps(i,13)
      fpp(i,13)=axcx(i)*fps(i,05)+gps(i,05)
      fpp(i,14)=aycy(i)*fps(i,05)+gps(i,11)
      fpp(i,15)=azcz(i)*fps(i,05)+gps(i,14)
      fpp(i,16)=axcx(i)*fps(i,06)+gps(i,06)
      fpp(i,17)=aycy(i)*fps(i,06)+gps(i,12)
      fpp(i,18)=azcz(i)*fps(i,06)+gps(i,15)
      fpp(i,19)=axcx(i)*fps(i,07)+gps(i,07)
      fpp(i,20)=aycy(i)*fps(i,07)+gps(i,13)
      fpp(i,21)=azcz(i)*fps(i,07)+gps(i,16)
      fpp(i,22)=axcx(i)*fps(i,08)+gps(i,08)
      fpp(i,23)=aycy(i)*fps(i,08)+gps(i,14)
      fpp(i,24)=azcz(i)*fps(i,08)+gps(i,17)
      fpp(i,25)=axcx(i)*fps(i,09)+gps(i,09)
      fpp(i,26)=aycy(i)*fps(i,09)+gps(i,15)
      fpp(i,27)=azcz(i)*fps(i,09)+gps(i,18)
      fpp(i,28)=axcx(i)*fps(i,10)+gps(i,10)
      fpp(i,29)=aycy(i)*fps(i,10)+gps(i,19)
      fpp(i,30)=azcz(i)*fps(i,10)+gps(i,22)
      fpp(i,31)=axcx(i)*fps(i,11)+gps(i,11)
      fpp(i,32)=aycy(i)*fps(i,11)+gps(i,20)
      fpp(i,33)=azcz(i)*fps(i,11)+gps(i,23)
      fpp(i,34)=axcx(i)*fps(i,12)+gps(i,12)
      fpp(i,35)=aycy(i)*fps(i,12)+gps(i,21)
      fpp(i,36)=azcz(i)*fps(i,12)+gps(i,24)
      fpp(i,37)=axcx(i)*fps(i,13)+gps(i,13)
      fpp(i,38)=aycy(i)*fps(i,13)+gps(i,22)
      fpp(i,39)=azcz(i)*fps(i,13)+gps(i,25)
      fpp(i,40)=axcx(i)*fps(i,14)+gps(i,14)
      fpp(i,41)=aycy(i)*fps(i,14)+gps(i,23)
      fpp(i,42)=azcz(i)*fps(i,14)+gps(i,26)
      fpp(i,43)=axcx(i)*fps(i,15)+gps(i,15)
      fpp(i,44)=aycy(i)*fps(i,15)+gps(i,24)
      fpp(i,45)=azcz(i)*fps(i,15)+gps(i,27)
      fpp(i,46)=axcx(i)*fps(i,16)+gps(i,16)
      fpp(i,47)=aycy(i)*fps(i,16)+gps(i,25)
      fpp(i,48)=azcz(i)*fps(i,16)+gps(i,28)
      fpp(i,49)=axcx(i)*fps(i,17)+gps(i,17)
      fpp(i,50)=aycy(i)*fps(i,17)+gps(i,26)
      fpp(i,51)=azcz(i)*fps(i,17)+gps(i,29)
      fpp(i,52)=axcx(i)*fps(i,18)+gps(i,18)
      fpp(i,53)=aycy(i)*fps(i,18)+gps(i,27)
      fpp(i,54)=azcz(i)*fps(i,18)+gps(i,30)
      fpp(i,55)=axcx(i)*fps(i,19)+gps(i,19)
      fpp(i,56)=aycy(i)*fps(i,19)+gps(i,31)
      fpp(i,57)=azcz(i)*fps(i,19)+gps(i,34)
      fpp(i,58)=axcx(i)*fps(i,20)+gps(i,20)
      fpp(i,59)=aycy(i)*fps(i,20)+gps(i,32)
      fpp(i,60)=azcz(i)*fps(i,20)+gps(i,35)
      fpp(i,61)=axcx(i)*fps(i,21)+gps(i,21)
      fpp(i,62)=aycy(i)*fps(i,21)+gps(i,33)
      fpp(i,63)=azcz(i)*fps(i,21)+gps(i,36)
      fpp(i,64)=axcx(i)*fps(i,22)+gps(i,22)
      fpp(i,65)=aycy(i)*fps(i,22)+gps(i,34)
      fpp(i,66)=azcz(i)*fps(i,22)+gps(i,37)
      fpp(i,67)=axcx(i)*fps(i,23)+gps(i,23)
      fpp(i,68)=aycy(i)*fps(i,23)+gps(i,35)
      fpp(i,69)=azcz(i)*fps(i,23)+gps(i,38)
      fpp(i,70)=axcx(i)*fps(i,24)+gps(i,24)
      fpp(i,71)=aycy(i)*fps(i,24)+gps(i,36)
      fpp(i,72)=azcz(i)*fps(i,24)+gps(i,39)
      fpp(i,73)=axcx(i)*fps(i,25)+gps(i,25)
      fpp(i,74)=aycy(i)*fps(i,25)+gps(i,37)
      fpp(i,75)=azcz(i)*fps(i,25)+gps(i,40)
      fpp(i,76)=axcx(i)*fps(i,26)+gps(i,26)
      fpp(i,77)=aycy(i)*fps(i,26)+gps(i,38)
      fpp(i,78)=azcz(i)*fps(i,26)+gps(i,41)
      fpp(i,79)=axcx(i)*fps(i,27)+gps(i,27)
      fpp(i,80)=aycy(i)*fps(i,27)+gps(i,39)
      fpp(i,81)=azcz(i)*fps(i,27)+gps(i,42)
      fpp(i,82)=axcx(i)*fps(i,28)+gps(i,28)
      fpp(i,83)=aycy(i)*fps(i,28)+gps(i,40)
      fpp(i,84)=azcz(i)*fps(i,28)+gps(i,43)
      fpp(i,85)=axcx(i)*fps(i,29)+gps(i,29)
      fpp(i,86)=aycy(i)*fps(i,29)+gps(i,41)
      fpp(i,87)=azcz(i)*fps(i,29)+gps(i,44)
      fpp(i,88)=axcx(i)*fps(i,30)+gps(i,30)
      fpp(i,89)=aycy(i)*fps(i,30)+gps(i,42)
 2028 fpp(i,90)=azcz(i)*fps(i,30)+gps(i,45)

      do 2029 i=1,m
      dpd(i,001)=axcx(i)*dpp(i,01)+fpp(i,01)
      dpd(i,002)=aycy(i)*dpp(i,01)+fpp(i,10)
      dpd(i,003)=azcz(i)*dpp(i,01)+fpp(i,19)
      dpd(i,004)=aycy(i)*dpp(i,02)+fpp(i,11)
      dpd(i,005)=azcz(i)*dpp(i,02)+fpp(i,20)
      dpd(i,006)=azcz(i)*dpp(i,03)+fpp(i,21)
      dpd(i,007)=axcx(i)*dpp(i,04)+fpp(i,04)
      dpd(i,008)=aycy(i)*dpp(i,04)+fpp(i,13)
      dpd(i,009)=azcz(i)*dpp(i,04)+fpp(i,22)
      dpd(i,010)=aycy(i)*dpp(i,05)+fpp(i,14)
      dpd(i,011)=azcz(i)*dpp(i,05)+fpp(i,23)
      dpd(i,012)=azcz(i)*dpp(i,06)+fpp(i,24)
      dpd(i,013)=axcx(i)*dpp(i,07)+fpp(i,07)
      dpd(i,014)=aycy(i)*dpp(i,07)+fpp(i,16)
      dpd(i,015)=azcz(i)*dpp(i,07)+fpp(i,25)
      dpd(i,016)=aycy(i)*dpp(i,08)+fpp(i,17)
      dpd(i,017)=azcz(i)*dpp(i,08)+fpp(i,26)
      dpd(i,018)=azcz(i)*dpp(i,09)+fpp(i,27)
      dpd(i,019)=axcx(i)*dpp(i,10)+fpp(i,10)
      dpd(i,020)=aycy(i)*dpp(i,10)+fpp(i,28)
      dpd(i,021)=azcz(i)*dpp(i,10)+fpp(i,37)
      dpd(i,022)=aycy(i)*dpp(i,11)+fpp(i,29)
      dpd(i,023)=azcz(i)*dpp(i,11)+fpp(i,38)
      dpd(i,024)=azcz(i)*dpp(i,12)+fpp(i,39)
      dpd(i,025)=axcx(i)*dpp(i,13)+fpp(i,13)
      dpd(i,026)=aycy(i)*dpp(i,13)+fpp(i,31)
      dpd(i,027)=azcz(i)*dpp(i,13)+fpp(i,40)
      dpd(i,028)=aycy(i)*dpp(i,14)+fpp(i,32)
      dpd(i,029)=azcz(i)*dpp(i,14)+fpp(i,41)
      dpd(i,030)=azcz(i)*dpp(i,15)+fpp(i,42)
      dpd(i,031)=axcx(i)*dpp(i,16)+fpp(i,16)
      dpd(i,032)=aycy(i)*dpp(i,16)+fpp(i,34)
      dpd(i,033)=azcz(i)*dpp(i,16)+fpp(i,43)
      dpd(i,034)=aycy(i)*dpp(i,17)+fpp(i,35)
      dpd(i,035)=azcz(i)*dpp(i,17)+fpp(i,44)
      dpd(i,036)=azcz(i)*dpp(i,18)+fpp(i,45)
      dpd(i,037)=axcx(i)*dpp(i,19)+fpp(i,19)
      dpd(i,038)=aycy(i)*dpp(i,19)+fpp(i,37)
      dpd(i,039)=azcz(i)*dpp(i,19)+fpp(i,46)
      dpd(i,040)=aycy(i)*dpp(i,20)+fpp(i,38)
      dpd(i,041)=azcz(i)*dpp(i,20)+fpp(i,47)
      dpd(i,042)=azcz(i)*dpp(i,21)+fpp(i,48)
      dpd(i,043)=axcx(i)*dpp(i,22)+fpp(i,22)
      dpd(i,044)=aycy(i)*dpp(i,22)+fpp(i,40)
      dpd(i,045)=azcz(i)*dpp(i,22)+fpp(i,49)
      dpd(i,046)=aycy(i)*dpp(i,23)+fpp(i,41)
      dpd(i,047)=azcz(i)*dpp(i,23)+fpp(i,50)
      dpd(i,048)=azcz(i)*dpp(i,24)+fpp(i,51)
      dpd(i,049)=axcx(i)*dpp(i,25)+fpp(i,25)
      dpd(i,050)=aycy(i)*dpp(i,25)+fpp(i,43)
      dpd(i,051)=azcz(i)*dpp(i,25)+fpp(i,52)
      dpd(i,052)=aycy(i)*dpp(i,26)+fpp(i,44)
      dpd(i,053)=azcz(i)*dpp(i,26)+fpp(i,53)
      dpd(i,054)=azcz(i)*dpp(i,27)+fpp(i,54)
      dpd(i,055)=axcx(i)*dpp(i,28)+fpp(i,28)
      dpd(i,056)=aycy(i)*dpp(i,28)+fpp(i,55)
      dpd(i,057)=azcz(i)*dpp(i,28)+fpp(i,64)
      dpd(i,058)=aycy(i)*dpp(i,29)+fpp(i,56)
      dpd(i,059)=azcz(i)*dpp(i,29)+fpp(i,65)
      dpd(i,060)=azcz(i)*dpp(i,30)+fpp(i,66)
      dpd(i,061)=axcx(i)*dpp(i,31)+fpp(i,31)
      dpd(i,062)=aycy(i)*dpp(i,31)+fpp(i,58)
      dpd(i,063)=azcz(i)*dpp(i,31)+fpp(i,67)
      dpd(i,064)=aycy(i)*dpp(i,32)+fpp(i,59)
      dpd(i,065)=azcz(i)*dpp(i,32)+fpp(i,68)
      dpd(i,066)=azcz(i)*dpp(i,33)+fpp(i,69)
      dpd(i,067)=axcx(i)*dpp(i,34)+fpp(i,34)
      dpd(i,068)=aycy(i)*dpp(i,34)+fpp(i,61)
      dpd(i,069)=azcz(i)*dpp(i,34)+fpp(i,70)
      dpd(i,070)=aycy(i)*dpp(i,35)+fpp(i,62)
      dpd(i,071)=azcz(i)*dpp(i,35)+fpp(i,71)
      dpd(i,072)=azcz(i)*dpp(i,36)+fpp(i,72)
      dpd(i,073)=axcx(i)*dpp(i,37)+fpp(i,37)
      dpd(i,074)=aycy(i)*dpp(i,37)+fpp(i,64)
      dpd(i,075)=azcz(i)*dpp(i,37)+fpp(i,73)
      dpd(i,076)=aycy(i)*dpp(i,38)+fpp(i,65)
      dpd(i,077)=azcz(i)*dpp(i,38)+fpp(i,74)
      dpd(i,078)=azcz(i)*dpp(i,39)+fpp(i,75)
      dpd(i,079)=axcx(i)*dpp(i,40)+fpp(i,40)
      dpd(i,080)=aycy(i)*dpp(i,40)+fpp(i,67)
      dpd(i,081)=azcz(i)*dpp(i,40)+fpp(i,76)
      dpd(i,082)=aycy(i)*dpp(i,41)+fpp(i,68)
      dpd(i,083)=azcz(i)*dpp(i,41)+fpp(i,77)
      dpd(i,084)=azcz(i)*dpp(i,42)+fpp(i,78)
      dpd(i,085)=axcx(i)*dpp(i,43)+fpp(i,43)
      dpd(i,086)=aycy(i)*dpp(i,43)+fpp(i,70)
      dpd(i,087)=azcz(i)*dpp(i,43)+fpp(i,79)
      dpd(i,088)=aycy(i)*dpp(i,44)+fpp(i,71)
      dpd(i,089)=azcz(i)*dpp(i,44)+fpp(i,80)
      dpd(i,090)=azcz(i)*dpp(i,45)+fpp(i,81)
      dpd(i,091)=axcx(i)*dpp(i,46)+fpp(i,46)
      dpd(i,092)=aycy(i)*dpp(i,46)+fpp(i,73)
      dpd(i,093)=azcz(i)*dpp(i,46)+fpp(i,82)
      dpd(i,094)=aycy(i)*dpp(i,47)+fpp(i,74)
      dpd(i,095)=azcz(i)*dpp(i,47)+fpp(i,83)
      dpd(i,096)=azcz(i)*dpp(i,48)+fpp(i,84)
      dpd(i,097)=axcx(i)*dpp(i,49)+fpp(i,49)
      dpd(i,098)=aycy(i)*dpp(i,49)+fpp(i,76)
      dpd(i,099)=azcz(i)*dpp(i,49)+fpp(i,85)
      dpd(i,100)=aycy(i)*dpp(i,50)+fpp(i,77)
      dpd(i,101)=azcz(i)*dpp(i,50)+fpp(i,86)
      dpd(i,102)=azcz(i)*dpp(i,51)+fpp(i,87)
      dpd(i,103)=axcx(i)*dpp(i,52)+fpp(i,52)
      dpd(i,104)=aycy(i)*dpp(i,52)+fpp(i,79)
      dpd(i,105)=azcz(i)*dpp(i,52)+fpp(i,88)
      dpd(i,106)=aycy(i)*dpp(i,53)+fpp(i,80)
      dpd(i,107)=azcz(i)*dpp(i,53)+fpp(i,89)
 2029 dpd(i,108)=azcz(i)*dpp(i,54)+fpp(i,90)

      do 2030 j=1,18
      do 2030 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dps(i,j)*xcft1s
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dps(i,j)*xcft2s
 2030 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dps(i,j)*xcft3s

      do 2031 k=1,3
      do 2031 j=1,18
      do 2031 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dpp(i,3*(j-1)+k)*xcft1p(k)
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dpp(i,3*(j-1)+k)*xcft2p(k)
 2031 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dpp(i,3*(j-1)+k)*xcft3p(k)

      do 2032 k=1,6
      do 2032 j=1,18
      do 2032 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dpd(i,6*(j-1)+k)*xcft1d(k)
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dpd(i,6*(j-1)+k)*xcft2d(k)
 2032 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dpd(i,6*(j-1)+k)*xcft3d(k)

 2001 continue

      do 3001 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))/sqrt3
      fock1(inddyy(i,02))=fock1(inddyy(i,02))/sqrt3
      fock1(inddyy(i,03))=fock1(inddyy(i,03))/sqrt3
      fock1(inddyy(i,10))=fock1(inddyy(i,10))/sqrt3
      fock1(inddyy(i,11))=fock1(inddyy(i,11))/sqrt3
      fock1(inddyy(i,12))=fock1(inddyy(i,12))/sqrt3
      fock1(inddyy(i,16))=fock1(inddyy(i,16))/sqrt3
      fock1(inddyy(i,17))=fock1(inddyy(i,17))/sqrt3
      fock1(inddyy(i,18))=fock1(inddyy(i,18))/sqrt3

      fock2(inddyy(i,01))=fock2(inddyy(i,01))/sqrt3
      fock2(inddyy(i,02))=fock2(inddyy(i,02))/sqrt3
      fock2(inddyy(i,03))=fock2(inddyy(i,03))/sqrt3
      fock2(inddyy(i,10))=fock2(inddyy(i,10))/sqrt3
      fock2(inddyy(i,11))=fock2(inddyy(i,11))/sqrt3
      fock2(inddyy(i,12))=fock2(inddyy(i,12))/sqrt3
      fock2(inddyy(i,16))=fock2(inddyy(i,16))/sqrt3
      fock2(inddyy(i,17))=fock2(inddyy(i,17))/sqrt3
      fock2(inddyy(i,18))=fock2(inddyy(i,18))/sqrt3

      fock3(inddyy(i,01))=fock3(inddyy(i,01))/sqrt3
      fock3(inddyy(i,02))=fock3(inddyy(i,02))/sqrt3
      fock3(inddyy(i,03))=fock3(inddyy(i,03))/sqrt3
      fock3(inddyy(i,10))=fock3(inddyy(i,10))/sqrt3
      fock3(inddyy(i,11))=fock3(inddyy(i,11))/sqrt3
      fock3(inddyy(i,12))=fock3(inddyy(i,12))/sqrt3
      fock3(inddyy(i,16))=fock3(inddyy(i,16))/sqrt3
      fock3(inddyy(i,17))=fock3(inddyy(i,17))/sqrt3
      fock3(inddyy(i,18))=fock3(inddyy(i,18))/sqrt3

 3001 continue

      return
      end
