      subroutine xcords(m,n,nxcs,nxcspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,coord,xcfit1,xcfit2,xcfit3,alphaaux,
     &                  coeffs,coeffp,coeffd,fock1,fock2,fock3,zeta,ax,
     &                  ay,az,px,py,pz,base,zetarec,zetafac,efac,gxax,
     &                  gyay,gzaz,sss,pss,dss,dsscond,fss,fsscond,gss,
     &                  gsscond,dsp,fsp,dsd,c,c1,c2,zzeta,aax,aay,aaz,
     &                  ppx,ppy,ppz,axcx,aycy,azcz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcft1p(3),xcft2p(3),xcft3p(3),
     &          xcft1d(6),xcft2d(6),xcft3d(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(m,*)

      dimension coord(3,*),xcfit1(*),xcfit2(*),xcfit3(*),alphaaux(*),
     &          coeffs(*),coeffp(*),coeffd(*),fock1(*),fock2(*),
     &          fock3(*),zeta(*),ax(*),ay(*),az(*),px(*),py(*),pz(*),
     &          base(*),zetarec(*),zetafac(*),efac(*),gxax(*),gyay(*),
     &          gzaz(*),sss(*),pss(n,*),dss(n,*),dsscond(m,*),fss(n,*),
     &          fsscond(m,*),gss(n,*),gsscond(m,*),dsp(m,*),fsp(m,*),
     &          dsd(m,*),c(*),c1(n,*),c2(n,*),zzeta(*),aax(*),aay(*),
     &          aaz(*),ppx(*),ppy(*),ppz(*),axcx(*),aycy(*),azcz(*)

      data zero,one,two,three/0.0,1.0,2.0,3.0/
      data expcut,calcut/80.0,1.0e-16/

      sqrt3=sqrt(three)

      do 1001 naux=1,nxcs

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(naux)*coeffs(ilaux)
      xcft2s=xcfit2(naux)*coeffs(ilaux)
      xcft3s=xcfit3(naux)*coeffs(ilaux)

      do 1002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      sss(i)=zero
 1004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 1005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 1005 continue

      do 1006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 1006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 1007 i=1,nn
 1007 zetarec(i)=zetarec(i)/two

      do 1008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 1008 pss(i,3)=gzaz(i)*sss(i)

      do 1009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 1009 continue

      do 1010 j=1,6
      do 1010 i=1,m
 1010 dsscond(i,j)=zero

      do 1011 j=1,6
      do 1011 i=1,nn
 1011 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 1012 j=1,6
      do 1012 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dsscond(i,j)*xcft1s
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dsscond(i,j)*xcft2s
 1012 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dsscond(i,j)*xcft3s

 1001 continue

      do 2001 naux=1,nxcspd

      ilaux=ilfunc(nxcs+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft2s=xcfit2(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft3s=xcfit3(nxcs+(naux-1)*10+1)*coeffs(ilaux)

      xcft1p(1)=xcfit1(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft1p(2)=xcfit1(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft1p(3)=xcfit1(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft2p(1)=xcfit2(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft2p(2)=xcfit2(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft2p(3)=xcfit2(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft3p(1)=xcfit3(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft3p(2)=xcfit3(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft3p(3)=xcfit3(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft1d(1)=xcfit1(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft1d(2)=xcfit1(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft1d(3)=xcfit1(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft1d(4)=xcfit1(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft1d(5)=xcfit1(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft1d(6)=xcfit1(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft2d(1)=xcfit2(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft2d(2)=xcfit2(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft2d(3)=xcfit2(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft2d(4)=xcfit2(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft2d(5)=xcfit2(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft2d(6)=xcfit2(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft3d(1)=xcfit3(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft3d(2)=xcfit3(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft3d(3)=xcfit3(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft3d(4)=xcfit3(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft3d(5)=xcfit3(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft3d(6)=xcfit3(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      do 2002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n

      axcx(icontr(i))=ax(i)-ccx
      aycy(icontr(i))=ay(i)-ccy
      azcz(icontr(i))=az(i)-ccz

      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz

 2003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      sss(i)=zero
 2004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 2005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 2005 continue

      do 2006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 2006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 2007 i=1,nn
 2007 zetarec(i)=zetarec(i)/two

      do 2008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 2008 pss(i,3)=gzaz(i)*sss(i)

      do 2009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 2009 continue

      do 2010 j=1,3
      do 2010 i=1,nn
 2010 c1(i,j)=zetarec(i)*pss(i,j)

      do 2011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)+c1(i,1)
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)+c1(i,2)
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 2011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)+c1(i,3)

      do 2012 j=1,6
      do 2012 i=1,nn
 2012 c2(i,j)=zetarec(i)*dss(i,j)

      do 2013 i=1,nn
      gss(i,01)=gxax(i)*fss(i,01)+c2(i,1)*three
      gss(i,02)=gyay(i)*fss(i,01)
      gss(i,03)=gzaz(i)*fss(i,01)
      gss(i,04)=gyay(i)*fss(i,02)+c2(i,1)
      gss(i,05)=gzaz(i)*fss(i,02)
      gss(i,06)=gzaz(i)*fss(i,03)+c2(i,1)
      gss(i,07)=gyay(i)*fss(i,04)+c2(i,2)*two
      gss(i,08)=gzaz(i)*fss(i,04)
      gss(i,09)=gzaz(i)*fss(i,05)+c2(i,2)
      gss(i,10)=gzaz(i)*fss(i,06)+c2(i,3)*two
      gss(i,11)=gyay(i)*fss(i,07)+c2(i,4)*three
      gss(i,12)=gzaz(i)*fss(i,07)
      gss(i,13)=gzaz(i)*fss(i,08)+c2(i,4)
      gss(i,14)=gzaz(i)*fss(i,09)+c2(i,5)*two
 2013 gss(i,15)=gzaz(i)*fss(i,10)+c2(i,6)*three

      do 2014 j=1,6
      do 2014 i=1,m
 2014 dsscond(i,j)=zero

      do 2015 j=1,10
      do 2015 i=1,m
 2015 fsscond(i,j)=zero

      do 2016 j=1,15
      do 2016 i=1,m
 2016 gsscond(i,j)=zero

      do 2017 j=1,6
      do 2017 i=1,nn
 2017 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 2018 j=1,10
      do 2018 i=1,nn
 2018 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss(i,j)

      do 2019 j=1,15
      do 2019 i=1,nn
 2019 gsscond(iicontr(i),j)=gsscond(iicontr(i),j)+gss(i,j)

      do 2020 i=1,m
      dsp(i,01)=axcx(i)*dsscond(i,1)+fsscond(i,01)
      dsp(i,02)=aycy(i)*dsscond(i,1)+fsscond(i,02)
      dsp(i,03)=azcz(i)*dsscond(i,1)+fsscond(i,03)
      dsp(i,04)=axcx(i)*dsscond(i,2)+fsscond(i,02)
      dsp(i,05)=aycy(i)*dsscond(i,2)+fsscond(i,04)
      dsp(i,06)=azcz(i)*dsscond(i,2)+fsscond(i,05)
      dsp(i,07)=axcx(i)*dsscond(i,3)+fsscond(i,03)
      dsp(i,08)=aycy(i)*dsscond(i,3)+fsscond(i,05)
      dsp(i,09)=azcz(i)*dsscond(i,3)+fsscond(i,06)
      dsp(i,10)=axcx(i)*dsscond(i,4)+fsscond(i,04)
      dsp(i,11)=aycy(i)*dsscond(i,4)+fsscond(i,07)
      dsp(i,12)=azcz(i)*dsscond(i,4)+fsscond(i,08)
      dsp(i,13)=axcx(i)*dsscond(i,5)+fsscond(i,05)
      dsp(i,14)=aycy(i)*dsscond(i,5)+fsscond(i,08)
      dsp(i,15)=azcz(i)*dsscond(i,5)+fsscond(i,09)
      dsp(i,16)=axcx(i)*dsscond(i,6)+fsscond(i,06)
      dsp(i,17)=aycy(i)*dsscond(i,6)+fsscond(i,09)
 2020 dsp(i,18)=azcz(i)*dsscond(i,6)+fsscond(i,10)

      do 2021 i=1,m
      fsp(i,01)=axcx(i)*fsscond(i,01)+gsscond(i,01)
      fsp(i,02)=aycy(i)*fsscond(i,01)+gsscond(i,02)
      fsp(i,03)=azcz(i)*fsscond(i,01)+gsscond(i,03)
      fsp(i,04)=axcx(i)*fsscond(i,02)+gsscond(i,02)
      fsp(i,05)=aycy(i)*fsscond(i,02)+gsscond(i,04)
      fsp(i,06)=azcz(i)*fsscond(i,02)+gsscond(i,05)
      fsp(i,07)=axcx(i)*fsscond(i,03)+gsscond(i,03)
      fsp(i,08)=aycy(i)*fsscond(i,03)+gsscond(i,05)
      fsp(i,09)=azcz(i)*fsscond(i,03)+gsscond(i,06)
      fsp(i,10)=axcx(i)*fsscond(i,04)+gsscond(i,04)
      fsp(i,11)=aycy(i)*fsscond(i,04)+gsscond(i,07)
      fsp(i,12)=azcz(i)*fsscond(i,04)+gsscond(i,08)
      fsp(i,13)=axcx(i)*fsscond(i,05)+gsscond(i,05)
      fsp(i,14)=aycy(i)*fsscond(i,05)+gsscond(i,08)
      fsp(i,15)=azcz(i)*fsscond(i,05)+gsscond(i,09)
      fsp(i,16)=axcx(i)*fsscond(i,06)+gsscond(i,06)
      fsp(i,17)=aycy(i)*fsscond(i,06)+gsscond(i,09)
      fsp(i,18)=azcz(i)*fsscond(i,06)+gsscond(i,10)
      fsp(i,19)=axcx(i)*fsscond(i,07)+gsscond(i,07)
      fsp(i,20)=aycy(i)*fsscond(i,07)+gsscond(i,11)
      fsp(i,21)=azcz(i)*fsscond(i,07)+gsscond(i,12)
      fsp(i,22)=axcx(i)*fsscond(i,08)+gsscond(i,08)
      fsp(i,23)=aycy(i)*fsscond(i,08)+gsscond(i,12)
      fsp(i,24)=azcz(i)*fsscond(i,08)+gsscond(i,13)
      fsp(i,25)=axcx(i)*fsscond(i,09)+gsscond(i,09)
      fsp(i,26)=aycy(i)*fsscond(i,09)+gsscond(i,13)
      fsp(i,27)=azcz(i)*fsscond(i,09)+gsscond(i,14)
      fsp(i,28)=axcx(i)*fsscond(i,10)+gsscond(i,10)
      fsp(i,29)=aycy(i)*fsscond(i,10)+gsscond(i,14)
 2021 fsp(i,30)=azcz(i)*fsscond(i,10)+gsscond(i,15)

      do 2022 i=1,m
      dsd(i,01)=axcx(i)*dsp(i,01)+fsp(i,01)
      dsd(i,02)=aycy(i)*dsp(i,01)+fsp(i,04)
      dsd(i,03)=azcz(i)*dsp(i,01)+fsp(i,07)
      dsd(i,04)=aycy(i)*dsp(i,02)+fsp(i,05)
      dsd(i,05)=azcz(i)*dsp(i,02)+fsp(i,08)
      dsd(i,06)=azcz(i)*dsp(i,03)+fsp(i,09)
      dsd(i,07)=axcx(i)*dsp(i,04)+fsp(i,04)
      dsd(i,08)=aycy(i)*dsp(i,04)+fsp(i,10)
      dsd(i,09)=azcz(i)*dsp(i,04)+fsp(i,13)
      dsd(i,10)=aycy(i)*dsp(i,05)+fsp(i,11)
      dsd(i,11)=azcz(i)*dsp(i,05)+fsp(i,14)
      dsd(i,12)=azcz(i)*dsp(i,06)+fsp(i,15)
      dsd(i,13)=axcx(i)*dsp(i,07)+fsp(i,07)
      dsd(i,14)=aycy(i)*dsp(i,07)+fsp(i,13)
      dsd(i,15)=azcz(i)*dsp(i,07)+fsp(i,16)
      dsd(i,16)=aycy(i)*dsp(i,08)+fsp(i,14)
      dsd(i,17)=azcz(i)*dsp(i,08)+fsp(i,17)
      dsd(i,18)=azcz(i)*dsp(i,09)+fsp(i,18)
      dsd(i,19)=axcx(i)*dsp(i,10)+fsp(i,10)
      dsd(i,20)=aycy(i)*dsp(i,10)+fsp(i,19)
      dsd(i,21)=azcz(i)*dsp(i,10)+fsp(i,22)
      dsd(i,22)=aycy(i)*dsp(i,11)+fsp(i,20)
      dsd(i,23)=azcz(i)*dsp(i,11)+fsp(i,23)
      dsd(i,24)=azcz(i)*dsp(i,12)+fsp(i,24)
      dsd(i,25)=axcx(i)*dsp(i,13)+fsp(i,13)
      dsd(i,26)=aycy(i)*dsp(i,13)+fsp(i,22)
      dsd(i,27)=azcz(i)*dsp(i,13)+fsp(i,25)
      dsd(i,28)=aycy(i)*dsp(i,14)+fsp(i,23)
      dsd(i,29)=azcz(i)*dsp(i,14)+fsp(i,26)
      dsd(i,30)=azcz(i)*dsp(i,15)+fsp(i,27)
      dsd(i,31)=axcx(i)*dsp(i,16)+fsp(i,16)
      dsd(i,32)=aycy(i)*dsp(i,16)+fsp(i,25)
      dsd(i,33)=azcz(i)*dsp(i,16)+fsp(i,28)
      dsd(i,34)=aycy(i)*dsp(i,17)+fsp(i,26)
      dsd(i,35)=azcz(i)*dsp(i,17)+fsp(i,29)
 2022 dsd(i,36)=azcz(i)*dsp(i,18)+fsp(i,30)

      do 2023 j=1,6
      do 2023 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dsscond(i,j)*xcft1s
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dsscond(i,j)*xcft2s
 2023 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dsscond(i,j)*xcft3s

      do 2024 k=1,3
      do 2024 j=1,6
      do 2024 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dsp(i,3*(j-1)+k)*xcft1p(k)
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dsp(i,3*(j-1)+k)*xcft2p(k)
 2024 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dsp(i,3*(j-1)+k)*xcft3p(k)

      do 2025 k=1,6
      do 2025 j=1,6
      do 2025 i=1,m
      fock1(inddyy(i,j))=fock1(inddyy(i,j))+dsd(i,6*(j-1)+k)*xcft1d(k)
      fock2(inddyy(i,j))=fock2(inddyy(i,j))+dsd(i,6*(j-1)+k)*xcft2d(k)
 2025 fock3(inddyy(i,j))=fock3(inddyy(i,j))+dsd(i,6*(j-1)+k)*xcft3d(k)

 2001 continue

      do 3001 i=1,m

      fock1(inddyy(i,1))=fock1(inddyy(i,1))/sqrt3
      fock1(inddyy(i,4))=fock1(inddyy(i,4))/sqrt3
      fock1(inddyy(i,6))=fock1(inddyy(i,6))/sqrt3

      fock2(inddyy(i,1))=fock2(inddyy(i,1))/sqrt3
      fock2(inddyy(i,4))=fock2(inddyy(i,4))/sqrt3
      fock2(inddyy(i,6))=fock2(inddyy(i,6))/sqrt3

      fock3(inddyy(i,1))=fock3(inddyy(i,1))/sqrt3
      fock3(inddyy(i,4))=fock3(inddyy(i,4))/sqrt3
      fock3(inddyy(i,6))=fock3(inddyy(i,6))/sqrt3

 3001 continue

      return
      end
