      subroutine baker(istep,imode,nint,ndim,dmt,dmt1,dmt2,xd,gd,f,
     &                 vec1,vec2,vec3,vec4,vec5,h,g1,g2,c1,c2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension dmt(nint,*),dmt1(nint,*),dmt2(nint,*),xd(*),gd(*),
     &          f(*),vec1(*),vec2(*),vec3(*),vec4(*),vec5(*)

      dimension h(ndim,*),g1(*),g2(*),c1(*),c2(*)

      dimension simvec(1000)

      data zero,half,four,cmpmax,eigmin/0.0,0.5,4.0,0.05,0.02/

      save simvec

      if(istep.ne.1) then
                           do 1001 i=1,nint
                           gd(i)=g2(i)-g1(i)
 1001                      xd(i)=c2(i)-c1(i)

                           do 1002 j=1,nint
                           do 1002 i=1,nint
 1002                      gd(i)=gd(i)-h(i,j)*xd(j)

                           gdotx=zero
                           xdotx=zero

                           do 1003 i=1,nint
                           gdotx=gdotx+gd(i)*xd(i)
 1003                      xdotx=xdotx+xd(i)*xd(i)

                           do 1004 j=1,nint
                           do 1004 i=1,nint
 1004                      h(i,j)=h(i,j)+gd(i)*xd(j)/xdotx

                           do 1005 j=1,nint
                           do 1005 i=1,nint
 1005                      h(i,j)=h(i,j)+xd(i)*gd(j)/xdotx

                           do 1006 j=1,nint
                           do 1006 i=1,nint
 1006                      dmt1(i,j)=xd(i)*xd(j)*(gdotx/xdotx)

                           do 1007 j=1,nint
                           do 1007 i=1,nint
 1007                      h(i,j)=h(i,j)-dmt1(i,j)/xdotx
                     endif

      do 1008 j=1,nint
      do 1008 i=1,nint
 1008 dmt1(i,j)=h(i,j)

      call tred2(nint,nint,dmt1,vec1,vec2,vec3,dmt)
      call tql2(nint,nint,vec1,vec2,dmt,vec3,vec4,ierr)

      if(istep.ne.1) then
                           dotmax=zero
                           imode=0
                           do 1009 i=1,nint
                           dotprd=zero
                           do 1010 j=1,nint
 1010                      dotprd=dotprd+abs(dmt(j,i)*simvec(j))
                           if(dotprd.gt.dotmax) imode=i
                           if(dotprd.gt.dotmax) dotmax=dotprd
 1009                      continue
                           if(imode.le.0) stop 'mode following failed'
                     endif

      do 1011 i=1,nint
 1011 simvec(i)=dmt(i,imode)

      do 1012 i=1,nint
      f(i)=zero
      do 1012 j=1,nint
 1012 f(i)=f(i)+dmt(j,i)*g2(j)

      do 1013 i=1,nint
      if(i.ne.imode) vec1(i)=max(vec1(i),+eigmin)
      if(i.eq.imode) vec1(i)=min(vec1(i),-eigmin)
 1013 continue

      eigp=half*vec1(imode)
     &    +half*sqrt((vec1(imode)**2)+four*(f(imode)**2))

      do 1014 j=1,nint
      do 1014 i=1,nint
 1014 dmt1(i,j)=zero

      m=0

      do 1015 i=1,nint
      if(i.ne.imode) then
                           m=m+1
                           dmt1(m,m)=vec1(i)
                           dmt1(m,nint)=f(i)
                           dmt1(nint,m)=f(i)
                     endif
 1015 continue

      call tred2(nint,nint,dmt1,vec5,vec2,vec3,dmt2)
      call tql2(nint,nint,vec5,vec2,dmt2,vec3,vec4,ierr)

      eign=vec5(1)

      do 1016 i=1,nint
 1016 vec2(i)=zero

      do 1017 i=1,nint
      if(i.eq.imode) eigval=eigp
      if(i.ne.imode) eigval=eign
      do 1017 j=1,nint
 1017 vec2(j)=vec2(j)-f(i)*dmt(j,i)/(vec1(i)-eigval)

      do 1018 i=1,nint
 1018 if(abs(vec2(i)).gt.cmpmax) vec2(i)=cmpmax*vec2(i)/abs(vec2(i))

      do 1019 i=1,nint
 1019 c2(i)=c2(i)+vec2(i)

      return
      end
