      subroutine cdftss(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,g,coord,alphaaux,coeffs,coeffp,coeffd,
     &                  tvec,dmat,zeta,px,py,pz,base,u,zetarec,wxcx,
     &                  wycy,wzcz,sss,sss0,sss1,sss2,ssp,ssp0,ssp1,ssd,
     &                  ssd0,zetac,c,zzeta,ppx,ppy,ppz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(*)

      dimension g(*),coord(3,*),alphaaux(*),coeffs(*),coeffp(*),
     &          coeffd(*),tvec(*),dmat(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),sss(*),
     &          sss0(*),sss1(*),sss2(*),ssp(m,*),ssp0(n,*),ssp1(n,*),
     &          ssd(m,*),ssd0(n,*),zetac(*),c(*),zzeta(*),ppx(*),ppy(*),
     &          ppz(*)

      data one,two,three,five,seven/1.0,2.0,3.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(1,u(i),g)
 1004 sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux

      do 1005 i=1,m
 1005 sss(i)=zero

      do 1006 i=1,n
 1006 sss(icontr(i))=sss(icontr(i))+sss0(i)

      do 1007 i=1,m
 1007 tvec(naux)=tvec(naux)+dmat(inddyy(i))*sss(i)*cdfits

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      cdfitp(1)=coeffp(ilaux)
      cdfitp(2)=coeffp(ilaux)
      cdfitp(3)=coeffp(ilaux)

      cdfitd(1)=coeffd(ilaux)/dnormcd
      cdfitd(2)=coeffd(ilaux)
      cdfitd(3)=coeffd(ilaux)
      cdfitd(4)=coeffd(ilaux)/dnormcd
      cdfitd(5)=coeffd(ilaux)
      cdfitd(6)=coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      call augg(3,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
 2004 sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux

      nn=0

      do 2005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                 endif

 2005 continue

      do 2006 i=1,nn
 2006 zetac(i)=zzeta(i)*zetarec(i)

      do 2007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2008 i=1,nn

      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
      ssp0(i,3)=wzcz(i)*sss1(i)

      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
      ssp1(i,3)=wzcz(i)*sss2(i)

 2008 continue

      do 2009 i=1,nn

      c(i)=(sss0(i)-zetac(i)*sss1(i))/(two*zetaux)

      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
      ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

 2009 continue

      do 2010 i=1,m
 2010 sss(i)=zero

      do 2011 j=1,3
      do 2011 i=1,m
 2011 ssp(i,j)=zero

      do 2012 j=1,6
      do 2012 i=1,m
 2012 ssd(i,j)=zero

      do 2013 i=1,nn
 2013 sss(iicontr(i))=sss(iicontr(i))+sss0(i)

      do 2014 j=1,3
      do 2014 i=1,nn
 2014 ssp(iicontr(i),j)=ssp(iicontr(i),j)+ssp0(i,j)

      do 2015 j=1,6
      do 2015 i=1,nn
 2015 ssd(iicontr(i),j)=ssd(iicontr(i),j)+ssd0(i,j)

      nc=ncds+(naux-1)*10

      do 2016 i=1,m
 2016 tvec(nc+1)=tvec(nc+1)+dmat(inddyy(i))*sss(i)*cdfits

      nc=ncds+(naux-1)*10+1

      do 2017 j=1,3
      do 2017 i=1,m
 2017 tvec(nc+j)=tvec(nc+j)+dmat(inddyy(i))*ssp(i,j)*cdfitp(j)

      nc=ncds+(naux-1)*10+4

      do 2018 j=1,6
      do 2018 i=1,m
 2018 tvec(nc+j)=tvec(nc+j)+dmat(inddyy(i))*ssd(i,j)*cdfitd(j)

 2001 continue

      return
      end
