      program main

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      parameter(nreal=4444444,ninteger=1666666,natoms=50,nmaxpts=2968,
     &          ncontractions=400,nauxiliary=700,nprimitives=10000,
     &          ncontacts=50000)

      parameter(nptcharges=1000*natoms,
     &          ndegfreedom=3*natoms,nesppts=1000*natoms,
     &          nfockdim=ncontractions*(ncontractions+1)/2)

      character input(natoms,2)*30,atomsymbol(natoms)*4

      common/ci/iwkvec(ninteger),nptsatom(natoms),natomtype(natoms),
     &          izmat1(natoms),izmat2(natoms),izmat3(natoms),
     &          nequivvec(natoms,2),intfreeze(ndegfreedom),
     &          nfuncatom(ncontractions),ilfunc(ncontractions),
     &          icfunc(ncontractions),mtloca(ncontractions),
     &          ngaussians(ncontractions),nshels(ncontractions),
     &          nshelp(ncontractions),nsheld(ncontractions),
     &          icdlfunc(nauxiliary),icdcfunc(nauxiliary),
     &          ixclfunc(nauxiliary),ixccfunc(nauxiliary)

      common/cr/wkvec(nreal),coord(3,natoms),coordsave(3,natoms),
     &          charge(natoms),coordptcharge(3,nptcharges),
     &          ptcharge(nptcharges),grad(3,natoms),gradsave(3,natoms),
     &          coord1(ndegfreedom),coord2(ndegfreedom),
     &          grad1(ndegfreedom),grad2(ndegfreedom),
     &          hessian(ndegfreedom,ndegfreedom),
     &          djacobian(ndegfreedom,ndegfreedom),
     &          coeffa(ncontractions,ncontractions),
     &          coeffb(ncontractions,ncontractions),
     &          overlap(ncontractions,ncontractions),
     &          orbnrga(ncontractions),orbnrgb(ncontractions),
     &          dmata(nfockdim),dmatb(nfockdim),core(nfockdim),
     &          focka(nfockdim),fockb(nfockdim),focke(nfockdim),
     &          alpha(nprimitives),coeff(nprimitives),
     &          auxoverlap(nauxiliary,nauxiliary),
     &          alphacd(nauxiliary),coefscd(nauxiliary),
     &          coefpcd(nauxiliary),coefdcd(nauxiliary),
     &          alphaxc(nauxiliary),coefsxc(nauxiliary),
     &          coefpxc(nauxiliary),coefdxc(nauxiliary),
     &          cdfitc(nauxiliary),xcfita(nauxiliary),
     &          xcfitb(nauxiliary),xcfite(nauxiliary),
     &          xcfitsave(nauxiliary),tvector(nauxiliary),
     &          tveca(nauxiliary),tvecb(nauxiliary),
     &          tvece(nauxiliary)

      call deft(nreal,ninteger,natoms,ncontractions,nfockdim,nauxiliary,
     &          nmaxpts,nesppts,ncontacts,ndegfreedom,iwkvec,nptsatom,
     &          natomtype,izmat1,izmat2,izmat3,nequivvec,intfreeze,
     &          nfuncatom,ilfunc,icfunc,mtloca,ngaussians,nshels,nshelp,
     &          nsheld,icdlfunc,icdcfunc,ixclfunc,ixccfunc,wkvec,coord,
     &          coordsave,charge,coordptcharge,ptcharge,grad,gradsave,
     &          coord1,coord2,grad1,grad2,hessian,djacobian,coeffa,
     &          coeffb,overlap,orbnrga,orbnrgb,dmata,dmatb,core,focka,
     &          fockb,focke,alpha,coeff,auxoverlap,alphacd,coefscd,
     &          coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,coefdxc,cdfitc,
     &          xcfita,xcfitb,xcfite,xcfitsave,tvector,tveca,tvecb,
     &          tvece,input,atomsymbol)

      stop 'normal'
      end
