      subroutine rijmat(n,label,cent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ival(6)

      dimension rval(6)

      character label(*)*4

      dimension cent(3,*)

      data small,six,bohr/0.01,6.0,0.529177/

      write(6,1001)
 1001 format(/,' distance matrix in angstroms : ',/)

      nblocks=int((real64(n)-small)/six)+1

      do 1002 i=1,nblocks
      do 1002 j=1,nblocks

      ii=max(1,(6*i-5))
      if=min(n,(6*i-0))

      ji=max(1,(6*j-5))
      jf=min(n,(6*j-0))

      nentries=min(6,(jf-ji+1))

      ival(1)=ji+0
      ival(2)=ji+1
      ival(3)=ji+2
      ival(4)=ji+3
      ival(5)=ji+4
      ival(6)=ji+5

      write(6,1003) (ival(l),label(ival(l)),l=1,nentries)
 1003 format(11x,6(2x,i4,1x,a4))

      write(6,1004)

      do 1005 k=0,5

      if((ii+k).gt.if) goto 1005

      rval(1)=dist(cent(1,ii+k),cent(1,ji+0))*bohr
      rval(2)=dist(cent(1,ii+k),cent(1,ji+1))*bohr
      rval(3)=dist(cent(1,ii+k),cent(1,ji+2))*bohr
      rval(4)=dist(cent(1,ii+k),cent(1,ji+3))*bohr
      rval(5)=dist(cent(1,ii+k),cent(1,ji+4))*bohr
      rval(6)=dist(cent(1,ii+k),cent(1,ji+5))*bohr

      write(6,1006) ii+k,label(ii+k),(rval(l),l=1,nentries)
 1006 format(2x,i4,1x,a4,6f11.6)

 1005 continue

      write(6,1004)
      write(6,1004)

 1002 continue

 1004 format()

      return
      end
