      subroutine scfcycle(iteration,nreal,ninteger,nmaxorbs,nxcmax,
     &                    nmaxpoints,idiis,nfunctional,irandgrid,
     &                    ngridtype,natoms,nptcharges,nalpha,nbeta,
     &                    ncontractions,nconts,ncontp,ncontd,ncds,
     &                    ncdspd,nxcs,nxcspd,natomtype,nptsatom,nshels,
     &                    nshelp,nsheld,mtloca,ilfunc,icfunc,ngaussians,
     &                    icdlfunc,icdcfunc,ixclfunc,ixccfunc,iwkvec,
     &                    energy,eshift,dmixing,diiserror,dmaxpc,coord,
     &                    coordpc,charge,ptcharge,core,focka,fockb,
     &                    focke,dmta,dmtb,coeffa,coeffb,orbnrga,orbnrgb,
     &                    overlapinv,alpha,coeffs,alphacd,coefscd,
     &                    coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &                    coefdxc,cdfitc,xcfita,xcfitb,xcfite,tvector,
     &                    tveca,tvecb,tvece,auxoverlap,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          mtloca(*),ilfunc(*),icfunc(*),ngaussians(*),icdlfunc(*),
     &          icdcfunc(*),ixclfunc(*),ixccfunc(*),iwkvec(*)

      dimension coord(3,*),coordpc(3,*),charge(*),ptcharge(*),core(*),
     &          focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),orbnrga(*),
     &          orbnrgb(*),overlapinv(nmaxorbs,*),alpha(*),coeffs(*),
     &          alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),alphaxc(*),
     &          coefsxc(*),coefpxc(*),coefdxc(*),cdfitc(*),xcfita(*),
     &          xcfitb(*),xcfite(*),tvector(*),tveca(*),tvecb(*),
     &          tvece(*),auxoverlap(nxcmax,*),wkvec(*)

      data zero/0.0/

      save nindpndnt

      ndim=ncontractions*(ncontractions+1)/2

      ncdfunc=ncds+10*ncdspd
      nxcfunc=nxcs+10*nxcspd

      if(iteration.eq.1) call startscf(nindpndnt,nreal,ninteger,
     &                                 nmaxorbs,nxcmax,nmaxpoints,
     &                                 natoms,nptcharges,nconts,ncontp,
     &                                 ncontd,ncds,ncdspd,nxcs,nxcspd,
     &                                 irandgrid,ngridtype,iwkvec,
     &                                 nshels,nshelp,nsheld,ilfunc,
     &                                 icfunc,ngaussians,mtloca,
     &                                 icdlfunc,icdcfunc,ixclfunc,
     &                                 ixccfunc,natomtype,nptsatom,
     &                                 energy,dmaxpc,diiserror,wkvec,
     &                                 core,focka,fockb,focke,
     &                                 overlapinv,auxoverlap,coord,
     &                                 coordpc,charge,ptcharge,alpha,
     &                                 coeffs,alphacd,coefscd,coefpcd,
     &                                 coefdcd,alphaxc,coefsxc,coefpxc,
     &                                 coefdxc,cdfitc,xcfita,xcfitb,
     &                                 xcfite)

      call twoemm(nreal-ndim,ninteger,nconts,ncontp,ncontd,ncds,ncdspd,
     &            nxcs,nxcspd,nshels,nshelp,nsheld,mtloca,ilfunc,
     &            ngaussians,icfunc,icdlfunc,icdcfunc,ixclfunc,ixccfunc,
     &            iwkvec,coord,alpha,coeffs,cdfitc,xcfita,xcfitb,xcfite,
     &            alphacd,coefscd,coefpcd,coefdcd,alphaxc,coefsxc,
     &            coefpxc,coefdxc,core,wkvec(1),focka,fockb,focke,
     &            wkvec(ndim+1))

      if(eshift.ne.zero) call carbo(nmaxorbs,ncontractions,nindpndnt,
     &                              nalpha,nbeta,eshift,focka,fockb,
     &                              coeffa,coeffb,overlapinv,wkvec(1),
     &                              wkvec(2*ndim+1))

      call totale(0,ncontractions,ncdfunc,iteration,nptcharges,natoms,
     &            nalpha,nbeta,nxcmax,energy,diiserror,dmta,dmtb,focke,
     &            coord,charge,coordpc,ptcharge,auxoverlap,cdfitc,
     &            dmaxpc)

      call getksorbs(iteration,nreal,idiis,nmaxorbs,ncontractions,
     &               nindpndnt,nalpha,nbeta,dmixing,eshift,diiserror,
     &               dmaxpc,dmta,dmtb,focka,fockb,coeffa,coeffb,orbnrga,
     &               orbnrgb,overlapinv,wkvec)

      call gridcall(1,iteration,nfunctional,ninteger,nreal,nmaxpoints,
     &              nmaxorbs,nxcmax,natoms,nalpha,nbeta,nconts,ncontp,
     &              ncontd,nxcs,nxcs+nxcspd,nxcfunc,natomtype,nptsatom,
     &              nshels,nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &              ixclfunc,ixccfunc,iwkvec,dmixing,coord,coeffa,
     &              coeffb,alpha,coeffs,alphaxc,coefsxc,coefpxc,coefdxc,
     &              xcfita,xcfitb,xcfite,tveca,tvecb,tvece,auxoverlap,
     &              wkvec)

      do 1001 i=1,ndim
 1001 wkvec(i)=dmta(i)+dmtb(i)

      call cdftmm(nreal-ndim,ninteger,nconts,ncontp,ncontd,ncds,ncdspd,
     &            nshels,nshelp,nsheld,mtloca,ilfunc,ngaussians,icfunc,
     &            icdlfunc,icdcfunc,iwkvec,coord,alpha,coeffs,alphacd,
     &            coefscd,coefpcd,coefdcd,tvector,wkvec(1),
     &            wkvec(ndim+1))

      call docdfit(nxcmax,nalpha,nbeta,ncds,ncdspd,icdlfunc,dmixing,
     &             alphacd,coefscd,coefdcd,cdfitc,tvector,auxoverlap,
     &             wkvec)

      return
      end
