      subroutine spingrid(npoints,coordinates)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension coordinates(3,*)

      data two,pi/2.0,3.1415926535898/

      rot_x=two*pi*aranf()
      rot_y=two*pi*aranf()
      rot_z=two*pi*aranf()

      theta1=cos(rot_z)
      theta2=sin(rot_z)
      theta3=cos(rot_y)
      theta4=sin(rot_y)
      theta5=cos(rot_x)
      theta6=sin(rot_x)

      do 1001 i=1,npoints
      xcoord=coordinates(1,i)
      ycoord=coordinates(2,i)
      coordinates(1,i)=theta1*xcoord+theta2*ycoord
 1001 coordinates(2,i)=theta1*ycoord-theta2*xcoord

      do 1002 i=1,npoints
      xcoord=coordinates(1,i)
      zcoord=coordinates(3,i)
      coordinates(1,i)=theta3*xcoord+theta4*zcoord
 1002 coordinates(3,i)=theta3*zcoord-theta4*xcoord

      do 1003 i=1,npoints
      ycoord=coordinates(2,i)
      zcoord=coordinates(3,i)
      coordinates(2,i)=theta5*ycoord+theta6*zcoord
 1003 coordinates(3,i)=theta5*zcoord-theta6*ycoord

      return
      end
