      subroutine checkpt(alpha,coeff,cent,cpt,dlarge,ilfunc,icfunc,
     &                   ngauss,nptrs,nptrp,nptrd,nconts,ncontp,ncontd)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cpt(*),alpha(*),coeff(*),cent(3,*)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      data zero,expcut/0.0,80.0/

      dlarge=zero

      if(nconts.eq.0) return

c  loop over s functions

      do 1001 i=1,nconts

      s=zero

      ilabel=nptrs(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      xx=cpt(1)-cent(1,nc)
      yy=cpt(2)-cent(2,nc)
      zz=cpt(3)-cent(3,nc)

      rr=xx*xx+yy*yy+zz*zz

      do 1002 j=iptr1,iptr2

      rralpha=rr*alpha(j)
      if(rralpha.gt.expcut) goto 1002

      s=s+coeff(j)*exp(-rralpha)

 1002 continue

      dlrgsub=abs(s)
      if(dlrgsub.gt.dlarge) dlarge=dlrgsub

 1001 continue

      if(ncontp.eq.0) return

c  loop over p functions

      do 1003 i=1,ncontp

      px=zero
      py=zero
      pz=zero

      ilabel=nptrp(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      xx=cpt(1)-cent(1,nc)
      yy=cpt(2)-cent(2,nc)
      zz=cpt(3)-cent(3,nc)

      rr=xx*xx+yy*yy+zz*zz

      do 2003 j=iptr1,iptr2

      rralpha=rr*alpha(j)
      if(rralpha.gt.expcut) goto 2003

      s=coeff(j)*exp(-rralpha)

      px=px+xx*s
      py=py+yy*s
      pz=pz+zz*s

 2003 continue

      dlrgsub=max(abs(px),abs(py),abs(pz))
      if(dlrgsub.gt.dlarge) dlarge=dlrgsub

 1003 continue

      if(ncontd.eq.0) return

c  loop over s functions

      do 3002 i=1,ncontd

      dxx=zero
      dxy=zero
      dxz=zero
      dyy=zero
      dyz=zero
      dzz=zero

      ilabel=nptrd(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      xx=cpt(1)-cent(1,nc)
      yy=cpt(2)-cent(2,nc)
      zz=cpt(3)-cent(3,nc)

      rr=xx*xx+yy*yy+zz*zz

      do 3003 j=iptr1,iptr2

      rralpha=rr*alpha(j)
      if(rralpha.gt.expcut) goto 3003

      s=coeff(j)*exp(-rralpha)

      dxx=dxx+xx*xx*s
      dxy=dxy+xx*yy*s
      dxz=dxz+xx*zz*s
      dyy=dyy+yy*yy*s
      dyz=dyz+yy*zz*s
      dzz=dzz+zz*zz*s

 3003 continue

      dlrgsub=max(abs(dxx),abs(dxy),abs(dxz),abs(dyy),abs(dyz),abs(dzz))
      if(dlrgsub.gt.dlarge) dlarge=dlrgsub

 3002 continue

      return
      end
