      subroutine delphidr(nreal,ninteger,natoms,nmaxorbs,nmaxaux,
     &                    nmaxpts,nmaxesp,mesp,nmaxiterations,ngridtype,
     &                    irandomgrid,nfunctional,ncenters,nptcharges,
     &                    nequivalences,nalpha,nbeta,nconts,ncontp,
     &                    ncontd,ncds,ncdspd,nxcs,nxcspd,natomtype,
     &                    nptsatom,nshels,nshelp,nsheld,ilfunc,icfunc,
     &                    ngaussians,mtloca,icdlfunc,icdcfunc,ixclfunc,
     &                    ixccfunc,nvecequivalences,iwkvec,epsilon,
     &                    econvergence,dmixing,elevelshift,coord,
     &                    charge,coordptcharge,ptcharge,core,focka,
     &                    fockb,focke,dmta,dmtb,coeffa,coeffb,orbnrga,
     &                    orbnrgb,overlap,alpha,coeffs,alphacd,coefscd,
     &                    coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &                    coefdxc,cdfitc,xcfita,xcfitb,xcfite,tvector,
     &                    tveca,tvecb,tvece,xcfitsave,auxoverlap,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),ngaussians(*),mtloca(*),icdlfunc(*),
     &          icdcfunc(*),ixclfunc(*),ixccfunc(*),
     &          nvecequivalences(natoms,*),iwkvec(*)

      dimension coord(3,*),charge(*),coordptcharge(3,*),ptcharge(*),
     &          core(*),focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),orbnrga(*),
     &          orbnrgb(*),overlap(nmaxorbs,*),alpha(*),coeffs(*),
     &          alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),alphaxc(*),
     &          coefsxc(*),coefpxc(*),coefdxc(*),cdfitc(*),xcfita(*),
     &          xcfitb(*),xcfite(*),tvector(*),tveca(*),tvecb(*),
     &          tvece(*),xcfitsave(*),auxoverlap(*),wkvec(*)

      data zero,dlarge/0.0,1.0e25/

      ncontractions=nconts+3*ncontp+6*ncontd

      ncdtotal=ncds+10*ncdspd
      nxctotal=nxcs+10*nxcspd

      ngrid=65
      ngridby2=33

      ja=1
      jb=ja+ngrid*ngrid*ngrid
      jc=jb+ngrid*ngrid*ngrid
      jd=jc+ngrid*ngrid*ngrid
      je=jd+ngrid*ngrid*ngrid*6
      jf=je+ngrid*ngrid*ngrid
      jg=jf+ncenters
      jh=jg+ncenters*3

      ji=jh+ncenters

      if(ji.gt.nreal) stop 'delphi driver real overflow'

      if((ngrid**3).gt.ninteger) stop 'delphi driver integer overflow'

      energy1=zero
      energy2=zero
      energy3=zero

      savedmixing=dmixing

      erange=dlarge

      ndelphi=0

      do 1001 i=1,nmaxiterations

      if(erange.lt.econvergence) goto 1001

      call scfcycle(i,nreal,ninteger,nmaxorbs,nmaxaux,nmaxpts,0,
     &              nfunctional,irandomgrid,ngridtype,ncenters,
     &              nptcharges,nalpha,nbeta,ncontractions,nconts,ncontp,
     &              ncontd,ncds,ncdspd,nxcs,nxcspd,natomtype,nptsatom,
     &              nshels,nshelp,nsheld,mtloca,ilfunc,icfunc,
     &              ngaussians,icdlfunc,icdcfunc,ixclfunc,ixccfunc,
     &              iwkvec,energy,elevelshift,dmixing,diiserror,dmaxpc,
     &              coord,coordptcharge,charge,ptcharge,core,focka,
     &              fockb,focke,dmta,dmtb,coeffa,coeffb,orbnrga,orbnrgb,
     &              overlap,alpha,coeffs,alphacd,coefscd,coefpcd,
     &              coefdcd,alphaxc,coefsxc,coefpxc,coefdxc,cdfitc,
     &              xcfita,xcfitb,xcfite,tvector,tveca,tvecb,tvece,
     &              auxoverlap,wkvec)

      energy3=energy2
      energy2=energy1

      energy1=energy

      erange=max(energy1,energy2,energy3)-min(energy1,energy2,energy3)

      if((erange.gt.sqrt(econvergence)).or.(mod(i,5).ne.0)) goto 1001

      write(6,1002)
 1002 format(//)

      ka=1
      kb=ka+mesp*3
      kc=kb+(2*ncenters)*(2*ncenters)
      kd=kc+(2*ncenters)
      ke=kd+ncenters
      kf=ke+ncenters*3
      kg=kf+ncenters

      kh=kg+nmaxesp*3

      if(kh.gt.nreal) stop 'cannot call espgen from delphi driver'

      call espgen(nreal-kh,ninteger-mesp,natoms,ncenters,mesp,nalpha,
     &            nbeta,nconts,ncontp,ncontd,nmaxesp,ilfunc,ngaussians,
     &            icfunc,mtloca,nshels,nshelp,nsheld,natomtype,
     &            iwkvec(1),nequivalences,nvecequivalences,
     &            iwkvec(mesp+1),coord,charge,dmta,dmtb,alpha,coeffs,
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh))

      do 1003 j=1,ncenters
 1003 wkvec(jf+j-1)=wkvec(kc+j-1)

      ndelphi=ndelphi+1

      call delphi(ndelphi,ncenters,nptcharges,ngrid,ngridby2,natomtype,
     &            iwkvec,epsilon,coord,wkvec(jf),coordptcharge,ptcharge,
     &            wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),
     &            wkvec(jg),wkvec(jh))

      ioffset=3*(ncenters+nptcharges)
      joffset=(ncenters+nptcharges)

      call coremm(nreal-ioffset-joffset,ninteger,ncenters,nptcharges,
     &            nconts,ncontp,ncontd,nshels,nshelp,nsheld,mtloca,
     &            ilfunc,ngaussians,icfunc,iwkvec,wkvec(1),coord,
     &            coordptcharge,wkvec(ioffset+1),charge,ptcharge,alpha,
     &            coeffs,overlap,core,wkvec(ioffset+joffset+1))

 1001 continue

      dmixing=savedmixing

      if(erange.le.econvergence) then
                                       write(6,1004)
                                 else
                                       write(6,1005)
                                 endif

 1004 format(/,' scf converged!!! :-) :-) :-) ')
 1005 format(/,' scf terminated unsuccessfully??? :-( :-( :-( ')

      call gengrid(nreal,nmaxpts,ngridtype,0,irandomgrid,ncenters,
     &             nconts,ncontp,ncontd,ilfunc,icfunc,ngaussians,nshels,
     &             nshelp,nsheld,natomtype,nptsatom,coord,alpha,coeffs,
     &             wkvec)

      call gridcall(0,-1,nfunctional,ninteger,nreal,nmaxpts,nmaxorbs,
     &              nmaxaux,ncenters,nalpha,nbeta,nconts,ncontp,ncontd,
     &              nxcs,nxcspd,nxctotal,natomtype,nptsatom,nshels,
     &              nshelp,nsheld,ilfunc,icfunc,ngaussians,ixclfunc,
     &              ixccfunc,iwkvec,dmixing,coord,coeffa,coeffb,alpha,
     &              coeffs,alphaxc,coefsxc,coefpxc,coefdxc,xcfita,
     &              xcfitb,xcfite,tveca,tvecb,tvece,auxoverlap,wkvec)

      do 1006 i=1,nxctotal
 1006 xcfitsave(i)=xcfite(i)

      do 1007 i=1,nxctotal
 1007 xcfite(i)=zero

      call numxcc(nreal,ninteger,nmaxpts,ncenters,nconts,ncontp,ncontd,
     &            ncds,ncdspd,nxcs,nxcspd,iwkvec,mtloca,ilfunc,
     &            ngaussians,icfunc,nshels,nshelp,nsheld,natomtype,
     &            nptsatom,icdlfunc,icdcfunc,ixclfunc,ixccfunc,wkvec,
     &            coord,core,focka,fockb,focke,alpha,coeffs,alphacd,
     &            coefscd,coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &            coefdxc,cdfitc,xcfita,xcfitb,xcfite)

      do 1008 i=1,nxctotal
 1008 xcfite(i)=xcfitsave(i)

      call totale(1,ncontractions,ncdtotal,-1,nptcharges,ncenters,
     &            nalpha,nbeta,nmaxaux,energy,diiserror,dmta,dmtb,focke,
     &            coord,charge,coordptcharge,ptcharge,auxoverlap,cdfitc,
     &            dmaxpc)

      return
      end
