      subroutine gradxxps(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                    icentr,iicontr,g,coord,density,gradient,
     &                    cdfitc,alphaaux,coeffs,coeffp,coeffd,zeta,
     &                    twozetaa,twozetab,px,py,pz,base,pxax,pyay,
     &                    pzaz,axbx,ayby,azbz,zzeta,ttwozetaa,ttwozetab,
     &                    zetarec,ppx,ppy,ppz,ppxax,ppyay,ppzaz,wxpx,
     &                    wypy,wzpz,wxcx,wycy,wzcz,zetac1,zetac2,u,sss0,
     &                    sss1,sss2,sss3,sss4,pss0,pss1,pss2,pss3,dss0,
     &                    dss1,dss2,ssp0,ssp1,ssd0,psp0,psp1,psd0,dsp0,
     &                    dsp1,dsd0,c,c1,c2,ssscond,sspcond,ssdcond,
     &                    psscond,pspcond,psdcond,dsscond,dspcond,
     &                    dsdcond,ppscond,pppcond,ppdcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),icentr(m,*),
     &          iicontr(*)

      dimension cdfitp(3),cdfitd(6)

      dimension g(*),coord(3,*),density(*),gradient(3,*),cdfitc(*),
     &          alphaaux(*),coeffs(*),coeffp(*),coeffd(*),zeta(*),
     &          twozetaa(*),twozetab(*),px(*),py(*),pz(*),base(*),
     &          pxax(*),pyay(*),pzaz(*),axbx(*),ayby(*),azbz(*),
     &          zzeta(*),ttwozetaa(*),ttwozetab(*),zetarec(*),ppx(*),
     &          ppy(*),ppz(*),ppxax(*),ppyay(*),ppzaz(*),wxpx(*),
     &          wypy(*),wzpz(*),wxcx(*),wycy(*),wzcz(*),zetac1(*),
     &          zetac2(*),u(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),dss0(n,*),
     &          dss1(n,*),dss2(n,*),ssp0(n,*),ssp1(n,*),ssd0(n,*),
     &          psp0(n,*),psp1(n,*),psd0(n,*),dsp0(n,*),dsp1(n,*),
     &          dsd0(n,*),c(*),c1(n,*),c2(n,*),ssscond(*),sspcond(m,*),
     &          ssdcond(m,*),psscond(m,*),pspcond(m,*),psdcond(m,*),
     &          dsscond(m,*),dspcond(m,*),dsdcond(m,*),ppscond(m,*),
     &          pppcond(m,*),ppdcond(m,*),grad(m,*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      dnormcd=seven/sqrt(three)

      do 1001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      nc=icfunc(ilaux)

      ccx=coord(1,nc)
      ccy=coord(2,nc)
      ccz=coord(3,nc)

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(5,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
 1004 sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n
      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ttwozetaa(nn)=twozetaa(i)
                                       ttwozetab(nn)=twozetab(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                 endif
 1005 continue

      do 1006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 1006 zetac2(i)=zzeta(i)*zetarec(i)

      do 1007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 1007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 1008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1009 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1009 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1010 i=1,nn
      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
 1010 pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      do 1011 i=1,nn
      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
 1011 pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      do 1012 i=1,nn
      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
 1012 pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      do 1013 i=1,nn
 1013 c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      do 1014 i=1,nn
      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
 1014 dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      do 1015 i=1,nn
 1015 c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      do 1016 i=1,nn
      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
 1016 dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      do 1017 i=1,nn
 1017 c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      do 1018 i=1,nn
      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
 1018 dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      do 1019 i=1,nn
      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
 1019 ssp0(i,3)=wzcz(i)*sss1(i)

      do 1020 i=1,nn
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 1020 ssp1(i,3)=wzcz(i)*sss2(i)

      do 1021 i=1,nn
 1021 c(i)=(sss0(i)-zetac2(i)*sss1(i))/(two*zetaux)

      do 1022 i=1,nn
      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
 1022 ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

      do 1023 i=1,nn
 1023 c(i)=half*sss1(i)*zetarec(i)

      do 1024 i=1,nn
      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
 1024 psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      do 1025 i=1,nn
 1025 c(i)=half*sss2(i)*zetarec(i)

      do 1026 i=1,nn
      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
 1026 psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

      do 1027 j=1,3
      do 1027 i=1,nn
 1027 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 1028 j=1,3
      do 1028 i=1,nn
 1028 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 1029 i=1,nn
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 1029 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 1030 j=1,3
      do 1030 i=1,nn
 1030 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 1031 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 1031 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 1032 j=1,3
      do 1032 i=1,nn
 1032 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 1033 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 1033 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 1034 j=1,6
      do 1034 i=1,nn
 1034 c1(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 1035 j=1,9
      do 1035 i=1,nn
 1035 c2(i,j)=half*psp1(i,j)*zetarec(i)

      do 1036 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c1(i,1)+c2(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c1(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c1(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c1(i,2)+c2(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c2(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c1(i,2)+c2(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c1(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c1(i,3)+c2(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c2(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c1(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c2(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c1(i,3)+c2(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c1(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c2(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c1(i,4)+c2(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c1(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c1(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c2(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c2(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c1(i,5)+c2(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c2(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c1(i,5)+c2(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c1(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c2(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c1(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c2(i,8)*two
 1036 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c1(i,6)+c2(i,9)*two

      do 1037 i=1,m
 1037 ssscond(i)=zero

      do 1038 j=1,3
      do 1038 i=1,m
 1038 sspcond(i,j)=zero

      do 1039 j=1,6
      do 1039 i=1,m
 1039 ssdcond(i,j)=zero

      do 1040 i=1,nn
 1040 ssscond(iicontr(i))=ssscond(iicontr(i))-sss0(i)

      do 1041 j=1,3
      do 1041 i=1,nn
 1041 sspcond(iicontr(i),j)=sspcond(iicontr(i),j)-ssp0(i,j)

      do 1042 j=1,6
      do 1042 i=1,nn
 1042 ssdcond(iicontr(i),j)=ssdcond(iicontr(i),j)-ssd0(i,j)

      do 1043 i=1,m
      grad(i,1)=ssscond(i)*density(inddyy(i,1))*cdfits
      grad(i,2)=ssscond(i)*density(inddyy(i,2))*cdfits
 1043 grad(i,3)=ssscond(i)*density(inddyy(i,3))*cdfits

      do 1044 j=1,3
      do 1044 i=1,m
 1044 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1045 j=1,3
      do 1045 i=1,m
 1045 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

      do 2001 l=1,3

      do 1046 i=1,m
      grad(i,1)=sspcond(i,l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,2)=sspcond(i,l)*density(inddyy(i,2))*cdfitp(l)
 1046 grad(i,3)=sspcond(i,l)*density(inddyy(i,3))*cdfitp(l)

      do 1047 j=1,3
      do 1047 i=1,m
 1047 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1048 j=1,3
      do 1048 i=1,m
 1048 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

 2001 continue

      do 2002 l=1,6

      do 1049 i=1,m
      grad(i,1)=ssdcond(i,l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,2)=ssdcond(i,l)*density(inddyy(i,2))*cdfitd(l)
 1049 grad(i,3)=ssdcond(i,l)*density(inddyy(i,3))*cdfitd(l)

      do 1050 j=1,3
      do 1050 i=1,m
 1050 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1051 j=1,3
      do 1051 i=1,m
 1051 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

 2002 continue

      do 1052 j=1,6
      do 1052 i=1,m
 1052 dsscond(i,j)=zero

      do 1053 j=1,18
      do 1053 i=1,m
 1053 dspcond(i,j)=zero

      do 1054 j=1,36
      do 1054 i=1,m
 1054 dsdcond(i,j)=zero

      do 1055 j=1,6
      do 1055 i=1,nn
 1055 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss0(i,j)*ttwozetaa(i)

      do 1056 j=1,18
      do 1056 i=1,nn
 1056 dspcond(iicontr(i),j)=dspcond(iicontr(i),j)+dsp0(i,j)*ttwozetaa(i)

      do 1057 j=1,36
      do 1057 i=1,nn
 1057 dsdcond(iicontr(i),j)=dsdcond(iicontr(i),j)+dsd0(i,j)*ttwozetaa(i)

      do 1058 i=1,m
      grad(i,1)=dsscond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=dsscond(i,2)*density(inddyy(i,2))*cdfits
      grad(i,3)=dsscond(i,3)*density(inddyy(i,3))*cdfits
      grad(i,4)=dsscond(i,2)*density(inddyy(i,1))*cdfits
      grad(i,5)=dsscond(i,4)*density(inddyy(i,2))*cdfits
      grad(i,6)=dsscond(i,5)*density(inddyy(i,3))*cdfits
      grad(i,7)=dsscond(i,3)*density(inddyy(i,1))*cdfits
      grad(i,8)=dsscond(i,5)*density(inddyy(i,2))*cdfits
 1058 grad(i,9)=dsscond(i,6)*density(inddyy(i,3))*cdfits

      do 1059 k=1,3
      do 1059 j=1,3
      do 1059 i=1,m
 1059 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1060 k=1,3
      do 1060 j=1,3
      do 1060 i=1,m
 1060 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

      do 2003 l=1,3

      do 1061 i=1,m
      grad(i,1)=dspcond(i,00+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,2)=dspcond(i,03+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,3)=dspcond(i,06+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,4)=dspcond(i,03+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,5)=dspcond(i,09+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,6)=dspcond(i,12+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,7)=dspcond(i,06+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,8)=dspcond(i,12+l)*density(inddyy(i,2))*cdfitp(l)
 1061 grad(i,9)=dspcond(i,15+l)*density(inddyy(i,3))*cdfitp(l)

      do 1062 k=1,3
      do 1062 j=1,3
      do 1062 i=1,m
 1062 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1063 k=1,3
      do 1063 j=1,3
      do 1063 i=1,m
 1063 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

 2003 continue

      do 2004 l=1,6

      do 1064 i=1,m
      grad(i,1)=dsdcond(i,00+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,2)=dsdcond(i,06+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,3)=dsdcond(i,12+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,4)=dsdcond(i,06+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,5)=dsdcond(i,18+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,6)=dsdcond(i,24+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,7)=dsdcond(i,12+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,8)=dsdcond(i,24+l)*density(inddyy(i,2))*cdfitd(l)
 1064 grad(i,9)=dsdcond(i,30+l)*density(inddyy(i,3))*cdfitd(l)

      do 1065 k=1,3
      do 1065 j=1,3
      do 1065 i=1,m
 1065 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1066 k=1,3
      do 1066 j=1,3
      do 1066 i=1,m
 1066 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

 2004 continue

      do 1067 j=1,3
      do 1067 i=1,m
 1067 psscond(i,j)=zero

      do 1068 j=1,9
      do 1068 i=1,m
 1068 pspcond(i,j)=zero

      do 1069 j=1,18
      do 1069 i=1,m
 1069 psdcond(i,j)=zero

      do 1070 j=1,6
      do 1070 i=1,m
 1070 dsscond(i,j)=zero

      do 1071 j=1,18
      do 1071 i=1,m
 1071 dspcond(i,j)=zero

      do 1072 j=1,36
      do 1072 i=1,m
 1072 dsdcond(i,j)=zero

      do 1073 j=1,3
      do 1073 i=1,nn
 1073 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss0(i,j)*ttwozetab(i)

      do 1074 j=1,9
      do 1074 i=1,nn
 1074 pspcond(iicontr(i),j)=pspcond(iicontr(i),j)+psp0(i,j)*ttwozetab(i)

      do 1075 j=1,18
      do 1075 i=1,nn
 1075 psdcond(iicontr(i),j)=psdcond(iicontr(i),j)+psd0(i,j)*ttwozetab(i)

      do 1076 j=1,6
      do 1076 i=1,nn
 1076 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss0(i,j)*ttwozetab(i)

      do 1077 j=1,18
      do 1077 i=1,nn
 1077 dspcond(iicontr(i),j)=dspcond(iicontr(i),j)+dsp0(i,j)*ttwozetab(i)

      do 1078 j=1,36
      do 1078 i=1,nn
 1078 dsdcond(iicontr(i),j)=dsdcond(iicontr(i),j)+dsd0(i,j)*ttwozetab(i)

      do 1079 i=1,m
      ppscond(i,1)=axbx(i)*psscond(i,1)+dsscond(i,1)
      ppscond(i,2)=ayby(i)*psscond(i,1)+dsscond(i,2)
      ppscond(i,3)=azbz(i)*psscond(i,1)+dsscond(i,3)
      ppscond(i,4)=axbx(i)*psscond(i,2)+dsscond(i,2)
      ppscond(i,5)=ayby(i)*psscond(i,2)+dsscond(i,4)
      ppscond(i,6)=azbz(i)*psscond(i,2)+dsscond(i,5)
      ppscond(i,7)=axbx(i)*psscond(i,3)+dsscond(i,3)
      ppscond(i,8)=ayby(i)*psscond(i,3)+dsscond(i,5)
 1079 ppscond(i,9)=azbz(i)*psscond(i,3)+dsscond(i,6)

      do 1080 i=1,m
      pppcond(i,01)=axbx(i)*pspcond(i,1)+dspcond(i,01)
      pppcond(i,02)=axbx(i)*pspcond(i,2)+dspcond(i,02)
      pppcond(i,03)=axbx(i)*pspcond(i,3)+dspcond(i,03)
      pppcond(i,04)=ayby(i)*pspcond(i,1)+dspcond(i,04)
      pppcond(i,05)=ayby(i)*pspcond(i,2)+dspcond(i,05)
      pppcond(i,06)=ayby(i)*pspcond(i,3)+dspcond(i,06)
      pppcond(i,07)=azbz(i)*pspcond(i,1)+dspcond(i,07)
      pppcond(i,08)=azbz(i)*pspcond(i,2)+dspcond(i,08)
      pppcond(i,09)=azbz(i)*pspcond(i,3)+dspcond(i,09)
      pppcond(i,10)=axbx(i)*pspcond(i,4)+dspcond(i,04)
      pppcond(i,11)=axbx(i)*pspcond(i,5)+dspcond(i,05)
      pppcond(i,12)=axbx(i)*pspcond(i,6)+dspcond(i,06)
      pppcond(i,13)=ayby(i)*pspcond(i,4)+dspcond(i,10)
      pppcond(i,14)=ayby(i)*pspcond(i,5)+dspcond(i,11)
      pppcond(i,15)=ayby(i)*pspcond(i,6)+dspcond(i,12)
      pppcond(i,16)=azbz(i)*pspcond(i,4)+dspcond(i,13)
      pppcond(i,17)=azbz(i)*pspcond(i,5)+dspcond(i,14)
      pppcond(i,18)=azbz(i)*pspcond(i,6)+dspcond(i,15)
      pppcond(i,19)=axbx(i)*pspcond(i,7)+dspcond(i,07)
      pppcond(i,20)=axbx(i)*pspcond(i,8)+dspcond(i,08)
      pppcond(i,21)=axbx(i)*pspcond(i,9)+dspcond(i,09)
      pppcond(i,22)=ayby(i)*pspcond(i,7)+dspcond(i,13)
      pppcond(i,23)=ayby(i)*pspcond(i,8)+dspcond(i,14)
      pppcond(i,24)=ayby(i)*pspcond(i,9)+dspcond(i,15)
      pppcond(i,25)=azbz(i)*pspcond(i,7)+dspcond(i,16)
      pppcond(i,26)=azbz(i)*pspcond(i,8)+dspcond(i,17)
 1080 pppcond(i,27)=azbz(i)*pspcond(i,9)+dspcond(i,18)

      do 1081 i=1,m
      ppdcond(i,01)=axbx(i)*psdcond(i,01)+dsdcond(i,01)
      ppdcond(i,02)=axbx(i)*psdcond(i,02)+dsdcond(i,02)
      ppdcond(i,03)=axbx(i)*psdcond(i,03)+dsdcond(i,03)
      ppdcond(i,04)=axbx(i)*psdcond(i,04)+dsdcond(i,04)
      ppdcond(i,05)=axbx(i)*psdcond(i,05)+dsdcond(i,05)
      ppdcond(i,06)=axbx(i)*psdcond(i,06)+dsdcond(i,06)
      ppdcond(i,07)=ayby(i)*psdcond(i,01)+dsdcond(i,07)
      ppdcond(i,08)=ayby(i)*psdcond(i,02)+dsdcond(i,08)
      ppdcond(i,09)=ayby(i)*psdcond(i,03)+dsdcond(i,09)
      ppdcond(i,10)=ayby(i)*psdcond(i,04)+dsdcond(i,10)
      ppdcond(i,11)=ayby(i)*psdcond(i,05)+dsdcond(i,11)
      ppdcond(i,12)=ayby(i)*psdcond(i,06)+dsdcond(i,12)
      ppdcond(i,13)=azbz(i)*psdcond(i,01)+dsdcond(i,13)
      ppdcond(i,14)=azbz(i)*psdcond(i,02)+dsdcond(i,14)
      ppdcond(i,15)=azbz(i)*psdcond(i,03)+dsdcond(i,15)
      ppdcond(i,16)=azbz(i)*psdcond(i,04)+dsdcond(i,16)
      ppdcond(i,17)=azbz(i)*psdcond(i,05)+dsdcond(i,17)
      ppdcond(i,18)=azbz(i)*psdcond(i,06)+dsdcond(i,18)
      ppdcond(i,19)=axbx(i)*psdcond(i,07)+dsdcond(i,07)
      ppdcond(i,20)=axbx(i)*psdcond(i,08)+dsdcond(i,08)
      ppdcond(i,21)=axbx(i)*psdcond(i,09)+dsdcond(i,09)
      ppdcond(i,22)=axbx(i)*psdcond(i,10)+dsdcond(i,10)
      ppdcond(i,23)=axbx(i)*psdcond(i,11)+dsdcond(i,11)
      ppdcond(i,24)=axbx(i)*psdcond(i,12)+dsdcond(i,12)
      ppdcond(i,25)=ayby(i)*psdcond(i,07)+dsdcond(i,19)
      ppdcond(i,26)=ayby(i)*psdcond(i,08)+dsdcond(i,20)
      ppdcond(i,27)=ayby(i)*psdcond(i,09)+dsdcond(i,21)
      ppdcond(i,28)=ayby(i)*psdcond(i,10)+dsdcond(i,22)
      ppdcond(i,29)=ayby(i)*psdcond(i,11)+dsdcond(i,23)
      ppdcond(i,30)=ayby(i)*psdcond(i,12)+dsdcond(i,24)
      ppdcond(i,31)=azbz(i)*psdcond(i,07)+dsdcond(i,25)
      ppdcond(i,32)=azbz(i)*psdcond(i,08)+dsdcond(i,26)
      ppdcond(i,33)=azbz(i)*psdcond(i,09)+dsdcond(i,27)
      ppdcond(i,34)=azbz(i)*psdcond(i,10)+dsdcond(i,28)
      ppdcond(i,35)=azbz(i)*psdcond(i,11)+dsdcond(i,29)
      ppdcond(i,36)=azbz(i)*psdcond(i,12)+dsdcond(i,30)
      ppdcond(i,37)=axbx(i)*psdcond(i,13)+dsdcond(i,13)
      ppdcond(i,38)=axbx(i)*psdcond(i,14)+dsdcond(i,14)
      ppdcond(i,39)=axbx(i)*psdcond(i,15)+dsdcond(i,15)
      ppdcond(i,40)=axbx(i)*psdcond(i,16)+dsdcond(i,16)
      ppdcond(i,41)=axbx(i)*psdcond(i,17)+dsdcond(i,17)
      ppdcond(i,42)=axbx(i)*psdcond(i,18)+dsdcond(i,18)
      ppdcond(i,43)=ayby(i)*psdcond(i,13)+dsdcond(i,25)
      ppdcond(i,44)=ayby(i)*psdcond(i,14)+dsdcond(i,26)
      ppdcond(i,45)=ayby(i)*psdcond(i,15)+dsdcond(i,27)
      ppdcond(i,46)=ayby(i)*psdcond(i,16)+dsdcond(i,28)
      ppdcond(i,47)=ayby(i)*psdcond(i,17)+dsdcond(i,29)
      ppdcond(i,48)=ayby(i)*psdcond(i,18)+dsdcond(i,30)
      ppdcond(i,49)=azbz(i)*psdcond(i,13)+dsdcond(i,31)
      ppdcond(i,50)=azbz(i)*psdcond(i,14)+dsdcond(i,32)
      ppdcond(i,51)=azbz(i)*psdcond(i,15)+dsdcond(i,33)
      ppdcond(i,52)=azbz(i)*psdcond(i,16)+dsdcond(i,34)
      ppdcond(i,53)=azbz(i)*psdcond(i,17)+dsdcond(i,35)
 1081 ppdcond(i,54)=azbz(i)*psdcond(i,18)+dsdcond(i,36)

      do 1082 i=1,m
      grad(i,1)=ppscond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=ppscond(i,4)*density(inddyy(i,2))*cdfits
      grad(i,3)=ppscond(i,7)*density(inddyy(i,3))*cdfits
      grad(i,4)=ppscond(i,2)*density(inddyy(i,1))*cdfits
      grad(i,5)=ppscond(i,5)*density(inddyy(i,2))*cdfits
      grad(i,6)=ppscond(i,8)*density(inddyy(i,3))*cdfits
      grad(i,7)=ppscond(i,3)*density(inddyy(i,1))*cdfits
      grad(i,8)=ppscond(i,6)*density(inddyy(i,2))*cdfits
 1082 grad(i,9)=ppscond(i,9)*density(inddyy(i,3))*cdfits

      do 1083 k=1,3
      do 1083 j=1,3
      do 1083 i=1,m
 1083 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1084 k=1,3
      do 1084 j=1,3
      do 1084 i=1,m
 1084 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

      do 2005 l=1,3

      do 1085 i=1,m
      grad(i,1)=pppcond(i,00+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,2)=pppcond(i,09+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,3)=pppcond(i,18+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,4)=pppcond(i,03+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,5)=pppcond(i,12+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,6)=pppcond(i,21+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,7)=pppcond(i,06+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,8)=pppcond(i,15+l)*density(inddyy(i,2))*cdfitp(l)
 1085 grad(i,9)=pppcond(i,24+l)*density(inddyy(i,3))*cdfitp(l)

      do 1086 k=1,3
      do 1086 j=1,3
      do 1086 i=1,m
 1086 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1087 k=1,3
      do 1087 j=1,3
      do 1087 i=1,m
 1087 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

 2005 continue

      do 2006 l=1,6

      do 1088 i=1,m
      grad(i,1)=ppdcond(i,00+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,2)=ppdcond(i,18+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,3)=ppdcond(i,36+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,4)=ppdcond(i,06+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,5)=ppdcond(i,24+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,6)=ppdcond(i,42+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,7)=ppdcond(i,12+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,8)=ppdcond(i,30+l)*density(inddyy(i,2))*cdfitd(l)
 1088 grad(i,9)=ppdcond(i,48+l)*density(inddyy(i,3))*cdfitd(l)

      do 1089 k=1,3
      do 1089 j=1,3
      do 1089 i=1,m
 1089 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1090 k=1,3
      do 1090 j=1,3
      do 1090 i=1,m
 1090 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

 2006 continue

 1001 continue

      return
      end
