      subroutine chrgpp(m,n,ncds,ncdspd,ilfunc,icfunc,iminj,icontr,
     &                  iicontr,inddyy,g,coord,cdfitc,alphaaux,coeffs,
     &                  coeffp,coeffd,fock,zeta,axbx,ayby,azbz,px,py,pz,
     &                  base,pxax,pyay,pzaz,u,zetarec,wxcx,wycy,wzcz,
     &                  wxpx,wypy,wzpz,sss0,sss1,sss2,sss3,sss4,pss,
     &                  pss0,pss1,pss2,pss3,dss,dss0,dss1,dss2,ssp1,psp,
     &                  psp0,psp1,dsp,dsp0,dsp1,psd,psd0,dsd,dsd0,pps,
     &                  ppp,ppd,zetac1,zetac2,c,c1,c2,c3,zzeta,ppx,ppy,
     &                  ppz,ppxax,ppyay,ppzaz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),iminj(*),icontr(*),iicontr(*),
     &          inddyy(m,*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),pxax(*),pyay(*),
     &          pzaz(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),wxpx(*),
     &          wypy(*),wzpz(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          pss(m,*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          dss(m,*),dss0(n,*),dss1(n,*),dss2(n,*),ssp1(n,*),
     &          psp(m,*),psp0(n,*),psp1(n,*),dsp(m,*),dsp0(n,*),
     &          dsp1(n,*),psd(m,*),psd0(n,*),dsd(m,*),dsd0(n,*),
     &          pps(m,*),ppp(m,*),ppd(m,*),zetac1(*),zetac2(*),c(*),
     &          c1(n,*),c2(n,*),c3(n,*),zzeta(*),ppx(*),ppy(*),ppz(*),
     &          ppxax(*),ppyay(*),ppzaz(*)

      data one,two,three,five,seven/1.0,2.0,3.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(3,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
 1004 sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                 endif

 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

 1008 continue

      do 1009 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,m
 1010 pss(i,j)=zero

      do 1011 j=1,6
      do 1011 i=1,m
 1011 dss(i,j)=zero

      do 1012 j=1,3
      do 1012 i=1,nn
 1012 pss(iicontr(i),j)=pss(iicontr(i),j)+pss0(i,j)

      do 1013 j=1,6
      do 1013 i=1,nn
 1013 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 1014 i=1,m
      pps(i,1)=axbx(i)*pss(i,1)+dss(i,1)
      pps(i,2)=ayby(i)*pss(i,1)+dss(i,2)
      pps(i,3)=azbz(i)*pss(i,1)+dss(i,3)
      pps(i,4)=axbx(i)*pss(i,2)+dss(i,2)
      pps(i,5)=ayby(i)*pss(i,2)+dss(i,4)
      pps(i,6)=azbz(i)*pss(i,2)+dss(i,5)
      pps(i,7)=axbx(i)*pss(i,3)+dss(i,3)
      pps(i,8)=ayby(i)*pss(i,3)+dss(i,5)
 1014 pps(i,9)=azbz(i)*pss(i,3)+dss(i,6)

      do 1015 i=1,m
      fock(inddyy(i,1))=fock(inddyy(i,1))+pps(i,1)*cdfits
      fock(inddyy(i,4))=fock(inddyy(i,4))+pps(i,4)*cdfits
      fock(inddyy(i,5))=fock(inddyy(i,5))+pps(i,5)*cdfits
      fock(inddyy(i,7))=fock(inddyy(i,7))+pps(i,7)*cdfits
      fock(inddyy(i,8))=fock(inddyy(i,8))+pps(i,8)*cdfits
 1015 fock(inddyy(i,9))=fock(inddyy(i,9))+pps(i,9)*cdfits

      do 1016 i=1,m
      if(iminj(i).ne.0) then

                   fock(inddyy(i,2))=fock(inddyy(i,2))+pps(i,2)*cdfits
                   fock(inddyy(i,3))=fock(inddyy(i,3))+pps(i,3)*cdfits
                   fock(inddyy(i,6))=fock(inddyy(i,6))+pps(i,6)*cdfits

                        endif
 1016 continue

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      call augg(5,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
 2004 sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux

      nn=0

      do 2005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                 endif

 2005 continue

      do 2006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 2006 zetac2(i)=zzeta(i)*zetarec(i)

      do 2007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 2008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 2009 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

 2009 continue

      do 2010 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

 2010 continue

      do 2011 i=1,nn
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 2011 ssp1(i,3)=wzcz(i)*sss2(i)

      do 2012 i=1,nn

      c(i)=half*sss1(i)*zetarec(i)

      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
      psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2012 continue

      do 2013 j=1,3
      do 2013 i=1,nn
 2013 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 2014 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 2014 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 2015 j=1,3
      do 2015 i=1,nn
 2015 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 2016 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 2016 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 2017 j=1,3
      do 2017 i=1,nn
 2017 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 2018 j=1,3
      do 2018 i=1,nn
 2018 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 2019 i=1,nn
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 2019 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 2020 j=1,6
      do 2020 i=1,nn
 2020 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 2021 j=1,9
      do 2021 i=1,nn
 2021 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 2022 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 2022 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 2023 j=1,3
      do 2023 i=1,m
 2023 pss(i,j)=zero

      do 2024 j=1,9
      do 2024 i=1,m
 2024 psp(i,j)=zero

      do 2025 j=1,18
      do 2025 i=1,m
 2025 psd(i,j)=zero

      do 2026 j=1,6
      do 2026 i=1,m
 2026 dss(i,j)=zero

      do 2027 j=1,18
      do 2027 i=1,m
 2027 dsp(i,j)=zero

      do 2028 j=1,36
      do 2028 i=1,m
 2028 dsd(i,j)=zero

      do 2029 j=1,3
      do 2029 i=1,nn
 2029 pss(iicontr(i),j)=pss(iicontr(i),j)+pss0(i,j)

      do 2030 j=1,9
      do 2030 i=1,nn
 2030 psp(iicontr(i),j)=psp(iicontr(i),j)+psp0(i,j)

      do 2031 j=1,18
      do 2031 i=1,nn
 2031 psd(iicontr(i),j)=psd(iicontr(i),j)+psd0(i,j)

      do 2032 j=1,6
      do 2032 i=1,nn
 2032 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 2033 j=1,18
      do 2033 i=1,nn
 2033 dsp(iicontr(i),j)=dsp(iicontr(i),j)+dsp0(i,j)

      do 2034 j=1,36
      do 2034 i=1,nn
 2034 dsd(iicontr(i),j)=dsd(iicontr(i),j)+dsd0(i,j)

      do 2035 i=1,m
      pps(i,1)=axbx(i)*pss(i,1)+dss(i,1)
      pps(i,2)=ayby(i)*pss(i,1)+dss(i,2)
      pps(i,3)=azbz(i)*pss(i,1)+dss(i,3)
      pps(i,4)=axbx(i)*pss(i,2)+dss(i,2)
      pps(i,5)=ayby(i)*pss(i,2)+dss(i,4)
      pps(i,6)=azbz(i)*pss(i,2)+dss(i,5)
      pps(i,7)=axbx(i)*pss(i,3)+dss(i,3)
      pps(i,8)=ayby(i)*pss(i,3)+dss(i,5)
 2035 pps(i,9)=azbz(i)*pss(i,3)+dss(i,6)

      do 2036 i=1,m
      ppp(i,01)=axbx(i)*psp(i,1)+dsp(i,01)
      ppp(i,02)=axbx(i)*psp(i,2)+dsp(i,02)
      ppp(i,03)=axbx(i)*psp(i,3)+dsp(i,03)
      ppp(i,04)=ayby(i)*psp(i,1)+dsp(i,04)
      ppp(i,05)=ayby(i)*psp(i,2)+dsp(i,05)
      ppp(i,06)=ayby(i)*psp(i,3)+dsp(i,06)
      ppp(i,07)=azbz(i)*psp(i,1)+dsp(i,07)
      ppp(i,08)=azbz(i)*psp(i,2)+dsp(i,08)
      ppp(i,09)=azbz(i)*psp(i,3)+dsp(i,09)
      ppp(i,10)=axbx(i)*psp(i,4)+dsp(i,04)
      ppp(i,11)=axbx(i)*psp(i,5)+dsp(i,05)
      ppp(i,12)=axbx(i)*psp(i,6)+dsp(i,06)
      ppp(i,13)=ayby(i)*psp(i,4)+dsp(i,10)
      ppp(i,14)=ayby(i)*psp(i,5)+dsp(i,11)
      ppp(i,15)=ayby(i)*psp(i,6)+dsp(i,12)
      ppp(i,16)=azbz(i)*psp(i,4)+dsp(i,13)
      ppp(i,17)=azbz(i)*psp(i,5)+dsp(i,14)
      ppp(i,18)=azbz(i)*psp(i,6)+dsp(i,15)
      ppp(i,19)=axbx(i)*psp(i,7)+dsp(i,07)
      ppp(i,20)=axbx(i)*psp(i,8)+dsp(i,08)
      ppp(i,21)=axbx(i)*psp(i,9)+dsp(i,09)
      ppp(i,22)=ayby(i)*psp(i,7)+dsp(i,13)
      ppp(i,23)=ayby(i)*psp(i,8)+dsp(i,14)
      ppp(i,24)=ayby(i)*psp(i,9)+dsp(i,15)
      ppp(i,25)=azbz(i)*psp(i,7)+dsp(i,16)
      ppp(i,26)=azbz(i)*psp(i,8)+dsp(i,17)
 2036 ppp(i,27)=azbz(i)*psp(i,9)+dsp(i,18)

      do 2037 i=1,m
      ppd(i,01)=axbx(i)*psd(i,01)+dsd(i,01)
      ppd(i,02)=axbx(i)*psd(i,02)+dsd(i,02)
      ppd(i,03)=axbx(i)*psd(i,03)+dsd(i,03)
      ppd(i,04)=axbx(i)*psd(i,04)+dsd(i,04)
      ppd(i,05)=axbx(i)*psd(i,05)+dsd(i,05)
      ppd(i,06)=axbx(i)*psd(i,06)+dsd(i,06)
      ppd(i,07)=ayby(i)*psd(i,01)+dsd(i,07)
      ppd(i,08)=ayby(i)*psd(i,02)+dsd(i,08)
      ppd(i,09)=ayby(i)*psd(i,03)+dsd(i,09)
      ppd(i,10)=ayby(i)*psd(i,04)+dsd(i,10)
      ppd(i,11)=ayby(i)*psd(i,05)+dsd(i,11)
      ppd(i,12)=ayby(i)*psd(i,06)+dsd(i,12)
      ppd(i,13)=azbz(i)*psd(i,01)+dsd(i,13)
      ppd(i,14)=azbz(i)*psd(i,02)+dsd(i,14)
      ppd(i,15)=azbz(i)*psd(i,03)+dsd(i,15)
      ppd(i,16)=azbz(i)*psd(i,04)+dsd(i,16)
      ppd(i,17)=azbz(i)*psd(i,05)+dsd(i,17)
      ppd(i,18)=azbz(i)*psd(i,06)+dsd(i,18)
      ppd(i,19)=axbx(i)*psd(i,07)+dsd(i,07)
      ppd(i,20)=axbx(i)*psd(i,08)+dsd(i,08)
      ppd(i,21)=axbx(i)*psd(i,09)+dsd(i,09)
      ppd(i,22)=axbx(i)*psd(i,10)+dsd(i,10)
      ppd(i,23)=axbx(i)*psd(i,11)+dsd(i,11)
      ppd(i,24)=axbx(i)*psd(i,12)+dsd(i,12)
      ppd(i,25)=ayby(i)*psd(i,07)+dsd(i,19)
      ppd(i,26)=ayby(i)*psd(i,08)+dsd(i,20)
      ppd(i,27)=ayby(i)*psd(i,09)+dsd(i,21)
      ppd(i,28)=ayby(i)*psd(i,10)+dsd(i,22)
      ppd(i,29)=ayby(i)*psd(i,11)+dsd(i,23)
      ppd(i,30)=ayby(i)*psd(i,12)+dsd(i,24)
      ppd(i,31)=azbz(i)*psd(i,07)+dsd(i,25)
      ppd(i,32)=azbz(i)*psd(i,08)+dsd(i,26)
      ppd(i,33)=azbz(i)*psd(i,09)+dsd(i,27)
      ppd(i,34)=azbz(i)*psd(i,10)+dsd(i,28)
      ppd(i,35)=azbz(i)*psd(i,11)+dsd(i,29)
      ppd(i,36)=azbz(i)*psd(i,12)+dsd(i,30)
      ppd(i,37)=axbx(i)*psd(i,13)+dsd(i,13)
      ppd(i,38)=axbx(i)*psd(i,14)+dsd(i,14)
      ppd(i,39)=axbx(i)*psd(i,15)+dsd(i,15)
      ppd(i,40)=axbx(i)*psd(i,16)+dsd(i,16)
      ppd(i,41)=axbx(i)*psd(i,17)+dsd(i,17)
      ppd(i,42)=axbx(i)*psd(i,18)+dsd(i,18)
      ppd(i,43)=ayby(i)*psd(i,13)+dsd(i,25)
      ppd(i,44)=ayby(i)*psd(i,14)+dsd(i,26)
      ppd(i,45)=ayby(i)*psd(i,15)+dsd(i,27)
      ppd(i,46)=ayby(i)*psd(i,16)+dsd(i,28)
      ppd(i,47)=ayby(i)*psd(i,17)+dsd(i,29)
      ppd(i,48)=ayby(i)*psd(i,18)+dsd(i,30)
      ppd(i,49)=azbz(i)*psd(i,13)+dsd(i,31)
      ppd(i,50)=azbz(i)*psd(i,14)+dsd(i,32)
      ppd(i,51)=azbz(i)*psd(i,15)+dsd(i,33)
      ppd(i,52)=azbz(i)*psd(i,16)+dsd(i,34)
      ppd(i,53)=azbz(i)*psd(i,17)+dsd(i,35)
 2037 ppd(i,54)=azbz(i)*psd(i,18)+dsd(i,36)

      do 2038 i=1,m
      fock(inddyy(i,1))=fock(inddyy(i,1))+pps(i,1)*cdfits
      fock(inddyy(i,4))=fock(inddyy(i,4))+pps(i,4)*cdfits
      fock(inddyy(i,5))=fock(inddyy(i,5))+pps(i,5)*cdfits
      fock(inddyy(i,7))=fock(inddyy(i,7))+pps(i,7)*cdfits
      fock(inddyy(i,8))=fock(inddyy(i,8))+pps(i,8)*cdfits
 2038 fock(inddyy(i,9))=fock(inddyy(i,9))+pps(i,9)*cdfits

      do 2039 i=1,m
      if(iminj(i).ne.0) then

                   fock(inddyy(i,2))=fock(inddyy(i,2))+pps(i,2)*cdfits
                   fock(inddyy(i,3))=fock(inddyy(i,3))+pps(i,3)*cdfits
                   fock(inddyy(i,6))=fock(inddyy(i,6))+pps(i,6)*cdfits

                        endif
 2039 continue

      do 2040 j=1,3
      do 2040 i=1,m
      fock(inddyy(i,1))=fock(inddyy(i,1))+ppp(i,3*0+j)*cdfitp(j)
      fock(inddyy(i,4))=fock(inddyy(i,4))+ppp(i,3*3+j)*cdfitp(j)
      fock(inddyy(i,5))=fock(inddyy(i,5))+ppp(i,3*4+j)*cdfitp(j)
      fock(inddyy(i,7))=fock(inddyy(i,7))+ppp(i,3*6+j)*cdfitp(j)
      fock(inddyy(i,8))=fock(inddyy(i,8))+ppp(i,3*7+j)*cdfitp(j)
 2040 fock(inddyy(i,9))=fock(inddyy(i,9))+ppp(i,3*8+j)*cdfitp(j)

      do 2041 j=1,3
      do 2041 i=1,m
      if(iminj(i).ne.0) then

            fock(inddyy(i,2))=fock(inddyy(i,2))+ppp(i,3*1+j)*cdfitp(j)
            fock(inddyy(i,3))=fock(inddyy(i,3))+ppp(i,3*2+j)*cdfitp(j)
            fock(inddyy(i,6))=fock(inddyy(i,6))+ppp(i,3*5+j)*cdfitp(j)

                        endif
 2041 continue

      do 2042 j=1,6
      do 2042 i=1,m
      fock(inddyy(i,1))=fock(inddyy(i,1))+ppd(i,6*0+j)*cdfitd(j)
      fock(inddyy(i,4))=fock(inddyy(i,4))+ppd(i,6*3+j)*cdfitd(j)
      fock(inddyy(i,5))=fock(inddyy(i,5))+ppd(i,6*4+j)*cdfitd(j)
      fock(inddyy(i,7))=fock(inddyy(i,7))+ppd(i,6*6+j)*cdfitd(j)
      fock(inddyy(i,8))=fock(inddyy(i,8))+ppd(i,6*7+j)*cdfitd(j)
 2042 fock(inddyy(i,9))=fock(inddyy(i,9))+ppd(i,6*8+j)*cdfitd(j)

      do 2043 j=1,6
      do 2043 i=1,m
      if(iminj(i).ne.0) then

            fock(inddyy(i,2))=fock(inddyy(i,2))+ppd(i,6*1+j)*cdfitd(j)
            fock(inddyy(i,3))=fock(inddyy(i,3))+ppd(i,6*2+j)*cdfitd(j)
            fock(inddyy(i,6))=fock(inddyy(i,6))+ppd(i,6*5+j)*cdfitd(j)

                        endif
 2043 continue

 2001 continue

      do 3001 i=1,n
 3001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      return
      end
