      subroutine gradnapp(m,n,ncentr,iminj,icontr,inddyy,icentr,g,coord,
     &                    charge,density,gradient,zeta,twozetaa,
     &                    twozetab,px,py,pz,base,pxax,pyay,pzaz,axbx,
     &                    ayby,azbz,pxcx,pycy,pzcz,twozeta,u,ss0,ss1,
     &                    ss2,ss3,ps0,ps1,ps2,ds0,ds1,fs0,c,c1,sscond,
     &                    pscond,spcond,dscond,ppcond,fscond,dpcond,
     &                    pdcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iminj(*),icontr(*),inddyy(m,*),icentr(m,*)

      dimension g(*),coord(3,*),charge(*),density(*),gradient(3,*),
     &          zeta(*),twozetaa(*),twozetab(*),px(*),py(*),pz(*),
     &          base(*),pxax(*),pyay(*),pzaz(*),axbx(*),ayby(*),azbz(*),
     &          pxcx(*),pycy(*),pzcz(*),twozeta(*),u(*),ss0(*),ss1(*),
     &          ss2(*),ss3(*),ps0(n,*),ps1(n,*),ps2(n,*),ds0(n,*),
     &          ds1(n,*),fs0(n,*),c(*),c1(n,*),sscond(*),pscond(m,*),
     &          spcond(m,*),dscond(m,*),ppcond(m,*),fscond(m,*),
     &          dpcond(m,*),pdcond(m,*),grad(m,*)

      data zero,two,pi/0.0,2.0,3.1415926535898/

      do 1001 i=1,n
 1001 twozeta(i)=two*zeta(i)

      do 1002 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 1003 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 1003 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 1004 i=1,n
      call augg(4,u(i),g)
      ss0(i)=base(i)*g(1)*twopichrg/zeta(i)
      ss1(i)=base(i)*g(2)*twopichrg/zeta(i)
      ss2(i)=base(i)*g(3)*twopichrg/zeta(i)
 1004 ss3(i)=base(i)*g(4)*twopichrg/zeta(i)

      do 1005 i=1,n
      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
 1005 ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      do 1006 i=1,n
      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
 1006 ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

      do 1007 i=1,n
      ps2(i,1)=pxax(i)*ss2(i)-pxcx(i)*ss3(i)
      ps2(i,2)=pyay(i)*ss2(i)-pycy(i)*ss3(i)
 1007 ps2(i,3)=pzaz(i)*ss2(i)-pzcz(i)*ss3(i)

      do 1008 i=1,n
 1008 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 1009 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 1009 ds0(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 1010 i=1,n
 1010 c(i)=(ss1(i)-ss2(i))/twozeta(i)

      do 1011 i=1,n
      ds1(i,1)=pxax(i)*ps1(i,1)-pxcx(i)*ps2(i,1)+c(i)
      ds1(i,2)=pyay(i)*ps1(i,1)-pycy(i)*ps2(i,1)
      ds1(i,3)=pzaz(i)*ps1(i,1)-pzcz(i)*ps2(i,1)
      ds1(i,4)=pyay(i)*ps1(i,2)-pycy(i)*ps2(i,2)+c(i)
      ds1(i,5)=pzaz(i)*ps1(i,2)-pzcz(i)*ps2(i,2)
 1011 ds1(i,6)=pzaz(i)*ps1(i,3)-pzcz(i)*ps2(i,3)+c(i)

      do 1012 j=1,3
      do 1012 i=1,n
 1012 c1(i,j)=(ps0(i,j)-ps1(i,j))/twozeta(i)

      do 1013 i=1,n
      fs0(i,01)=pxax(i)*ds0(i,1)-pxcx(i)*ds1(i,1)+c1(i,1)*two
      fs0(i,02)=pyay(i)*ds0(i,1)-pycy(i)*ds1(i,1)
      fs0(i,03)=pzaz(i)*ds0(i,1)-pzcz(i)*ds1(i,1)
      fs0(i,04)=pyay(i)*ds0(i,2)-pycy(i)*ds1(i,2)+c1(i,1)
      fs0(i,05)=pzaz(i)*ds0(i,2)-pzcz(i)*ds1(i,2)
      fs0(i,06)=pzaz(i)*ds0(i,3)-pzcz(i)*ds1(i,3)+c1(i,1)
      fs0(i,07)=pyay(i)*ds0(i,4)-pycy(i)*ds1(i,4)+c1(i,2)*two
      fs0(i,08)=pzaz(i)*ds0(i,4)-pzcz(i)*ds1(i,4)
      fs0(i,09)=pzaz(i)*ds0(i,5)-pzcz(i)*ds1(i,5)+c1(i,2)
 1013 fs0(i,10)=pzaz(i)*ds0(i,6)-pzcz(i)*ds1(i,6)+c1(i,3)*two

      do 1014 i=1,m
 1014 sscond(i)=zero

      do 1015 j=1,3
      do 1015 i=1,m
 1015 pscond(i,j)=zero

      do 1016 i=1,n
 1016 sscond(icontr(i))=sscond(icontr(i))-ss0(i)

      do 1017 j=1,3
      do 1017 i=1,n
 1017 pscond(icontr(i),j)=pscond(icontr(i),j)-ps0(i,j)

      do 1018 i=1,m
      spcond(i,1)=axbx(i)*sscond(i)+pscond(i,1)
      spcond(i,2)=ayby(i)*sscond(i)+pscond(i,2)
 1018 spcond(i,3)=azbz(i)*sscond(i)+pscond(i,3)

      do 1019 i=1,m
      grad(i,1)=spcond(i,1)*density(inddyy(i,1))
      grad(i,2)=spcond(i,2)*density(inddyy(i,2))
      grad(i,3)=spcond(i,3)*density(inddyy(i,3))
      grad(i,4)=spcond(i,1)*density(inddyy(i,4))
      grad(i,5)=spcond(i,2)*density(inddyy(i,5))
      grad(i,6)=spcond(i,3)*density(inddyy(i,6))
      grad(i,7)=spcond(i,1)*density(inddyy(i,7))
      grad(i,8)=spcond(i,2)*density(inddyy(i,8))
 1019 grad(i,9)=spcond(i,3)*density(inddyy(i,9))

      do 1020 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,2)=zero
                              grad(i,3)=zero
                              grad(i,6)=zero
                        endif
 1020 continue

      do 1021 k=1,3
      do 1021 j=1,3
      do 1021 i=1,m
 1021 gradient(k,nn)=gradient(k,nn)+grad(i,3*(k-1)+j)

      do 1022 k=1,3
      do 1022 j=1,3
      do 1022 i=1,m
 1022 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))-grad(i,3*(k-1)+j)

      do 1023 i=1,m
      grad(i,1)=pscond(i,1)*density(inddyy(i,1))
      grad(i,2)=pscond(i,2)*density(inddyy(i,4))
      grad(i,3)=pscond(i,3)*density(inddyy(i,7))
      grad(i,4)=pscond(i,1)*density(inddyy(i,2))
      grad(i,5)=pscond(i,2)*density(inddyy(i,5))
      grad(i,6)=pscond(i,3)*density(inddyy(i,8))
      grad(i,7)=pscond(i,1)*density(inddyy(i,3))
      grad(i,8)=pscond(i,2)*density(inddyy(i,6))
 1023 grad(i,9)=pscond(i,3)*density(inddyy(i,9))

      do 1024 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,4)=zero
                              grad(i,7)=zero
                              grad(i,8)=zero
                        endif
 1024 continue

      do 1025 k=1,3
      do 1025 j=1,3
      do 1025 i=1,m
 1025 gradient(k,nn)=gradient(k,nn)+grad(i,3*(k-1)+j)

      do 1026 k=1,3
      do 1026 j=1,3
      do 1026 i=1,m
 1026 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))-grad(i,3*(k-1)+j)

      do 1027 j=1,6
      do 1027 i=1,m
 1027 dscond(i,j)=zero

      do 1028 j=1,10
      do 1028 i=1,m
 1028 fscond(i,j)=zero

      do 1029 j=1,6
      do 1029 i=1,n
 1029 dscond(icontr(i),j)=dscond(icontr(i),j)+ds0(i,j)*twozetaa(i)

      do 1030 j=1,10
      do 1030 i=1,n
 1030 fscond(icontr(i),j)=fscond(icontr(i),j)+fs0(i,j)*twozetaa(i)

      do 1031 i=1,m
      dpcond(i,01)=axbx(i)*dscond(i,1)+fscond(i,01)
      dpcond(i,02)=ayby(i)*dscond(i,1)+fscond(i,02)
      dpcond(i,03)=azbz(i)*dscond(i,1)+fscond(i,03)
      dpcond(i,04)=axbx(i)*dscond(i,2)+fscond(i,02)
      dpcond(i,05)=ayby(i)*dscond(i,2)+fscond(i,04)
      dpcond(i,06)=azbz(i)*dscond(i,2)+fscond(i,05)
      dpcond(i,07)=axbx(i)*dscond(i,3)+fscond(i,03)
      dpcond(i,08)=ayby(i)*dscond(i,3)+fscond(i,05)
      dpcond(i,09)=azbz(i)*dscond(i,3)+fscond(i,06)
      dpcond(i,10)=axbx(i)*dscond(i,4)+fscond(i,04)
      dpcond(i,11)=ayby(i)*dscond(i,4)+fscond(i,07)
      dpcond(i,12)=azbz(i)*dscond(i,4)+fscond(i,08)
      dpcond(i,13)=axbx(i)*dscond(i,5)+fscond(i,05)
      dpcond(i,14)=ayby(i)*dscond(i,5)+fscond(i,08)
      dpcond(i,15)=azbz(i)*dscond(i,5)+fscond(i,09)
      dpcond(i,16)=axbx(i)*dscond(i,6)+fscond(i,06)
      dpcond(i,17)=ayby(i)*dscond(i,6)+fscond(i,09)
 1031 dpcond(i,18)=azbz(i)*dscond(i,6)+fscond(i,10)

      do 1032 i=1,m
      grad(i,01)=dpcond(i,01)*density(inddyy(i,1))
      grad(i,02)=dpcond(i,02)*density(inddyy(i,2))
      grad(i,03)=dpcond(i,03)*density(inddyy(i,3))
      grad(i,04)=dpcond(i,04)*density(inddyy(i,4))
      grad(i,05)=dpcond(i,05)*density(inddyy(i,5))
      grad(i,06)=dpcond(i,06)*density(inddyy(i,6))
      grad(i,07)=dpcond(i,07)*density(inddyy(i,7))
      grad(i,08)=dpcond(i,08)*density(inddyy(i,8))
      grad(i,09)=dpcond(i,09)*density(inddyy(i,9))
      grad(i,10)=dpcond(i,04)*density(inddyy(i,1))
      grad(i,11)=dpcond(i,05)*density(inddyy(i,2))
      grad(i,12)=dpcond(i,06)*density(inddyy(i,3))
      grad(i,13)=dpcond(i,10)*density(inddyy(i,4))
      grad(i,14)=dpcond(i,11)*density(inddyy(i,5))
      grad(i,15)=dpcond(i,12)*density(inddyy(i,6))
      grad(i,16)=dpcond(i,13)*density(inddyy(i,7))
      grad(i,17)=dpcond(i,14)*density(inddyy(i,8))
      grad(i,18)=dpcond(i,15)*density(inddyy(i,9))
      grad(i,19)=dpcond(i,07)*density(inddyy(i,1))
      grad(i,20)=dpcond(i,08)*density(inddyy(i,2))
      grad(i,21)=dpcond(i,09)*density(inddyy(i,3))
      grad(i,22)=dpcond(i,13)*density(inddyy(i,4))
      grad(i,23)=dpcond(i,14)*density(inddyy(i,5))
      grad(i,24)=dpcond(i,15)*density(inddyy(i,6))
      grad(i,25)=dpcond(i,16)*density(inddyy(i,7))
      grad(i,26)=dpcond(i,17)*density(inddyy(i,8))
 1032 grad(i,27)=dpcond(i,18)*density(inddyy(i,9))

      do 1033 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,02)=zero
                              grad(i,03)=zero
                              grad(i,06)=zero
                              grad(i,11)=zero
                              grad(i,12)=zero
                              grad(i,15)=zero
                              grad(i,20)=zero
                              grad(i,21)=zero
                              grad(i,24)=zero
                        endif
 1033 continue

      do 1034 k=1,3
      do 1034 j=1,9
      do 1034 i=1,m
 1034 gradient(k,nn)=gradient(k,nn)+grad(i,9*(k-1)+j)

      do 1035 k=1,3
      do 1035 j=1,9
      do 1035 i=1,m
 1035 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))-grad(i,9*(k-1)+j)

      do 1036 j=1,3
      do 1036 i=1,m
 1036 pscond(i,j)=zero

      do 1037 j=1,6
      do 1037 i=1,m
 1037 dscond(i,j)=zero

      do 1038 j=1,10
      do 1038 i=1,m
 1038 fscond(i,j)=zero

      do 1039 j=1,3
      do 1039 i=1,n
 1039 pscond(icontr(i),j)=pscond(icontr(i),j)+ps0(i,j)*twozetab(i)

      do 1040 j=1,6
      do 1040 i=1,n
 1040 dscond(icontr(i),j)=dscond(icontr(i),j)+ds0(i,j)*twozetab(i)

      do 1041 j=1,10
      do 1041 i=1,n
 1041 fscond(icontr(i),j)=fscond(icontr(i),j)+fs0(i,j)*twozetab(i)

      do 1042 i=1,m
      ppcond(i,1)=axbx(i)*pscond(i,1)+dscond(i,1)
      ppcond(i,2)=ayby(i)*pscond(i,1)+dscond(i,2)
      ppcond(i,3)=azbz(i)*pscond(i,1)+dscond(i,3)
      ppcond(i,4)=axbx(i)*pscond(i,2)+dscond(i,2)
      ppcond(i,5)=ayby(i)*pscond(i,2)+dscond(i,4)
      ppcond(i,6)=azbz(i)*pscond(i,2)+dscond(i,5)
      ppcond(i,7)=axbx(i)*pscond(i,3)+dscond(i,3)
      ppcond(i,8)=ayby(i)*pscond(i,3)+dscond(i,5)
 1042 ppcond(i,9)=azbz(i)*pscond(i,3)+dscond(i,6)

      do 1043 i=1,m
      dpcond(i,01)=axbx(i)*dscond(i,1)+fscond(i,01)
      dpcond(i,02)=ayby(i)*dscond(i,1)+fscond(i,02)
      dpcond(i,03)=azbz(i)*dscond(i,1)+fscond(i,03)
      dpcond(i,04)=axbx(i)*dscond(i,2)+fscond(i,02)
      dpcond(i,05)=ayby(i)*dscond(i,2)+fscond(i,04)
      dpcond(i,06)=azbz(i)*dscond(i,2)+fscond(i,05)
      dpcond(i,07)=axbx(i)*dscond(i,3)+fscond(i,03)
      dpcond(i,08)=ayby(i)*dscond(i,3)+fscond(i,05)
      dpcond(i,09)=azbz(i)*dscond(i,3)+fscond(i,06)
      dpcond(i,10)=axbx(i)*dscond(i,4)+fscond(i,04)
      dpcond(i,11)=ayby(i)*dscond(i,4)+fscond(i,07)
      dpcond(i,12)=azbz(i)*dscond(i,4)+fscond(i,08)
      dpcond(i,13)=axbx(i)*dscond(i,5)+fscond(i,05)
      dpcond(i,14)=ayby(i)*dscond(i,5)+fscond(i,08)
      dpcond(i,15)=azbz(i)*dscond(i,5)+fscond(i,09)
      dpcond(i,16)=axbx(i)*dscond(i,6)+fscond(i,06)
      dpcond(i,17)=ayby(i)*dscond(i,6)+fscond(i,09)
 1043 dpcond(i,18)=azbz(i)*dscond(i,6)+fscond(i,10)

      do 1044 i=1,m
      pdcond(i,01)=axbx(i)*ppcond(i,1)+dpcond(i,01)
      pdcond(i,02)=ayby(i)*ppcond(i,1)+dpcond(i,04)
      pdcond(i,03)=azbz(i)*ppcond(i,1)+dpcond(i,07)
      pdcond(i,04)=ayby(i)*ppcond(i,2)+dpcond(i,05)
      pdcond(i,05)=azbz(i)*ppcond(i,2)+dpcond(i,08)
      pdcond(i,06)=azbz(i)*ppcond(i,3)+dpcond(i,09)
      pdcond(i,07)=axbx(i)*ppcond(i,4)+dpcond(i,04)
      pdcond(i,08)=ayby(i)*ppcond(i,4)+dpcond(i,10)
      pdcond(i,09)=azbz(i)*ppcond(i,4)+dpcond(i,13)
      pdcond(i,10)=ayby(i)*ppcond(i,5)+dpcond(i,11)
      pdcond(i,11)=azbz(i)*ppcond(i,5)+dpcond(i,14)
      pdcond(i,12)=azbz(i)*ppcond(i,6)+dpcond(i,15)
      pdcond(i,13)=axbx(i)*ppcond(i,7)+dpcond(i,07)
      pdcond(i,14)=ayby(i)*ppcond(i,7)+dpcond(i,13)
      pdcond(i,15)=azbz(i)*ppcond(i,7)+dpcond(i,16)
      pdcond(i,16)=ayby(i)*ppcond(i,8)+dpcond(i,14)
      pdcond(i,17)=azbz(i)*ppcond(i,8)+dpcond(i,17)
 1044 pdcond(i,18)=azbz(i)*ppcond(i,9)+dpcond(i,18)

      do 1045 i=1,m
      grad(i,01)=pdcond(i,01)*density(inddyy(i,1))
      grad(i,02)=pdcond(i,02)*density(inddyy(i,2))
      grad(i,03)=pdcond(i,03)*density(inddyy(i,3))
      grad(i,04)=pdcond(i,07)*density(inddyy(i,4))
      grad(i,05)=pdcond(i,08)*density(inddyy(i,5))
      grad(i,06)=pdcond(i,09)*density(inddyy(i,6))
      grad(i,07)=pdcond(i,13)*density(inddyy(i,7))
      grad(i,08)=pdcond(i,14)*density(inddyy(i,8))
      grad(i,09)=pdcond(i,15)*density(inddyy(i,9))
      grad(i,10)=pdcond(i,02)*density(inddyy(i,1))
      grad(i,11)=pdcond(i,04)*density(inddyy(i,2))
      grad(i,12)=pdcond(i,05)*density(inddyy(i,3))
      grad(i,13)=pdcond(i,08)*density(inddyy(i,4))
      grad(i,14)=pdcond(i,10)*density(inddyy(i,5))
      grad(i,15)=pdcond(i,11)*density(inddyy(i,6))
      grad(i,16)=pdcond(i,14)*density(inddyy(i,7))
      grad(i,17)=pdcond(i,16)*density(inddyy(i,8))
      grad(i,18)=pdcond(i,17)*density(inddyy(i,9))
      grad(i,19)=pdcond(i,03)*density(inddyy(i,1))
      grad(i,20)=pdcond(i,05)*density(inddyy(i,2))
      grad(i,21)=pdcond(i,06)*density(inddyy(i,3))
      grad(i,22)=pdcond(i,09)*density(inddyy(i,4))
      grad(i,23)=pdcond(i,11)*density(inddyy(i,5))
      grad(i,24)=pdcond(i,12)*density(inddyy(i,6))
      grad(i,25)=pdcond(i,15)*density(inddyy(i,7))
      grad(i,26)=pdcond(i,17)*density(inddyy(i,8))
 1045 grad(i,27)=pdcond(i,18)*density(inddyy(i,9))

      do 1046 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,02)=zero
                              grad(i,03)=zero
                              grad(i,06)=zero
                              grad(i,11)=zero
                              grad(i,12)=zero
                              grad(i,15)=zero
                              grad(i,20)=zero
                              grad(i,21)=zero
                              grad(i,24)=zero
                        endif
 1046 continue

      do 1047 k=1,3
      do 1047 j=1,9
      do 1047 i=1,m
 1047 gradient(k,nn)=gradient(k,nn)+grad(i,9*(k-1)+j)

      do 1048 k=1,3
      do 1048 j=1,9
      do 1048 i=1,m
 1048 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))-grad(i,9*(k-1)+j)

 1002 continue

      return
      end
