      subroutine irspectrum(nonlinear,natoms,natomtype,stepsize,coord,
     &                      wkmata,wkmatb,wkmatc,wkmatd,freqncy,dipole,
     &                      aux1,aux2,aux3)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension atwght(102),component(3)

      dimension natomtype(*)

      dimension coord(3,*),wkmata(natoms*3,*),wkmatb(natoms*3,*),
     &          wkmatc(3,*),wkmatd(3,*),freqncy(*),dipole(3,*),aux1(*),
     &          aux2(*),aux3(*)

      data zero,two,pi/0.0,2.0,3.1415926535898/

      data shift,eliminate/20.0,5000.0/

      data factor1,factor2,factor3/9.6828862e+14,2.9979246e+10,974.8644/

      data atwght/
     &    1.0078,    4.0026,    7.0160,    9.0122,   11.0093,   12.0000,
     &   14.0031,   15.9949,   18.9984,   19.9924,   22.9898,   23.9850,
     &   26.9815,   27.9769,   30.9738,   31.9721,   34.9689,   39.9480,
     &   38.9637,   39.9626,   44.9559,   47.9000,   50.9440,   51.9405,
     &   54.9381,   55.9349,   58.9332,   57.9353,   62.9298,   63.9291,
     &   68.9257,   73.9219,   74.9216,   79.9165,   78.9183,   83.8000,
     &   84.9117,   87.9056,   88.9054,   89.9043,   92.9060,   97.9055,
     &   98.9062,  101.9037,  102.9048,  105.9032,  106.9051,  113.9036,
     &  114.9041,  117.9018,  120.9038,  129.9067,  126.9004,  131.9042,
     &  133.9051,  137.9050,  138.9061,  139.9053,  140.9074,  141.9075,
     &  147.0000,  151.9195,  152.9209,  157.9241,  159.9250,  163.9288,
     &  164.9303,  165.9304,  168.9344,  173.9390,  174.9409,  179.9468,
     &  180.9480,  183.9510,  186.9560,  190.2000,  192.9633,  194.9648,
     &  196.9666,  201.9706,  204.9745,  207.9766,  208.9804,  209.0000,
     &  210.0000,  222.0000,  223.0000,  226.0254,  227.0000,  232.0381,
     &  231.0359,  238.0289,  237.0482,  242.0000,  243.0000,  247.0000,
     &  247.0000,  249.0000,  254.0000,  253.0000,  256.0000,  254.0000/

      rewind 73
      rewind 74

      do 1001 i=1,2
      do 1001 j=1,natoms*3
      do 1001 k=1,natoms

      read(74) x,y,z

      if(i.eq.1) then
                       wkmata(j,3*(k-1)+1)=x
                       wkmata(j,3*(k-1)+2)=y
                       wkmata(j,3*(k-1)+3)=z
                 else
                       wkmatb(j,3*(k-1)+1)=x
                       wkmatb(j,3*(k-1)+2)=y
                       wkmatb(j,3*(k-1)+3)=z
                 endif

 1001 continue

      do 1002 i=1,natoms*3
      do 1002 j=1,natoms*3
 1002 wkmata(j,i)=(wkmata(j,i)-wkmatb(j,i))/(two*stepsize)

      do 1003 i=1,natoms*3
      do 1003 j=1,natoms*3
 1003 wkmatb(i,j)=(wkmata(j,i)+wkmata(i,j))/two

      do 1004 i=1,natoms
      do 1004 j=1,natoms*3
      wkmatb(3*(i-1)+1,j)=wkmatb(3*(i-1)+1,j)/sqrt(atwght(natomtype(i)))
      wkmatb(3*(i-1)+2,j)=wkmatb(3*(i-1)+2,j)/sqrt(atwght(natomtype(i)))
 1004 wkmatb(3*(i-1)+3,j)=wkmatb(3*(i-1)+3,j)/sqrt(atwght(natomtype(i)))

      do 1005 i=1,natoms
      do 1005 j=1,natoms*3
      wkmatb(j,3*(i-1)+1)=wkmatb(j,3*(i-1)+1)/sqrt(atwght(natomtype(i)))
      wkmatb(j,3*(i-1)+2)=wkmatb(j,3*(i-1)+2)/sqrt(atwght(natomtype(i)))
 1005 wkmatb(j,3*(i-1)+3)=wkmatb(j,3*(i-1)+3)/sqrt(atwght(natomtype(i)))

      do 1006 i=1,2
      do 1006 j=1,natoms
      do 1006 k=1,3

      read(73) x,y,z

      if(i.eq.1) then
                       wkmatc(1,3*(j-1)+k)=x/sqrt(atwght(natomtype(j)))
                       wkmatc(2,3*(j-1)+k)=y/sqrt(atwght(natomtype(j)))
                       wkmatc(3,3*(j-1)+k)=z/sqrt(atwght(natomtype(j)))
                 else
                       wkmatd(1,3*(j-1)+k)=x/sqrt(atwght(natomtype(j)))
                       wkmatd(2,3*(j-1)+k)=y/sqrt(atwght(natomtype(j)))
                       wkmatd(3,3*(j-1)+k)=z/sqrt(atwght(natomtype(j)))
                 endif

 1006 continue

      do 1007 i=1,natoms*3
      do 1007 j=1,3
 1007 dipole(j,i)=(wkmatc(j,i)-wkmatd(j,i))/(two*stepsize)

      do 1008 jj=1,3
      do 1009 ii=1,natoms
 1009 aux1(3*(ii-1)+jj)=shift*sqrt(atwght(natomtype(ii)))
      do 1008 i=1,natoms*3
      do 1008 j=1,natoms*3
      do 1008 k=1,natoms*3
      do 1008 l=1,natoms*3
 1008 if((i.eq.k).and.(j.eq.l)) wkmatb(i,j)=wkmatb(i,j)-aux1(k)*aux1(l)

      if(nonlinear.eq.0) goto 1010

      do 1011 j=1,3
      do 1012 i=1,natoms
      dmass=atwght(natomtype(i))
      if(j.eq.1) aux1(3*(i-1)+2)=-shift*sqrt(dmass)*coord(3,i)
      if(j.eq.1) aux1(3*(i-1)+3)=+shift*sqrt(dmass)*coord(2,i)
      if(j.eq.2) aux1(3*(i-1)+1)=+shift*sqrt(dmass)*coord(3,i)
      if(j.eq.2) aux1(3*(i-1)+3)=-shift*sqrt(dmass)*coord(1,i)
      if(j.eq.3) aux1(3*(i-1)+1)=-shift*sqrt(dmass)*coord(2,i)
 1012 if(j.eq.3) aux1(3*(i-1)+2)=+shift*sqrt(dmass)*coord(1,i)
      do 1011 k=1,natoms*3
      do 1011 l=1,natoms*3
      do 1011 m=1,natoms*3
      do 1011 n=1,natoms*3
 1011 if((k.eq.m).and.(l.eq.n)) wkmatb(k,l)=wkmatb(k,l)-aux1(m)*aux1(n)

 1010 continue

      call tred2(natoms*3,natoms*3,wkmatb,freqncy,aux1,aux2,wkmata)
      call tql2(natoms*3,natoms*3,freqncy,aux1,wkmata,aux2,aux3,ierror)

      do 1013 i=1,natoms*3

      if(freqncy(i).lt.zero) then
                                   iflag=1
                                   freqncy(i)=-freqncy(i)
                             else
                                   iflag=0
                             endif

      freqncy(i)=sqrt(freqncy(i))*factor1/(two*pi*factor2)

      if(freqncy(i).gt.eliminate) goto 1013

      do 1014 j=1,3
 1014 component(j)=zero

      do 1015 j=1,3
      do 1015 k=1,natoms*3
 1015 component(j)=component(j)+dipole(j,k)*wkmata(k,i)

      dintensity=factor3*(component(1)*component(1)
     &                   +component(2)*component(2)
     &                   +component(3)*component(3))

      if(iflag.eq.0) write(6,1016) i,+freqncy(i),dintensity
      if(iflag.eq.1) write(6,1017) i,-freqncy(i),dintensity

 1016 format(///,' normal mode # ',i3,//,
     &           '      real frequency       : ',f15.3,' 1/cm',/,
     &           '      infrared intensity   : ',f15.3,' km/mol',/)

 1017 format(///,' normal mode # ',i3,//,
     &           '      imaginary frequency  : ',f15.3,' 1/cm',/,
     &           '      infrared intensity   : ',f15.3,' km/mol',/)

      write(6,1018)
 1018 format('      atom #    ',
     &       'x-coordinate    y-coordinate    z-coordinate',
     &       ' (bohr * amu**0.5)',/)

      do 1019 j=1,natoms
 1019 write(6,1020) j,wkmata(3*(j-1)+1,i),
     &                wkmata(3*(j-1)+2,i),
     &                wkmata(3*(j-1)+3,i)

 1020 format(5x,i5,5x,f12.6,4x,f12.6,4x,f12.6)

 1013 continue

      return
      end
