      subroutine chrgdd(m,n,ncds,ncdspd,ilfunc,icfunc,iminj,icontr,
     &                  iicontr,inddyy,g,coord,cdfitc,alphaaux,coeffs,
     &                  coeffp,coeffd,fock,zeta,axbx,ayby,azbz,px,py,pz,
     &                  base,pxax,pyay,pzaz,u,zetarec,wxcx,wycy,wzcz,
     &                  wxpx,wypy,wzpz,sss0,sss1,sss2,sss3,sss4,sss5,
     &                  sss6,pss0,pss1,pss2,pss3,pss4,pss5,dss,dss0,
     &                  dss1,dss2,dss3,dss4,fss,fss0,fss1,fss2,fss3,gss,
     &                  gss0,gss1,gss2,psp0,psp1,dsp,dsp0,dsp1,fsp,fsp0,
     &                  fsp1,gsp,gsp0,gsp1,dsd,dsd0,fsd,fsd0,gsd,gsd0,
     &                  dps,fps,dds,dpp,fpp,ddp,dpd,fpd,ddd,zetac1,
     &                  zetac2,c,c1,c2,c3,c4,c5,zzeta,ppx,ppy,ppz,ppxax,
     &                  ppyay,ppzaz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),iminj(*),icontr(*),iicontr(*),
     &          inddyy(m,*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),pxax(*),pyay(*),
     &          pzaz(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),wxpx(*),
     &          wypy(*),wzpz(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          sss5(*),sss6(*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          pss4(n,*),pss5(n,*),dss(m,*),dss0(n,*),dss1(n,*),
     &          dss2(n,*),dss3(n,*),dss4(n,*),fss(m,*),fss0(n,*),
     &          fss1(n,*),fss2(n,*),fss3(n,*),gss(m,*),gss0(n,*),
     &          gss1(n,*),gss2(n,*),psp0(n,*),psp1(n,*),dsp(m,*),
     &          dsp0(n,*),dsp1(n,*),fsp(m,*),fsp0(n,*),fsp1(n,*),
     &          gsp(m,*),gsp0(n,*),gsp1(n,*),dsd(m,*),dsd0(n,*),
     &          fsd(m,*),fsd0(n,*),gsd(m,*),gsd0(n,*),dps(m,*),fps(m,*),
     &          dds(m,*),dpp(m,*),fpp(m,*),ddp(m,*),dpd(m,*),fpd(m,*),
     &          ddd(m,*),zetac1(*),zetac2(*),c(*),c1(n,*),c2(n,*),
     &          c3(n,*),c4(n,*),c5(n,*),zzeta(*),ppx(*),ppy(*),ppz(*),
     &          ppxax(*),ppyay(*),ppzaz(*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(5,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
 1004 sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                 endif

 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

 1008 continue

      do 1009 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 1011 i=1,nn
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1011 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1012 j=1,3
      do 1012 i=1,nn
 1012 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 1013 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 1013 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 1014 j=1,6
      do 1014 i=1,nn
 1014 c2(i,j)=(dss0(i,j)-zetac1(i)*dss1(i,j))/(two*zzeta(i))

      do 1015 i=1,nn
      gss0(i,01)=ppxax(i)*fss0(i,01)+wxpx(i)*fss1(i,01)+c2(i,1)*three
      gss0(i,02)=ppyay(i)*fss0(i,01)+wypy(i)*fss1(i,01)
      gss0(i,03)=ppzaz(i)*fss0(i,01)+wzpz(i)*fss1(i,01)
      gss0(i,04)=ppyay(i)*fss0(i,02)+wypy(i)*fss1(i,02)+c2(i,1)
      gss0(i,05)=ppzaz(i)*fss0(i,02)+wzpz(i)*fss1(i,02)
      gss0(i,06)=ppzaz(i)*fss0(i,03)+wzpz(i)*fss1(i,03)+c2(i,1)
      gss0(i,07)=ppyay(i)*fss0(i,04)+wypy(i)*fss1(i,04)+c2(i,2)*two
      gss0(i,08)=ppzaz(i)*fss0(i,04)+wzpz(i)*fss1(i,04)
      gss0(i,09)=ppzaz(i)*fss0(i,05)+wzpz(i)*fss1(i,05)+c2(i,2)
      gss0(i,10)=ppzaz(i)*fss0(i,06)+wzpz(i)*fss1(i,06)+c2(i,3)*two
      gss0(i,11)=ppyay(i)*fss0(i,07)+wypy(i)*fss1(i,07)+c2(i,4)*three
      gss0(i,12)=ppzaz(i)*fss0(i,07)+wzpz(i)*fss1(i,07)
      gss0(i,13)=ppzaz(i)*fss0(i,08)+wzpz(i)*fss1(i,08)+c2(i,4)
      gss0(i,14)=ppzaz(i)*fss0(i,09)+wzpz(i)*fss1(i,09)+c2(i,5)*two
 1015 gss0(i,15)=ppzaz(i)*fss0(i,10)+wzpz(i)*fss1(i,10)+c2(i,6)*three

      do 1016 j=1,6
      do 1016 i=1,m
 1016 dss(i,j)=zero

      do 1017 j=1,10
      do 1017 i=1,m
 1017 fss(i,j)=zero

      do 1018 j=1,15
      do 1018 i=1,m
 1018 gss(i,j)=zero

      do 1019 j=1,6
      do 1019 i=1,nn
 1019 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 1020 j=1,10
      do 1020 i=1,nn
 1020 fss(iicontr(i),j)=fss(iicontr(i),j)+fss0(i,j)

      do 1021 j=1,15
      do 1021 i=1,nn
 1021 gss(iicontr(i),j)=gss(iicontr(i),j)+gss0(i,j)

      do 1022 i=1,m
      dps(i,01)=axbx(i)*dss(i,1)+fss(i,01)
      dps(i,02)=ayby(i)*dss(i,1)+fss(i,02)
      dps(i,03)=azbz(i)*dss(i,1)+fss(i,03)
      dps(i,04)=axbx(i)*dss(i,2)+fss(i,02)
      dps(i,05)=ayby(i)*dss(i,2)+fss(i,04)
      dps(i,06)=azbz(i)*dss(i,2)+fss(i,05)
      dps(i,07)=axbx(i)*dss(i,3)+fss(i,03)
      dps(i,08)=ayby(i)*dss(i,3)+fss(i,05)
      dps(i,09)=azbz(i)*dss(i,3)+fss(i,06)
      dps(i,10)=axbx(i)*dss(i,4)+fss(i,04)
      dps(i,11)=ayby(i)*dss(i,4)+fss(i,07)
      dps(i,12)=azbz(i)*dss(i,4)+fss(i,08)
      dps(i,13)=axbx(i)*dss(i,5)+fss(i,05)
      dps(i,14)=ayby(i)*dss(i,5)+fss(i,08)
      dps(i,15)=azbz(i)*dss(i,5)+fss(i,09)
      dps(i,16)=axbx(i)*dss(i,6)+fss(i,06)
      dps(i,17)=ayby(i)*dss(i,6)+fss(i,09)
 1022 dps(i,18)=azbz(i)*dss(i,6)+fss(i,10)

      do 1023 i=1,m
      fps(i,01)=axbx(i)*fss(i,01)+gss(i,01)
      fps(i,02)=ayby(i)*fss(i,01)+gss(i,02)
      fps(i,03)=azbz(i)*fss(i,01)+gss(i,03)
      fps(i,04)=axbx(i)*fss(i,02)+gss(i,02)
      fps(i,05)=ayby(i)*fss(i,02)+gss(i,04)
      fps(i,06)=azbz(i)*fss(i,02)+gss(i,05)
      fps(i,07)=axbx(i)*fss(i,03)+gss(i,03)
      fps(i,08)=ayby(i)*fss(i,03)+gss(i,05)
      fps(i,09)=azbz(i)*fss(i,03)+gss(i,06)
      fps(i,10)=axbx(i)*fss(i,04)+gss(i,04)
      fps(i,11)=ayby(i)*fss(i,04)+gss(i,07)
      fps(i,12)=azbz(i)*fss(i,04)+gss(i,08)
      fps(i,13)=axbx(i)*fss(i,05)+gss(i,05)
      fps(i,14)=ayby(i)*fss(i,05)+gss(i,08)
      fps(i,15)=azbz(i)*fss(i,05)+gss(i,09)
      fps(i,16)=axbx(i)*fss(i,06)+gss(i,06)
      fps(i,17)=ayby(i)*fss(i,06)+gss(i,09)
      fps(i,18)=azbz(i)*fss(i,06)+gss(i,10)
      fps(i,19)=axbx(i)*fss(i,07)+gss(i,07)
      fps(i,20)=ayby(i)*fss(i,07)+gss(i,11)
      fps(i,21)=azbz(i)*fss(i,07)+gss(i,12)
      fps(i,22)=axbx(i)*fss(i,08)+gss(i,08)
      fps(i,23)=ayby(i)*fss(i,08)+gss(i,12)
      fps(i,24)=azbz(i)*fss(i,08)+gss(i,13)
      fps(i,25)=axbx(i)*fss(i,09)+gss(i,09)
      fps(i,26)=ayby(i)*fss(i,09)+gss(i,13)
      fps(i,27)=azbz(i)*fss(i,09)+gss(i,14)
      fps(i,28)=axbx(i)*fss(i,10)+gss(i,10)
      fps(i,29)=ayby(i)*fss(i,10)+gss(i,14)
 1023 fps(i,30)=azbz(i)*fss(i,10)+gss(i,15)

      do 1024 i=1,m
      dds(i,01)=axbx(i)*dps(i,01)+fps(i,01)
      dds(i,02)=ayby(i)*dps(i,01)+fps(i,04)
      dds(i,03)=azbz(i)*dps(i,01)+fps(i,07)
      dds(i,04)=ayby(i)*dps(i,02)+fps(i,05)
      dds(i,05)=azbz(i)*dps(i,02)+fps(i,08)
      dds(i,06)=azbz(i)*dps(i,03)+fps(i,09)
      dds(i,07)=axbx(i)*dps(i,04)+fps(i,04)
      dds(i,08)=ayby(i)*dps(i,04)+fps(i,10)
      dds(i,09)=azbz(i)*dps(i,04)+fps(i,13)
      dds(i,10)=ayby(i)*dps(i,05)+fps(i,11)
      dds(i,11)=azbz(i)*dps(i,05)+fps(i,14)
      dds(i,12)=azbz(i)*dps(i,06)+fps(i,15)
      dds(i,13)=axbx(i)*dps(i,07)+fps(i,07)
      dds(i,14)=ayby(i)*dps(i,07)+fps(i,13)
      dds(i,15)=azbz(i)*dps(i,07)+fps(i,16)
      dds(i,16)=ayby(i)*dps(i,08)+fps(i,14)
      dds(i,17)=azbz(i)*dps(i,08)+fps(i,17)
      dds(i,18)=azbz(i)*dps(i,09)+fps(i,18)
      dds(i,19)=axbx(i)*dps(i,10)+fps(i,10)
      dds(i,20)=ayby(i)*dps(i,10)+fps(i,19)
      dds(i,21)=azbz(i)*dps(i,10)+fps(i,22)
      dds(i,22)=ayby(i)*dps(i,11)+fps(i,20)
      dds(i,23)=azbz(i)*dps(i,11)+fps(i,23)
      dds(i,24)=azbz(i)*dps(i,12)+fps(i,24)
      dds(i,25)=axbx(i)*dps(i,13)+fps(i,13)
      dds(i,26)=ayby(i)*dps(i,13)+fps(i,22)
      dds(i,27)=azbz(i)*dps(i,13)+fps(i,25)
      dds(i,28)=ayby(i)*dps(i,14)+fps(i,23)
      dds(i,29)=azbz(i)*dps(i,14)+fps(i,26)
      dds(i,30)=azbz(i)*dps(i,15)+fps(i,27)
      dds(i,31)=axbx(i)*dps(i,16)+fps(i,16)
      dds(i,32)=ayby(i)*dps(i,16)+fps(i,25)
      dds(i,33)=azbz(i)*dps(i,16)+fps(i,28)
      dds(i,34)=ayby(i)*dps(i,17)+fps(i,26)
      dds(i,35)=azbz(i)*dps(i,17)+fps(i,29)
 1024 dds(i,36)=azbz(i)*dps(i,18)+fps(i,30)

      do 1025 i=1,m
      fock(inddyy(i,01))=fock(inddyy(i,01))+dds(i,01)*cdfits
      fock(inddyy(i,07))=fock(inddyy(i,07))+dds(i,07)*cdfits
      fock(inddyy(i,08))=fock(inddyy(i,08))+dds(i,08)*cdfits
      fock(inddyy(i,13))=fock(inddyy(i,13))+dds(i,13)*cdfits
      fock(inddyy(i,14))=fock(inddyy(i,14))+dds(i,14)*cdfits
      fock(inddyy(i,15))=fock(inddyy(i,15))+dds(i,15)*cdfits
      fock(inddyy(i,19))=fock(inddyy(i,19))+dds(i,19)*cdfits
      fock(inddyy(i,20))=fock(inddyy(i,20))+dds(i,20)*cdfits
      fock(inddyy(i,21))=fock(inddyy(i,21))+dds(i,21)*cdfits
      fock(inddyy(i,22))=fock(inddyy(i,22))+dds(i,22)*cdfits
      fock(inddyy(i,25))=fock(inddyy(i,25))+dds(i,25)*cdfits
      fock(inddyy(i,26))=fock(inddyy(i,26))+dds(i,26)*cdfits
      fock(inddyy(i,27))=fock(inddyy(i,27))+dds(i,27)*cdfits
      fock(inddyy(i,28))=fock(inddyy(i,28))+dds(i,28)*cdfits
      fock(inddyy(i,29))=fock(inddyy(i,29))+dds(i,29)*cdfits
      fock(inddyy(i,31))=fock(inddyy(i,31))+dds(i,31)*cdfits
      fock(inddyy(i,32))=fock(inddyy(i,32))+dds(i,32)*cdfits
      fock(inddyy(i,33))=fock(inddyy(i,33))+dds(i,33)*cdfits
      fock(inddyy(i,34))=fock(inddyy(i,34))+dds(i,34)*cdfits
      fock(inddyy(i,35))=fock(inddyy(i,35))+dds(i,35)*cdfits
 1025 fock(inddyy(i,36))=fock(inddyy(i,36))+dds(i,36)*cdfits

      do 1026 i=1,m
      if(iminj(i).ne.0) then

                 fock(inddyy(i,02))=fock(inddyy(i,02))+dds(i,02)*cdfits
                 fock(inddyy(i,03))=fock(inddyy(i,03))+dds(i,03)*cdfits
                 fock(inddyy(i,04))=fock(inddyy(i,04))+dds(i,04)*cdfits
                 fock(inddyy(i,05))=fock(inddyy(i,05))+dds(i,05)*cdfits
                 fock(inddyy(i,06))=fock(inddyy(i,06))+dds(i,06)*cdfits
                 fock(inddyy(i,09))=fock(inddyy(i,09))+dds(i,09)*cdfits
                 fock(inddyy(i,10))=fock(inddyy(i,10))+dds(i,10)*cdfits
                 fock(inddyy(i,11))=fock(inddyy(i,11))+dds(i,11)*cdfits
                 fock(inddyy(i,12))=fock(inddyy(i,12))+dds(i,12)*cdfits
                 fock(inddyy(i,16))=fock(inddyy(i,16))+dds(i,16)*cdfits
                 fock(inddyy(i,17))=fock(inddyy(i,17))+dds(i,17)*cdfits
                 fock(inddyy(i,18))=fock(inddyy(i,18))+dds(i,18)*cdfits
                 fock(inddyy(i,23))=fock(inddyy(i,23))+dds(i,23)*cdfits
                 fock(inddyy(i,24))=fock(inddyy(i,24))+dds(i,24)*cdfits
                 fock(inddyy(i,30))=fock(inddyy(i,30))+dds(i,30)*cdfits

                        endif
 1026 continue

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)
 2003 continue

      do 2004 i=1,n
      call augg(7,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
      sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux
      sss5(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(6)/zeta(i)/zetaux
      sss6(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(7)/zeta(i)/zetaux
 2004 continue

      nn=0

      do 2005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                       sss5(nn)=sss5(i)
                                       sss6(nn)=sss6(i)
                                 endif

 2005 continue

      do 2006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 2006 zetac2(i)=zzeta(i)*zetarec(i)

      do 2007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 2008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 2009 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      pss4(i,1)=ppxax(i)*sss4(i)+wxpx(i)*sss5(i)
      pss4(i,2)=ppyay(i)*sss4(i)+wypy(i)*sss5(i)
      pss4(i,3)=ppzaz(i)*sss4(i)+wzpz(i)*sss5(i)

      pss5(i,1)=ppxax(i)*sss5(i)+wxpx(i)*sss6(i)
      pss5(i,2)=ppyay(i)*sss5(i)+wypy(i)*sss6(i)
      pss5(i,3)=ppzaz(i)*sss5(i)+wzpz(i)*sss6(i)

 2009 continue

      do 2010 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      c(i)=(sss3(i)-zetac1(i)*sss4(i))/(two*zzeta(i))

      dss3(i,1)=ppxax(i)*pss3(i,1)+wxpx(i)*pss4(i,1)+c(i)
      dss3(i,2)=ppyay(i)*pss3(i,1)+wypy(i)*pss4(i,1)
      dss3(i,3)=ppzaz(i)*pss3(i,1)+wzpz(i)*pss4(i,1)
      dss3(i,4)=ppyay(i)*pss3(i,2)+wypy(i)*pss4(i,2)+c(i)
      dss3(i,5)=ppzaz(i)*pss3(i,2)+wzpz(i)*pss4(i,2)
      dss3(i,6)=ppzaz(i)*pss3(i,3)+wzpz(i)*pss4(i,3)+c(i)

      c(i)=(sss4(i)-zetac1(i)*sss5(i))/(two*zzeta(i))

      dss4(i,1)=ppxax(i)*pss4(i,1)+wxpx(i)*pss5(i,1)+c(i)
      dss4(i,2)=ppyay(i)*pss4(i,1)+wypy(i)*pss5(i,1)
      dss4(i,3)=ppzaz(i)*pss4(i,1)+wzpz(i)*pss5(i,1)
      dss4(i,4)=ppyay(i)*pss4(i,2)+wypy(i)*pss5(i,2)+c(i)
      dss4(i,5)=ppzaz(i)*pss4(i,2)+wzpz(i)*pss5(i,2)
      dss4(i,6)=ppzaz(i)*pss4(i,3)+wzpz(i)*pss5(i,3)+c(i)

 2010 continue

      do 2011 j=1,3
      do 2011 i=1,nn
 2011 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 2012 i=1,n
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 2012 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 2013 j=1,3
      do 2013 i=1,nn
 2013 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 2014 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 2014 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 2015 j=1,3
      do 2015 i=1,nn
 2015 c1(i,j)=(pss2(i,j)-zetac1(i)*pss3(i,j))/(two*zzeta(i))

      do 2016 i=1,nn
      fss2(i,01)=ppxax(i)*dss2(i,1)+wxpx(i)*dss3(i,1)+c1(i,1)+c1(i,1)
      fss2(i,02)=ppyay(i)*dss2(i,1)+wypy(i)*dss3(i,1)
      fss2(i,03)=ppzaz(i)*dss2(i,1)+wzpz(i)*dss3(i,1)
      fss2(i,04)=ppyay(i)*dss2(i,2)+wypy(i)*dss3(i,2)+c1(i,1)
      fss2(i,05)=ppzaz(i)*dss2(i,2)+wzpz(i)*dss3(i,2)
      fss2(i,06)=ppzaz(i)*dss2(i,3)+wzpz(i)*dss3(i,3)+c1(i,1)
      fss2(i,07)=ppyay(i)*dss2(i,4)+wypy(i)*dss3(i,4)+c1(i,2)+c1(i,2)
      fss2(i,08)=ppzaz(i)*dss2(i,4)+wzpz(i)*dss3(i,4)
      fss2(i,09)=ppzaz(i)*dss2(i,5)+wzpz(i)*dss3(i,5)+c1(i,2)
 2016 fss2(i,10)=ppzaz(i)*dss2(i,6)+wzpz(i)*dss3(i,6)+c1(i,3)+c1(i,3)

      do 2017 j=1,3
      do 2017 i=1,nn
 2017 c1(i,j)=(pss3(i,j)-zetac1(i)*pss4(i,j))/(two*zzeta(i))

      do 2018 i=1,nn
      fss3(i,01)=ppxax(i)*dss3(i,1)+wxpx(i)*dss4(i,1)+c1(i,1)+c1(i,1)
      fss3(i,02)=ppyay(i)*dss3(i,1)+wypy(i)*dss4(i,1)
      fss3(i,03)=ppzaz(i)*dss3(i,1)+wzpz(i)*dss4(i,1)
      fss3(i,04)=ppyay(i)*dss3(i,2)+wypy(i)*dss4(i,2)+c1(i,1)
      fss3(i,05)=ppzaz(i)*dss3(i,2)+wzpz(i)*dss4(i,2)
      fss3(i,06)=ppzaz(i)*dss3(i,3)+wzpz(i)*dss4(i,3)+c1(i,1)
      fss3(i,07)=ppyay(i)*dss3(i,4)+wypy(i)*dss4(i,4)+c1(i,2)+c1(i,2)
      fss3(i,08)=ppzaz(i)*dss3(i,4)+wzpz(i)*dss4(i,4)
      fss3(i,09)=ppzaz(i)*dss3(i,5)+wzpz(i)*dss4(i,5)+c1(i,2)
 2018 fss3(i,10)=ppzaz(i)*dss3(i,6)+wzpz(i)*dss4(i,6)+c1(i,3)+c1(i,3)

      do 2019 j=1,6
      do 2019 i=1,nn
 2019 c2(i,j)=(dss0(i,j)-zetac1(i)*dss1(i,j))/(two*zzeta(i))

      do 2020 i=1,nn
      gss0(i,01)=ppxax(i)*fss0(i,01)+wxpx(i)*fss1(i,01)+c2(i,1)*three
      gss0(i,02)=ppyay(i)*fss0(i,01)+wypy(i)*fss1(i,01)
      gss0(i,03)=ppzaz(i)*fss0(i,01)+wzpz(i)*fss1(i,01)
      gss0(i,04)=ppyay(i)*fss0(i,02)+wypy(i)*fss1(i,02)+c2(i,1)
      gss0(i,05)=ppzaz(i)*fss0(i,02)+wzpz(i)*fss1(i,02)
      gss0(i,06)=ppzaz(i)*fss0(i,03)+wzpz(i)*fss1(i,03)+c2(i,1)
      gss0(i,07)=ppyay(i)*fss0(i,04)+wypy(i)*fss1(i,04)+c2(i,2)*two
      gss0(i,08)=ppzaz(i)*fss0(i,04)+wzpz(i)*fss1(i,04)
      gss0(i,09)=ppzaz(i)*fss0(i,05)+wzpz(i)*fss1(i,05)+c2(i,2)
      gss0(i,10)=ppzaz(i)*fss0(i,06)+wzpz(i)*fss1(i,06)+c2(i,3)*two
      gss0(i,11)=ppyay(i)*fss0(i,07)+wypy(i)*fss1(i,07)+c2(i,4)*three
      gss0(i,12)=ppzaz(i)*fss0(i,07)+wzpz(i)*fss1(i,07)
      gss0(i,13)=ppzaz(i)*fss0(i,08)+wzpz(i)*fss1(i,08)+c2(i,4)
      gss0(i,14)=ppzaz(i)*fss0(i,09)+wzpz(i)*fss1(i,09)+c2(i,5)*two
 2020 gss0(i,15)=ppzaz(i)*fss0(i,10)+wzpz(i)*fss1(i,10)+c2(i,6)*three

      do 2021 j=1,6
      do 2021 i=1,nn
 2021 c2(i,j)=(dss1(i,j)-zetac1(i)*dss2(i,j))/(two*zzeta(i))

      do 2022 i=1,nn
      gss1(i,01)=ppxax(i)*fss1(i,01)+wxpx(i)*fss2(i,01)+c2(i,1)*three
      gss1(i,02)=ppyay(i)*fss1(i,01)+wypy(i)*fss2(i,01)
      gss1(i,03)=ppzaz(i)*fss1(i,01)+wzpz(i)*fss2(i,01)
      gss1(i,04)=ppyay(i)*fss1(i,02)+wypy(i)*fss2(i,02)+c2(i,1)
      gss1(i,05)=ppzaz(i)*fss1(i,02)+wzpz(i)*fss2(i,02)
      gss1(i,06)=ppzaz(i)*fss1(i,03)+wzpz(i)*fss2(i,03)+c2(i,1)
      gss1(i,07)=ppyay(i)*fss1(i,04)+wypy(i)*fss2(i,04)+c2(i,2)*two
      gss1(i,08)=ppzaz(i)*fss1(i,04)+wzpz(i)*fss2(i,04)
      gss1(i,09)=ppzaz(i)*fss1(i,05)+wzpz(i)*fss2(i,05)+c2(i,2)
      gss1(i,10)=ppzaz(i)*fss1(i,06)+wzpz(i)*fss2(i,06)+c2(i,3)*two
      gss1(i,11)=ppyay(i)*fss1(i,07)+wypy(i)*fss2(i,07)+c2(i,4)*three
      gss1(i,12)=ppzaz(i)*fss1(i,07)+wzpz(i)*fss2(i,07)
      gss1(i,13)=ppzaz(i)*fss1(i,08)+wzpz(i)*fss2(i,08)+c2(i,4)
      gss1(i,14)=ppzaz(i)*fss1(i,09)+wzpz(i)*fss2(i,09)+c2(i,5)*two
 2022 gss1(i,15)=ppzaz(i)*fss1(i,10)+wzpz(i)*fss2(i,10)+c2(i,6)*three

      do 2023 j=1,6
      do 2023 i=1,nn
 2023 c2(i,j)=(dss2(i,j)-zetac1(i)*dss3(i,j))/(two*zzeta(i))

      do 2024 i=1,nn
      gss2(i,01)=ppxax(i)*fss2(i,01)+wxpx(i)*fss3(i,01)+c2(i,1)*three
      gss2(i,02)=ppyay(i)*fss2(i,01)+wypy(i)*fss3(i,01)
      gss2(i,03)=ppzaz(i)*fss2(i,01)+wzpz(i)*fss3(i,01)
      gss2(i,04)=ppyay(i)*fss2(i,02)+wypy(i)*fss3(i,02)+c2(i,1)
      gss2(i,05)=ppzaz(i)*fss2(i,02)+wzpz(i)*fss3(i,02)
      gss2(i,06)=ppzaz(i)*fss2(i,03)+wzpz(i)*fss3(i,03)+c2(i,1)
      gss2(i,07)=ppyay(i)*fss2(i,04)+wypy(i)*fss3(i,04)+c2(i,2)*two
      gss2(i,08)=ppzaz(i)*fss2(i,04)+wzpz(i)*fss3(i,04)
      gss2(i,09)=ppzaz(i)*fss2(i,05)+wzpz(i)*fss3(i,05)+c2(i,2)
      gss2(i,10)=ppzaz(i)*fss2(i,06)+wzpz(i)*fss3(i,06)+c2(i,3)*two
      gss2(i,11)=ppyay(i)*fss2(i,07)+wypy(i)*fss3(i,07)+c2(i,4)*three
      gss2(i,12)=ppzaz(i)*fss2(i,07)+wzpz(i)*fss3(i,07)
      gss2(i,13)=ppzaz(i)*fss2(i,08)+wzpz(i)*fss3(i,08)+c2(i,4)
      gss2(i,14)=ppzaz(i)*fss2(i,09)+wzpz(i)*fss3(i,09)+c2(i,5)*two
 2024 gss2(i,15)=ppzaz(i)*fss2(i,10)+wzpz(i)*fss3(i,10)+c2(i,6)*three

      do 2025 i=1,nn

      c(i)=half*sss1(i)*zetarec(i)

      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
      psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2025 continue

      do 2026 j=1,3
      do 2026 i=1,nn
 2026 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 2027 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 2027 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 2028 j=1,3
      do 2028 i=1,nn
 2028 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 2029 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 2029 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 2030 j=1,6
      do 2030 i=1,nn
 2030 c2(i,j)=half*dss1(i,j)*zetarec(i)

      do 2031 i=1,nn
      fsp0(i,01)=wxcx(i)*fss1(i,01)+c2(i,1)*three
      fsp0(i,02)=wycy(i)*fss1(i,01)
      fsp0(i,03)=wzcz(i)*fss1(i,01)
      fsp0(i,04)=wxcx(i)*fss1(i,02)+c2(i,2)*two
      fsp0(i,05)=wycy(i)*fss1(i,02)+c2(i,1)
      fsp0(i,06)=wzcz(i)*fss1(i,02)
      fsp0(i,07)=wxcx(i)*fss1(i,03)+c2(i,3)*two
      fsp0(i,08)=wycy(i)*fss1(i,03)
      fsp0(i,09)=wzcz(i)*fss1(i,03)+c2(i,1)
      fsp0(i,10)=wxcx(i)*fss1(i,04)+c2(i,4)
      fsp0(i,11)=wycy(i)*fss1(i,04)+c2(i,2)*two
      fsp0(i,12)=wzcz(i)*fss1(i,04)
      fsp0(i,13)=wxcx(i)*fss1(i,05)+c2(i,5)
      fsp0(i,14)=wycy(i)*fss1(i,05)+c2(i,3)
      fsp0(i,15)=wzcz(i)*fss1(i,05)+c2(i,2)
      fsp0(i,16)=wxcx(i)*fss1(i,06)+c2(i,6)
      fsp0(i,17)=wycy(i)*fss1(i,06)
      fsp0(i,18)=wzcz(i)*fss1(i,06)+c2(i,3)*two
      fsp0(i,19)=wxcx(i)*fss1(i,07)
      fsp0(i,20)=wycy(i)*fss1(i,07)+c2(i,4)*three
      fsp0(i,21)=wzcz(i)*fss1(i,07)
      fsp0(i,22)=wxcx(i)*fss1(i,08)
      fsp0(i,23)=wycy(i)*fss1(i,08)+c2(i,5)*two
      fsp0(i,24)=wzcz(i)*fss1(i,08)+c2(i,4)
      fsp0(i,25)=wxcx(i)*fss1(i,09)
      fsp0(i,26)=wycy(i)*fss1(i,09)+c2(i,6)
      fsp0(i,27)=wzcz(i)*fss1(i,09)+c2(i,5)*two
      fsp0(i,28)=wxcx(i)*fss1(i,10)
      fsp0(i,29)=wycy(i)*fss1(i,10)
 2031 fsp0(i,30)=wzcz(i)*fss1(i,10)+c2(i,6)*three

      do 2032 j=1,6
      do 2032 i=1,nn
 2032 c2(i,j)=half*dss2(i,j)*zetarec(i)

      do 2033 i=1,nn
      fsp1(i,01)=wxcx(i)*fss2(i,01)+c2(i,1)*three
      fsp1(i,02)=wycy(i)*fss2(i,01)
      fsp1(i,03)=wzcz(i)*fss2(i,01)
      fsp1(i,04)=wxcx(i)*fss2(i,02)+c2(i,2)*two
      fsp1(i,05)=wycy(i)*fss2(i,02)+c2(i,1)
      fsp1(i,06)=wzcz(i)*fss2(i,02)
      fsp1(i,07)=wxcx(i)*fss2(i,03)+c2(i,3)*two
      fsp1(i,08)=wycy(i)*fss2(i,03)
      fsp1(i,09)=wzcz(i)*fss2(i,03)+c2(i,1)
      fsp1(i,10)=wxcx(i)*fss2(i,04)+c2(i,4)
      fsp1(i,11)=wycy(i)*fss2(i,04)+c2(i,2)*two
      fsp1(i,12)=wzcz(i)*fss2(i,04)
      fsp1(i,13)=wxcx(i)*fss2(i,05)+c2(i,5)
      fsp1(i,14)=wycy(i)*fss2(i,05)+c2(i,3)
      fsp1(i,15)=wzcz(i)*fss2(i,05)+c2(i,2)
      fsp1(i,16)=wxcx(i)*fss2(i,06)+c2(i,6)
      fsp1(i,17)=wycy(i)*fss2(i,06)
      fsp1(i,18)=wzcz(i)*fss2(i,06)+c2(i,3)*two
      fsp1(i,19)=wxcx(i)*fss2(i,07)
      fsp1(i,20)=wycy(i)*fss2(i,07)+c2(i,4)*three
      fsp1(i,21)=wzcz(i)*fss2(i,07)
      fsp1(i,22)=wxcx(i)*fss2(i,08)
      fsp1(i,23)=wycy(i)*fss2(i,08)+c2(i,5)*two
      fsp1(i,24)=wzcz(i)*fss2(i,08)+c2(i,4)
      fsp1(i,25)=wxcx(i)*fss2(i,09)
      fsp1(i,26)=wycy(i)*fss2(i,09)+c2(i,6)
      fsp1(i,27)=wzcz(i)*fss2(i,09)+c2(i,5)*two
      fsp1(i,28)=wxcx(i)*fss2(i,10)
      fsp1(i,29)=wycy(i)*fss2(i,10)
 2033 fsp1(i,30)=wzcz(i)*fss2(i,10)+c2(i,6)*three

      do 2034 j=1,10
      do 2034 i=1,nn
 2034 c3(i,j)=half*fss1(i,j)*zetarec(i)

      do 2035 i=1,nn
      gsp0(i,01)=wxcx(i)*gss1(i,01)+c3(i,01)*four
      gsp0(i,02)=wycy(i)*gss1(i,01)
      gsp0(i,03)=wzcz(i)*gss1(i,01)
      gsp0(i,04)=wxcx(i)*gss1(i,02)+c3(i,02)*three
      gsp0(i,05)=wycy(i)*gss1(i,02)+c3(i,01)
      gsp0(i,06)=wzcz(i)*gss1(i,02)
      gsp0(i,07)=wxcx(i)*gss1(i,03)+c3(i,03)*three
      gsp0(i,08)=wycy(i)*gss1(i,03)
      gsp0(i,09)=wzcz(i)*gss1(i,03)+c3(i,01)
      gsp0(i,10)=wxcx(i)*gss1(i,04)+c3(i,04)*two
      gsp0(i,11)=wycy(i)*gss1(i,04)+c3(i,02)*two
      gsp0(i,12)=wzcz(i)*gss1(i,04)
      gsp0(i,13)=wxcx(i)*gss1(i,05)+c3(i,05)*two
      gsp0(i,14)=wycy(i)*gss1(i,05)+c3(i,03)
      gsp0(i,15)=wzcz(i)*gss1(i,05)+c3(i,02)
      gsp0(i,16)=wxcx(i)*gss1(i,06)+c3(i,06)*two
      gsp0(i,17)=wycy(i)*gss1(i,06)
      gsp0(i,18)=wzcz(i)*gss1(i,06)+c3(i,03)*two
      gsp0(i,19)=wxcx(i)*gss1(i,07)+c3(i,07)
      gsp0(i,20)=wycy(i)*gss1(i,07)+c3(i,04)*three
      gsp0(i,21)=wzcz(i)*gss1(i,07)
      gsp0(i,22)=wxcx(i)*gss1(i,08)+c3(i,08)
      gsp0(i,23)=wycy(i)*gss1(i,08)+c3(i,05)*two
      gsp0(i,24)=wzcz(i)*gss1(i,08)+c3(i,04)
      gsp0(i,25)=wxcx(i)*gss1(i,09)+c3(i,09)
      gsp0(i,26)=wycy(i)*gss1(i,09)+c3(i,06)
      gsp0(i,27)=wzcz(i)*gss1(i,09)+c3(i,05)*two
      gsp0(i,28)=wxcx(i)*gss1(i,10)+c3(i,10)
      gsp0(i,29)=wycy(i)*gss1(i,10)
      gsp0(i,30)=wzcz(i)*gss1(i,10)+c3(i,06)*three
      gsp0(i,31)=wxcx(i)*gss1(i,11)
      gsp0(i,32)=wycy(i)*gss1(i,11)+c3(i,07)*four
      gsp0(i,33)=wzcz(i)*gss1(i,11)
      gsp0(i,34)=wxcx(i)*gss1(i,12)
      gsp0(i,35)=wycy(i)*gss1(i,12)+c3(i,08)*three
      gsp0(i,36)=wzcz(i)*gss1(i,12)+c3(i,07)
      gsp0(i,37)=wxcx(i)*gss1(i,13)
      gsp0(i,38)=wycy(i)*gss1(i,13)+c3(i,09)*two
      gsp0(i,39)=wzcz(i)*gss1(i,13)+c3(i,08)*two
      gsp0(i,40)=wxcx(i)*gss1(i,14)
      gsp0(i,41)=wycy(i)*gss1(i,14)+c3(i,10)
      gsp0(i,42)=wzcz(i)*gss1(i,14)+c3(i,09)*three
      gsp0(i,43)=wxcx(i)*gss1(i,15)
      gsp0(i,44)=wycy(i)*gss1(i,15)
 2035 gsp0(i,45)=wzcz(i)*gss1(i,15)+c3(i,10)*four

      do 2036 j=1,10
      do 2036 i=1,nn
 2036 c3(i,j)=half*fss2(i,j)*zetarec(i)

      do 2037 i=1,nn
      gsp1(i,01)=wxcx(i)*gss2(i,01)+c3(i,01)*four
      gsp1(i,02)=wycy(i)*gss2(i,01)
      gsp1(i,03)=wzcz(i)*gss2(i,01)
      gsp1(i,04)=wxcx(i)*gss2(i,02)+c3(i,02)*three
      gsp1(i,05)=wycy(i)*gss2(i,02)+c3(i,01)
      gsp1(i,06)=wzcz(i)*gss2(i,02)
      gsp1(i,07)=wxcx(i)*gss2(i,03)+c3(i,03)*three
      gsp1(i,08)=wycy(i)*gss2(i,03)
      gsp1(i,09)=wzcz(i)*gss2(i,03)+c3(i,01)
      gsp1(i,10)=wxcx(i)*gss2(i,04)+c3(i,04)*two
      gsp1(i,11)=wycy(i)*gss2(i,04)+c3(i,02)*two
      gsp1(i,12)=wzcz(i)*gss2(i,04)
      gsp1(i,13)=wxcx(i)*gss2(i,05)+c3(i,05)*two
      gsp1(i,14)=wycy(i)*gss2(i,05)+c3(i,03)
      gsp1(i,15)=wzcz(i)*gss2(i,05)+c3(i,02)
      gsp1(i,16)=wxcx(i)*gss2(i,06)+c3(i,06)*two
      gsp1(i,17)=wycy(i)*gss2(i,06)
      gsp1(i,18)=wzcz(i)*gss2(i,06)+c3(i,03)*two
      gsp1(i,19)=wxcx(i)*gss2(i,07)+c3(i,07)
      gsp1(i,20)=wycy(i)*gss2(i,07)+c3(i,04)*three
      gsp1(i,21)=wzcz(i)*gss2(i,07)
      gsp1(i,22)=wxcx(i)*gss2(i,08)+c3(i,08)
      gsp1(i,23)=wycy(i)*gss2(i,08)+c3(i,05)*two
      gsp1(i,24)=wzcz(i)*gss2(i,08)+c3(i,04)
      gsp1(i,25)=wxcx(i)*gss2(i,09)+c3(i,09)
      gsp1(i,26)=wycy(i)*gss2(i,09)+c3(i,06)
      gsp1(i,27)=wzcz(i)*gss2(i,09)+c3(i,05)*two
      gsp1(i,28)=wxcx(i)*gss2(i,10)+c3(i,10)
      gsp1(i,29)=wycy(i)*gss2(i,10)
      gsp1(i,30)=wzcz(i)*gss2(i,10)+c3(i,06)*three
      gsp1(i,31)=wxcx(i)*gss2(i,11)
      gsp1(i,32)=wycy(i)*gss2(i,11)+c3(i,07)*four
      gsp1(i,33)=wzcz(i)*gss2(i,11)
      gsp1(i,34)=wxcx(i)*gss2(i,12)
      gsp1(i,35)=wycy(i)*gss2(i,12)+c3(i,08)*three
      gsp1(i,36)=wzcz(i)*gss2(i,12)+c3(i,07)
      gsp1(i,37)=wxcx(i)*gss2(i,13)
      gsp1(i,38)=wycy(i)*gss2(i,13)+c3(i,09)*two
      gsp1(i,39)=wzcz(i)*gss2(i,13)+c3(i,08)*two
      gsp1(i,40)=wxcx(i)*gss2(i,14)
      gsp1(i,41)=wycy(i)*gss2(i,14)+c3(i,10)
      gsp1(i,42)=wzcz(i)*gss2(i,14)+c3(i,09)*three
      gsp1(i,43)=wxcx(i)*gss2(i,15)
      gsp1(i,44)=wycy(i)*gss2(i,15)
 2037 gsp1(i,45)=wzcz(i)*gss2(i,15)+c3(i,10)*four

      do 2038 j=1,6
      do 2038 i=1,nn
 2038 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 2039 j=1,9
      do 2039 i=1,nn
 2039 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 2040 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 2040 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 2041 j=1,10
      do 2041 i=1,nn
 2041 c4(i,j)=(fss0(i,j)-zetac2(i)*fss1(i,j))/(two*zetaux)

      do 2042 j=1,18
      do 2042 i=1,nn
 2042 c5(i,j)=half*dsp1(i,j)*zetarec(i)

      do 2043 i=1,nn
      fsd0(i,01)=wxcx(i)*fsp1(i,01)+c4(i,01)+c5(i,01)*three
      fsd0(i,02)=wycy(i)*fsp1(i,01)
      fsd0(i,03)=wzcz(i)*fsp1(i,01)
      fsd0(i,04)=wycy(i)*fsp1(i,02)+c4(i,01)
      fsd0(i,05)=wzcz(i)*fsp1(i,02)
      fsd0(i,06)=wzcz(i)*fsp1(i,03)+c4(i,01)
      fsd0(i,07)=wxcx(i)*fsp1(i,04)+c4(i,02)+c5(i,04)*two
      fsd0(i,08)=wycy(i)*fsp1(i,04)         +c5(i,01)
      fsd0(i,09)=wzcz(i)*fsp1(i,04)
      fsd0(i,10)=wycy(i)*fsp1(i,05)+c4(i,02)+c5(i,02)
      fsd0(i,11)=wzcz(i)*fsp1(i,05)
      fsd0(i,12)=wzcz(i)*fsp1(i,06)+c4(i,02)
      fsd0(i,13)=wxcx(i)*fsp1(i,07)+c4(i,03)+c5(i,07)*two
      fsd0(i,14)=wycy(i)*fsp1(i,07)
      fsd0(i,15)=wzcz(i)*fsp1(i,07)         +c5(i,01)
      fsd0(i,16)=wycy(i)*fsp1(i,08)+c4(i,03)
      fsd0(i,17)=wzcz(i)*fsp1(i,08)         +c5(i,02)
      fsd0(i,18)=wzcz(i)*fsp1(i,09)+c4(i,03)+c5(i,03)
      fsd0(i,19)=wxcx(i)*fsp1(i,10)+c4(i,04)+c5(i,10)
      fsd0(i,20)=wycy(i)*fsp1(i,10)         +c5(i,04)*two
      fsd0(i,21)=wzcz(i)*fsp1(i,10)
      fsd0(i,22)=wycy(i)*fsp1(i,11)+c4(i,04)+c5(i,05)*two
      fsd0(i,23)=wzcz(i)*fsp1(i,11)
      fsd0(i,24)=wzcz(i)*fsp1(i,12)+c4(i,04)
      fsd0(i,25)=wxcx(i)*fsp1(i,13)+c4(i,05)+c5(i,13)
      fsd0(i,26)=wycy(i)*fsp1(i,13)         +c5(i,07)
      fsd0(i,27)=wzcz(i)*fsp1(i,13)         +c5(i,04)
      fsd0(i,28)=wycy(i)*fsp1(i,14)+c4(i,05)+c5(i,08)
      fsd0(i,29)=wzcz(i)*fsp1(i,14)         +c5(i,05)
      fsd0(i,30)=wzcz(i)*fsp1(i,15)+c4(i,05)+c5(i,06)
      fsd0(i,31)=wxcx(i)*fsp1(i,16)+c4(i,06)+c5(i,16)
      fsd0(i,32)=wycy(i)*fsp1(i,16)
      fsd0(i,33)=wzcz(i)*fsp1(i,16)         +c5(i,07)*two
      fsd0(i,34)=wycy(i)*fsp1(i,17)+c4(i,06)
      fsd0(i,35)=wzcz(i)*fsp1(i,17)         +c5(i,08)*two
      fsd0(i,36)=wzcz(i)*fsp1(i,18)+c4(i,06)+c5(i,09)*two
      fsd0(i,37)=wxcx(i)*fsp1(i,19)+c4(i,07)
      fsd0(i,38)=wycy(i)*fsp1(i,19)         +c5(i,10)*three
      fsd0(i,39)=wzcz(i)*fsp1(i,19)
      fsd0(i,40)=wycy(i)*fsp1(i,20)+c4(i,07)+c5(i,11)*three
      fsd0(i,41)=wzcz(i)*fsp1(i,20)
      fsd0(i,42)=wzcz(i)*fsp1(i,21)+c4(i,07)
      fsd0(i,43)=wxcx(i)*fsp1(i,22)+c4(i,08)
      fsd0(i,44)=wycy(i)*fsp1(i,22)         +c5(i,13)*two
      fsd0(i,45)=wzcz(i)*fsp1(i,22)         +c5(i,10)
      fsd0(i,46)=wycy(i)*fsp1(i,23)+c4(i,08)+c5(i,14)*two
      fsd0(i,47)=wzcz(i)*fsp1(i,23)         +c5(i,11)
      fsd0(i,48)=wzcz(i)*fsp1(i,24)+c4(i,08)+c5(i,12)
      fsd0(i,49)=wxcx(i)*fsp1(i,25)+c4(i,09)
      fsd0(i,50)=wycy(i)*fsp1(i,25)         +c5(i,16)
      fsd0(i,51)=wzcz(i)*fsp1(i,25)         +c5(i,13)*two
      fsd0(i,52)=wycy(i)*fsp1(i,26)+c4(i,09)+c5(i,17)
      fsd0(i,53)=wzcz(i)*fsp1(i,26)         +c5(i,14)*two
      fsd0(i,54)=wzcz(i)*fsp1(i,27)+c4(i,09)+c5(i,15)*two
      fsd0(i,55)=wxcx(i)*fsp1(i,28)+c4(i,10)
      fsd0(i,56)=wycy(i)*fsp1(i,28)
      fsd0(i,57)=wzcz(i)*fsp1(i,28)         +c5(i,16)*three
      fsd0(i,58)=wycy(i)*fsp1(i,29)+c4(i,10)
      fsd0(i,59)=wzcz(i)*fsp1(i,29)         +c5(i,17)*three
 2043 fsd0(i,60)=wzcz(i)*fsp1(i,30)+c4(i,10)+c5(i,18)*three

      do 2044 j=1,15
      do 2044 i=1,nn
 2044 c4(i,j)=(gss0(i,j)-zetac2(i)*gss1(i,j))/(two*zetaux)

      do 2045 j=1,30
      do 2045 i=1,nn
 2045 c5(i,j)=half*fsp1(i,j)*zetarec(i)

      do 2046 i=1,nn
      gsd0(i,01)=wxcx(i)*gsp1(i,01)+c4(i,01)+c5(i,01)*four
      gsd0(i,02)=wycy(i)*gsp1(i,01)
      gsd0(i,03)=wzcz(i)*gsp1(i,01)
      gsd0(i,04)=wycy(i)*gsp1(i,02)+c4(i,01)
      gsd0(i,05)=wzcz(i)*gsp1(i,02)
      gsd0(i,06)=wzcz(i)*gsp1(i,03)+c4(i,01)
      gsd0(i,07)=wxcx(i)*gsp1(i,04)+c4(i,02)+c5(i,04)*three
      gsd0(i,08)=wycy(i)*gsp1(i,04)         +c5(i,01)
      gsd0(i,09)=wzcz(i)*gsp1(i,04)
      gsd0(i,10)=wycy(i)*gsp1(i,05)+c4(i,02)+c5(i,02)
      gsd0(i,11)=wzcz(i)*gsp1(i,05)
      gsd0(i,12)=wzcz(i)*gsp1(i,06)+c4(i,02)
      gsd0(i,13)=wxcx(i)*gsp1(i,07)+c4(i,03)+c5(i,07)*three
      gsd0(i,14)=wycy(i)*gsp1(i,07)
      gsd0(i,15)=wzcz(i)*gsp1(i,07)         +c5(i,01)
      gsd0(i,16)=wycy(i)*gsp1(i,08)+c4(i,03)
      gsd0(i,17)=wzcz(i)*gsp1(i,08)         +c5(i,02)
      gsd0(i,18)=wzcz(i)*gsp1(i,09)+c4(i,03)+c5(i,03)
      gsd0(i,19)=wxcx(i)*gsp1(i,10)+c4(i,04)+c5(i,10)*two
      gsd0(i,20)=wycy(i)*gsp1(i,10)         +c5(i,04)*two
      gsd0(i,21)=wzcz(i)*gsp1(i,10)
      gsd0(i,22)=wycy(i)*gsp1(i,11)+c4(i,04)+c5(i,05)*two
      gsd0(i,23)=wzcz(i)*gsp1(i,11)
      gsd0(i,24)=wzcz(i)*gsp1(i,12)+c4(i,04)
      gsd0(i,25)=wxcx(i)*gsp1(i,13)+c4(i,05)+c5(i,13)*two
      gsd0(i,26)=wycy(i)*gsp1(i,13)         +c5(i,07)
      gsd0(i,27)=wzcz(i)*gsp1(i,13)         +c5(i,04)
      gsd0(i,28)=wycy(i)*gsp1(i,14)+c4(i,05)+c5(i,08)
      gsd0(i,29)=wzcz(i)*gsp1(i,14)         +c5(i,05)
      gsd0(i,30)=wzcz(i)*gsp1(i,15)+c4(i,05)+c5(i,06)
      gsd0(i,31)=wxcx(i)*gsp1(i,16)+c4(i,06)+c5(i,16)*two
      gsd0(i,32)=wycy(i)*gsp1(i,16)
      gsd0(i,33)=wzcz(i)*gsp1(i,16)         +c5(i,07)*two
      gsd0(i,34)=wycy(i)*gsp1(i,17)+c4(i,06)
      gsd0(i,35)=wzcz(i)*gsp1(i,17)         +c5(i,08)*two
      gsd0(i,36)=wzcz(i)*gsp1(i,18)+c4(i,06)+c5(i,09)*two
      gsd0(i,37)=wxcx(i)*gsp1(i,19)+c4(i,07)+c5(i,19)
      gsd0(i,38)=wycy(i)*gsp1(i,19)         +c5(i,10)*three
      gsd0(i,39)=wzcz(i)*gsp1(i,19)
      gsd0(i,40)=wycy(i)*gsp1(i,20)+c4(i,07)+c5(i,11)*three
      gsd0(i,41)=wzcz(i)*gsp1(i,20)
      gsd0(i,42)=wzcz(i)*gsp1(i,21)+c4(i,07)
      gsd0(i,43)=wxcx(i)*gsp1(i,22)+c4(i,08)+c5(i,22)
      gsd0(i,44)=wycy(i)*gsp1(i,22)         +c5(i,13)*two
      gsd0(i,45)=wzcz(i)*gsp1(i,22)         +c5(i,10)
      gsd0(i,46)=wycy(i)*gsp1(i,23)+c4(i,08)+c5(i,14)*two
      gsd0(i,47)=wzcz(i)*gsp1(i,23)         +c5(i,11)
      gsd0(i,48)=wzcz(i)*gsp1(i,24)+c4(i,08)+c5(i,12)
      gsd0(i,49)=wxcx(i)*gsp1(i,25)+c4(i,09)+c5(i,25)
      gsd0(i,50)=wycy(i)*gsp1(i,25)         +c5(i,16)
      gsd0(i,51)=wzcz(i)*gsp1(i,25)         +c5(i,13)*two
      gsd0(i,52)=wycy(i)*gsp1(i,26)+c4(i,09)+c5(i,17)
      gsd0(i,53)=wzcz(i)*gsp1(i,26)         +c5(i,14)*two
      gsd0(i,54)=wzcz(i)*gsp1(i,27)+c4(i,09)+c5(i,15)*two
      gsd0(i,55)=wxcx(i)*gsp1(i,28)+c4(i,10)+c5(i,28)
      gsd0(i,56)=wycy(i)*gsp1(i,28)
      gsd0(i,57)=wzcz(i)*gsp1(i,28)         +c5(i,16)*three
      gsd0(i,58)=wycy(i)*gsp1(i,29)+c4(i,10)
      gsd0(i,59)=wzcz(i)*gsp1(i,29)         +c5(i,17)*three
      gsd0(i,60)=wzcz(i)*gsp1(i,30)+c4(i,10)+c5(i,18)*three
      gsd0(i,61)=wxcx(i)*gsp1(i,31)+c4(i,11)
      gsd0(i,62)=wycy(i)*gsp1(i,31)         +c5(i,19)*four
      gsd0(i,63)=wzcz(i)*gsp1(i,31)
      gsd0(i,64)=wycy(i)*gsp1(i,32)+c4(i,11)+c5(i,20)*four
      gsd0(i,65)=wzcz(i)*gsp1(i,32)
      gsd0(i,66)=wzcz(i)*gsp1(i,33)+c4(i,11)
      gsd0(i,67)=wxcx(i)*gsp1(i,34)+c4(i,12)
      gsd0(i,68)=wycy(i)*gsp1(i,34)         +c5(i,22)*three
      gsd0(i,69)=wzcz(i)*gsp1(i,34)         +c5(i,19)
      gsd0(i,70)=wycy(i)*gsp1(i,35)+c4(i,12)+c5(i,23)*three
      gsd0(i,71)=wzcz(i)*gsp1(i,35)         +c5(i,20)
      gsd0(i,72)=wzcz(i)*gsp1(i,36)+c4(i,12)+c5(i,21)
      gsd0(i,73)=wxcx(i)*gsp1(i,37)+c4(i,13)
      gsd0(i,74)=wycy(i)*gsp1(i,37)         +c5(i,25)*two
      gsd0(i,75)=wzcz(i)*gsp1(i,37)         +c5(i,22)*two
      gsd0(i,76)=wycy(i)*gsp1(i,38)+c4(i,13)+c5(i,26)*two
      gsd0(i,77)=wzcz(i)*gsp1(i,38)         +c5(i,23)*two
      gsd0(i,78)=wzcz(i)*gsp1(i,39)+c4(i,13)+c5(i,24)*two
      gsd0(i,79)=wxcx(i)*gsp1(i,40)+c4(i,14)
      gsd0(i,80)=wycy(i)*gsp1(i,40)         +c5(i,28)
      gsd0(i,81)=wzcz(i)*gsp1(i,40)         +c5(i,25)*three
      gsd0(i,82)=wycy(i)*gsp1(i,41)+c4(i,14)+c5(i,29)
      gsd0(i,83)=wzcz(i)*gsp1(i,41)         +c5(i,26)*three
      gsd0(i,84)=wzcz(i)*gsp1(i,42)+c4(i,14)+c5(i,27)*three
      gsd0(i,85)=wxcx(i)*gsp1(i,43)+c4(i,15)
      gsd0(i,86)=wycy(i)*gsp1(i,43)
      gsd0(i,87)=wzcz(i)*gsp1(i,43)         +c5(i,28)*four
      gsd0(i,88)=wycy(i)*gsp1(i,44)+c4(i,15)
      gsd0(i,89)=wzcz(i)*gsp1(i,44)         +c5(i,29)*four
 2046 gsd0(i,90)=wzcz(i)*gsp1(i,45)+c4(i,15)+c5(i,30)*four

      call chrgdd1(m,n,nn,iicontr,axbx,ayby,azbz,dss,dss0,fss,fss0,gss,
     &             gss0,dsp,dsp0,fsp,fsp0,gsp,gsp0,dsd,dsd0,fsd,fsd0,
     &             gsd,gsd0,dps,fps,dds,dpp,fpp,ddp,dpd,fpd,ddd)

      call chrgdd2(m,iminj,inddyy,cdfits,cdfitp,cdfitd,fock,dds,ddp,ddd)

 2001 continue

      do 3001 i=1,n
 3001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      do 3002 i=1,m
      fock(inddyy(i,01))=fock(inddyy(i,01))/three
      fock(inddyy(i,07))=fock(inddyy(i,07))/sqrt3
      fock(inddyy(i,13))=fock(inddyy(i,13))/sqrt3
      fock(inddyy(i,19))=fock(inddyy(i,19))/three
      fock(inddyy(i,20))=fock(inddyy(i,20))/sqrt3
      fock(inddyy(i,21))=fock(inddyy(i,21))/sqrt3
      fock(inddyy(i,22))=fock(inddyy(i,22))/three
      fock(inddyy(i,25))=fock(inddyy(i,25))/sqrt3
      fock(inddyy(i,28))=fock(inddyy(i,28))/sqrt3
      fock(inddyy(i,31))=fock(inddyy(i,31))/three
      fock(inddyy(i,32))=fock(inddyy(i,32))/sqrt3
      fock(inddyy(i,33))=fock(inddyy(i,33))/sqrt3
      fock(inddyy(i,34))=fock(inddyy(i,34))/three
      fock(inddyy(i,35))=fock(inddyy(i,35))/sqrt3
 3002 fock(inddyy(i,36))=fock(inddyy(i,36))/three

      do 3003 i=1,m
      if(iminj(i).ne.0) then

                      fock(inddyy(i,02))=fock(inddyy(i,02))/sqrt3
                      fock(inddyy(i,03))=fock(inddyy(i,03))/sqrt3
                      fock(inddyy(i,04))=fock(inddyy(i,04))/three
                      fock(inddyy(i,05))=fock(inddyy(i,05))/sqrt3
                      fock(inddyy(i,06))=fock(inddyy(i,06))/three
                      fock(inddyy(i,10))=fock(inddyy(i,10))/sqrt3
                      fock(inddyy(i,12))=fock(inddyy(i,12))/sqrt3
                      fock(inddyy(i,16))=fock(inddyy(i,16))/sqrt3
                      fock(inddyy(i,18))=fock(inddyy(i,18))/sqrt3
                      fock(inddyy(i,23))=fock(inddyy(i,23))/sqrt3
                      fock(inddyy(i,24))=fock(inddyy(i,24))/three
                      fock(inddyy(i,30))=fock(inddyy(i,30))/sqrt3

                        endif
 3003 continue

      return
      end
