      subroutine chrgds(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,iicontr,
     &                  inddyy,g,coord,cdfitc,alphaaux,coeffs,coeffp,
     &                  coeffd,fock,zeta,px,py,pz,base,pxax,pyay,pzaz,u,
     &                  zetarec,wxcx,wycy,wzcz,wxpx,wypy,wzpz,sss0,sss1,
     &                  sss2,sss3,sss4,pss0,pss1,pss2,pss3,dss,dss0,
     &                  dss1,dss2,psp1,dsp,dsp0,dsp1,dsd,dsd0,zetac1,
     &                  zetac2,c,c1,c2,c3,zzeta,ppx,ppy,ppz,ppxax,ppyay,
     &                  ppzaz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),iicontr(*),inddyy(m,*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),pxax(*),pyay(*),pzaz(*),u(*),zetarec(*),wxcx(*),
     &          wycy(*),wzcz(*),wxpx(*),wypy(*),wzpz(*),sss0(*),sss1(*),
     &          sss2(*),sss3(*),sss4(*),pss0(n,*),pss1(n,*),pss2(n,*),
     &          pss3(n,*),dss(m,*),dss0(n,*),dss1(n,*),dss2(n,*),
     &          psp1(n,*),dsp(m,*),dsp0(n,*),dsp1(n,*),dsd(m,*),
     &          dsd0(n,*),zetac1(*),zetac2(*),c(*),c1(n,*),c2(n,*),
     &          c3(n,*),zzeta(*),ppx(*),ppy(*),ppz(*),ppxax(*),ppyay(*),
     &          ppzaz(*)

      data one,two,three,five,seven/1.0,2.0,3.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(3,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
 1004 sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                 endif

 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

 1008 continue

      do 1009 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

 1009 continue

      do 1010 j=1,6
      do 1010 i=1,m
 1010 dss(i,j)=zero

      do 1011 j=1,6
      do 1011 i=1,nn
 1011 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 1012 j=1,6
      do 1012 i=1,m
 1012 fock(inddyy(i,j))=fock(inddyy(i,j))+dss(i,j)*cdfits

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      call augg(5,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
 2004 sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux

      nn=0

      do 2005 i=1,n

      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                 endif

 2005 continue

      do 2006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 2006 zetac2(i)=zzeta(i)*zetarec(i)

      do 2007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 2008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 2009 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

 2009 continue

      do 2010 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

 2010 continue

      do 2011 i=1,nn

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2011 continue

      do 2012 j=1,3
      do 2012 i=1,nn
 2012 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 2013 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 2013 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 2014 j=1,3
      do 2014 i=1,nn
 2014 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 2015 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 2015 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 2016 j=1,6
      do 2016 i=1,nn
 2016 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 2017 j=1,9
      do 2017 i=1,nn
 2017 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 2018 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 2018 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 2019 j=1,6
      do 2019 i=1,m
 2019 dss(i,j)=zero

      do 2020 j=1,18
      do 2020 i=1,m
 2020 dsp(i,j)=zero

      do 2021 j=1,36
      do 2021 i=1,m
 2021 dsd(i,j)=zero

      do 2022 j=1,6
      do 2022 i=1,nn
 2022 dss(iicontr(i),j)=dss(iicontr(i),j)+dss0(i,j)

      do 2023 j=1,18
      do 2023 i=1,nn
 2023 dsp(iicontr(i),j)=dsp(iicontr(i),j)+dsp0(i,j)

      do 2024 j=1,36
      do 2024 i=1,nn
 2024 dsd(iicontr(i),j)=dsd(iicontr(i),j)+dsd0(i,j)

      do 2025 j=1,6
      do 2025 i=1,m
 2025 fock(inddyy(i,j))=fock(inddyy(i,j))+dss(i,j)*cdfits

      do 2026 k=1,3
      do 2026 j=1,6
      do 2026 i=1,m
 2026 fock(inddyy(i,j))=fock(inddyy(i,j))+dsp(i,3*(j-1)+k)*cdfitp(k)

      do 2027 k=1,6
      do 2027 j=1,6
      do 2027 i=1,m
 2027 fock(inddyy(i,j))=fock(inddyy(i,j))+dsd(i,6*(j-1)+k)*cdfitd(k)

 2001 continue

      do 3001 i=1,n
 3001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      do 3002 i=1,m
      fock(inddyy(i,1))=fock(inddyy(i,1))/sqrt3
      fock(inddyy(i,4))=fock(inddyy(i,4))/sqrt3
 3002 fock(inddyy(i,6))=fock(inddyy(i,6))/sqrt3

      return
      end
