      subroutine dipolemm(nreal,ninteger,natoms,nconts,ncontp,ncontd,
     &                    nshels,nshelp,nsheld,mtloca,iprimvc,nprimvc,
     &                    icentvc,iwkvec,dipole,coord,charge,alpha,
     &                    coeff,dmata,dmatb,density,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nshels(*),nshelp(*),nsheld(*),mtloca(*),iprimvc(*),
     &          nprimvc(*),icentvc(*),iwkvec(*)

      dimension dipole(*),coord(3,*),charge(*),alpha(*),coeff(*),
     &          dmata(*),dmatb(*),density(*),wkvec(*)

      data zero,three,debye/0.0,3.0,2.54176568/

      sqrt3=sqrt(three)

      ncontractions=nconts+3*ncontp+6*ncontd

      do 1001 i=1,ncontractions*(ncontractions+1)/2
 1001 density(i)=dmata(i)+dmatb(i)

      do 1002 i=1,ncontd
      do 1002 j=1,nconts

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshels(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3

 1002 continue

      do 1003 i=1,ncontd
      do 1003 j=1,ncontp

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshelp(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+1)=density(i4+1)/sqrt3
      density(i4+2)=density(i4+2)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3

 1003 continue

      do 1004 i=1,ncontd
      do 1004 j=1,i

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nsheld(j))
      i4=i2+i3

      density(i4)=density(i4)/three
      if(i.ne.j) density(i4+1)=density(i4+1)/sqrt3
      if(i.ne.j) density(i4+2)=density(i4+2)/sqrt3
      if(i.ne.j) density(i4+3)=density(i4+3)/three
      if(i.ne.j) density(i4+4)=density(i4+4)/sqrt3
      if(i.ne.j) density(i4+5)=density(i4+5)/three

      density(i4+i1)=density(i4+i1)/sqrt3
      if(i.ne.j) density(i4+i1+3)=density(i4+i1+3)/sqrt3
      if(i.ne.j) density(i4+i1+5)=density(i4+i1+5)/sqrt3

      density(i4+i1*2+1)=density(i4+i1*2+1)/sqrt3
      if(i.ne.j) density(i4+i1*2+4)=density(i4+i1*2+4)/sqrt3
      if(i.ne.j) density(i4+i1*2+6)=density(i4+i1*2+6)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/three
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3
      density(i4+i1*3+6)=density(i4+i1*3+6)/three
      if(i.ne.j) density(i4+i1*3+7)=density(i4+i1*3+7)/sqrt3
      if(i.ne.j) density(i4+i1*3+8)=density(i4+i1*3+8)/three

      density(i4+i1*4+6)=density(i4+i1*4+6)/sqrt3
      density(i4+i1*4+9)=density(i4+i1*4+9)/sqrt3
      if(i.ne.j) density(i4+i1*4+11)=density(i4+i1*4+11)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/three
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3
      density(i4+i1*5+13)=density(i4+i1*5+13)/three
      density(i4+i1*5+14)=density(i4+i1*5+14)/sqrt3
      density(i4+i1*5+15)=density(i4+i1*5+15)/three

 1004 continue

      do 1005 i=1,3
 1005 dipole(i)=zero

      do 1006 i=1,natoms
      do 1006 j=1,3
 1006 dipole(j)=dipole(j)+coord(j,i)*charge(i)

      ncposs=nconts*(nconts+1)/2
      ncpopp=ncontp*(ncontp+1)/2
      ncpodd=ncontd*(ncontd+1)/2

      ncpops=ncontp*nconts
      ncpods=ncontd*nconts
      ncpodp=ncontd*ncontp

      npposs=0
      nppops=0
      nppopp=0
      nppods=0
      nppodp=0
      nppodd=0

      do 1007 i=1,nconts
      do 1007 j=1,i
 1007 npposs=npposs+nprimvc(nshels(i))*nprimvc(nshels(j))

      do 1008 i=1,ncontp
      do 1008 j=1,nconts
 1008 nppops=nppops+nprimvc(nshelp(i))*nprimvc(nshels(j))

      do 1009 i=1,ncontp
      do 1009 j=1,i
 1009 nppopp=nppopp+nprimvc(nshelp(i))*nprimvc(nshelp(j))

      do 1010 i=1,ncontd
      do 1010 j=1,nconts
 1010 nppods=nppods+nprimvc(nsheld(i))*nprimvc(nshels(j))

      do 1011 i=1,ncontd
      do 1011 j=1,ncontp
 1011 nppodp=nppodp+nprimvc(nsheld(i))*nprimvc(nshelp(j))

      do 1012 i=1,ncontd
      do 1012 j=1,i
 1012 nppodd=nppodd+nprimvc(nsheld(i))*nprimvc(nsheld(j))

      ja=1
      jb=ja+npposs
      jc=jb+ncposs

      if(jc.gt.ninteger) stop 'dipolemm ss integer overflow'

      je=1
      jf=je+npposs
      jg=jf+npposs
      jh=jg+npposs
      ji=jh+npposs
      jj=ji+npposs
      jk=jj+npposs
      jl=jk+npposs
      jm=jl+npposs
      jn=jm+npposs
      jo=jn+npposs
      jp=jo+npposs
      jq=jp+npposs

      if(jq.gt.nreal) stop 'dipolemm ss real overflow'

      call setupss(ncposs,n,nconts,nshels,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,coeff,
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),wkvec(ji),
     &             wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),wkvec(jn),
     &             wkvec(jo),wkvec(jp))

      ka=jq+1
      kb=ka+n*3
      kc=kb+ncposs*3

      if(kc.gt.nreal) stop 'dipolemm ss real overflow'

      call dipoless(ncposs,n,iwkvec(ja),iwkvec(jb),density,wkvec(je),
     &              wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jm),wkvec(ka),
     &              wkvec(kb),dipole)

      if(ncontp.eq.0) goto 1013

      ja=1
      jb=ja+nppops
      jc=jb+ncpops*3

      if(jc.gt.ninteger) stop 'dipolemm ps integer overflow'

      je=1
      jf=je+nppops
      jg=jf+nppops
      jh=jg+nppops
      ji=jh+nppops
      jj=ji+nppops
      jk=jj+nppops
      jl=jk+nppops
      jm=jl+nppops
      jn=jm+nppops
      jo=jn+nppops
      jp=jo+nppops
      jq=jp+nppops
      jr=jq+nppops
      js=jr+nppops
      jt=js+nppops

      if(jt.gt.nreal) stop 'dipolemm ps real overflow'

      call setupps(ncpops,n,ncontp,nconts,nshelp,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n*3
      kc=kb+n*9
      kd=kc+n
      ke=kd+ncpops*9

      if(ke.gt.nreal) stop 'dipolemm ps real overflow'

      call dipoleps(ncpops,n,iwkvec(ja),iwkvec(jb),density,wkvec(je),
     &              wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),dipole)

      ja=1
      jb=ja+ncpopp
      jc=jb+nppopp
      jd=jc+ncpopp*9

      if(jd.gt.ninteger) stop 'dipolemm pp integer overflow'

      je=1
      jf=je+nppopp
      jg=jf+nppopp
      jh=jg+nppopp
      ji=jh+nppopp
      jj=ji+nppopp
      jk=jj+nppopp
      jl=jk+nppopp
      jm=jl+nppopp
      jn=jm+nppopp
      jo=jn+nppopp
      jp=jo+nppopp
      jq=jp+nppopp
      jr=jq+nppopp
      js=jr+nppopp
      jt=js+nppopp
      ju=jt+nppopp
      jv=ju+nppopp
      jw=jv+nppopp
      jx=jw+ncpopp
      jy=jx+ncpopp
      jz=jy+ncpopp

      if(jz.gt.nreal) stop 'dipolemm pp real overflow'

      call setuppp(ncpopp,n,ncontp,nshelp,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n*3
      kc=kb+n*9
      kd=kc+n*27
      ke=kd+n*3
      kf=ke+n
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+ncpopp*27

      if(ki.gt.nreal) stop 'dipolemm pp real overflow'

      call dipolepp(ncpopp,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),density,
     &              wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),dipole)

      if(ncontd.eq.0) goto 1013

      ja=1
      jb=ja+nppods
      jc=jb+ncpods*6

      if(jc.gt.ninteger) stop 'dipolemm ds integer overflow'

      je=1
      jf=je+nppods
      jg=jf+nppods
      jh=jg+nppods
      ji=jh+nppods
      jj=ji+nppods
      jk=jj+nppods
      jl=jk+nppods
      jm=jl+nppods
      jn=jm+nppods
      jo=jn+nppods
      jp=jo+nppods
      jq=jp+nppods
      jr=jq+nppods
      js=jr+nppods
      jt=js+nppods

      if(jt.gt.nreal) stop 'dipolemm ds real overflow'

      call setupds(ncpods,n,ncontd,nconts,nsheld,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n*3
      kc=kb+n*9
      kd=kc+n*18
      ke=kd+n*3
      kf=ke+n
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+ncpods*18

      if(ki.gt.nreal) stop 'dipolemm ds real overflow'

      call dipoleds(ncpods,n,iwkvec(ja),iwkvec(jb),density,wkvec(je),
     &              wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),
     &              wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &              dipole)

      ja=1
      jb=ja+nppodp
      jc=jb+ncpodp*18

      if(jc.gt.ninteger) stop 'dipolemm dp integer overflow'

      je=1
      jf=je+nppodp
      jg=jf+nppodp
      jh=jg+nppodp
      ji=jh+nppodp
      jj=ji+nppodp
      jk=jj+nppodp
      jl=jk+nppodp
      jm=jl+nppodp
      jn=jm+nppodp
      jo=jn+nppodp
      jp=jo+nppodp
      jq=jp+nppodp
      jr=jq+nppodp
      js=jr+nppodp
      jt=js+nppodp
      ju=jt+nppodp
      jv=ju+nppodp
      jw=jv+nppodp
      jx=jw+ncpodp
      jy=jx+ncpodp
      jz=jy+ncpodp

      if(jz.gt.nreal) stop 'dipolemm dp real overflow'

      call setupdp(ncpodp,n,ncontd,ncontp,nsheld,nshelp,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n*3
      kc=kb+n*9
      kd=kc+n*18
      ke=kd+n*54
      kf=ke+n*3
      kg=kf+n*6
      kh=kg+n
      ki=kh+n*6
      kj=ki+n*9
      kk=kj+ncpodp*54

      if(kk.gt.nreal) stop 'dipolemm dp real overflow'

      call dipoledp(ncpodp,n,iwkvec(ja),iwkvec(jb),density,wkvec(je),
     &              wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &              wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jm),
     &              wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &              wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &              dipole)

      ja=1
      jb=ja+ncpodd
      jc=jb+nppodd
      jd=jc+ncpodd*36

      if(jd.gt.ninteger) stop 'dipolemm dd integer overflow'

      je=1
      jf=je+nppodd
      jg=jf+nppodd
      jh=jg+nppodd
      ji=jh+nppodd
      jj=ji+nppodd
      jk=jj+nppodd
      jl=jk+nppodd
      jm=jl+nppodd
      jn=jm+nppodd
      jo=jn+nppodd
      jp=jo+nppodd
      jq=jp+nppodd
      jr=jq+nppodd
      js=jr+nppodd
      jt=js+nppodd
      ju=jt+nppodd
      jv=ju+nppodd
      jw=jv+nppodd
      jx=jw+ncpodd
      jy=jx+ncpodd
      jz=jy+ncpodd

      if(jz.gt.nreal) stop 'dipolemm dd real overflow'

      call setupdd(ncpodd,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n*3
      kc=kb+n*9
      kd=kc+n*18
      ke=kd+n*27
      kf=ke+n*54
      kg=kf+n*108
      kh=kg+n*3
      ki=kh+n*6
      kj=ki+n*18
      kk=kj+n
      kl=kk+n*18
      km=kl+n*18
      kn=km+n*27
      ko=kn+ncpodd*108

      if(ko.gt.nreal) stop 'dipolemm dd real overflow'

      call dipoledd(ncpodd,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),density,
     &              wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &              wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &              wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &              wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &              wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &              dipole)

 1013 continue

      dipole(4)=sqrt(dipole(1)*dipole(1)
     &              +dipole(2)*dipole(2)
     &              +dipole(3)*dipole(3))

      write(6,1014) dipole(1),dipole(1)*debye,dipole(2),dipole(2)*debye,
     &              dipole(3),dipole(3)*debye,dipole(4),dipole(4)*debye

 1014 format(/,' dipole moment : ',16x,'atomic units',15x,'debyes',//,
     &             22x,'x-axis : ',f12.6,12x,f12.6,/,
     &             22x,'y-axis : ',f12.6,12x,f12.6,/,
     &             22x,'z-axis : ',f12.6,12x,f12.6,//,
     &             22x,'total  : ',f12.6,12x,f12.6,/)

      return
      end
