      subroutine fockmm(nreal,ninteger,natoms,nptcharges,nconts,ncontp,
     &                  ncontd,ncds,ncdspd,nxcs,nxcspd,nshels,nshelp,
     &                  nsheld,mtloca,iprimvc,nprimvc,icentvc,icdlfunc,
     &                  icdcfunc,ixclfunc,ixccfunc,iwkvec,coord,
     &                  coordatom,coordptcharge,charge,chargatom,
     &                  chargptcharge,alpha,coeff,cdfitc,xcfit1,xcfit2,
     &                  xcfit3,alphacd,coefscd,coefpcd,coefdcd,alphaxc,
     &                  coefsxc,coefpxc,coefdxc,overlap,core,fock,fock1,
     &                  fock2,fock3,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(7)

      dimension nshels(*),nshelp(*),nsheld(*),mtloca(*),iprimvc(*),
     &          nprimvc(*),icentvc(*),icdlfunc(*),icdcfunc(*),
     &          ixclfunc(*),ixccfunc(*),iwkvec(*)

      dimension coord(3,*),coordatom(3,*),coordptcharge(3,*),charge(*),
     &          chargatom(*),chargptcharge(*),alpha(*),coeff(*),
     &          cdfitc(*),xcfit1(*),xcfit2(*),xcfit3(*),alphacd(*),
     &          coefscd(*),coefpcd(*),coefdcd(*),alphaxc(*),coefsxc(*),
     &          coefpxc(*),coefdxc(*),overlap(*),core(*),fock(*),
     &          fock1(*),fock2(*),fock3(*),wkvec(*)

      data zero/0.0/

      ndim=nconts+3*ncontp+6*ncontd
      ndim=ndim*(ndim+1)/2

      do 1001 i=1,ndim
      core(i)=zero
      fock(i)=zero
      fock1(i)=zero
      fock2(i)=zero
      fock3(i)=zero
 1001 overlap(i)=zero

      ncentr=natoms+nptcharges

      do 1002 i=1,natoms
      do 1003 j=1,3
 1003 coord(j,i)=coordatom(j,i)
 1002 charge(i)=chargatom(i)

      if(nptcharges.eq.0) goto 1004

      do 1005 i=1,nptcharges
      do 1006 j=1,3
 1006 coord(j,natoms+i)=coordptcharge(j,i)
 1005 charge(natoms+i)=chargptcharge(i)

 1004 continue

      ncposs=nconts*(nconts+1)/2
      ncpopp=ncontp*(ncontp+1)/2
      ncpodd=ncontd*(ncontd+1)/2

      ncpops=ncontp*nconts
      ncpods=ncontd*nconts
      ncpodp=ncontd*ncontp

      npposs=0
      nppops=0
      nppopp=0
      nppods=0
      nppodp=0
      nppodd=0

      do 1007 i=1,nconts
      do 1007 j=1,i
 1007 npposs=npposs+nprimvc(nshels(i))*nprimvc(nshels(j))

      do 1008 i=1,ncontp
      do 1008 j=1,nconts
 1008 nppops=nppops+nprimvc(nshelp(i))*nprimvc(nshels(j))

      do 1009 i=1,ncontp
      do 1009 j=1,i
 1009 nppopp=nppopp+nprimvc(nshelp(i))*nprimvc(nshelp(j))

      do 1010 i=1,ncontd
      do 1010 j=1,nconts
 1010 nppods=nppods+nprimvc(nsheld(i))*nprimvc(nshels(j))

      do 1011 i=1,ncontd
      do 1011 j=1,ncontp
 1011 nppodp=nppodp+nprimvc(nsheld(i))*nprimvc(nshelp(j))

      do 1012 i=1,ncontd
      do 1012 j=1,i
 1012 nppodd=nppodd+nprimvc(nsheld(i))*nprimvc(nsheld(j))

      ja=1
      jb=ja+npposs
      jc=jb+ncposs

      if(jc.gt.ninteger) stop 'fockmm ss integer overflow'

      je=1
      jf=je+npposs
      jg=jf+npposs
      jh=jg+npposs
      ji=jh+npposs
      jj=ji+npposs
      jk=jj+npposs
      jl=jk+npposs
      jm=jl+npposs
      jn=jm+npposs
      jo=jn+npposs
      jp=jo+npposs
      jq=jp+npposs

      if(jq.gt.nreal) stop 'fockmm ss real overflow'

      call setupss(ncposs,n,nconts,nshels,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,coeff,
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),wkvec(ji),
     &             wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),wkvec(jn),
     &             wkvec(jo),wkvec(jp))

      ka=jq+1
      kb=ka+n
      kc=kb+ncposs
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n

      if(kg.gt.nreal) stop 'fockmm ss real overflow'

      call coress(ncposs,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf))

      jd=jc+n

      if(jd.gt.ninteger) stop 'fockmm ss integer overflow'

      ka=jq+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+ncposs
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+ncposs*3
      kl=kk+n*3
      km=kl+n*3
      kn=km+ncposs*6
      ko=kn+n*6
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n

      if(ku.gt.nreal) stop 'fockmm ss real overflow'

      call chrgss(ncposs,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),g,coord,cdfitc,alphacd,coefscd,
     &            coefpcd,coefdcd,fock,wkvec(je),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),
     &            wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &            wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &            wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &            wkvec(ks),wkvec(kt))

      ka=jq+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+ncposs
      kj=ki+n*3
      kk=kj+ncposs*3
      kl=kk+n*6
      km=kl+ncposs*6
      kn=km+ncposs*3
      ko=kn+ncposs*9
      kp=ko+ncposs*6
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+ncposs
      kz=ky+ncposs
      la=kz+ncposs

      if(la.gt.nreal) stop 'fockmm ss real overflow'

      call xcorss(ncposs,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),coord,xcfit1,xcfit2,xcfit3,
     &            alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,fock3,
     &            wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz))

      if(ncontp.eq.0) goto 1013

      ja=1
      jb=ja+nppops
      jc=jb+ncpops*3

      if(jc.gt.ninteger) stop 'fockmm ps integer overflow'

      je=1
      jf=je+nppops
      jg=jf+nppops
      jh=jg+nppops
      ji=jh+nppops
      jj=ji+nppops
      jk=jj+nppops
      jl=jk+nppops
      jm=jl+nppops
      jn=jm+nppops
      jo=jn+nppops
      jp=jo+nppops
      jq=jp+nppops
      jr=jq+nppops
      js=jr+nppops
      jt=js+nppops

      if(jt.gt.nreal) stop 'fockmm ps real overflow'

      call setupps(ncpops,n,ncontp,nconts,nshelp,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+ncpops*3
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n

      if(kk.gt.nreal) stop 'fockmm ps real overflow'

      call coreps(ncpops,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(jk),wkvec(jm),
     &            wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj))

      jd=jc+n

      if(jd.gt.ninteger) stop 'fockmm ps integer overflow'

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+ncpops*3
      ko=kn+n*3
      kp=ko+n*3
      kq=kp+n*3
      kr=kq+n*3
      ks=kr+ncpops*9
      kt=ks+n*9
      ku=kt+n*9
      kv=ku+ncpops*18
      kw=kv+n*18
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n*3
      lb=la+n*3
      lc=lb+n
      ld=lc+n
      le=ld+n
      lf=le+n
      lg=lf+n
      lh=lg+n
      li=lh+n

      if(li.gt.nreal) stop 'fockmm ps real overflow'

      call chrgps(ncpops,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),g,coord,cdfitc,alphacd,coefscd,
     &            coefpcd,coefdcd,fock,wkvec(je),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &            wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),
     &            wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),
     &            wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),
     &            wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),
     &            wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n*3
      kj=ki+ncpops*3
      kk=kj+n*6
      kl=kk+ncpops*6
      km=kl+n*10
      kn=km+ncpops*10
      ko=kn+ncpops*9
      kp=ko+ncpops*18
      kq=kp+ncpops*18
      kr=kq+n
      ks=kr+n*3
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+ncpops
      lb=la+ncpops
      lc=lb+ncpops

      if(lc.gt.nreal) stop 'fockmm ps real overflow'

      call xcorps(ncpops,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),coord,xcfit1,xcfit2,xcfit3,
     &            alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,fock3,
     &            wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &            wkvec(lb))

      ja=1
      jb=ja+ncpopp
      jc=jb+nppopp
      jd=jc+ncpopp*9

      if(jd.gt.ninteger) stop 'fockmm pp integer overflow'

      je=1
      jf=je+nppopp
      jg=jf+nppopp
      jh=jg+nppopp
      ji=jh+nppopp
      jj=ji+nppopp
      jk=jj+nppopp
      jl=jk+nppopp
      jm=jl+nppopp
      jn=jm+nppopp
      jo=jn+nppopp
      jp=jo+nppopp
      jq=jp+nppopp
      jr=jq+nppopp
      js=jr+nppopp
      jt=js+nppopp
      ju=jt+nppopp
      jv=ju+nppopp
      jw=jv+nppopp
      jx=jw+ncpopp
      jy=jx+ncpopp
      jz=jy+ncpopp

      if(jz.gt.nreal) stop 'fockmm pp real overflow'

      call setuppp(ncpopp,n,ncontp,nshelp,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+ncpopp*3
      kj=ki+n*6
      kk=kj+ncpopp*6
      kl=kk+n*9
      km=kl+ncpopp*9
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n

      if(kt.gt.nreal) stop 'fockmm pp real overflow'

      call corepp(ncpopp,n,ncentr,iwkvec(ja),iwkvec(jb),iwkvec(jc),g,
     &            coord,charge,overlap,core,wkvec(je),wkvec(jw),
     &            wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),
     &            wkvec(jv),wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),
     &            wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &            wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &            wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &            wkvec(kq),wkvec(kr),wkvec(ks))

      j0=jd+n

      if(j0.gt.ninteger) stop 'fockmm pp integer overflow'

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+ncpopp*3
      kp=ko+n*3
      kq=kp+n*3
      kr=kq+n*3
      ks=kr+n*3
      kt=ks+ncpopp*6
      ku=kt+n*6
      kv=ku+n*6
      kw=kv+n*6
      kx=kw+n*3
      ky=kx+ncpopp*9
      kz=ky+n*9
      la=kz+n*9
      lb=la+ncpopp*18
      lc=lb+n*18
      ld=lc+n*18
      le=ld+ncpopp*18
      lf=le+n*18
      lg=lf+ncpopp*36
      lh=lg+n*36
      li=lh+ncpopp*9
      lj=li+ncpopp*27
      lk=lj+ncpopp*54
      ll=lk+n
      lm=ll+n
      ln=lm+n
      lo=ln+n*3
      lp=lo+n*6
      lq=lp+n*9
      lr=lq+n
      ls=lr+n
      lt=ls+n
      lu=lt+n
      lv=lu+n
      lw=lv+n
      lx=lw+n

      if(lx.gt.nreal) stop 'fockmm pp real overflow'

      call chrgpp(ncpopp,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jb),iwkvec(jd),iwkvec(jc),g,coord,cdfitc,
     &            alphacd,coefscd,coefpcd,coefdcd,fock,wkvec(je),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &            wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),
     &            wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),
     &            wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),
     &            wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),
     &            wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),wkvec(li),
     &            wkvec(lj),wkvec(lk),wkvec(ll),wkvec(lm),wkvec(ln),
     &            wkvec(lo),wkvec(lp),wkvec(lq),wkvec(lr),wkvec(ls),
     &            wkvec(lt),wkvec(lu),wkvec(lv),wkvec(lw))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n*3
      kj=ki+ncpopp*3
      kk=kj+n*6
      kl=kk+ncpopp*6
      km=kl+n*10
      kn=km+ncpopp*10
      ko=kn+n*15
      kp=ko+ncpopp*15
      kq=kp+ncpopp*9
      kr=kq+ncpopp*18
      ks=kr+ncpopp*30
      kt=ks+ncpopp*27
      ku=kt+ncpopp*54
      kv=ku+ncpopp*54
      kw=kv+n
      kx=kw+n*3
      ky=kx+n*6
      kz=ky+n
      la=kz+n
      lb=la+n
      lc=lb+n
      ld=lc+n
      le=ld+n
      lf=le+n
      lg=lf+ncpopp
      lh=lg+ncpopp
      li=lh+ncpopp

      if(li.gt.nreal) stop 'fockmm pp real overflow'

      call xcorpp(ncpopp,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jb),iwkvec(jd),iwkvec(jc),coord,xcfit1,xcfit2,
     &            xcfit3,alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,
     &            fock3,wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),
     &            wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &            wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &            wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &            wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),
     &            wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),
     &            wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),
     &            wkvec(lh))

      if(ncontd.eq.0) goto 1013

      ja=1
      jb=ja+nppods
      jc=jb+ncpods*6

      if(jc.gt.ninteger) stop 'fockmm ds integer overflow'

      je=1
      jf=je+nppods
      jg=jf+nppods
      jh=jg+nppods
      ji=jh+nppods
      jj=ji+nppods
      jk=jj+nppods
      jl=jk+nppods
      jm=jl+nppods
      jn=jm+nppods
      jo=jn+nppods
      jp=jo+nppods
      jq=jp+nppods
      jr=jq+nppods
      js=jr+nppods
      jt=js+nppods

      if(jt.gt.nreal) stop 'fockmm ds real overflow'

      call setupds(ncpods,n,ncontd,nconts,nsheld,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+n*6
      kj=ki+ncpods*6
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n

      if(kq.gt.nreal) stop 'fockmm ds real overflow'

      call coreds(ncpods,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jf),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jk),
     &            wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),
     &            wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &            wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &            wkvec(kn),wkvec(ko),wkvec(kp))

      jd=jc+n

      if(jd.gt.ninteger) stop 'fockmm ds integer overflow'

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n*3
      kp=ko+n*3
      kq=kp+n*3
      kr=kq+n*3
      ks=kr+ncpods*6
      kt=ks+n*6
      ku=kt+n*6
      kv=ku+n*6
      kw=kv+n*9
      kx=kw+ncpods*18
      ky=kx+n*18
      kz=ky+n*18
      la=kz+ncpods*36
      lb=la+n*36
      lc=lb+n
      ld=lc+n
      le=ld+n
      lf=le+n*3
      lg=lf+n*6
      lh=lg+n*9
      li=lh+n
      lj=li+n
      lk=lj+n
      ll=lk+n
      lm=ll+n
      ln=lm+n
      lo=ln+n

      if(lo.gt.nreal) stop 'fockmm ds real overflow'

      call chrgds(ncpods,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),g,coord,cdfitc,alphacd,coefscd,
     &            coefpcd,coefdcd,fock,wkvec(je),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &            wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),
     &            wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),
     &            wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),
     &            wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),
     &            wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),wkvec(li),
     &            wkvec(lj),wkvec(lk),wkvec(ll),wkvec(lm),wkvec(ln))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n*3
      kj=ki+n*6
      kk=kj+ncpods*6
      kl=kk+n*10
      km=kl+ncpods*10
      kn=km+n*15
      ko=kn+ncpods*15
      kp=ko+ncpods*18
      kq=kp+ncpods*30
      kr=kq+ncpods*36
      ks=kr+n
      kt=ks+n*3
      ku=kt+n*6
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n
      kz=ky+n
      la=kz+n
      lb=la+n
      lc=lb+ncpods
      ld=lc+ncpods
      le=ld+ncpods

      if(le.gt.nreal) stop 'fockmm ds real overflow'

      call xcords(ncpods,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),coord,xcfit1,xcfit2,xcfit3,
     &            alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,fock3,
     &            wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &            wkvec(lb),wkvec(lc),wkvec(ld))

      ja=1
      jb=ja+nppodp
      jc=jb+ncpodp*18

      if(jc.gt.ninteger) stop 'fockmm dp integer overflow'

      je=1
      jf=je+nppodp
      jg=jf+nppodp
      jh=jg+nppodp
      ji=jh+nppodp
      jj=ji+nppodp
      jk=jj+nppodp
      jl=jk+nppodp
      jm=jl+nppodp
      jn=jm+nppodp
      jo=jn+nppodp
      jp=jo+nppodp
      jq=jp+nppodp
      jr=jq+nppodp
      js=jr+nppodp
      jt=js+nppodp
      ju=jt+nppodp
      jv=ju+nppodp
      jw=jv+nppodp
      jx=jw+ncpodp
      jy=jx+ncpodp
      jz=jy+ncpodp

      if(jz.gt.nreal) stop 'fockmm dp real overflow'

      call setupdp(ncpodp,n,ncontd,ncontp,nsheld,nshelp,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+n*3
      kj=ki+n*3
      kk=kj+ncpodp*6
      kl=kk+n*6
      km=kl+n*6
      kn=km+ncpodp*10
      ko=kn+n*10
      kp=ko+n*18
      kq=kp+ncpodp*18
      kr=kq+n
      ks=kr+n*3
      kt=ks+n
      ku=kt+n
      kv=ku+n
      kw=kv+n
      kx=kw+n
      ky=kx+n

      if(ky.gt.nreal) stop 'fockmm dp real overflow'

      call coredp(ncpodp,n,ncentr,iwkvec(ja),iwkvec(jb),g,coord,charge,
     &            overlap,core,wkvec(je),wkvec(jf),wkvec(jw),wkvec(jx),
     &            wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),
     &            wkvec(jr),wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),
     &            wkvec(jk),wkvec(jm),wkvec(jl),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx))

      jd=jc+n

      if(jd.gt.ninteger) stop 'fockmm dp integer overflow'

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n*3
      kq=kp+n*3
      kr=kq+n*3
      ks=kr+n*3
      kt=ks+n*3
      ku=kt+ncpodp*6
      kv=ku+n*6
      kw=kv+n*6
      kx=kw+n*6
      ky=kx+n*6
      kz=ky+ncpodp*10
      la=kz+n*10
      lb=la+n*10
      lc=lb+n*10
      ld=lc+n*9
      le=ld+ncpodp*18
      lf=le+n*18
      lg=lf+n*18
      lh=lg+ncpodp*30
      li=lh+n*30
      lj=li+n*30
      lk=lj+ncpodp*36
      ll=lk+n*36
      lm=ll+ncpodp*60
      ln=lm+n*60
      lo=ln+ncpodp*18
      lp=lo+ncpodp*54
      lq=lp+ncpodp*108
      lr=lq+n
      ls=lr+n
      lt=ls+n
      lu=lt+n*3
      lv=lu+n*6
      lw=lv+n*9
      lx=lw+n*10
      ly=lx+n*18
      lz=ly+n
      ma=lz+n
      mb=ma+n
      mc=mb+n
      md=mc+n
      me=md+n
      mf=me+n

      if(mf.gt.nreal) stop 'fockmm dp real overflow'

      call chrgdp(ncpodp,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),g,coord,cdfitc,alphacd,coefscd,
     &            coefpcd,coefdcd,fock,wkvec(je),wkvec(jw),wkvec(jx),
     &            wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jm),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),
     &            wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &            wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),
     &            wkvec(kr),wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),
     &            wkvec(kw),wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),
     &            wkvec(lb),wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),
     &            wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),
     &            wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &            wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),
     &            wkvec(lv),wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz),
     &            wkvec(ma),wkvec(mb),wkvec(mc),wkvec(md),wkvec(me))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n*3
      kj=ki+n*6
      kk=kj+ncpodp*6
      kl=kk+n*10
      km=kl+ncpodp*10
      kn=km+n*15
      ko=kn+ncpodp*15
      kp=ko+n*21
      kq=kp+ncpodp*21
      kr=kq+ncpodp*18
      ks=kr+ncpodp*30
      kt=ks+ncpodp*45
      ku=kt+ncpodp*54
      kv=ku+ncpodp*90
      kw=kv+ncpodp*108
      kx=kw+n
      ky=kx+n*3
      kz=ky+n*6
      la=kz+n*10
      lb=la+n
      lc=lb+n
      ld=lc+n
      le=ld+n
      lf=le+n
      lg=lf+n
      lh=lg+n
      li=lh+ncpodp
      lj=li+ncpodp
      lk=lj+ncpodp

      if(lk.gt.nreal) stop 'fockmm dp real overflow'

      call xcordp(ncpodp,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jc),iwkvec(jb),coord,xcfit1,xcfit2,xcfit3,
     &            alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,fock3,
     &            wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),wkvec(jw),
     &            wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &            wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &            wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &            wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),
     &            wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),
     &            wkvec(li),wkvec(lj))

      ja=1
      jb=ja+ncpodd
      jc=jb+nppodd
      jd=jc+ncpodd*36

      if(jd.gt.ninteger) stop 'fockmm dd integer overflow'

      je=1
      jf=je+nppodd
      jg=jf+nppodd
      jh=jg+nppodd
      ji=jh+nppodd
      jj=ji+nppodd
      jk=jj+nppodd
      jl=jk+nppodd
      jm=jl+nppodd
      jn=jm+nppodd
      jo=jn+nppodd
      jp=jo+nppodd
      jq=jp+nppodd
      jr=jq+nppodd
      js=jr+nppodd
      jt=js+nppodd
      ju=jt+nppodd
      jv=ju+nppodd
      jw=jv+nppodd
      jx=jw+ncpodd
      jy=jx+ncpodd
      jz=jy+ncpodd

      if(jz.gt.nreal) stop 'fockmm dd real overflow'

      call setupdd(ncpodd,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n*3
      ki=kh+n*3
      kj=ki+n*3
      kk=kj+n*3
      kl=kk+n*3
      km=kl+ncpodd*6
      kn=km+n*6
      ko=kn+n*6
      kp=ko+n*6
      kq=kp+ncpodd*10
      kr=kq+n*10
      ks=kr+n*10
      kt=ks+ncpodd*15
      ku=kt+n*15
      kv=ku+n*9
      kw=kv+ncpodd*18
      kx=kw+n*18
      ky=kx+ncpodd*30
      kz=ky+ncpodd*36
      la=kz+n*36
      lb=la+n
      lc=lb+n*3
      ld=lc+n*6
      le=ld+n*9
      lf=le+n
      lg=lf+n
      lh=lg+n
      li=lh+n
      lj=li+n
      lk=lj+n

      if(lk.gt.nreal) stop 'fockmm dd real overflow'

      call coredd(ncpodd,n,ncentr,iwkvec(ja),iwkvec(jb),iwkvec(jc),g,
     &            coord,charge,overlap,core,wkvec(je),wkvec(jf),
     &            wkvec(jg),wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jk),wkvec(jm),
     &            wkvec(jl),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),
     &            wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),
     &            wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &            wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),
     &            wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),
     &            wkvec(li),wkvec(lj))

      j0=jd+n

      if(j0.gt.ninteger) stop 'fockmm dd integer overflow'

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n
      kq=kp+n*3
      kr=kq+n*3
      ks=kr+n*3
      kt=ks+n*3
      ku=kt+n*3
      kv=ku+n*3
      kw=kv+ncpodd*6
      kx=kw+n*6
      ky=kx+n*6
      kz=ky+n*6
      la=kz+n*6
      lb=la+n*6
      lc=lb+ncpodd*10
      ld=lc+n*10
      le=ld+n*10
      lf=le+n*10
      lg=lf+n*10
      lh=lg+ncpodd*15
      li=lh+n*15
      lj=li+n*15
      lk=lj+n*15
      ll=lk+n*9
      lm=ll+n*9
      ln=lm+ncpodd*18
      lo=ln+n*18
      lp=lo+n*18
      lq=lp+ncpodd*30
      lr=lq+n*30
      ls=lr+n*30
      lt=ls+ncpodd*45
      lu=lt+n*45
      lv=lu+n*45
      lw=lv+ncpodd*36
      lx=lw+n*36
      ly=lx+ncpodd*60
      lz=ly+n*60
      ma=lz+ncpodd*90
      mb=ma+n*90
      mc=mb+ncpodd*18
      md=mc+ncpodd*30
      me=md+ncpodd*36
      mf=me+ncpodd*54
      mg=mf+ncpodd*90
      mh=mg+ncpodd*108
      mi=mh+ncpodd*108
      mj=mi+ncpodd*180
      mk=mj+ncpodd*216
      ml=mk+n
      mm=ml+n
      mn=mm+n
      mo=mn+n*3
      mp=mo+n*6
      mq=mp+n*10
      mr=mq+n*15
      ms=mr+n*30
      mt=ms+n
      mu=mt+n
      mv=mu+n
      mw=mv+n
      mx=mw+n
      my=mx+n
      mz=my+n

      if(mz.gt.nreal) stop 'fockmm dd real overflow'

      call chrgdd(ncpodd,n,ncds,ncdspd,icdlfunc,icdcfunc,iwkvec(ja),
     &            iwkvec(jb),iwkvec(jd),iwkvec(jc),g,coord,cdfitc,
     &            alphacd,coefscd,coefpcd,coefdcd,fock,wkvec(je),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(jq),wkvec(jr),wkvec(js),
     &     wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &     wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),
     &     wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &     wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),
     &     wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),
     &     wkvec(le),wkvec(lf),wkvec(lg),wkvec(lh),wkvec(li),wkvec(lj),
     &     wkvec(lk),wkvec(ll),wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),
     &     wkvec(lq),wkvec(lr),wkvec(ls),wkvec(lt),wkvec(lu),wkvec(lv),
     &     wkvec(lw),wkvec(lx),wkvec(ly),wkvec(lz),wkvec(ma),wkvec(mb),
     &     wkvec(mc),wkvec(md),wkvec(me),wkvec(mf),wkvec(mg),wkvec(mh),
     &     wkvec(mi),wkvec(mj),wkvec(mk),wkvec(ml),wkvec(mm),wkvec(mn),
     &     wkvec(mo),wkvec(mp),wkvec(mq),wkvec(mr),wkvec(ms),wkvec(mt),
     &     wkvec(mu),wkvec(mv),wkvec(mw),wkvec(mx),wkvec(my))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n*3
      kj=ki+n*6
      kk=kj+ncpodd*6
      kl=kk+n*10
      km=kl+ncpodd*10
      kn=km+n*15
      ko=kn+ncpodd*15
      kp=ko+n*21
      kq=kp+ncpodd*21
      kr=kq+n*28
      ks=kr+ncpodd*28
      kt=ks+ncpodd*18
      ku=kt+ncpodd*36
      kv=ku+ncpodd*108
      kw=kv+ncpodd*216
      kx=kw+ncpodd*30
      ky=kx+ncpodd*60
      kz=ky+ncpodd*180
      la=kz+ncpodd*45
      lb=la+ncpodd*90
      lc=lb+ncpodd*63
      ld=lc+n
      le=ld+n*3
      lf=le+n*6
      lg=lf+n*10
      lh=lg+n*15
      li=lh+n
      lj=li+n
      lk=lj+n
      ll=lk+n
      lm=ll+n
      ln=lm+n
      lo=ln+n
      lp=lo+ncpodd
      lq=lp+ncpodd
      lr=lq+ncpodd

      if(lr.gt.nreal) stop 'fockmm dd real overflow'

      call xcordd(ncpodd,n,nxcs,nxcspd,ixclfunc,ixccfunc,iwkvec(ja),
     &            iwkvec(jb),iwkvec(jd),iwkvec(jc),coord,xcfit1,xcfit2,
     &            xcfit3,alphaxc,coefsxc,coefpxc,coefdxc,fock1,fock2,
     &            fock3,wkvec(je),wkvec(jh),wkvec(ji),wkvec(jj),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),
     &            wkvec(kd),wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),
     &            wkvec(ki),wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km),
     &            wkvec(kn),wkvec(ko),wkvec(kp),wkvec(kq),wkvec(kr),
     &            wkvec(ks),wkvec(kt),wkvec(ku),wkvec(kv),wkvec(kw),
     &            wkvec(kx),wkvec(ky),wkvec(kz),wkvec(la),wkvec(lb),
     &            wkvec(lc),wkvec(ld),wkvec(le),wkvec(lf),wkvec(lg),
     &            wkvec(lh),wkvec(li),wkvec(lj),wkvec(lk),wkvec(ll),
     &            wkvec(lm),wkvec(ln),wkvec(lo),wkvec(lp),wkvec(lq))

 1013 continue

      do 1014 i=1,ndim
      fock1(i)=core(i)+fock(i)+fock1(i)
      fock2(i)=core(i)+fock(i)+fock2(i)
 1014 fock3(i)=core(i)+fock(i)+fock3(i)

      return
      end
