      subroutine genxyz(n,i,j,k,bondl,bangle,dangle,c)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension c(3,*)

      data zero,pi,one80/0.0,3.1415926535898,180.0/

      pi180=pi/one80

      if(n.eq.1) then
                       c(1,n)=zero
                       c(2,n)=zero
                       c(3,n)=zero
                       return
                 endif

      if(n.eq.2) then
                       c(1,n)=bondl
                       c(2,n)=zero
                       c(3,n)=zero
                       return
                 endif

      xo=c(1,i)
      yo=c(2,i)
      zo=c(3,i)

      if(n.eq.3) then
                       if(i.eq.1) c(1,n)=xo+bondl*cos(bangle*pi180)
                       if(i.eq.2) c(1,n)=xo-bondl*cos(bangle*pi180)
                                  c(2,n)=yo+bondl*sin(bangle*pi180)
                                  c(3,n)=zero
                                  return
                 endif

      xa=c(1,j)-c(1,i)
      ya=c(2,j)-c(2,i)
      za=c(3,j)-c(3,i)

      r=sqrt(xa*xa+ya*ya+za*za)

      xa=xa/r
      ya=ya/r
      za=za/r

      xb=c(1,j)-c(1,k)
      yb=c(2,j)-c(2,k)
      zb=c(3,j)-c(3,k)

      xc=ya*zb-za*yb
      yc=za*xb-xa*zb
      zc=xa*yb-ya*xb

      r=sqrt(xc*xc+yc*yc+zc*zc)

      xc=xc/r
      yc=yc/r
      zc=zc/r

      xb=ya*zc-za*yc
      yb=za*xc-xa*zc
      zb=xa*yc-ya*xc

      z=bondl*cos(bangle*pi180)
      x=bondl*sin(bangle*pi180)*cos(dangle*pi180)
      y=bondl*sin(bangle*pi180)*sin(dangle*pi180)

      c(1,n)=xo+xa*z+xb*x+xc*y
      c(2,n)=yo+ya*z+yb*x+yc*y
      c(3,n)=zo+za*z+zb*x+zc*y

      return
      end
