      subroutine getksorbs(niteration,nreal,idiis,maxao,ncontractions,
     &                     nindpndnt,nalpha,nbeta,xim,elevelshift,
     &                     diiserror,changep,amat,bmat,fockalpha,
     &                     fockbeta,coeffalpha,coeffbeta,enrgalpha,
     &                     enrgbeta,sinverse,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension amat(*),bmat(*),fockalpha(*),fockbeta(*)
      dimension coeffalpha(maxao,*),coeffbeta(maxao,*)
      dimension enrgalpha(*),enrgbeta(*),sinverse(maxao,*),wkvec(*)

      noccupied=max(nalpha,nbeta)
      nvirtual=-min(nalpha,nbeta)+nindpndnt

      ja=1
      jb=ja+ncontractions*ncontractions
      jc=jb+ncontractions*ncontractions
      jd=jc+nindpndnt*nindpndnt
      je=jd+noccupied*nvirtual
      jf=je+noccupied*nvirtual
      jg=jf+ncontractions*(ncontractions+1)/2
      jh=jg+ncontractions
      ji=jh+ncontractions

      if((ji+ncontractions).gt.nreal) stop 'real overflow in getksorbs'

      call solveks(niteration,idiis,maxao,ncontractions,nindpndnt,
     &             noccupied,nalpha,nbeta,xim,elevelshift,diiserror,
     &             changep,amat,bmat,fockalpha,fockbeta,coeffalpha,
     &             coeffbeta,enrgalpha,enrgbeta,sinverse,wkvec(ja),
     &             wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),wkvec(jf),
     &             wkvec(jg),wkvec(jh),wkvec(ji))

      return
      end
