      subroutine igftable

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.
c
c  based on brett dunlap's incomplete gamma function subroutines

      implicit real*8(a-h,o-z)

      common/igfdata/table(17,161),smallu(17),bigu(13)

      data small,tenth,one,two,t1,t2/0.0000000001,0.1,1.0,2.0,16.5,33.0/

      bigu(1)=one

      do 1001 i=2,13
 1001 bigu(i)=real64(2*i-3)*bigu(i-1)

      do 1002 i=1,17
 1002 smallu(i)=one/real64(2*i-1)

      do 1003 i=1,17
 1003 table(i,1)=smallu(i)

      do 1004 i=2,161

      factor=tenth*real64(i-1)

      scale=smallu(17)

      sum=scale

      do 1005 j=1,99
      scale=scale*factor/(t1+real64(j))
      if(scale.le.small) goto 1006
 1005 sum=sum+scale

 1006 expfac=exp(-factor)

      table(17,i)=expfac*sum

      do 1007 j=1,16
 1007 table(17-j,i)=(table(18-j,i)*two*factor+expfac)/(t2-real64(2*j))

 1004 continue

      return
      end
