      subroutine mespmm(nreal,ninteger,npoints,ncentr,nd,nconts,ncontp,
     &                  ncontd,nshels,nshelp,nsheld,mtloca,iprimvc,
     &                  nprimvc,icentvc,iwkvec,coord,charge,alpha,coeff,
     &                  density,qqa,qqb,qqd,esppt,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(5)

      dimension nshels(*),nshelp(*),nsheld(*),mtloca(*),iprimvc(*),
     &          nprimvc(*),icentvc(*),iwkvec(*)

      dimension coord(3,*),charge(*),alpha(*),coeff(*),density(*),
     &          qqa(nd,*),qqb(*),qqd(npoints,*),esppt(npoints,*),
     &          wkvec(*)

      data zero,bohr,one,three/0.0,0.529177,1.0,3.0/

      sqrt3=sqrt(three)

      do 1001 i=1,ncentr
 1001 qqb(i)=zero

      rewind 66

      n=0

      do 1002 i=1,4

      read(66) nsubpoints

      call fastrd(66,esppt(n+1,1),nsubpoints)
      call fastrd(66,esppt(n+1,2),nsubpoints)
      call fastrd(66,esppt(n+1,3),nsubpoints)

 1002 n=n+nsubpoints

      do 1003 j=1,ncentr
      do 1003 i=1,npoints
      qqd(i,j)=one/sqrt((esppt(i,1)-coord(1,j))**2
     &                 +(esppt(i,2)-coord(2,j))**2
     &                 +(esppt(i,3)-coord(3,j))**2)
 1003 continue

      do 1004 j=1,ncentr
      do 1005 i=1,npoints
 1005 wkvec(i)=qqd(i,j)
      do 1004 k=1,ncentr
      qqa(k,j)=zero
      do 1006 i=1,npoints
 1006 qqa(k,j)=qqa(k,j)+qqd(i,k)*wkvec(i)
 1004 continue

      do 1007 i=1,ncontd
      do 1007 j=1,nconts

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshels(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3

 1007 continue

      do 1008 i=1,ncontd
      do 1008 j=1,ncontp

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nshelp(j))
      i4=i2+i3

      density(i4)=density(i4)/sqrt3
      density(i4+1)=density(i4+1)/sqrt3
      density(i4+2)=density(i4+2)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/sqrt3
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/sqrt3
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3

 1008 continue

      do 1009 i=1,ncontd
      do 1009 j=1,i

      i1=mtloca(nsheld(i))
      i2=(i1*(i1-1))/2
      i3=mtloca(nsheld(j))
      i4=i2+i3

      density(i4)=density(i4)/three
      if(i.ne.j) density(i4+1)=density(i4+1)/sqrt3
      if(i.ne.j) density(i4+2)=density(i4+2)/sqrt3
      if(i.ne.j) density(i4+3)=density(i4+3)/three
      if(i.ne.j) density(i4+4)=density(i4+4)/sqrt3
      if(i.ne.j) density(i4+5)=density(i4+5)/three

      density(i4+i1)=density(i4+i1)/sqrt3
      if(i.ne.j) density(i4+i1+3)=density(i4+i1+3)/sqrt3
      if(i.ne.j) density(i4+i1+5)=density(i4+i1+5)/sqrt3

      density(i4+i1*2+1)=density(i4+i1*2+1)/sqrt3
      if(i.ne.j) density(i4+i1*2+4)=density(i4+i1*2+4)/sqrt3
      if(i.ne.j) density(i4+i1*2+6)=density(i4+i1*2+6)/sqrt3

      density(i4+i1*3+3)=density(i4+i1*3+3)/three
      density(i4+i1*3+4)=density(i4+i1*3+4)/sqrt3
      density(i4+i1*3+5)=density(i4+i1*3+5)/sqrt3
      density(i4+i1*3+6)=density(i4+i1*3+6)/three
      if(i.ne.j) density(i4+i1*3+7)=density(i4+i1*3+7)/sqrt3
      if(i.ne.j) density(i4+i1*3+8)=density(i4+i1*3+8)/three

      density(i4+i1*4+6)=density(i4+i1*4+6)/sqrt3
      density(i4+i1*4+9)=density(i4+i1*4+9)/sqrt3
      if(i.ne.j) density(i4+i1*4+11)=density(i4+i1*4+11)/sqrt3

      density(i4+i1*5+10)=density(i4+i1*5+10)/three
      density(i4+i1*5+11)=density(i4+i1*5+11)/sqrt3
      density(i4+i1*5+12)=density(i4+i1*5+12)/sqrt3
      density(i4+i1*5+13)=density(i4+i1*5+13)/three
      density(i4+i1*5+14)=density(i4+i1*5+14)/sqrt3
      density(i4+i1*5+15)=density(i4+i1*5+15)/three

 1009 continue

      ncposs=nconts*(nconts+1)/2
      ncpopp=ncontp*(ncontp+1)/2
      ncpodd=ncontd*(ncontd+1)/2

      ncpops=ncontp*nconts
      ncpods=ncontd*nconts
      ncpodp=ncontd*ncontp

      npposs=0
      nppops=0
      nppopp=0
      nppods=0
      nppodp=0
      nppodd=0

      do 1010 i=1,nconts
      do 1010 j=1,i
 1010 npposs=npposs+nprimvc(nshels(i))*nprimvc(nshels(j))

      do 1011 i=1,ncontp
      do 1011 j=1,nconts
 1011 nppops=nppops+nprimvc(nshelp(i))*nprimvc(nshels(j))

      do 1012 i=1,ncontp
      do 1012 j=1,i
 1012 nppopp=nppopp+nprimvc(nshelp(i))*nprimvc(nshelp(j))

      do 1013 i=1,ncontd
      do 1013 j=1,nconts
 1013 nppods=nppods+nprimvc(nsheld(i))*nprimvc(nshels(j))

      do 1014 i=1,ncontd
      do 1014 j=1,ncontp
 1014 nppodp=nppodp+nprimvc(nsheld(i))*nprimvc(nshelp(j))

      do 1015 i=1,ncontd
      do 1015 j=1,i
 1015 nppodd=nppodd+nprimvc(nsheld(i))*nprimvc(nsheld(j))

      do 1016 i=1,npoints
      esppt(i,4)=zero
      do 1016 j=1,ncentr
      esppt(i,4)=esppt(i,4)+charge(j)/sqrt((esppt(i,1)-coord(1,j))**2
     &                                    +(esppt(i,2)-coord(2,j))**2
     &                                    +(esppt(i,3)-coord(3,j))**2)
 1016 continue

      ja=1
      jb=ja+npposs
      jc=jb+ncposs

      if(jc.gt.ninteger) stop 'mespmm ss integer overflow'

      je=1
      jf=je+npposs
      jg=jf+npposs
      jh=jg+npposs
      ji=jh+npposs
      jj=ji+npposs
      jk=jj+npposs
      jl=jk+npposs
      jm=jl+npposs
      jn=jm+npposs
      jo=jn+npposs
      jp=jo+npposs
      jq=jp+npposs

      if(jq.gt.nreal) stop 'mespmm ss real overflow'

      call setupss(ncposs,n,nconts,nshels,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,coeff,
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),wkvec(ji),
     &             wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),wkvec(jn),
     &             wkvec(jo),wkvec(jp))

      ka=jq+1
      kb=ka+n
      kc=kb+ncposs
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n

      if(kg.gt.nreal) stop 'mespmm ss real overflow'

      do 1017 i=1,npoints

      call mespss(ncposs,n,iwkvec(ja),iwkvec(jb),esppt(i,4),esppt(i,1),
     &            esppt(i,2),esppt(i,3),g,density,wkvec(je),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jm),wkvec(ka),wkvec(kb),
     &            wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf))

 1017 continue

      if(ncontp.eq.0) goto 2001

      ja=1
      jb=ja+nppops
      jc=jb+ncpops*3

      if(jc.gt.ninteger) stop 'mespmm ps integer overflow'

      je=1
      jf=je+nppops
      jg=jf+nppops
      jh=jg+nppops
      ji=jh+nppops
      jj=ji+nppops
      jk=jj+nppops
      jl=jk+nppops
      jm=jl+nppops
      jn=jm+nppops
      jo=jn+nppops
      jp=jo+nppops
      jq=jp+nppops
      jr=jq+nppops
      js=jr+nppops
      jt=js+nppops

      if(jt.gt.nreal) stop 'mespmm ps real overflow'

      call setupps(ncpops,n,ncontp,nconts,nshelp,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n*3
      ke=kd+ncpops*3
      kf=ke+n
      kg=kf+n
      kh=kg+n
      ki=kh+n

      if(ki.gt.nreal) stop 'mespmm ps real overflow'

      do 1018 i=1,npoints

      call mespps(ncpops,n,iwkvec(ja),iwkvec(jb),esppt(i,4),esppt(i,1),
     &            esppt(i,2),esppt(i,3),g,density,wkvec(je),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh))

 1018 continue

      ja=1
      jb=ja+ncpopp
      jc=jb+nppopp
      jd=jc+ncpopp*9

      if(jd.gt.ninteger) stop 'mespmm pp integer overflow'

      je=1
      jf=je+nppopp
      jg=jf+nppopp
      jh=jg+nppopp
      ji=jh+nppopp
      jj=ji+nppopp
      jk=jj+nppopp
      jl=jk+nppopp
      jm=jl+nppopp
      jn=jm+nppopp
      jo=jn+nppopp
      jp=jo+nppopp
      jq=jp+nppopp
      jr=jq+nppopp
      js=jr+nppopp
      jt=js+nppopp
      ju=jt+nppopp
      jv=ju+nppopp
      jw=jv+nppopp
      jx=jw+ncpopp
      jy=jx+ncpopp
      jz=jy+ncpopp

      if(jz.gt.nreal) stop 'mespmm pp real overflow'

      call setuppp(ncpopp,n,ncontp,nshelp,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+ncpopp*3
      kh=kg+n*6
      ki=kh+ncpopp*6
      kj=ki+ncpopp*9
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n
      ko=kn+n
      kp=ko+n

      if(kp.gt.nreal) stop 'mespmm pp real overflow'

      do 1019 i=1,npoints

      call mesppp(ncpopp,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),esppt(i,4),
     &            esppt(i,1),esppt(i,2),esppt(i,3),g,density,wkvec(je),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jm),
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &            wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko))

 1019 continue

      if(ncontd.eq.0) goto 2001

      ja=1
      jb=ja+nppods
      jc=jb+ncpods*6

      if(jc.gt.ninteger) stop 'mespmm ds integer overflow'

      je=1
      jf=je+nppods
      jg=jf+nppods
      jh=jg+nppods
      ji=jh+nppods
      jj=ji+nppods
      jk=jj+nppods
      jl=jk+nppods
      jm=jl+nppods
      jn=jm+nppods
      jo=jn+nppods
      jp=jo+nppods
      jq=jp+nppods
      jr=jq+nppods
      js=jr+nppods
      jt=js+nppods

      if(jt.gt.nreal) stop 'mespmm ds real overflow'

      call setupds(ncpods,n,ncontd,nconts,nsheld,nshels,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js))

      ka=jt+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n*3
      kf=ke+n*3
      kg=kf+n*6
      kh=kg+ncpods*6
      ki=kh+n
      kj=ki+n
      kk=kj+n
      kl=kk+n
      km=kl+n
      kn=km+n

      if(kn.gt.nreal) stop 'mespmm ds real overflow'

      do 1020 i=1,npoints

      call mespds(ncpods,n,iwkvec(ja),iwkvec(jb),esppt(i,4),esppt(i,1),
     &            esppt(i,2),esppt(i,3),g,density,wkvec(je),wkvec(jn),
     &            wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),
     &            wkvec(jm),wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),
     &            wkvec(ke),wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),
     &            wkvec(kj),wkvec(kk),wkvec(kl),wkvec(km))

 1020 continue

      ja=1
      jb=ja+nppodp
      jc=jb+ncpodp*18

      if(jc.gt.ninteger) stop 'mespmm dp integer overflow'

      je=1
      jf=je+nppodp
      jg=jf+nppodp
      jh=jg+nppodp
      ji=jh+nppodp
      jj=ji+nppodp
      jk=jj+nppodp
      jl=jk+nppodp
      jm=jl+nppodp
      jn=jm+nppodp
      jo=jn+nppodp
      jp=jo+nppodp
      jq=jp+nppodp
      jr=jq+nppodp
      js=jr+nppodp
      jt=js+nppodp
      ju=jt+nppodp
      jv=ju+nppodp
      jw=jv+nppodp
      jx=jw+ncpodp
      jy=jx+ncpodp
      jz=jy+ncpodp

      if(jz.gt.nreal) stop 'mespmm dp real overflow'

      call setupdp(ncpodp,n,ncontd,ncontp,nsheld,nshelp,mtloca,iprimvc,
     &             nprimvc,icentvc,iwkvec(ja),iwkvec(jb),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n*3
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+ncpodp*6
      kj=ki+n*6
      kk=kj+n*6
      kl=kk+ncpodp*10
      km=kl+n*10
      kn=km+ncpodp*18
      ko=kn+n
      kp=ko+n*3
      kq=kp+n
      kr=kq+n
      ks=kr+n
      kt=ks+n
      ku=kt+n

      if(ku.gt.nreal) stop 'mespmm dp real overflow'

      do 1021 i=1,npoints

      call mespdp(ncpodp,n,iwkvec(ja),iwkvec(jb),esppt(i,4),esppt(i,1),
     &            esppt(i,2),esppt(i,3),g,density,wkvec(je),wkvec(jw),
     &            wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),wkvec(jp),
     &            wkvec(jq),wkvec(jr),wkvec(js),wkvec(jm),wkvec(ka),
     &            wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf),
     &            wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),wkvec(kk),
     &            wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),wkvec(kp),
     &            wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt))

 1021 continue

      ja=1
      jb=ja+ncpodd
      jc=jb+nppodd
      jd=jc+ncpodd*36

      if(jd.gt.ninteger) stop 'mespmm dd integer overflow'

      je=1
      jf=je+nppodd
      jg=jf+nppodd
      jh=jg+nppodd
      ji=jh+nppodd
      jj=ji+nppodd
      jk=jj+nppodd
      jl=jk+nppodd
      jm=jl+nppodd
      jn=jm+nppodd
      jo=jn+nppodd
      jp=jo+nppodd
      jq=jp+nppodd
      jr=jq+nppodd
      js=jr+nppodd
      jt=js+nppodd
      ju=jt+nppodd
      jv=ju+nppodd
      jw=jv+nppodd
      jx=jw+ncpodd
      jy=jx+ncpodd
      jz=jy+ncpodd

      if(jz.gt.nreal) stop 'mespmm dd real overflow'

      call setupdd(ncpodd,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &             icentvc,iwkvec(ja),iwkvec(jb),iwkvec(jc),coord,alpha,
     &             coeff,wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &             wkvec(ji),wkvec(jj),wkvec(jk),wkvec(jl),wkvec(jm),
     &             wkvec(jn),wkvec(jo),wkvec(jp),wkvec(jq),wkvec(jr),
     &             wkvec(js),wkvec(jt),wkvec(ju),wkvec(jv),wkvec(jw),
     &             wkvec(jx),wkvec(jy))

      ka=jz+1
      kb=ka+n
      kc=kb+n
      kd=kc+n
      ke=kd+n
      kf=ke+n
      kg=kf+n*3
      kh=kg+n*3
      ki=kh+n*3
      kj=ki+n*3
      kk=kj+ncpodd*6
      kl=kk+n*6
      km=kl+n*6
      kn=km+n*6
      ko=kn+ncpodd*10
      kp=ko+n*10
      kq=kp+n*10
      kr=kq+ncpodd*15
      ks=kr+n*15
      kt=ks+ncpodd*18
      ku=kt+ncpodd*30
      kv=ku+ncpodd*36
      kw=kv+n
      kx=kw+n*3
      ky=kx+n*6
      kz=ky+n
      la=kz+n
      lb=la+n
      lc=lb+n
      ld=lc+n

      if(ld.gt.nreal) stop 'mespmm dd real overflow'

      do 1022 i=1,npoints

      call mespdd(ncpodd,n,iwkvec(ja),iwkvec(jb),iwkvec(jc),esppt(i,4),
     &            esppt(i,1),esppt(i,2),esppt(i,3),g,density,wkvec(je),
     &            wkvec(jw),wkvec(jx),wkvec(jy),wkvec(jn),wkvec(jo),
     &            wkvec(jp),wkvec(jq),wkvec(jr),wkvec(js),wkvec(jm),
     &            wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &            wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &            wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),
     &            wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),
     &            wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),
     &            wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc))

 1022 continue

 2001 continue

      do 2002 j=1,ncentr
      do 2002 i=1,npoints
 2002 qqb(j)=qqb(j)+esppt(i,4)*qqd(i,j)

      rewind 99

      write(99,2003) npoints
 2003 format(i5)

      do 2004 i=1,npoints
 2004 write(99,2005) esppt(i,1)*bohr,esppt(i,2)*bohr,esppt(i,3)*bohr,
     &               esppt(i,4)
 2005 format(1x,4e16.7)

      return
      end
