      subroutine numxcc(nreal,ninteger,nmaxpoints,natoms,nconts,ncontp,
     &                  ncontd,ncds,ncdspd,nxcs,nxcspd,iwkvec,mtloca,
     &                  ilfunc,ngauss,icfunc,nptrs,nptrp,nptrd,
     &                  natomtype,nptsatom,icdlfunc,icdcfunc,ixclfunc,
     &                  ixccfunc,wkvec,coord,core,fock1,fock2,fock3,
     &                  alpha,coeff,alphacd,coefscd,coefpcd,coefdcd,
     &                  alphaxc,coefsxc,coefpxc,coefdxc,cdfitc,xcfit1,
     &                  xcfit2,xcfit3)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iwkvec(*)
      dimension mtloca(*),ilfunc(*),ngauss(*),icfunc(*)
      dimension nptrs(*),nptrp(*),nptrd(*)
      dimension natomtype(*),nptsatom(*)
      dimension icdlfunc(*),icdcfunc(*),ixclfunc(*),ixccfunc(*)

      dimension wkvec(*)
      dimension coord(3,*),core(*),fock1(*),fock2(*),fock3(*)
      dimension alpha(*),coeff(*)
      dimension alphacd(*),coefscd(*),coefpcd(*),coefdcd(*)
      dimension alphaxc(*),coefsxc(*),coefpxc(*),coefdxc(*)
      dimension cdfitc(*),xcfit1(*),xcfit2(*),xcfit3(*)

      ncntrt=nconts+3*ncontp+6*ncontd

      ncntsq=ncntrt*(ncntrt+1)/2
      
      call twoemm(nreal-ncntsq,ninteger,nconts,ncontp,ncontd,ncds,
     &            ncdspd,nxcs,nxcspd,nptrs,nptrp,nptrd,mtloca,ilfunc,
     &            ngauss,icfunc,icdlfunc,icdcfunc,ixclfunc,ixccfunc,
     &            iwkvec,coord,alpha,coeff,cdfitc,xcfit1,xcfit2,xcfit3,
     &            alphacd,coefscd,coefpcd,coefdcd,alphaxc,coefsxc,
     &            coefpxc,coefdxc,core,wkvec(1),fock1,fock2,fock3,
     &            wkvec(ncntsq+1))

      ja=1
      jb=ja+nmaxpoints
      jc=jb+nmaxpoints
      jd=jc+nmaxpoints
      je=jd+nmaxpoints
      jf=je+nmaxpoints
      jg=jf+128
      jh=jg+ncntrt*128
      ji=jh+ncntrt*128

      if((ji+128*12).gt.nreal) stop 'numxcc real overflow'

      call numxc(128,natoms,ncntrt,nconts,ncontp,ncontd,ilfunc,icfunc,
     &           ngauss,nptrs,nptrp,nptrd,natomtype,nptsatom,coord,
     &           alpha,coeff,fock3,wkvec(ja),wkvec(jb),wkvec(jc),
     &           wkvec(jd),wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &           wkvec(ji))

      return
      end
