      subroutine scfrun(nreal,ninteger,nmaxorbs,nmaxaux,nmaxpoints,
     &                  nfunctional,maxiterations,idiis,ngridtype,
     &                  irandgrid,natoms,nptcharges,nalpha,nbeta,nconts,
     &                  ncontp,ncontd,ncds,ncdspd,nxcs,nxcspd,natomtype,
     &                  nptsatom,nshels,nshelp,nsheld,ilfunc,icfunc,
     &                  mtloca,ngaussian,icdlfunc,icdcfunc,ixclfunc,
     &                  ixccfunc,iwkvec,converged,dmixing,eshift,
     &                  diiserror,coord,charge,coordpc,ptcharge,core,
     &                  focka,fockb,focke,dmta,dmtb,coeffa,coeffb,
     &                  orbnrga,orbnrgb,alpha,coeffs,alphacd,coefscd,
     &                  coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,coefdxc,
     &                  cdfitc,xcfita,xcfitb,xcfite,xcfitesave,
     &                  auxoverlap,tvector,tveca,tvecb,tvece,overlapinv,
     &                  wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),mtloca(*),ngaussian(*),icdlfunc(*),
     &          icdcfunc(*),ixclfunc(*),ixccfunc(*),iwkvec(*)

      dimension coord(3,*),charge(*),coordpc(3,*),ptcharge(*),core(*),
     &          focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),orbnrga(*),
     &          orbnrgb(*),alpha(*),coeffs(*),alphacd(*),coefscd(*),
     &          coefpcd(*),coefdcd(*),alphaxc(*),coefsxc(*),coefpxc(*),
     &          coefdxc(*),cdfitc(*),xcfita(*),xcfitb(*),xcfite(*),
     &          xcfitesave(*),auxoverlap(nmaxaux,*),tvector(*),tveca(*),
     &          tvecb(*),tvece(*),overlapinv(nmaxorbs,*),wkvec(*)

      data zero,dlarge/0.0,1.0e+25/

      ncontractions=nconts+3*ncontp+6*ncontd

      ncdfunc=ncds+10*ncdspd
      nxcfunc=nxcs+10*nxcspd

      e1=zero
      e2=zero

      savedmixing=dmixing

      deltanrg=dlarge

      ihit=0

      do 1001 i=1,maxiterations

      if(deltanrg.le.converged) ihit=ihit+1
      if(ihit.gt.1) goto 1001

      call scfcycle(i,nreal,ninteger,nmaxorbs,nmaxaux,nmaxpoints,idiis,
     &              nfunctional,irandgrid,ngridtype,natoms,nptcharges,
     &              nalpha,nbeta,ncontractions,nconts,ncontp,ncontd,
     &              ncds,ncdspd,nxcs,nxcspd,natomtype,nptsatom,nshels,
     &              nshelp,nsheld,mtloca,ilfunc,icfunc,ngaussian,
     &              icdlfunc,icdcfunc,ixclfunc,ixccfunc,iwkvec,energy,
     &              eshift,dmixing,diiserror,dmaxpc,coord,coordpc,
     &              charge,ptcharge,core,focka,fockb,focke,dmta,dmtb,
     &              coeffa,coeffb,orbnrga,orbnrgb,overlapinv,alpha,
     &              coeffs,alphacd,coefscd,coefpcd,coefdcd,alphaxc,
     &              coefsxc,coefpxc,coefdxc,cdfitc,xcfita,xcfitb,xcfite,
     &              tvector,tveca,tvecb,tvece,auxoverlap,wkvec)

      e2=e1
      e1=energy

      deltanrg=max(abs(e2-e1),dmaxpc)

 1001 continue

      dmixing=savedmixing

      if(deltanrg.le.converged) then
                                      write(6,1002) 
                                else
                                      write(6,1003)
                                endif

 1002 format(/,' scf converged!!! :-) :-) :-) ')
 1003 format(/,' scf terminated unsuccessfully??? :-( :-( :-( ')

      call gengrid(nreal,nmaxpoints,ngridtype,0,irandgrid,natoms,nconts,
     &             ncontp,ncontd,ilfunc,icfunc,ngaussian,nshels,nshelp,
     &             nsheld,natomtype,nptsatom,coord,alpha,coeffs,wkvec)

      call gridcall(0,-1,nfunctional,ninteger,nreal,nmaxpoints,nmaxorbs,
     &              nmaxaux,natoms,nalpha,nbeta,nconts,ncontp,ncontd,
     &              nxcs,nxcs+nxcspd,nxcfunc,natomtype,nptsatom,nshels,
     &              nshelp,nsheld,ilfunc,icfunc,ngaussian,ixclfunc,
     &              ixccfunc,iwkvec,dmixing,coord,coeffa,coeffb,alpha,
     &              coeffs,alphaxc,coefsxc,coefpxc,coefdxc,xcfita,
     &              xcfitb,xcfite,tveca,tvecb,tvece,auxoverlap,wkvec)

      do 1004 i=1,nxcfunc
 1004 xcfitesave(i)=xcfite(i)

      do 1005 i=1,nxcfunc
 1005 xcfite(i)=zero

      call numxcc(nreal,ninteger,nmaxpoints,natoms,nconts,ncontp,ncontd,
     &            ncds,ncdspd,nxcs,nxcspd,iwkvec,mtloca,ilfunc,
     &            ngaussian,icfunc,nshels,nshelp,nsheld,natomtype,
     &            nptsatom,icdlfunc,icdcfunc,ixclfunc,ixccfunc,wkvec,
     &            coord,core,focka,fockb,focke,alpha,coeffs,alphacd,
     &            coefscd,coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &            coefdxc,cdfitc,xcfita,xcfitb,xcfite)

      do 1006 i=1,nxcfunc
 1006 xcfite(i)=xcfitesave(i)

      call totale(1,ncontractions,ncdfunc,0,nptcharges,natoms,nalpha,
     &            nbeta,nmaxaux,energy,diiserror,dmta,dmtb,focke,coord,
     &            charge,coordpc,ptcharge,auxoverlap,cdfitc,dmaxpc)

      return
      end
